/* 
   Copyright 1994-2003 Free Software Foundation, Inc.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
   USA

   You may contact the author at:

   mailto::camille@bluegrass.net

   or by snail mail at:

   David Lindauer
   850 Washburn Ave Apt 99
   Louisville, KY 40222
*/
#include <stdio.h>
#include <stdlib.h>
int _RTL_FUNC setvbuf(FILE *restrict stream, char *restrict buf, int mode, size_t size)
{
	if (stream->token != FILTOK || (stream->flags & _F_VBUF))
		return 1;
	switch (mode) {
		case _IOFBF:
		case _IOLBF:
		case _IONBF:
			break;
		default:
			return 1;
	}
	if (fflush(stream))
		return 1;
	if (stream->flags & _F_BUF)
		free(stream->buffer);
	stream->flags &= ~(_F_BUF | _F_LBUF);
	switch (mode) {
		case _IOLBF:
			stream->flags |= _F_LBUF;
		case _IOFBF:
            if (!buf) {
                buf = malloc(size);
                if (!buf)
                    return 1;
	            stream->flags |= _F_BUF;
            }
        	stream->buffer = buf;
	        stream->bsize = size;
			break;
		case _IONBF:
			stream->buffer = 0;
			stream->bsize = 0;
			break;
		default:
			return 1;
	}
    stream->level = 0;
    stream->flags &= ~_F_VBUF;
	return 0;
	
}