/* 
   Copyright 1994-2003 Free Software Foundation, Inc.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
   USA

   You may contact the author at:

   mailto::camille@bluegrass.net

   or by snail mail at:

   David Lindauer
   850 Washburn Ave Apt 99
   Louisville, KY 40222
*/
#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <errno.h>
#include <locale.h>
#include <wchar.h>
#include "libp.h"

int _RTL_FUNC vfprintf(FILE *restrict stream, const char *restrict format, 
        va_list arglist)
{
	int written=0;
	char buffer[8192],*p;
	int i = 0;
	if (stream->token != FILTOK) {
		errno = _dos_errno = ENOENT;
		return 0;
	}
    if (stream->orient == __or_wide) {
        errno = EINVAL;
        return 0;
    }
    stream->orient = __or_narrow;
	while (*format) {
        p = buffer;
		while (*format != '%' && *format != 0 && p < buffer + sizeof(buffer))
			*p++ = *format++;
      	if (fwrite(buffer,1,p-buffer,stream) != p-buffer)
		    return EOF;
        written += p-buffer;
		if (*format == '%') {
            if  (*(format+1)) {
                p = buffer;
                format = __onetostr(buffer,&p,format+1,((char **)arglist+i),&i, &written);
                if (fwrite(buffer,1,p-buffer,stream) != p-buffer)
		            return EOF;
                written += p-buffer;
            } else
                format++;
        }
	}
	return written;
}
int _RTL_FUNC fprintf(FILE *restrict stream, const char *restrict format, ...)
{
	return vfprintf(stream,format,((char *)&format+sizeof(char *)));
}