/* 
   Copyright 1994-2003 Free Software Foundation, Inc.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
   USA

   You may contact the author at:

   mailto::camille@bluegrass.net

   or by snail mail at:

   David Lindauer
   850 Washburn Ave Apt 99
   Louisville, KY 40222
*/
#include <stdio.h>
#include <errno.h>
#include <time.h>
#include <stdlib.h>
#include <string.h>
#include <locale.h>
#include <wchar.h>
#include <io.h>
#include <fcntl.h>
#include <share.h>
#include <sys\stat.h>
#include "libp.h"

extern FILE *_pstreams[_NFILE_];
extern int __maxfiles;

static int cvFlags(int flags)
{
	int rv = 0;
	switch (flags & (_F_READ | _F_WRIT))
	{
		case _F_READ:
		case 0:
			rv = O_RDONLY;
			break;
		case _F_WRIT:
			rv = O_WRONLY;
			break;
		case _F_READ | _F_WRIT:
			rv = O_RDWR;
			break;
	}
	if (flags & _F_BIN)
		rv |= O_BINARY;
	else
		rv |= O_TEXT;
	if (flags & _F_APPEND)
		rv |= O_APPEND;
	return rv;
}
FILE *__basefopen(const char *restrict name, const char *restrict mode,
        FILE *restrict stream, int fd)
{
	int flags = 0,append = 0, update = 0, id = 0,i;
	FILE *file;
	char *buf,*fname;
   __ll_enter_critical() ;
	if (__maxfiles >= _NFILE_) {
		_dos_errno = errno = EMFILE;
      __ll_exit_critical() ;
		return 0;
	}
	for (i=0; i < strlen(mode); i++) {
		switch (mode[i]) {
			case 'r':
				flags |= _F_READ;
				break;
			case 'w':
				flags |= _F_WRIT;
				break;
			case 'a':
				flags |= _F_WRIT;
				append = 1;
				break;
			case '+':
				update = 1;
				break;
			case 'b':
				flags |= _F_BIN;
				break;
			case 't':
				flags &= ~_F_BIN;
				break;
			default:
            __ll_exit_critical() ;
				return 0;
		}
	}
   if (!(flags & (_F_READ | _F_WRIT))) {
      __ll_exit_critical() ;
		return 0;
   }
	fname = malloc(strlen(name)+1);
   if (!fname) {
      __ll_exit_critical() ;
		return 0;
   }
	strcpy(fname,name);
	if (stream)
		file = stream;
	else
		if ((file = malloc(sizeof(FILE))) == 0) {
			free(fname);
            __ll_exit_critical() ;
			return 0;
		}
		else
			memset(file,0,sizeof(FILE));
	file->flags = 0;
    if (!stream) {
    	file->buffer = malloc(BUFSIZ);
        file->bsize = BUFSIZ;
	    if (!file->buffer) {
		    free(fname);
		    free(file);
            __ll_exit_critical() ;
		    return 0;
        }
	}
	if (append)
		flags |= _F_APPEND;
	switch (flags & (_F_READ | _F_WRIT)) {
		case 0:
			goto nofile;
		case _F_READ:
			if (update)
				flags |= _F_WRIT;
			if (fd != -1)
				id = fd;
			else
	         	id = open(name,  cvFlags(flags), S_IREAD | S_IWRITE);
			break;
		case _F_WRIT:
			if (update)
				flags |= _F_READ;
			id = -1;
			if (fd != -1)
				id = fd;
			else
			{
				if (append)
	                id = open(name, cvFlags(flags), S_IREAD | S_IWRITE);
				if (id < 0)
	                id = open(name, O_CREAT | O_TRUNC | cvFlags(flags), S_IREAD | S_IWRITE);
			}
			break;
		case _F_READ | _F_WRIT:
         __ll_exit_critical() ;
			return 0;
	}
    if (id < 0) {
		goto nofile;
    }
    file->orient = __or_unspecified;
    memset(file->mbstate,0,sizeof(file->mbstate));
	file->token = FILTOK;
	file->level = 0;
	file->fd = id;
	file->flags |= flags | _F_VBUF;
	file->hold = 0;
    if (!stream) {
    	if (!isatty(id))
	    	setvbuf(file,buf,_IOFBF,BUFSIZ);
	    else {
            file->flags |= _F_TERM;
		    setvbuf(file,buf,_IOLBF,BUFSIZ);
        }
		file->flags |= _F_BUF;
    }
	if (append) {
		if (fseek(file,0,SEEK_END)) {
nofile:
			free(fname);
			free(file->buffer);
			free(file);
         __ll_exit_critical() ;
			return 0;
		}
	}
    file->name = fname;
	_pstreams[__maxfiles++] = file;
   __ll_exit_critical() ;
	return file;
}
FILE *_RTL_FUNC fopen(const char *restrict name, const char *restrict mode)
{
	return __basefopen(name,mode,0, -1);
}
FILE *_RTL_FUNC fdopen(int handle, const char *restrict mode)
{
	return __basefopen("", mode, 0, handle);
}
FILE *_RTL_FUNC _fdopen(int handle, const char *restrict mode)
{
	return fdopen(handle, mode);
}
int _RTL_FUNC (fileno)(FILE *stream)
{
	if (stream->token != FILTOK)
	{
		errno = ENOENT;
		return -1;
	}
	return stream->fd;
}
int _RTL_FUNC (_fileno)(FILE *stream)
{
	if (stream->token != FILTOK)
	{
		errno = ENOENT;
		return -1;
	}
	return stream->fd;
}