/* 
   Copyright 1994-2003 Free Software Foundation, Inc.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
   USA

   You may contact the author at:

   mailto::camille@bluegrass.net

   or by snail mail at:

   David Lindauer
   850 Washburn Ave Apt 99
   Louisville, KY 40222
*/
#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <time.h>
#include <locale.h>
#include <wchar.h>
#include "io.h"
#include "libp.h"

extern int _abterm;

FILE *_pstreams[_NFILE_];
int __maxfiles;

FILE _RTL_DATA *__stdin ;
FILE _RTL_DATA *__stdout ;
FILE _RTL_DATA *__stderr ;
FILE _RTL_DATA *__stdaux ;
FILE _RTL_DATA *__stdprn ;

#pragma startup __fileinit 139
#pragma rundown __closeall 50

void __fileinit(void)
{
	__ll_init();
   __stdin = __getStream(0) ;
   __stdout = __getStream(1) ;
   __stderr = __getStream(2) ;
}

void __closeall(void)
{
   if (!_abterm) {
   	  fcloseall() ;
   }
}
int _RTL_FUNC fcloseall(void)
{
	int i;
	int rv = __maxfiles - 3 ;
	for (i= __maxfiles-1; i >=3; i--)
		fclose(_pstreams[i]) ;
	__maxfiles = 3 ;
	return rv ;	
}
int _RTL_FUNC _fcloseall(void)
{
	return fcloseall();
}
int __basefclose(FILE *stream,int release)
{
	int rv,i;
    
	if (stream->token == FILTOK && __maxfiles) {
		char *fname = stream->name;
        stream->flags &= ~_F_VBUF;
		fflush(stream);
		stream->token = (short)-1;
		if (__maxfiles > 1) {
            __ll_enter_critical() ;
			for (i=0; i < __maxfiles; i++)
				if (_pstreams[i] == stream) {
					_pstreams[i] = _pstreams[__maxfiles-1];
                    __maxfiles--;
					break ;
				}
            __ll_exit_critical() ;
		}
		rv = close(fileno(stream));
		if (fname)
			free(fname);
		if (release) {
    		if (stream->flags & _F_BUF)
	    		free(stream->buffer);
			free(stream);
        }
		if (!rv)
			return 0;
		else {
			return EOF;
		}
	}
	else {
		errno = _dos_errno = ENOENT;
		return EOF;
	}
}
int _RTL_FUNC fclose(FILE *stream)
{
	return __basefclose(stream,1);
}