; 
;   Copyright 1994-2003 Free Software Foundation, Inc.
;
;   This library is free software; you can redistribute it and/or
;   modify it under the terms of the GNU Lesser General Public
;   License as published by the Free Software Foundation; either
;   version 2.1 of the License, or (at your option) any later version.
;
;   This library is distributed in the hope that it will be useful,
;   but WITHOUT ANY WARRANTY; without even the implied warranty of
;   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;   Lesser General Public License for more details.
;
;   You should have received a copy of the GNU Lesser General Public
;   License along with this library; if not, write to the Free Software
;   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
;   USA
;
;   You may contact the author at:
;
;   mailto::camille@bluegrass.net
;
;   or by snail mail at:
;
;   David Lindauer
;   850 Washburn Ave Apt 99
;   Louisville, KY 40222
;
%include "matherr.inc"

%ifdef __BUILDING_LSCRTL_DLL
[export _fmax]
[export _fmaxf]
[export _fmaxl]
%endif
[global _fmax]
[global _fmaxf]
[global _fmaxl]
SECTION _DATA CLASS=DATA USE32
nm	db	"fmax",0

SECTION _TEXT CLASS=CODE USE32
_fmaxf:
	lea	ecx,[esp+4]
	fld	dword [ecx]
	lea	edx,[esp+8]
	fld	dword [edx]
    sub dl,dl
    jmp short ffmax
_fmaxl:
	lea	ecx,[esp+4]
	fld	tword [ecx]
	lea	edx,[esp+16]
	fld	tword [edx]
    mov dl,2
    jmp short ffmax
_fmax:
	lea	ecx,[esp+4]
	fld	qword [ecx]
	lea	edx,[esp+12]
	fld	qword [edx]
    mov dl,1
ffmax:
    lea eax,[nm]
    call clearmath
    fcom st1
    fstsw   ax
    sahf
    jc  short noxchg
    fxch
noxchg:
    popone
    jmp wrapmath
