/* 
   Copyright 1994-2003 Free Software Foundation, Inc.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
   USA

   You may contact the author at:

   mailto::camille@bluegrass.net

   or by snail mail at:

   David Lindauer
   850 Washburn Ave Apt 99
   Louisville, KY 40222
*/
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <time.h>
#include <locale.h>
#include <wchar.h>
#include "libp.h"

FREELIST *__mallocchains[MEMCHAINS];

BLKHEAD *_allocbloc;
BLKHEAD *_newfree;

#pragma rundown memdelete 5

static void memdelete(void)
{
   BLKHEAD *p ;
   __ll_enter_critical() ;
   p = _allocbloc;
	while (p) {
		BLKHEAD *n = p->next;
		__ll_free(p);
		p = n;
	}
   __ll_exit_critical() ;
}

static int init_block(size_t size)
{
	size_t ns = size+sizeof(BLKHEAD);
	BLKHEAD *nb;
	FREELIST *list ;
	if (ns < ALLOCSIZE)
		ns = ALLOCSIZE;
	nb = __ll_malloc(ns);
	if (!nb)
		return NULL;
	nb->next = _allocbloc;
	_allocbloc = nb;
	list = nb->freemem = nb + 1 ;
	list->size = ns - sizeof(BLKHEAD) ;
	list->next = 0;
	_newfree = nb;
	return 1;
}
static FREELIST *split(FREELIST *p, int size, FREELIST **slist)
{
	FREELIST *rv;
	int ch;
	rv = (FREELIST *)(((char *)p)+size);
	rv->size = p->size - size ;
	rv->next = 0;
	*slist = rv;
	p->size = size ;
 	return ++p;
}
void * _RTL_FUNC malloc(size_t size)
{
	BLKHEAD *head ;
	FREELIST **slist;
	register FREELIST *p;
	register int siz1 ;
	if (!size)
		return NULL;
	size +=3;	/* must be the same as in realloc for comparison purposes */
	size &= 0xfffffffc;

	siz1 = size + sizeof(FREELIST);

   __ll_enter_critical() ;
	/* search the chain for reuse */
	slist = &__mallocchains[(siz1 >> 2) % MEMCHAINS];
	while (*slist) {
		p = *slist;
		if (p->size == siz1) {
		 	*slist = p->next;
         __ll_exit_critical() ;
 			return ++p;
		}
		slist = &p->next;
	}
	/* search the free blocks for free mem */
	head = _newfree ;
	while (head) {
		p = head->freemem ;
		if (p) {
			if (p->size == siz1) {
			 	head->freemem = 0;
            __ll_exit_critical() ;
 				return ++p;
			}
         else if (p->size > siz1+sizeof(FREELIST)) {
            p = split(p,siz1,&head->freemem);
            __ll_exit_critical() ;
            return p ;
         }
		}
		head = head->next ;
	}
	/* now get a new block */
	if (!init_block(siz1)) {
      __ll_exit_critical() ;
		return NULL;
	}
	/* and split it up to get our block */
	p = _newfree->freemem;
	if (p->size == siz1) {
		 	_newfree->freemem = p->next ;
         __ll_exit_critical() ;
 			return ++p;
	}

   p = split(p,siz1,&_newfree->freemem);
   __ll_exit_critical() ;
   return p ;
}