/* 
   Copyright 1994-2003 Free Software Foundation, Inc.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
   USA

   You may contact the author at:

   mailto::camille@bluegrass.net

   or by snail mail at:

   David Lindauer
   850 Washburn Ave Apt 99
   Louisville, KY 40222
*/
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <time.h>
#include <locale.h>
#include <wchar.h>
#include "libp.h"
#include <dpmi.h>
#include <dos.h>

void far *_RTL_FUNC farmalloc(size_t size)
{
   SELECTOR seg=0 ;
   void *s = malloc(size) ;
   if (s) {
      if (!dpmi_alloc_descriptors(&seg,1)) {
         dpmi_set_sel_access_rights(seg,0xc092) ;
         dpmi_set_sel_limit(seg, size-1) ;
         dpmi_set_sel_base(seg, (ULONG)s) ;
      } else {
         seg = 0 ;
         free(s) ;
      }
   }
   return MK_FP(seg,0) ;
}
void _RTL_FUNC farfree(void far *ptr)
{
   SELECTOR seg = FP_SEG(ptr) ;
   ULONG base ;
   if (seg == _CS || seg == _DS || seg == _SS)
      return ;
   if (!dpmi_get_sel_base(&base,seg)) {
      free((void *)base) ;
      dpmi_free_selector(seg) ;
   }
}