	.386p

	.model small

include  prints.ase 
include  mtrap.ase 
include  input.ase 

	PUBLIC	setbreak, breaks, enablebreaks, disablebreaks
	extrn put_char : proc, put_msg : proc

	.data
breaklist dd 16 DUP (?)		; List of breakpoints
breakhold db 16 dup (?)		; List of values where 'int 3' has covered
				; the opcode
breakenum dw	0		; Flags telling which breakpoints are set

	.code
;
; Command to set a breakpoint comes here
;
setbreak	PROC	
	push	edx
	push	ebx
	push	eax
	mov	esi,ebx
	push	esi
	call	PageTrapErr	; Turn on page traps
	pop	esi		;
	mov	al,[esi]	; Read the byte at the base to see if
				; its page is accessable
				; (if trap is followed, input routine
				; will be entered )
	pushfd			; Turn off page traps
	call	PageTrapUnerr	;
	popfd			;
	pop	eax
	pop	ebx
	pop	edx
	and	eax,0fh		; Set the breakpoint set bit
	bts	[breakenum],ax	;
	shl	eax,2
	add	eax,offset DGROUP:breaklist
	mov	[eax],ebx	;
	ret
setbreak	ENDP	
;
; Command to clear a breakpoint comes here
;
clearbreak	PROC	
	and	eax,0fh		; Reset the flag bit
	btr	[breakenum],ax	;
	ret
clearbreak	ENDP	
;
; Command to display a breakpoint comes here
;
displaybreak	PROC	
	and	eax,0fh		; See if set
	bt	[breakenum],ax	;
	jnc	short nodisplay	; Quit with no disp if no breakpoint set
	push	eax		; CR/LF
	mov	ebx,offset CRLF
	call	put_msg
	pop	eax		;
	push	eax		;
	call	printbyte	; Print breakpoint #
	mov	dl,'-'		; Print '-'
	call	put_char
	pop	eax		;
	mov	ebx,eax		; Get offset into breakpoint address list
	shl	ebx,2
	add	ebx,offset DGROUP:breaklist	;
	mov	eax,[ebx]	; Print offset
	call	printdword      ;
nodisplay:
	ret
displaybreak	ENDP	
;
; When GO or TRAP or PROCEED commands execute, they call this to
; enable breakpoints
;
enablebreaks	PROC	
	mov	ecx,15		; For each breakpoint
eblp:
	bt	[breakenum],cx	; If not set
	jnc	short ebnn	; Don't do anything
	mov	eax,ecx		; Else get breakpoint address
	shl	eax,2
	add	eax,offset DGROUP:breaklist;
	mov	esi,[eax]	;
	mov	bl,[esi]	; Get the byte at that location
	mov	[ecx + breakhold],bl	; Save it for restore
	mov	BYTE PTR [esi],0cch	; Put an int 3
ebnn:
	dec	ecx		; Next breakpoint
	jns	eblp		;
	mov	eax,ecx		;
	ret	
enablebreaks	ENDP	
;
; Int 3 or int 1 call this to disable breakpoints and restore the
; values covered by the int 3
;
disablebreaks	PROC	
	mov	ecx,15		; For each breakpoint
dblp:
	bt	[breakenum],cx	; If not set
	jnc	short dbnn	; Go nothing
	mov	eax,ecx		; Else get address
	shl	eax,2
	add	eax,offset DGROUP:breaklist	;
	mov	esi,[eax]	;
	mov	bl,[ecx + breakhold] ; Restore the covered value
	mov	[esi],bl	;
dbnn:
	dec	ecx
	jns	dblp		; Next breakpoint
	btr	[breakenum],0   ; Reset breakpoint 0 (the automatic breakpoint)
	ret
disablebreaks	ENDP	
;
; Handle breakpoint-related commands
;
breaks	PROC	
	call	WadeSpace	; Wade through spaces
	cmp	al,13		; If no args
	jz	short showall	; Show all breakpoints
	cmp	al,'-'		; Else check for '-'
	pushfd			;
	jnz	noinc		;
	inc	esi		; Skip to next arg
	call	WadeSpace	;
noinc:
	call    ReadNumber	; Read break number
	jc	short badbreak2	; Exit if error
	cmp	eax,16		; Make sure in range
	jnc	short badbreak2	; Exit if error
	or	eax,eax		; Can't do anything with break #0, it's automatic
	jz	short badbreak2	;
	popfd			;
	push	eax		;
	jz	short unmake	; If was '-', clear break
	call	WadeSpace	; Else wade to next arg
	call	ReadAddress	; Read the bp address
	pop	eax		;
	jc	short badbreak	; Quit if error
	call	setbreak	; Set breakpoint at this address
	jmp	short breakdone	; Get out
unmake:
	call	WadeSpace	; Wade to end
	cmp	al,13		;
	pop	eax		;
	jnz	short badbreak	; If there is more we have an error
	call	clearbreak	; Clear breakpoint
	jmp	short breakdone	; Get out
showall:
	mov	ecx,15		; For each breakpoint
salp:
	mov	eax,ecx		; Display it if set
	call	displaybreak	;
	loop	salp		;
breakdone:
	clc			; Exit, no errors
	ret
badbreak2:
	pop	eax		;
badbreak:
	stc			; Exit, errors
	ret
breaks	ENDP	
END