#define _xst2c_version "v1.2"

/*

                 XST 2 C converter v1.2
                     By Rd
                 Started  13/10/01
                 Finished 21/10/01    [Converter]
                          23/10/01    [lib etc..]


 gcc -s -m486 -ofilename.exe filename.c irqwrap.o xst_lib.o -lxlib -lsb -lwtd

lost the -O3 as it can screw up

Future update
 End (and Stop) (in_proc) have all the string release code?
 or goto end_of_proc (setting an end variable that'll be
                      check after each procedure call????)

 maybe check to see if every user procedure has been defined?

 and allow user libs (treat as system commands!!!)
  -maybe even XST option to (A:test B:call this C:run prog)
   so user libs be possible...all in the maybe future...?
*/



#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#include "..\xst_cmds.h"

void do_command(char fst, char *str, char mustbesolo);
void do_keyword(char *str);
int notletter(char k);
void error(char *str);
int scan_next(char *str);

int in_switch=0,in_repeat=0,in_for=0,in_do=0;
char incase=0,in_proc=0,in_proc_type=0;
int need_endif=0,array_no=0,cur_top_ele=0;
char had_a_dim=0;

int set_max_sam=64;
int set_max_mod=24;
int set_max_sprite=64;
int set_max_bank=24;
int set_max_anim=20;
int set_max_object=100;

int find_extern_command(char *label, char type);


char out_of_mem=0;

char *filename;
int malfreecntr=0;
int linecnt=0,total_lines=0;
FILE *src=NULL,*dest=NULL;

char *s_keywords[]={ "SETMAXSAM","SETMAXMOD",
                     "SETMAXSPRITE","SETMAXBANK",
                     "SETMAXANIM","SETMAXOBJECT",
                     NULL};

char new_line[512];//some are big

typedef struct extern_cmd{
                        char *name;
                        char *parms;
                        char ret;
                        struct extern_cmd *prev;
                        }extern_cmd;
extern_cmd *top_extrn=NULL;
extern_cmd *tmp_extrn;

char win_compat=0;


typedef struct for_s{
                char *line;
                struct for_s *prev;
                }for_s;
for_s *top_for=NULL;

void store_for(char *line){
 for_s *t;
 t=(for_s*)malloc(sizeof(for_s));
 if(t==NULL){out_of_mem=1; return; }
 malfreecntr++;
 t->prev=top_for; top_for=t;
 t->line=(char *)malloc(strlen(line)+1);
 if(t->line==NULL){out_of_mem=1; return; }
 malfreecntr++;
 strcpy(t->line,line);
return; }

void cat_for(){
 for_s *t;
 if(top_for){
        strcat(new_line,top_for->line);
        t=top_for->prev;
        if(top_for->line){ free(top_for->line); malfreecntr--;}
        free(top_for); malfreecntr--;
        top_for=t;
            }
return; }

void free_for(){
 for_s *t;
        while(top_for){
                        t=top_for->prev;
                        if(top_for->line){ free(top_for->line); malfreecntr--;}
                        free(top_for); malfreecntr--;
                        top_for=t;
                        }
return; }

typedef struct incs{
                char *las_fname;
                FILE *las_hnd;
                int las_lineno;
                struct incs *prev;
                }incs;
incs *top_inc=NULL;

void free_incs(){
 incs *t;
 while(top_inc){
                t=top_inc->prev;
                if(top_inc->las_hnd)fclose(top_inc->las_hnd);
                if(top_inc->las_fname){ malfreecntr--;
                                        free(top_inc->las_fname);
                                        }
                free(top_inc); malfreecntr--;
                top_inc=t;
                }
return; }
void pop_include(){
 incs *t;
 if(top_inc){
        if(src)fclose(src);
        src=top_inc->las_hnd;
        if(filename){ free(filename); malfreecntr--;}
        filename=top_inc->las_fname;
        linecnt=top_inc->las_lineno+1;
        t=top_inc->prev;
        free(top_inc); malfreecntr--;
        top_inc=t;
                }
return; }
void do_include(char *fname){
 incs *t;
 FILE *hnd;
 char st[100];
 hnd=fopen(fname,"r");
 if(hnd==NULL){ sprintf(st,"Cannot open include file %s",fname);
                     error(st);
                     return; }
 t=(incs *)malloc(sizeof(incs));
 if(t==NULL){ out_of_mem=1; fclose(hnd); return; }
 malfreecntr++;
 t->prev=top_inc; top_inc=t;
 t->las_lineno=linecnt; linecnt=-1;//take into account the line will be added afterwards
 t->las_hnd=src; src=hnd;
 t->las_fname=filename;
 filename=(char *)malloc(strlen(fname)+1);
 if(filename==NULL){ out_of_mem=1; return; }
 malfreecntr++;
 strcpy(filename,fname);
return; }

typedef struct arrays{
               char *name;
               char elecnt;
               char typ;
               int no;
               struct arrays *prev;
                }arrays;
arrays *top_array=NULL, *cur_array=NULL;
void free_arrays(){
 while(top_array){
                cur_array=top_array->prev;
                if(top_array->name){ free(top_array->name); malfreecntr--;}
                free(top_array); malfreecntr--;
                top_array=cur_array;
                }
return; }

void add_array(char *name, char tpe,int num){
 cur_array=(arrays *)malloc(sizeof(arrays));
 if(cur_array==NULL){ out_of_mem=1; return; }
 malfreecntr++;
 cur_array->prev=top_array; top_array=cur_array;
 cur_array->elecnt=0;
 cur_array->typ=tpe;
 cur_array->no=num;
 cur_array->name=(char *)malloc(strlen(name)+1);
 if(cur_array->name==NULL){ out_of_mem=1; return; }
 malfreecntr++;
 strcpy(cur_array->name,name);
return; }

void dump_arrays_reset(){
 int a;
 cur_array=top_array;
 while(cur_array){
        for(a=0; a<=cur_array->elecnt; a++)
                fprintf(dest," for(a%d=0;a%d<ac_%d_%d;a%d++)\n",a,a,cur_array->no,a,a);
        if(cur_array->typ==1)fprintf(dest,"       s_");
        else if(cur_array->typ==2)fprintf(dest,"       f_");
        else fprintf(dest,"       i_");
        fprintf(dest,"%s",cur_array->name);
        for(a=0; a<=cur_array->elecnt; a++)fprintf(dest,"[a%d]",a);
        if(cur_array->typ==1)fprintf(dest,"=NULL;\n");
        else fprintf(dest,"=0;\n");
        cur_array=cur_array->prev;
        }
return; }

void dump_arrays_str_free(){
 int a;
 cur_array=top_array;
 while(cur_array){
        if(cur_array->typ==1){
                for(a=0; a<=cur_array->elecnt; a++)
                        fprintf(dest," for(a%d=0;a%d<ac_%d_%d;a%d++)\n",a,a,cur_array->no,a,a);
                
                fprintf(dest,"       str_free((char **)&s_");
                fprintf(dest,"%s",cur_array->name);
                for(a=0; a<=cur_array->elecnt; a++)fprintf(dest,"[a%d]",a);
                fprintf(dest,");\n");
                }
        cur_array=cur_array->prev;
        }
return; }

int find_array(char *name, char tpe){
 cur_array=top_array;
 while(cur_array){
        if(cur_array->typ==tpe && !stricmp(name,cur_array->name))return cur_array->no+1;
        cur_array=cur_array->prev;
        }
return 0; }

typedef struct proc{
                char *name;
                char typ;
                char declr;
                char parms[12];
                struct proc *prev;
                }proc;
proc *top_proc=NULL, *cur_proc=NULL;

int find_user_proc(char *name, char typ){
 cur_proc=top_proc;
 while(cur_proc){
                if(cur_proc->typ==typ && !stricmp(name,cur_proc->name))return 1;
                cur_proc=cur_proc->prev;
                }
return 0; }

void add_user_proc(char *name, char typ, char declr){
 int a;
 cur_proc=(proc *)malloc(sizeof(proc));
 if(cur_proc==NULL){ out_of_mem=1; return; }
 malfreecntr++;
 cur_proc->prev=top_proc; top_proc=cur_proc;
 cur_proc->typ=typ;
 cur_proc->declr=declr;
 for(a=0;a<12;a++)cur_proc->parms[a]=0;
 cur_proc->name=(char *)malloc(strlen(name)+1);
 if(cur_proc->name==NULL){ out_of_mem=1; return; }
 malfreecntr++;
 strcpy(cur_proc->name,name);
return; }

void free_user_proc(){
  while(top_proc){
                cur_proc=top_proc->prev;
                if(top_proc->name){ free(top_proc->name); malfreecntr--; }
                free(top_proc); malfreecntr--;
                top_proc=cur_proc;
                }
return; }

int def_count;
typedef struct def_w{
                struct def_w *prev;
                char *name;
                }def_w;
def_w *top_defw=NULL;

void free_got_define_words(){
  def_w *t;
  while(top_defw){
         t=top_defw->prev;
         if(top_defw->name){ malfreecntr--; free(top_defw->name); }
         free(top_defw);
         malfreecntr--;
         top_defw=t;
         }
return; }
void store_define_word(char *wd){
  def_w *t,*f;
  t=(def_w *)malloc(sizeof(def_w));
  if(t==NULL){ out_of_mem=1; return; }
  malfreecntr++;
  t->prev=NULL;
  if(top_defw==NULL){ top_defw=t; def_count=1; }
  else{ f=top_defw; while(f->prev)f=f->prev;
        f->prev=t; def_count++;
        }
  t->name=(char *)malloc(strlen(wd)+1);
  if(t->name==NULL){ out_of_mem=1; return; }
  malfreecntr++;
  strcpy(t->name,wd);
return; }


typedef struct label{
                struct label *prev;
                char *name;
                char type;
                char wasparm;
                }label;
label *top_label=NULL, *top_gobal=NULL;

void free_gobal(){
  label *t;
  while(top_gobal){
        t=top_gobal->prev;
        if(top_gobal->name){ malfreecntr--; free(top_gobal->name); }
        free(top_gobal); malfreecntr--;
        top_gobal=t;
        }
return; }

void free_label(){
  label *t;
  while(top_label){
        t=top_label->prev;
        if(top_label->name){ malfreecntr--; free(top_label->name); }
        free(top_label); malfreecntr--;
        top_label=t;
        }
return; }

label *tmp_lp;
void add_gobal(char *name, char tpe){
 label *t;
 t=(label *)malloc(sizeof(label));
 if(t==NULL){ out_of_mem=1;return; }
 malfreecntr++;
 t->prev=top_gobal; top_gobal=t;
 t->type=tpe;
 t->name=(char *)malloc(strlen(name)+1);
 if(t->name==NULL){ out_of_mem=1;return; }
 malfreecntr++;
 strcpy(t->name,name);
return; }

int find_variable(char *name,char typ){//-1 illegal, 0 nofound ,1/2 found
 int a;
 label *t;
 tmp_lp=NULL;

 for(a=0;;a++){//make sure it aint a sys var
        if(sysvariables[a].name==NULL)break;
        if(sysvariables[a].type==typ && !stricmp(sysvariables[a].name,name))return -1;
        }

 t=top_gobal;
 while(t){
        tmp_lp=t;
        if(t->type==typ && !stricmp(t->name,name))return 1;
        t=t->prev;
                }

 t=top_label;
 while(t){
        tmp_lp=t;
        if(t->type==typ && !stricmp(t->name,name))return 2;
        t=t->prev;
                }
return 0; }


void fadd_variable(char *name,char typ, char parm){
 int a;
 label *t;
 tmp_lp=NULL;

 for(a=0;;a++){//make sure it aint a sys var
        if(sysvariables[a].name==NULL)break;
        if(sysvariables[a].type==typ && !stricmp(sysvariables[a].name,name))return;
        }

 t=top_gobal;
 while(t){
        tmp_lp=t;
        if(t->type==typ && !stricmp(t->name,name))return;
        t=t->prev;
                }

 t=top_label;
 while(t){
        tmp_lp=t;
        if(t->type==typ && !stricmp(t->name,name))return;
        t=t->prev;
                }
 t=(label *)malloc(sizeof(label));
 if(t==NULL){ out_of_mem=1;return; }
 malfreecntr++;
 t->wasparm=parm;

 t->prev=top_label; top_label=t;
 t->type=typ;
 t->name=(char *)malloc(strlen(name)+1);
 if(t->name==NULL){ out_of_mem=1;return; }
 malfreecntr++;
 strcpy(t->name,name);
 tmp_lp=t;
return; }

typedef struct data_st{
                char *name;
                long offset;
                struct data_st *prev;
                }data_st;
data_st *top_data=NULL;
unsigned char *data_place=NULL;
long data_size=0;
long cur_data_offset=0;

void free_data_st(){
 data_st *t;
 while(top_data){
                t=top_data->prev;
                if(top_data->name){ free(top_data->name); malfreecntr--; }
                free(top_data); malfreecntr--;
                top_data=t;
                }
 if(data_place){ free(data_place); malfreecntr--; data_place=NULL; }
return; }

void fadd_data_pointer_name(char *name,long offsetptr){
 data_st *t;
 t=top_data;
 while(t){
        if(!stricmp(name,t->name))return;
        t=t->prev; }
 t=(data_st *)malloc(sizeof(data_st));
 if(t==NULL){ out_of_mem=1; return; }
 malfreecntr++;
 t->prev=top_data; top_data=t;
 t->offset=offsetptr;
 t->name=(char *)malloc(strlen(name)+1);
 if(t->name==NULL){ out_of_mem=1; return; }
 malfreecntr++;
 strcpy(t->name,name);
return; }

void add_data_byte(unsigned char k){
  //char w[10];
  //sprintf(w,"%x",k);
  if(data_place==NULL){ data_place=(char *)malloc(101);
                        if(data_place==NULL){ out_of_mem=1; return; }
                        malfreecntr++;
                        data_place[0]=0; data_size=100;
                        cur_data_offset=0;
                        }
  else if(cur_data_offset>data_size-10){
                 data_place=(char *)realloc(data_place,data_size+100);
                 if(data_place==NULL){malfreecntr--; out_of_mem=1; return; }
                 data_size+=100;
                  }
 //strcat(data_place,w);
 data_place[cur_data_offset++]=k;
return; }

void dump_proto(int st,int ed,char *line){
 int a;
 for(a=st; a<ed; a++) fprintf(dest,"%c",line[a]);
 fprintf(dest,";\n");
return; }

void dump_data_pointers(){
 data_st *t;
 t=top_data;
 while(t){
        fprintf(dest,"#define d_%s %ld\n",t->name,t->offset);
        t=t->prev;
         }
return; }

void dump_data(){
 long a;
 int b=0;
 fprintf(dest,"\n//Data\n");
 fprintf(dest,"long data_length=%ld;\n",cur_data_offset);
 dump_data_pointers();
 fprintf(dest,"unsigned char data[]={");
 if(data_place)
          for(a=0; a<cur_data_offset; a++){
                        fprintf(dest,"0x%x,",data_place[a]);
                        b++; if(b>14){ b=0; fprintf(dest,"\n            "); }
                                }
 fprintf(dest," 0 };\n\n//Gobals\n");
return; }

char curlabel[257];
char the_word[257];
//char new_line[512];//some are big

label *store_locals=NULL;

void pop_locals(){
 if(top_label)free_label(top_label); 
 top_label=store_locals;
 store_locals=NULL;
return; }

void push_locals(){
 if(store_locals)pop_locals();
 store_locals=top_label;
 top_label=NULL;
return; }

void str_free_locals(label *t){
 label *f=t;
 while(f){
        if(f->type==1){
                sprintf(the_word," str_free((char **)&s_%s);\n",f->name);
                strcat(new_line,the_word);
                        }
        f=f->prev;
        }
return; }

void dump_label(label *t){
 label *f=t;
 while(f){
        if(f->type==0)fprintf(dest," long i_%s=0;\n",f->name);
        if(f->type==1)fprintf(dest," char *s_%s=NULL;\n",f->name);
        if(f->type==2)fprintf(dest," float f_%s=0;\n",f->name);
        f=f->prev;
        }
 fprintf(dest,"\n");
return; }

typedef struct def_t{
                   char *label;
                   char *def;
                   char is_deffn;
                   char def_parms[12];
                   struct def_t *prev;
                   }def_t;
def_t *top_def=NULL;

char tmpcharheld[12];
int lptr;
void free_defines(){
 def_t *t;
 while(top_def){
              t=top_def->prev;
              if(top_def->label){ malfreecntr--; free(top_def->label); }
              if(top_def->def){ malfreecntr--; free(top_def->def); }
              malfreecntr--;
              free(top_def);
              top_def=t;
                }
return; }

def_t *cur_define;
int find_define(char matters, char wantfn, char *name){
 cur_define=top_def;
 while(cur_define){
         if((matters==0 || wantfn==cur_define->is_deffn) && !stricmp(cur_define->label,name))return 1;
         cur_define=cur_define->prev;
         }
return 0; }

void makedefine(char is_deffn, char *name,char *str){
 int a;
 def_t *t;
 t=(def_t *)malloc(sizeof(def_t));
 if(t==NULL){ out_of_mem=1; return; }
 malfreecntr++;
 t->prev=top_def; top_def=t;
 t->def=NULL;
 if(is_deffn==-1)t->is_deffn=0;
 else t->is_deffn=is_deffn;
 for(a=0;a<10;a++)t->def_parms[a]=tmpcharheld[a];
 t->label=(char *)malloc(strlen(name)+1);
 if(t->label==NULL){out_of_mem=1; return; }
 malfreecntr++;
 strcpy(t->label,name);
 if(is_deffn==-1){
         t->def=(char *)malloc(strlen(str)+1);
         if(t->def==NULL){ out_of_mem=1; return; }
         malfreecntr++;
         strcpy(t->def,str);
                        }
 else{
         t->def=(char *)malloc((strlen(str)-lptr)+1);
         if(t->def==NULL){ out_of_mem=1; return; }
         malfreecntr++;
         strcpy(t->def,str+lptr);
         lptr=strlen(str);
                }
return; }

void build_default_defs(){
 int c=0;
 for(;;){
        if(sysdefines[c].name==NULL)break;
        if(stricmp(sysdefines[c].name,"FLOAT") && stricmp(sysdefines[c].name,"INT"))
                                        makedefine(-1,sysdefines[c].name,sysdefines[c].def);
        c++;
         }
return; }

//unpack define, +the parm count test
int unpak_def(char *str){
 char k,k2;
 char w[3];
 int a=0,c,us;
 def_w *t;
 for(us=0;us<10;us++){ if(cur_define->def_parms[us]==0)break; }
 if(def_count>us){ error("Function missing parameter(s)"); return 1; }
 if(def_count<us){ error("Function has too many parameters"); return 1; }
 for(;;){
      k=cur_define->def[a++];
      k2=cur_define->def[a];
      if(k==0)break;
      if(toupper(k)>='A' && toupper(k)<='H' &&
                notletter(k2) && (k2<'0' || k2>'9')){
                        us=0;
                        for(c=0;;){
                                if(cur_define->def_parms[c]==0)break;
                                if(toupper(cur_define->def_parms[c])==toupper(k)){
                                                us=1;
                                                break;
                                                }
                                c++; if(c>9)break;
                                }
                        if(us==0){  sprintf(w,"%c",k);
                                     strcat(str,w); }
                        else{   t=top_defw;
                                us=0;
                                for(;;){
                                      if(us==c){
                                                strcat(str,t->name);
                                                break; }
                                      us++;
                                      t=t->prev; if(t==NULL)break;
                                                }
                                        }
                                }
      else{  sprintf(w,"%c",k);
             strcat(str,w); }
          }
return 0; }


typedef struct code{
                struct code *prev;
                char *line;
                }code;
code *main_code=NULL, *proc_code=NULL;
code *lst_line;
code *proc_entry_line=NULL;

void insert_line(code *line, char *str){
 code *t;
 t=(code *)malloc(sizeof(code));
 if(t==NULL){ out_of_mem=1;return; }
 malfreecntr++;
 t->prev=line->prev; line->prev=t;
 t->line=(char *)malloc(strlen(str)+1);
 if(t->line==NULL){ out_of_mem=1;return; }
 malfreecntr++;
 strcpy(t->line,str);
return; }

void dump_label_local(label *t){
 label *f=t;
 while(f){
        the_word[0]=0;
        if(f->wasparm==0 && f->type==0)sprintf(the_word," long i_%s=0;",f->name);
        if(f->type==1)sprintf(the_word," char *s_%s=NULL;",f->name);
        if(f->wasparm==0 && f->type==2)sprintf(the_word," float f_%s=0;",f->name);
        f=f->prev;
        if(the_word[0])insert_line(proc_entry_line,the_word);
        }
return; }


void store_line(char *str){
 code *t,*w;
 t=(code *)malloc(sizeof(code));
 if(t==NULL){ out_of_mem=1;return; }
 malfreecntr++;
 t->prev=NULL;
 if(in_proc){
  if(proc_code==NULL) proc_code=t;
  else{ w=proc_code; while(w->prev)w=w->prev;
                     w->prev=t;
                 }
        }
 else{
  if(main_code==NULL) main_code=t;
  else{ w=main_code; while(w->prev)w=w->prev;
                     w->prev=t;
         }
     }
 lst_line=t;
 t->line=(char *)malloc(strlen(str)+1);
 if(t->line==NULL){ out_of_mem=1;return; }
 malfreecntr++;
 strcpy(t->line,str);
return; }

void dump_code(code *t){
 code *k=t;
 while(k){
        fprintf(dest,"%s\n",k->line);
        k=k->prev;
        }
return; }

void free_code(){
 code *t;
 while(main_code){
         t=main_code->prev;
         if(main_code->line){ malfreecntr--; free(main_code->line); }
         free(main_code); malfreecntr--;
         main_code=t;
                }
return; }

void free_proc(){
 code *t;
 while(proc_code){
         t=proc_code->prev;
         if(proc_code->line){ malfreecntr--; free(proc_code->line); }
         free(proc_code); malfreecntr--;
         proc_code=t;
                }
return; }


void dump_header(){
 fprintf(dest,"/*\n");
 fprintf(dest,"     File Created by XST2C %s\n",_xst2c_version);
 fprintf(dest,"     XST2C (c) SnAkEsSoFt/RodneyMcConnell (snakessoft@yahoo.co.uk)\n");
 fprintf(dest,"*/\n\n");
 fprintf(dest,"#include \"xst_lib.h\"\n\n");
return; }

int err_cnt=0;
char had_error;
void error(char *str){
 if(top_inc)printf("File %s:",filename);
 printf("%s (line %d)\n",str,linecnt);
 err_cnt++;
 had_error=1;
return; }

void skipspaces(char *str){
 char k;
 for(;;){ k=str[lptr]; if(k!=32 && k!=9)break; lptr++;  }
return; }

void get_word(char *str){
 char k;
 int w_ptr=0;
 while(1){
   k=toupper(str[lptr]);
   if(k>='a' && k<='z');
   else if(k>='A' && k<='Z');
   else if(k=='_');
   else if(k>='0' && k<='9');
   else break;
   lptr++; the_word[w_ptr++]=k;
   if(w_ptr>=255)w_ptr=255;
   }
 the_word[w_ptr]=0;
return; }

int last_keyword;
int find_keyword(char *str){
 int c=0;
 last_keyword=0;
 for(;;){
        if(keywords[c]==NULL)break;
        if(!stricmp(keywords[c],str)){ last_keyword=c;
                                        return c+1; }
        c++;
         }
return 0; }

int find_s_keyword(char *str){
 int c=0;
 last_keyword=0;
 for(;;){
        if(s_keywords[c]==NULL)break;
        if(!stricmp(s_keywords[c],str)){ last_keyword=c;
                                         return c+1; }
        c++;
        }
return 0; }

int last_command;
int find_command(char *str,char tpe){
 int c=0,r;
 last_command=0;

 if(find_extern_command(str,tpe)){last_command=-90; return 1; }

 if(!stricmp(str,"SORT")){last_command=1000; return 1001;}
 if(!stricmp(str,"DIMTOP")){last_command=1001; return 1002;}
 if(!stricmp(str,"VARPTR")){last_command=1002; return 1003;}
 for(;;){
        if(sysprocs[c].name==NULL)break;
        r=sysprocs[c].rettype; if(r==9)r=0;
        if(r==tpe && !stricmp(sysprocs[c].name,str)){
                                           last_command=c;
                                            return c+1; }
        c++;
         }
return 0; }

int notletter(char k){
 k=toupper(k);
 if((k>='A' && k<='Z') || k=='_')return 0;
return 1; }


void skiptoeol(char *str){
 char k;
 for(;;){
      k=str[lptr];
      if(k==':'){lptr++; break; }
      if(k==0)break;
      lptr++;
      }
return; }


void add_type(char tpe){
                if(tpe==1)strcat(new_line,"s_");
                else if(tpe==2)strcat(new_line,"f_");
                else strcat(new_line,"i_");
return; }

int pastit,intfloat;
int testintfloat(char *str){
  int bptr=lptr,ok=0;
  lptr++;
  get_word(str);
  if(!stricmp(the_word,"float")){ok=1; strcat(new_line,"(float)"); }
  if(!stricmp(the_word,"int")){ok=1; strcat(new_line,"(int)"); }
  if(ok){ skipspaces(str);
          if(str[lptr]==')')lptr++;
          return 1;
                }
  else lptr=bptr;
return 0; }

void insert_in(int pos,char k){
 int cnt,ed=strlen(new_line);
 for(cnt=ed; cnt>=pos; cnt--) new_line[cnt+1]=new_line[cnt];
 new_line[cnt+1]=k;
return; }

typedef struct store_curpos{
                int pos;
                struct store_curpos *prev;
                }store_curpos;
store_curpos *top_curpos=NULL, *other_curpos=NULL;
store_curpos *free_curpos(store_curpos *wh,int use){
 store_curpos *t;
 while(wh){
                if(use) insert_in(wh->pos,'(');
                t=wh->prev;
                free(wh); malfreecntr--;
                wh=t;
                   }
return wh;  }
store_curpos *store_the_curpos(store_curpos *wh,int pos){
 store_curpos *t;
 t=(store_curpos *)malloc(sizeof(store_curpos));
 if(t==NULL)return wh;
 malfreecntr++;
 t->prev=wh;
 wh=t;
 t->pos=pos;
return wh; }

int pop_curpos_tree(){
 int wh=-1;
 store_curpos *t;
 if(other_curpos){
                t=other_curpos->prev;
                wh=other_curpos->pos;
                free(other_curpos);
                malfreecntr--;
                other_curpos=t;
                 }
return wh; }

char canto;
char sowasto;
char had_then,had_for_t;
char if_and_or;
int get_int(char *str, char isfloat, char isparm, char isprint, char is_if, char in_for, char no_var){
 char k,tpe,firstthing=1;
 int cur_pos,ooh;
 int bra_cnt=0;
 char w[5],need_end=0,a,m,making;
 store_curpos *our_curpos,*our_curpos2;

 other_curpos=free_curpos(other_curpos,0);
 top_curpos=free_curpos(top_curpos,0);
 sowasto=0; if_and_or=0;
 had_then=0;
 had_for_t=0;
 cur_pos=strlen(new_line);
 for(;;){
  // re_try:
     for(;;){
        skipspaces(str);
        if(str[lptr]=='(' && testintfloat(str)) skipspaces(str);
        if(str[lptr]!='(')break;
        bra_cnt++; strcat(new_line,"("); firstthing=1;
        other_curpos=store_the_curpos(other_curpos,cur_pos);
        //strcat(new_line,"@");
        cur_pos=strlen(new_line);
        lptr++;
                }
     if(str[lptr]=='-'){ lptr++; skipspaces(str);
                         strcat(new_line,"-"); }
     k=str[lptr];
     if(k=='\"'){ error("Type Mismatch"); skiptoeol(str); return 1; }
     if((k>='0' && k<='9') || k=='.'){
                    for(;;){
                        sprintf(w,"%c",k); strcat(new_line,w);
                        k=str[++lptr];
                        if(k!='.' && (k<'0' || k>'9'))break;
                                }
                        }
     else if(notletter(k)==0){
                if(no_var){ error("Can only be a number"); skiptoeol(str); return 1; }
                get_word(str);
                tpe=0;
                if(str[lptr]=='$'){tpe=1; lptr++; }
                else if(str[lptr]=='#'){tpe=2; lptr++; }
                skipspaces(str);
                if(tpe==1){ error("Type Mismatch"); skiptoeol(str); return 1; }
           skipspaces(str);
                if(find_s_keyword(the_word) || find_keyword(the_word)){ error("Illegal use of a keyword"); skiptoeol(str); return 1; }
                else if(find_command(the_word,tpe)) {
                                        if((last_command==-90 && tmp_extrn->ret==9) ||
                                               (sysprocs[last_command].rettype==9)){
                                                         error("Does not return a value");
                                                         skiptoeol(str); return 1;
                                                                        }
                                        do_command(0,str,0);
                                        if(str[lptr-1]==':')lptr--;
                                                }
          else if(str[lptr]=='('){ lptr++;
                        if(find_array(the_word,tpe)==0){ error("Undeminished array");
                                                         skiptoeol(str); break; }
                        m=cur_array->elecnt;
                        add_type(tpe);
                        strcat(new_line,the_word);
                        strcat(new_line,"[");
                        making=0;
                                for(a=0;;){
                                   our_curpos=top_curpos;
                                   our_curpos2=other_curpos;
                                   other_curpos=top_curpos=NULL;
                                   making=get_int(str,0,1,0,0,0,0);
                                   top_curpos=our_curpos;
                                   other_curpos=our_curpos2;
                                   if(making)break;
                                   strcat(new_line,"]");
                                   if(str[lptr-1]==',');
                                   else if(str[lptr]==')'){lptr++; break; }
                                   else{ error("Array missing )");break; }
                                   strcat(new_line,"[");
                                   a++;
                                      }
                           if(making)break;
                           if(a>m){error("Too many elements"); break; }
                           if(a<m){error("Missing element(s)"); break; }
                         }                            
                else if(str[lptr]=='[' || find_user_proc(the_word,tpe)){
                                        error("User procedures cannot return a value");
                                        skiptoeol(str); return 1;
                                                        }
                else{
                        fadd_variable(the_word,tpe,0);
                        add_type(tpe);
                        strcat(new_line,the_word);
                        }
                }
     else { error("1Syntax Error"); skiptoeol(str); return 1; }

     for(;;){
        skipspaces(str);
        if(str[lptr]!=')')break;
        if(bra_cnt==0){need_end=1; break; }
        lptr++;
        if(isparm==1 && bra_cnt==0){need_end=1; break; }
        bra_cnt--; strcat(new_line,")");
        ooh=pop_curpos_tree();
        if(ooh>-1)cur_pos=ooh;
                }
     if(need_end)break;
     k=str[lptr];
     if(in_for && notletter(k)==0){
                       get_word(str);
                       if(in_for==1 && !stricmp(the_word,"TO")){ had_for_t=1; break; }
                       else if(in_for==2 && !stricmp(the_word,"STEP")){ had_for_t=2; break; }
                       else { error("2Syntax Error"); skiptoeol(str); return 1; }
                        }
     else if(canto && isparm && toupper(str[lptr])=='T' && toupper(str[lptr+1])=='O'
                                        && notletter(str[lptr+2]) && (str[lptr+2]<'0' || str[lptr+2]>'9')){
                                             lptr+=2; sowasto=1; break;
                                                }
     else if(is_if && notletter(k)==0){
                       get_word(str);
                       if(!stricmp(the_word,"AND")) {strcat(new_line," && "); if_and_or=1; break;}
                       else if(!stricmp(the_word,"OR")) {strcat(new_line," || ");if_and_or=2; break;}
                       else if(!stricmp(the_word,"THEN")){ had_then=1; break; }
                       else { error("2Syntax Error"); skiptoeol(str); return 1; }
                         }
     else if(is_if && k=='='){lptr++;
                         if(str[lptr]=='>'){ if(is_if==2) strcat(new_line,"<");
                                             else strcat(new_line,">=");
                                             lptr++; }
                         else if(str[lptr]=='<'){ if(is_if==2)strcat(new_line,">");
                                                  else strcat(new_line,"<=");
                                                lptr++; }
                         else { if(is_if==2) strcat(new_line,"!=");
                                else strcat(new_line,"==");
                                }
                         }
     else if(is_if && k=='<'){lptr++;
                              if(str[lptr]=='='){lptr++; if(is_if==2)strcat(new_line,">");
                                                         else strcat(new_line,"<="); }
                              else if(str[lptr]=='>'){lptr++; if(is_if==2)strcat(new_line,"==");
                                                              else strcat(new_line,"!="); }
                              else {if(is_if==2)strcat(new_line,">=");
                                    else strcat(new_line,"<");
                                                }
                                        }
     else if(is_if && k=='>'){lptr++;
                             if(str[lptr]=='='){lptr++; if(is_if==2)strcat(new_line,"<");
                                                        else strcat(new_line,">="); }
                             else if(str[lptr]=='<'){lptr++;
                                                if(is_if==2)strcat(new_line,"==");
                                                else strcat(new_line,"!="); }
                             else {     if(is_if==2)strcat(new_line,"<=");
                                        else strcat(new_line,">");
                                        }
                                }
     else if(k==':')break;//{lptr++; break; }
     else if(k==';' && isprint){ lptr++; break; }
     else if(k==',' && isparm){ lptr++; break; }
     else if(k==']' && isparm==2){ lptr++; break; }
     else if(k==0)break;
     else if(k=='+' || k=='-' || k=='*' || k=='/' || k=='~' || k=='^' ||k=='|' ||k=='&'){
              if(firstthing==0 && (k=='*' || k=='/' || k=='~')){ strcat(new_line,")");
                                                                 top_curpos=store_the_curpos(top_curpos,cur_pos);
                                                                         }
              if(k=='~')k='%';
              sprintf(w,"%c",k);
              strcat(new_line,w);
              lptr++;
                }
     else {
                //printf("> %c %d \n",k,canto);
                error("12Syntax Error"); skiptoeol(str); return 1;
            }
     firstthing=0;
        }

 if(bra_cnt<0)error("Unexpected )");
 if(bra_cnt>0)error("Missing )");
 top_curpos=free_curpos(top_curpos,1);

return 0; }

int get_str(char *str, char isparm, char isprint, char is_if,char is_parm_no){
 char k,tpe,fst=1,wasnot=0;
 int brcnt=0;
 int mypos=0,ifp=0;
 char w[5],making,a,m;
 had_then=0; if_and_or=0;
//printf("!");
 for(;;){
//   re_try:
      skipspaces(str);
      k=str[lptr];
      if(k>='0' && k<='9'){ error("Type Mismatch"); return 1; }
      if(k=='\"'){
             //if(fst)strcat(new_line," store_setstr(\"");
             //else strcat(new_line," store_catstr(\"");
             //if(isparm){
                        strcat(new_line," str_pc(");
                        mypos=strlen(new_line)-2;
                        sprintf(w,"%d,",is_parm_no);
                        strcat(new_line,w);
             //             }
             //else {
             //     strcat(new_line," str_c(");
             //     mypos=strlen(new_line)-2;
             //     }
             if(ifp==0)ifp=mypos;
             strcat(new_line,"\""); lptr++; k=0;
             for(;;){
                    if(k!=0 && k!='\"'){sprintf(w,"%c",k); strcat(new_line,w); }
                    k=str[lptr];
                    //if(k=='\"' && str[lptr+1]!='\"'){ lptr++;
                    //                                    break;}
                    if(k==0){  error("Missing \""); return 1; }
                    lptr++;
                    if(k=='\"'){
                             //lptr++;
                             if(str[lptr]=='\"'){ lptr++;
                                          sprintf(w,"\\\"");
                                          strcat(new_line,w);
                                                }
                             else break;
                                        }
                        }
                    strcat(new_line,"\"");
                  }
      else if(notletter(k)==0){
           get_word(str);
          //if(isparm){
                        strcat(new_line," str_pc(");
                        mypos=strlen(new_line)-2;
                        sprintf(w,"%d,",is_parm_no);
                        strcat(new_line,w);
          //                }
          //else{
          //      strcat(new_line," str_c(");
          //      mypos=strlen(new_line)-2;
          //       }
          if(ifp==0)ifp=mypos;
           tpe=0;
           if(str[lptr]=='$'){tpe=1; lptr++; }
           else if(str[lptr]=='#'){tpe=2; lptr++; }
           if(tpe!=1){ error("Type Mismatch"); skiptoeol(str); return 1; }
           skipspaces(str);
           if(find_s_keyword(the_word) || find_keyword(the_word)){ error("Illegal use of a keyword"); skiptoeol(str); return 1; }
           else if(find_command(the_word,tpe)) {
                              if((last_command==-90 && tmp_extrn->ret==9) ||  
                                 (sysprocs[last_command].rettype==9)){
                                                    error("Does not return a value");
                                                    skiptoeol(str); return 1;
                                                                  }
                               do_command(fst,str,0);
                               if(str[lptr-1]==':')lptr--;
                               //if(str[lptr-1]==')')lptr--;
                        //printf("(%c)",str[lptr]);
                               }
          else if(str[lptr]=='('){ lptr++;
                        if(find_array(the_word,tpe)==0){ error("Undeminished array");
                                                         skiptoeol(str); break; }
                        m=cur_array->elecnt;
                        add_type(tpe);
                        strcat(new_line,the_word);
                        strcat(new_line,"[");
                        making=0;
                                for(a=0;;){
                                   making=get_int(str,0,1,0,0,0,0);
                                   if(making)break;
                                   strcat(new_line,"]");
                                   if(str[lptr-1]==',');
                                   else if(str[lptr]==')'){lptr++; break;}
                                   else{ error("Array missing )");break; }
                                   strcat(new_line,"[");
                                   a++;
                                      }
                           if(making)break;
                           if(a>m){error("Too many elements"); break; }
                           if(a<m){error("Missing element(s)"); break; }
                                }
          else if(str[lptr]=='[' || find_user_proc(the_word,tpe)){
                                        error("User procedures cannot return a value");
                                        skiptoeol(str); return 1;
                                                        }

            else{
             fadd_variable(the_word,tpe,0);
             //if(fst)strcat(new_line," store_setstr(");
             //else strcat(new_line," store_catstr(");
             add_type(tpe);
             strcat(new_line,the_word);
             //strcat(new_line,"");
                  }
              }
      else { error("3Syntax Error"); skiptoeol(str); return 1; }
      fst=0;
      skipspaces(str);
      if(canto && isparm && toupper(str[lptr])=='T' && toupper(str[lptr+1])=='O'
                                        && notletter(str[lptr+2]) && (str[lptr+2]<'0' || str[lptr+2]>'9')){
                                             lptr+=2; break;
                                                }
      if(is_if && notletter(str[lptr])==0){
                       get_word(str);
                       if(!stricmp(the_word,"AND")){    for(;brcnt>=0;brcnt--)strcat(new_line,")");
                                                        strcat(new_line," && ");if_and_or=1; break;}
                       else if(!stricmp(the_word,"OR")) {
                                                        for(;brcnt>=0;brcnt--)strcat(new_line,")");
                                                        strcat(new_line," || ");if_and_or=2; break;}
                       else if(!stricmp(the_word,"THEN")){ had_then=1;break;}
                       else { error("4Syntax Error"); skiptoeol(str); return 1; }
                         }
      else if(is_if && str[lptr]=='='){
                                lptr++;
                                //if(is_if==2)
                                strcat(new_line,",");
                                }
      else if(is_if && str[lptr]=='<' && str[lptr+1]=='>'){
                                 lptr+=2;
                                 wasnot=1;
                                //if(is_if==2)
                                strcat(new_line,",");
                                }
      else if(str[lptr]==0)break;
      else if(str[lptr]==';' && isprint){ lptr++; break; }
      //else if(isparm==1 && (str[lptr]==')' || str[lptr]==',')){ lptr++; break; }
      else if(isparm==1 && str[lptr]==','){ lptr++; break; }
      else if(isparm==1 && str[lptr]==')') break; 
      //else if(is_if && str[lptr]==')'){ lptr++; break; }
      else if(str[lptr]==':')break;//{lptr++; break;}
      else if((str[lptr]==',' || str[lptr]==']') && isparm==2){ lptr++; break; }
      else if(str[lptr]=='+') { lptr++; strcat(new_line,","); }
      else {
//printf(">%d %c",is_if,str[lptr]);
      error("4Syntax Error"); skiptoeol(str); return 1; }
      brcnt++;
      }
  for(;brcnt>=0;brcnt--)strcat(new_line,")");
 if(mypos>0)new_line[mypos]='s';
 if(is_if && ifp>0){new_line[ifp]='m';
                    if(wasnot)new_line[ifp-6]='!';
                        }
// printf("@");
return 0; }

int last_was_e(char *str){
 int bp=lptr-1;
 for(;;){
        if(bp<1)break;
        if(str[bp]==0)return 1;
        if(str[bp]==':')return 1;
        if(str[bp]!=32 && str[bp]!=9)break;
        bp--;
        }
return 0; }

void unsupported_com(int num){
 char str[100];
 sprintf(str,"Unsupported Command %s",keywords[num]);
 error(str);
return; }


void do_s_keyword(char *str){
 int num=0;
 char k;
         //strcat(new_line," s_");
         //strcat(new_line,s_keywords[last_keyword]);
         //strcat(new_line,"(");
         //get_int(str,0,0,0,0,0,1);
         //strcat(new_line,");");
        skipspaces(str);
        if(str[lptr]<'0' || str[lptr]>'9'){ error("Must be a NUMBER");
                                          skiptoeol(str); return; }
        for(;;){
               k=str[lptr];
               if(k==0 || k==32 || k==9 || k==':')break;
               else if(k>='0' && k<='9');
               else { error("Can Only be a NUMBER"); skiptoeol(str); return; }
               num*=10; num+=k-'0';
               lptr++;
                        }
         switch(last_keyword){
                       case 0: set_max_sam=num; break;
                       case 1: set_max_mod=num; break;
                       case 2: set_max_sprite=num; break;
                       case 3: set_max_bank=num; break;
                       case 4: set_max_anim=num; break;
                       case 5: set_max_object=num; break;
                        }
return; }

void make_type(char type,char *str){
 int a;
 char bw[255],tpe;
 skipspaces(str);
 if(str[lptr]==0 || str[lptr]==':'){ error("Syntax Error"); return; }
 for(;;){
        skipspaces(str);
        if(notletter(str[lptr])){ error("Syntax Error"); return; }
        get_word(str);
        tpe=0;
        if(str[lptr]=='$'){ lptr++; tpe=1; }
        else if(str[lptr]=='#'){ lptr++; tpe=2; }

        a=find_variable(the_word,tpe);//-1 illegal, 0 nofound ,1/2 found
        if(a>0){
                error("Label already in Use"); return; 
                }
        else{
         if(a!=0){ error("Syntax Error"); return; }

         strcpy(bw,the_word);
         if(type==2){ strcat(bw,"#");
                      makedefine(-1,the_word,bw);
                        }
         if(type==1){ strcat(bw,"$");
                      makedefine(-1,the_word,bw);
                        }
         fadd_variable(the_word,tpe, 0);
                }
        skipspaces(str);
        if(str[lptr]==',')lptr++;
        else if(str[lptr]==0 || str[lptr]==':')break;
        else { error("Syntax Error"); return; }
    }
return; }

void convert_line(char *str){
 char t_str[255];
 char tpe,making,a;
 int m;
 proc *our_proc;

 new_line[0]=0; lptr=0;
 for(;;){
        //notfirst=0;
        skipspaces(str);
        if(str[lptr]==0 || str[lptr]=='\n')break;
        for(;;){ if(str[lptr]!=':')break; lptr++; }
        skipspaces(str);
        if(str[lptr]==0 || str[lptr]=='\n')break;
        if(str[lptr]=='\''){
                        //sprintf(new_line,"//%s",str+lptr+1);
                        strcat(new_line,"//");
                        strcat(new_line,str+lptr+1);
                        lptr=strlen(str);
                        break;  }
        if(notletter(str[lptr])){
                                //printf(">%c %d<",str[lptr],str[lptr]);
                                error("5Syntax Error"); break; }
        get_word(str);
        tpe=0;
        if(str[lptr]=='$'){ lptr++; tpe=1; }
        else if(str[lptr]=='#'){ lptr++; tpe=2; }
        if(tpe==0 && !stricmp(the_word,"STRING"))make_type(1,str);
        else if(tpe==0 && !stricmp(the_word,"FLOAT"))make_type(2,str);
        else if(tpe==0 && !stricmp(the_word,"INT"))make_type(0,str);
        else if(find_s_keyword(the_word)) do_s_keyword(str);
        else if(find_keyword(the_word)){
                                do_keyword(str);
                                        }
        else if(find_command(the_word,tpe)) {
                                        strcat(new_line," ");
                                        do_command(0,str,1);
                                        strcat(new_line,";");
                                        }
        else if(str[lptr]==':'){ lptr++;//goto location
                                 //sprintf(t_str," %s: ",the_word);
                                 strcpy(curlabel,the_word);
                                 if(win_compat)sprintf(t_str," __asm _p_%s:",the_word);
                                 else sprintf(t_str," __asm__(\" _p_%s:\" );",the_word);
                                 strcat(new_line,t_str); 
                                  }        
        else { skipspaces(str);
               if(str[lptr]=='('){ lptr++;//array set
                                if(find_array(the_word,tpe)==0){
                                                error("Undeminished array");
                                                skiptoeol(str); break;
                                                                }
                                m=cur_array->elecnt;
                                strcat(new_line," ");
                                if(tpe==1) strcat(new_line," set_str((char **)&");
                                add_type(tpe);
                                strcat(new_line,the_word);
                                strcat(new_line,"[");
                                making=0;
                                for(a=0;;){
                                        making=get_int(str,0,1,0,0,0,0);
                                        if(making)break;
                                        strcat(new_line,"]");
                                        if(str[lptr-1]==',');
                                        else if(str[lptr]==')'){lptr++;break;}
                                        else{ error("Array missing )");break; }
                                        strcat(new_line,"[");
                                        a++;
                                        }
                                if(making)break;
                                if(a>m){error("Too many elements"); break; }
                                if(a<m){error("Missing element(s)"); break; }
                                skipspaces(str);
                                if(str[lptr]!='='){ error("Code has no effect"); break; }
                                if(tpe!=1){strcat(new_line,"=");
                                          if(tpe==2)strcat(new_line,"(float)");
                                                }
                                else strcat(new_line,",");
                                lptr++;
                                if(tpe==2)get_int(str,1,0,0,0,0,0);
                                else if(tpe==0)get_int(str,0,0,0,0,0,0);
                                else get_str(str,0,0,0,0);
                                if(tpe==1)strcat(new_line,")");
                                if(new_line[strlen(new_line)-1]!=';')strcat(new_line,";");
                                        }
               else if(str[lptr]=='='){ lptr++;//set variable (rem getint/getstring)
                                strcpy(t_str,the_word);
                                if(tpe!=1){
                                         strcat(new_line," ");
                                         add_type(tpe);
                                         strcat(new_line,the_word);
                                         strcat(new_line,"=");
                                         if(tpe==2)strcat(new_line,"(float)");
                                                }
                                else{  strcat(new_line," set_str((char **)&");
                                         add_type(tpe);
                                         strcat(new_line,the_word);
                                         strcat(new_line,",");
                                                }
                                fadd_variable(the_word,tpe,0);
                                if(tpe==2)get_int(str,1,0,0,0,0,0);
                                else if(tpe==0)get_int(str,0,0,0,0,0,0);
                                else get_str(str,0,0,0,0);
                                if(tpe==1){ //strcat(new_line," set_str((char **)&");
                                            //add_type(tpe);
                                            //strcat(new_line,t_str);
                                            strcat(new_line,")");
                                                }
                                //else
                                if(new_line[strlen(new_line)-1]!=';')strcat(new_line,";");
                                        }
               else{//user procedure
                     making=0; m=0;
                     if(find_user_proc(the_word,tpe)==0){add_user_proc(the_word,tpe,0); making=1; }
                     our_proc=cur_proc;
                     skipspaces(str);
                     strcat(new_line," ");
                     add_type(tpe);
                     strcat(new_line,the_word);
                     strcat(new_line,"(");
                     if(str[lptr]=='['){lptr++;
                              if(making==0 && our_proc->parms[0]==0){
                                                        error("This procedure doesn't have any parameters");
                                                        skiptoeol(str);
                                                        break; }
                                                        
                              for(;;){
                                if(making){
                                         skipspaces(str);
                                         if(str[lptr]==']'){ lptr++; break; }
                                         a=scan_next(str);
                                         our_proc->parms[m]='0';
                                         if(a==1)our_proc->parms[m]='1';
                                         }
                                else {a=our_proc->parms[m];
                                      if(a==0){ error("Too many parameters");
                                                break; }
                                      a-='0';
                                        }
                                if(a==1) get_str(str,2,0,0,m);
                                else get_int(str,0,2,0,0,0,0);
                                m++;
                                if(str[lptr-1]==',')strcat(new_line,",");
                                else if(str[lptr-1]==']') break;
                                else { error("Procedure Syntax Error");
                                       skiptoeol(str);
                                       break; }

                                if(making==0 && our_proc->parms[m]==0){ error("Too many parameters");
                                                                        skiptoeol(str);
                                                                        break; }
                                    }//for
                            if(making==0 && our_proc->parms[m]!=0){ error("Procedure Missing parameter(s)");
                                                                        break; }
                                  }
                        else if(making==0 && our_proc->parms[0]!=0)
                                        error("Procedure Missing parameter(s)");
                     strcat(new_line,");");
                          }
        skipspaces(str);
        if(str[lptr]==0)break;
        else if(str[lptr]==':')lptr++;
        else if(last_was_e(str));
        else { error("6Syntax Error"); break; }
                }
           }//for
//printf(">%s %s\n",str,new_line);
return; }

typedef struct our_element{
                char *label;
                char type;
                struct our_element *prev;
                }our_element;
typedef struct our_structs{
                char *label;
                char dimtype;
                struct our_structs *prev;
                our_element *top_element;
                }our_structs;
our_structs *top_struct=NULL,*tmp_struct=NULL;

void free_ele(our_element *top){
 our_element *tmp;
 while(top){
        tmp=top->prev;
        if(top->label){ free(top->label); malfreecntr--;}
        free(top);malfreecntr--;
        top=tmp;
   }
return; }

void free_structs(){
 our_structs *tmp_struct;
 while(top_struct){
          tmp_struct=top_struct->prev;
          if(top_struct->label){ free(top_struct->label); malfreecntr--; }
          if(top_struct->top_element) free_ele(top_struct->top_element);
          free(top_struct);malfreecntr--;
          top_struct=tmp_struct;
           }
 tmp_struct=NULL;
return; }

int make_struct(char *label){
 our_structs *tmp_struct;
        tmp_struct=(our_structs *)malloc(sizeof(our_structs));
        if(tmp_struct==NULL)return -1; malfreecntr++;
        tmp_struct->prev=top_struct;
        top_struct=tmp_struct;
        tmp_struct->dimtype=0;
        tmp_struct->top_element=NULL;
        tmp_struct->label=(char *)malloc(strlen(label)+1);
        if(tmp_struct->label==NULL)return -1; malfreecntr++;
        strcpy(tmp_struct->label,label);
return 0; }

int add2struct(char *label,char type){
 our_element *tmp;
 if(top_struct==NULL)return -1;
 tmp=(our_element *)malloc(sizeof(our_element));
 if(tmp==NULL)return -1; malfreecntr++;
 tmp->prev=top_struct->top_element;
 top_struct->top_element=tmp;
 tmp->type=type;
 tmp->label=(char *)malloc(strlen(label)+1);
 if(tmp->label==NULL)return -1; malfreecntr++;
 strcpy(tmp->label,label);
return 0; }

int find_element(char *the_word){
 our_element *tmp;
 if(tmp_struct==NULL)return -1;
 tmp=tmp_struct->top_element;
 while(tmp){
        if(!stricmp(tmp->label,the_word))return 1;
        tmp=tmp->prev;
                }
return -1; }

int find_struct(char *the_word){
 tmp_struct=top_struct;
 while(tmp_struct){
        if(!stricmp(tmp_struct->label,the_word))return 1;
        tmp_struct=tmp_struct->prev;
        }
return -1; }


int preprocess(char *str){
 char oldstr[257];
 char k,ft=1,ts;
 char w[5];
 long total;
 int srcp=0,desp=0,a,ha,num;
 char needglobal;
 char another_tmpstr[100];
 char doanothergo=0;

 strcpy(oldstr,str);

 for(;;){
       k=oldstr[srcp++];
       if(k==0)break;
       if(k=='\"'){//get string
               ft=0;
               str[desp++]='\"';
               k=oldstr[srcp];
              if(k=='\"' && oldstr[srcp+1]!='\"') srcp++; 
              else for(;;){
                  str[desp++]=k;
                  if(k=='\\')str[desp++]=k;
                  k=oldstr[++srcp];
                  if(k==0){  error("String missing \""); return 1; }
                  if(k=='\"'){ srcp++;
                              if(oldstr[srcp]=='\"') str[desp++]='\"';
                              else break;
                              }
                      }
               str[desp++]='\"';
                 }
       else if(ft==1 && k=='\''){
                      strcpy(str,oldstr);
                      desp=strlen(str);
                      break;
                             }
       else if(k=='\''){//get ASCII
                       k=oldstr[srcp++];
                       sprintf(w,"%d",k);
                       str[desp]=0;
                       strcat(str,w);
                       desp=strlen(str);
                       if(oldstr[srcp]!='\''){ error("Missing \'"); return 1; }
                       srcp++;
                        }
       else if(k=='$' ||(k=='0' && toupper(oldstr[srcp])=='X')){//hexnum
                        ft=0;
                        if(k=='0')srcp++;
                        total=0;
                        for(;;){
                                k=toupper(oldstr[srcp]);
                                if(k>='0' && k<='9'){
                                                total*=0x10;
                                                total+=k-'0';
                                                srcp++;
                                                    }
                //todo: future update check if it's A to F only
                                else if(k>='A' && k<='Z'){
                                                total*=0x10;
                                                total+=(k-'A')+10;
                                                srcp++;
                                                }
                                else break;
                                  }
                        sprintf(the_word,"%ld",total);
                         str[desp]=0;
                         strcat(str,the_word);
                         desp=strlen(str);
                                }
       else if(k=='%'){//bin number
                        ft=0;
                        total=0;
                        for(;;){
                //todo: future update check if it's 01 not 012
                                k=toupper(oldstr[srcp]);
                                if(k>='0' && k<='9'){
                                                total*=2;
                                                total+=k-'0';
                                                srcp++;
                                                    }
                                else break;
                                  }
                        sprintf(the_word,"%ld",total);
                         str[desp]=0;
                         strcat(str,the_word);
                         desp=strlen(str);
                        }
       else if(notletter(k)==0){//getword
                        ft=0;
                        for(a=0;;){
                           the_word[a++]=k;
                           k=oldstr[srcp];
                           if(notletter(k) && (k<'0' || k>'9'))break;
                           srcp++;
                                }
                         the_word[a]=0;
                         str[desp]=0;
                         ts=1;
                         if(!stricmp(the_word,"MOD"))strcpy(the_word,"~");
                        else if(find_struct(the_word)==1){
                         if(oldstr[srcp]=='('){ num=-1; ha=0;
                                doanothergo=1;
                                if(tmp_struct->dimtype==0){error("Struct Not Array Type");return 1; }
                                for(;;){
                                    k=oldstr[srcp];
                                    another_tmpstr[ha++]=k;
                                    another_tmpstr[ha]=0;
                                    if(k==':' || k==0){error("MIssing Bracket"); return 1; }
                                    if(k=='(') num++;
                                    if(k==')') { if(num<1)break;
                                                 num--; }
                                    srcp++;
                                        }
                                srcp++;//past the )
                                }
                         else if(tmp_struct->dimtype==1){error("Array Struct Missing ("); return 1;}
                         if(oldstr[srcp]!='.'){error("Struct Missing Element"); return 1; }
                         srcp++;
                        a=0;
                        while(1){ //get LABEL
                                k=oldstr[srcp];
                                if((toupper(k)>='A' && toupper(k)<='Z') || k=='_') the_word[a++]=k;
                                else if(k>='0' && k<='9') the_word[a++]=k;
                                else break;
                                srcp++;
                                } the_word[a]=0;
                        if(oldstr[srcp]=='#'){ srcp++; strcat(the_word,"#"); }
                        if(oldstr[srcp]=='$'){ srcp++; strcat(the_word,"$"); }
                        if(find_element(the_word)==-1){error("Element Not Part Of Struct"); return 1; }
                        strcat(str,"_"); strcat(str,tmp_struct->label);
                        strcat(str,"_"); strcat(str,the_word);
                        if(tmp_struct->dimtype==1)strcat(str,another_tmpstr);
                        ts=0;
                        }

                         else if((!stricmp(the_word,"STRUCT") || !stricmp(the_word,"GLOBALSTRUCT"))
                                      && oldstr[srcp]==' '){
                                 needglobal=0;
                                 if(!stricmp(the_word,"GLOBALSTRUCT"))needglobal=1;
                                 for(;;){ if(oldstr[srcp]!=32)break; srcp++; }
                                 a=0;
                                 while(1){ //get LABEL
                                        k=oldstr[srcp];
                                        if((toupper(k)>='A' && toupper(k)<='Z') || k=='_') the_word[a++]=k;
                                        else if(k>='0' && k<='9') the_word[a++]=k;
                                        else break;
                                        srcp++;
                                        } the_word[a]=0;
                                if(a==0){error("Missing Parameter");
                                        return 1;}
                                if(make_struct(the_word)==-1){error("Out Of Memory");return 1; }
                                another_tmpstr[0]=0;
                                for(;;){ if(oldstr[srcp]!=32)break; srcp++; }
                                if(oldstr[srcp]=='('){ num=-1; ha=0; needglobal=0;
                                                doanothergo=1;
                                        for(;;){
                                            k=oldstr[srcp];
                                            another_tmpstr[ha++]=k;
                                            another_tmpstr[ha]=0;
                                            if(k==':' || k==0){error("Missing Bracket"); return 1; }
                                            if(k=='(') num++;
                                            if(k==')') { if(num<1)break;
                                                         num--; }
                                            srcp++;
                                                }
                                        srcp++;//past the )
                                        top_struct->dimtype=1; strcat(str,"Dim ");
                                        for(;;){ if(oldstr[srcp]!=32)break; srcp++; }
                                        }
                                if(oldstr[srcp]!='='){error("Syntax Error"); return 1; }
                                if(needglobal) strcat(str,"gobal ");
                                srcp++;
                                for(;;){
                                        for(;;){ if(oldstr[srcp]!=32)break; srcp++; }
                                        a=0;
                                       while(1){ //get LABEL
                                             k=oldstr[srcp];
                                            if((toupper(k)>='A' && toupper(k)<='Z') || k=='_') the_word[a++]=k;
                                            else if(k>='0' && k<='9') the_word[a++]=k;
                                            else break;
                                            srcp++;
                                            } the_word[a]=0;
                                     if(a==0){error("Struct Missing Element"); return 1; }
                                     k=0;
                                    if(oldstr[srcp]=='#')k=2;
                                    if(oldstr[srcp]=='$')k=1;
                                    if(k==1){ srcp++; strcat(the_word,"$"); }
                                    if(k==2){ srcp++; strcat(the_word,"#"); }
                                    if(add2struct(the_word,k)==-1){error("Out Of Memory"); return 1; }
                                    if(needglobal || top_struct->dimtype){  strcat(str,"_"); strcat(str,top_struct->label);
                                                  strcat(str,"_"); strcat(str,the_word);
                                                  strcat(str,another_tmpstr);
                                                }
                                   for(;;){ if(oldstr[srcp]!=32)break; srcp++; }
                                  if(oldstr[srcp]!=','){
                                        if(oldstr[srcp]!=':' && oldstr[srcp]!=0){error("Syntax Error"); return 1;}
                                        break;
                                         }
                                if(needglobal || top_struct->dimtype) strcat(str,",");
                                srcp++;
                                }
                               ts=0;
                                }
                         else if(!stricmp(the_word,"DIR") && oldstr[srcp]=='$'){
                                        srcp++;
                                        for(;;){
                                              if(oldstr[srcp]!=32)break;
                                              srcp++;
                                                }
                                        if(oldstr[srcp]=='='){ srcp++;
                                                              strcpy(the_word,"SetDir ");
                                                                        }
                                        else strcpy(the_word,"GetDir$");
                                                        }
                         else if(find_define(1,0,the_word)) strcpy(the_word,cur_define->def);
                         else if(find_define(1,1,the_word)){
                                                for(;;){ if(oldstr[srcp]!=32 && oldstr[srcp]!=9)break;
                                                           srcp++; }
                                                if(oldstr[srcp]!='('){ error("Function missing (");
                                                                        return 1; }
                                                srcp++; def_count=0;
                                                free_got_define_words();
                                                for(;;){
                                                       for(a=0;;){
                                                           k=oldstr[srcp];
                                                           if(k!='.' && notletter(k) && (k<'0' || k>'9'))break;
                                                           the_word[a++]=k; srcp++;
                                                                }
                                                       the_word[a]=0;
                                                       store_define_word(the_word);
                                                       for(;;){ if(oldstr[srcp]!=32 && oldstr[srcp]!=9)break;
                                                                   srcp++; }
                                                        if(oldstr[srcp]==',')srcp++;
                                                        else if(oldstr[srcp]==')'){ srcp++; break; }
                                                        else { error("Function Missing )");
                                                               free_got_define_words();
                                                               return 1; }
                                                         }
                                                a=unpak_def(str);
                                                free_got_define_words();
                                                if(a)return 1;
                                                ts=0;
                                                        }
                         if(ts)strcat(str,the_word);

                         desp=strlen(str);
                         if(ts && oldstr[srcp]=='$'){ srcp++;
                                                str[desp++]='$'; }
                        if(!stricmp(the_word,"REM")){
                                       strcat(str,oldstr+srcp);
                                       desp=strlen(str);
                                       break;
                                        }
                        if(!stricmp(the_word,"CADD")){
                                       strcat(str,oldstr+srcp);
                                       desp=strlen(str);
                                       break;
                                        }
                              }
       else if(k>='0' && k<='9'){
                      ft=0;  
                      for(;;){ str[desp++]=k;
                               k=oldstr[srcp];
                               if(k<'0' || k>'9')break;
                               srcp++;
                                }
                        }
       else { str[desp++]=k; if(k!=32 && k!=9)ft=0; }
        }
 str[desp]=0;

 if(doanothergo==1) return preprocess(str);
// printf("%s >\n%s\n",oldstr,str);

return 0; }

char endif_eol=0;
void dump_endif(){
 for(;;){
    strcat(new_line,"}");
    endif_eol--;
    if(endif_eol<1)break;
    }
return; }


int convert(){
 char str[257];
 int a;
 char k,st;

 src=fopen(filename,"r");
 if(src==NULL){ printf("Cannot open source: %s\n",filename);
                return -1; }
 strcpy(str,filename);
 a=strlen(str);
 for(;a>0;a--)
        if(str[a]=='.'){ str[a]=0; break; }
 strcat(str,".C"); 
 dest=fopen(str,"w");
 if(dest==NULL){ printf("Cannot open dest: %s\n",str);
                 return -1; }

 dump_header();

 for(;;){
       //if(err_cnt>2)break;//don't want too many errors
       k=getc(src);if(k<1){  k=0;
                             if(top_inc)pop_include();
                             else break; }
       str[0]=k; st=1;
       for(a=1;;a++){
                if(k<1 || k=='\n')break;
                k=fgetc(src);
                if(k<1 || k=='\n')break;
                if(st)str[a]=k;
                if(a>255){ str[a]=0;
                           if(st)printf("Line %d too long\n",linecnt);
                           st=0;
                          }
                  }
        str[256]=0;
        if(st)str[a]=0;

        if(preprocess(str)==0){
                convert_line(str);

                if(endif_eol>0) dump_endif();

                store_line(new_line);
                        }
        linecnt++; total_lines++;
                }

 if(need_endif>0)error("If without EndIf");
 if(in_switch>0)error("Switch without EndSwitch");
 if(in_proc)error("Missing EndProc");


 fprintf(dest,"int total_sam=%d;\n",set_max_sam);
 fprintf(dest,"int total_mod=%d;\n",set_max_mod);
 fprintf(dest,"int total_sprites=%d;\n",set_max_sprite);
 fprintf(dest,"int max_mem_bank=%d;\n",set_max_bank);

 fprintf(dest,"int total_anim=%d;\n",set_max_anim);
 fprintf(dest,"int total_object=%d;\n",set_max_object);


 dump_data();

 dump_label(top_gobal);
// fprintf(dest,"\nvoid main(int argc,char **argv){\n");

 fprintf(dest,"\nvoid proc_main(){\n");

 dump_label(top_label);

 if(had_a_dim)
         for(a=0; a<=cur_top_ele; a++)fprintf(dest," int a%d;\n",a);

 if(win_compat){
         fprintf(dest,"\n __asm call _entry\n");
         fprintf(dest," error(4);\n");
         fprintf(dest," __asm _entry:\n\n");
        }
 else{
         fprintf(dest,"\n __asm__(\" call _entry\" );\n");
         fprintf(dest," error(4);\n");
         fprintf(dest," __asm__(\" _entry:\" );\n\n");
        }

 dump_arrays_reset();

 

 store_line("end_of_proc:\n");
 new_line[0]=0;
 str_free_locals(top_label); store_line(new_line);
 new_line[0]=0;
 str_free_locals(top_gobal); store_line(new_line);

 other_curpos=free_curpos(other_curpos,0);
 top_curpos=free_curpos(top_curpos,0);


 dump_code(main_code);

 dump_arrays_str_free();

 fprintf(dest,"prog_end();\n");

 fprintf(dest,"return; }\n\n");

 dump_code(proc_code);

return 0; }

int find_extern_command(char *label, char type){
 char r;
 extern_cmd *t=top_extrn;
 tmp_extrn=NULL;
 while(t){
        tmp_extrn=t;
        r=t->ret; if(r==9)r=0;
        if(r==type && !stricmp(t->name,label))return 1; 
        t=t->prev;
                }
return 0; }

void store_extern_command(char *label, char *parms, char ret){
 extern_cmd *t;
 t=( extern_cmd *)malloc(sizeof(extern_cmd));
 if(t==NULL){ out_of_mem=1; return; }
 malfreecntr++;
 t->prev=top_extrn; top_extrn=t;
 t->ret=ret;
 t->parms=NULL;
 t->name=(char *)malloc(strlen(label)+1);
 if(t->name==NULL){ out_of_mem=1;return; }
 malfreecntr++;
 strcpy(t->name,label);
 t->parms=(char *)malloc(strlen(parms)+1);
 if(t->parms==NULL){ out_of_mem=1;return; }
 malfreecntr++;
 strcpy(t->parms,parms);
return; }

void free_extern_commands(){
 extern_cmd *t;
 while(top_extrn){
                t=top_extrn->prev;
                if(top_extrn->name){free(top_extrn->name);
                                        malfreecntr--; }
                if(top_extrn->parms){free(top_extrn->parms);
                                        malfreecntr--; }
                free(top_extrn); malfreecntr--;
                top_extrn=t;
                } 
return; }

void list_extern_commands(){
 extern_cmd *t=top_extrn;
 if(t==NULL) printf("No extern commands loaded\n");
 else while(t){
        printf("%s %s %d\n",t->name,t->parms,t->ret);
        t=t->prev;
                } 
return; }

void read_extern_commands(){
 FILE *la;
 char k;
 int c;
 la=fopen("XST_XTRA.CMD","r");
 if(la==NULL)return;
      for(;;){
        c=0;
        for(;;){  k=fgetc(la); if(k<1 || (k!=32 && k!=9 && k!='\n'))break; }
        if(k<1)break;
        curlabel[c++]=k;
        for(;;){
               k=fgetc(la);                
               if(k<1 || (notletter(k) && (k<'0' || k>'9')))break;
               curlabel[c++]=k;
                }
        curlabel[c]=0;
        if(k<1 || k=='\n'){ printf("ExternCommand File Error\n"); break; }
        c=0;
        for(;;){  k=fgetc(la); if(k<1 || (k!=32 && k!=9))break; }
        if(k==',') for(;;){  k=fgetc(la); if(k<1 || (k!=32 && k!=9))break; }
        the_word[c++]=k;
        for(;;){
               k=fgetc(la); 
               if(k<1 || (notletter(k) && (k<'0' || k>'9')))break;
               the_word[c++]=k;
                }
        the_word[c]=0;
        if(k<1 || k=='\n'){ printf("ExternCommand File Error\n"); break; }
        for(;;){  k=fgetc(la); if(k<1 || (k!=32 && k!=9))break; }
        if(k==',') for(;;){  k=fgetc(la); if(k<1 || (k!=32 && k!=9))break; }
        if(k<1 || k=='\n'){ printf("ExternCommand File Error\n"); break; }
        store_extern_command(curlabel,the_word,k-'0');
           }
 fclose(la);
return; }

char *xstwin_replacement="1";
//char *samplaying_replacement="0";
void fix_xstcmds(){
 int cnt=0;
 for(;;){//1
        if(sysdefines[cnt].name==NULL)break;
        if(!stricmp(sysdefines[cnt].name,"XstWin")){
//printf("Yeah %s\n",sysdefines[cnt].def);
                sysdefines[cnt].def=xstwin_replacement;
//printf("Yeah %s\n",sysdefines[cnt].def);
                break;
                }
        cnt++;
        }//for 1
  cnt=0;
/*  for(;;){//2
        if(sysprocs[cnt].name==NULL)break;
        if(!stricmp(sysprocs[cnt].name,"SamPlaying")){
//printf("Yeah %s\n",sysprocs[cnt].parmstr);
                sysprocs[cnt].parmstr=samplaying_replacement;
//printf("Yeah %s\n",sysprocs[cnt].parmstr);
                break;
                }
        cnt++;
       }//for 2
       */
return; }

void main(int argc,char **argv){
 int a,whpos;
 FILE *hnd;

 curlabel[0]=0;

 if(argc<2){
       printf("XST2C %s:\n(c)SnAkEsSoFt\\RodneyMcConnell(snakessoft@yahoo.co.uk)\n\nConTact:\n",_xst2c_version);
       printf("Rodney McConnell\n214 Drumagarner rd,\nKilrea,\nColeraine,\nCo.L.Derry,\nN.Ireland,\nBT51 5TR\n");
       printf("\n\n Usage XST2C file.XST\n");
       printf(" XST2C -w file.XST (for windows compatible source)\n");
        exit(-1);
        }
 else printf("XST2C %s:\n(c)SnAkEsSoFt\\RodneyMcConnell(snakessoft@yahoo.co.uk)\n\n",_xst2c_version);
 read_extern_commands();
 if(!stricmp(argv[1],"-l")){
                        printf("Extern Command List:\n");
                        list_extern_commands();
                        free_extern_commands();
                        exit(0);
                             }
 whpos=1;
 if(!stricmp(argv[1],"-w")){
                         whpos=2;
                         win_compat=1;
                         fix_xstcmds();
                        }
 filename=argv[whpos];

 build_default_defs();

 a=convert();


 if(store_locals)pop_locals();

 free_structs();
 free_code(); free_label(); free_defines();
 free_proc(); free_user_proc(); free_gobal();
 free_arrays(); free_data_st();
 free_incs(); free_for();

 free_extern_commands();

 if(out_of_mem)printf("OUT OF MEMORY...\n");
 if(malfreecntr!=0) printf("Memory Error %d\n",malfreecntr);
 else if(a==0 && err_cnt==0)printf("Operation Complete: Ok: Lines %d", total_lines);
 if(err_cnt)printf("\n%d Error(s)...\n",err_cnt);
 if(src)fclose(src);
 if(dest)fclose(dest);

 if(err_cnt==0 && win_compat==0){
        hnd=fopen("MAKEIT.BAT","w");
        if(hnd==NULL) printf("Could not create BAT file\n");
        else{
                for(a=strlen(filename); a>0; a--)
                                       if(filename[a]=='.'){
                                                        filename[a]=0;
                                                        break;
                                                        }
                fprintf(hnd,"gcc -s -m486 -o%s.exe %s.c irqwrap.o xst_lib.o -lxlib -lsb -lwtd\n\n",filename,filename);
                fclose(hnd);
             }
          }
return; }

void do_command(char fst, char *str, char mustbesolo){
 char p=0,k,hadb=0,a,parmcnt=0,tpe;
 int o_c=last_command,oldps;
 int place_of_me=0,ourparmcnt=0;
 char bak_canto=canto;
 char w[10],canend=0,was_multi=0;

 char *proc_name;
 char *proc_parm;
 char proc_ret;

 if(last_command==-90){
         proc_name=tmp_extrn->name;
         proc_parm=tmp_extrn->parms;
         proc_ret=tmp_extrn->ret;
        }
 else{
         proc_name=sysprocs[o_c].name;
         proc_parm=sysprocs[o_c].parmstr;
         proc_ret=sysprocs[o_c].rettype;
         }

 if(last_command==1000){ error("Unsupported Command Sort");
                                   skiptoeol(str);
                                   return; }//sort
 if(last_command==1001){//dimtop
                      skipspaces(str);
                      if(str[lptr]!='('){ error("DimTop missing (");
                                        skiptoeol(str); return; }
                      lptr++; skipspaces(str);
                      if(notletter(str[lptr])){ error("Label expected");
                                           skiptoeol(str); return; }
                      get_word(str);
                      tpe=0;
                      if(str[lptr]=='$'){tpe=1; lptr++; }
                      else if(str[lptr]=='#'){tpe=2; lptr++; }
                      if(find_array(the_word,tpe)==0){ error("Undefined Array");
                                             skiptoeol(str);
                                             return; }
                      skipspaces(str);
                      if(str[lptr]!=','){ error("DimTop missing parameter");
                                          skiptoeol(str); return; }
                      a=str[++lptr];
                      if(a<'0' || a>'9'){ error("Number expected"); skiptoeol(str);
                                                return; }
                      lptr++;
                      if(a<'1' || (str[lptr]>='0' && str[lptr]<='9')){ error("Out of range");
                                                                skiptoeol(str);
                                                                return; }
                      skipspaces(str);
                      if(str[lptr]==','){ error("DimTop has too many parameters");
                                          skiptoeol(str); return; }
                      if(str[lptr]!=')'){ error("DimTop missing )");
                                                skiptoeol(str); return; }
                      lptr++;
                      sprintf(w,"ac_%d_%d",cur_array->no,(a-'0')-1);
                      strcat(new_line,w);
                        return;
                               }
 if(last_command==1002){//varptr
                        skipspaces(str);
                        if(str[lptr]!='('){ error("Varptr missing (");
                                           skiptoeol(str); return; }
                        lptr++; skipspaces(str);
                        if(notletter(str[lptr])){ error("Label expected");
                                           skiptoeol(str); return; }                                                
                        get_word(str);
                        tpe=0;
                        if(str[lptr]=='$'){tpe=1; lptr++; }
                        else if(str[lptr]=='#'){tpe=2; lptr++; }
                        skipspaces(str);
                        if(str[lptr]==','){ error("Varptr has too many parameters");
                                            skiptoeol(str);
                                                return; }
                        if(str[lptr]!=')'){ error("Varptr Missing )");
                                            skiptoeol(str);
                                                return; }
                        lptr++;
                        if(tpe!=1){ error("Varptr only works with strings");
                                        return; }
                        fadd_variable(the_word,tpe,0);
                        strcat(new_line,"(int)&");
                        add_type(tpe);
                        strcat(new_line,the_word);
                        return; 
                                 }
// char s[20];
// notfirst++;
 strcat(new_line,"s_");
 strcat(new_line,proc_name);//sysprocs[o_c].name);
 place_of_me=strlen(new_line);
 strcat(new_line,"( ");
// if(notfirst>1){ strcat(new_line," push_parms();\n"); pushed=1; }
 skipspaces(str); if(str[lptr]=='('){ hadb=1; lptr++; skipspaces(str); }


  if(o_c==0 ||o_c==1 || o_c==250 || o_c==251){
                skipspaces(str);
                if(str[lptr]=='#')lptr++;
                             }

 for(;;){
        oldps=lptr;
        skipspaces(str);
        k=proc_parm[p];//sysprocs[o_c].parmstr[p];
        canto=0;
        //if(sysprocs[o_c].parmstr[p+1]=='-')canto=1;
        if(proc_parm[p+1]=='-')canto=1;
        canend=0;
        //if(k=='+'){p++; k=sysprocs[o_c].parmstr[p]; canend=1; was_multi=1; }
        //if(k=='-'){p++; k=sysprocs[o_c].parmstr[p]; }
        if(k=='+'){p++; k=proc_parm[p]; canend=1; was_multi=1; }
        if(k=='-'){p++; k=proc_parm[p]; }
        if(proc_parm[p+1]=='-')canto=1;
                        
        //printf("(%c-%d)",k,canto);
        if(k==0)break;
        if(str[lptr]==0 || str[lptr]==':' || str[lptr]==')' || str[lptr]==','){
                        if(canend){
                                if(new_line[strlen(new_line)-1]==',')new_line[strlen(new_line)-1]=0;
                                break;}
                        error("Missing parameter"); skiptoeol(str); return; }
        if(k=='1'){ //sprintf(s," p_str[%d]=",p); strcat(new_line,s);
                      a=get_str(str,1,0,0,parmcnt++);
                      }
        else{
           if(k=='0'){// sprintf(s," p_int[%d]=",p); strcat(new_line,s);
                      a=get_int(str,0,1,0,0,0,0);
                      }
           else {// sprintf(s," p_float[%d]=",p); strcat(new_line,s);
              a=get_int(str,1,1,0,0,0,0);
                  }
             }
        //strcat(new_line,";\n");
        if(a)return;
        p++; ourparmcnt++;
        //if(sysprocs[o_c].parmstr[p]!=0)strcat(new_line,",");
        if(proc_parm[p]!=0)strcat(new_line,",");
         }
 skipspaces(str);
 if(str[lptr]==')'){
                if(hadb){lptr++; skipspaces(str); }
                else if(mustbesolo){ error("Unexpected )"); skiptoeol(str); return; }
                }
 if(str[lptr]==0);
 else if(str[oldps-1]==':');
 else if(str[lptr]==':')lptr++;
 else if(mustbesolo==0);
 else if(str[lptr]==','){ error("Too Many Parameters"); skiptoeol(str);
                          return; }
 else {
        //printf(">%d %c %d\n",mustbesolo,str[lptr],str[lptr]);
                error("7Syntax Error"); skiptoeol(str); return; }

// strcat(new_line," s_");
// strcat(new_line,proc_name);//sysprocs[o_c].name);

 strcat(new_line,")");
 if(place_of_me>0 && was_multi==1){// && ourparmcnt>0){
               new_line[place_of_me]=ourparmcnt+'0';
               if(ourparmcnt>9) new_line[place_of_me]=ourparmcnt+'a'-10;
               new_line[place_of_me+1]='(';
                }

 
/// if(proc_ret==1){//sysprocs[o_c].rettype==1){
//             if(fst)strcat(new_line," store_setstr(sysproc_retstr)");
//             else strcat(new_line," store_catstr(sysproc_retstr)");
//                        }
// if(pushed)strcat(new_line," pop_parms();\n");
// notfirst--;

 canto=bak_canto;
return; }

int scan_next(char *str){
 int bp=lptr;
 char k;
 for(;;){
        for(;;){ k=str[bp++]; if(k!=32 && k!=9)break; }

        if(notletter(k)==0){
                      if(toupper(k)=='F' &&
                          toupper(str[bp])=='L' &&
                           toupper(str[bp]+1)=='O' &&
                            toupper(str[bp]+2)=='A' &&
                             toupper(str[bp]+3)=='T' &&
                              (str[bp+4]==')' || str[bp+4]==' '))return 2;
                      if(toupper(k)=='I' &&
                          toupper(str[bp])=='N' &&
                             toupper(str[bp]+1)=='T' &&
                              (str[bp+2]==')' || str[bp+2]==' '))return 0;
                         for(;;){ k=str[bp++];
                                  if(notletter(k) && (k<'0' || k>'9'))break;
                                  }
                          }
        if(k==0)break;
        if(k==',' || k==';' || k==':' || k=='(' || k==')' || k=='[' || k==']')return 0;
        if(k=='\"' || k=='$')return 1;
        if(k=='#')return 2;
        if(k>='0' && k<='9'){   for(;;){ k=str[bp++];
                                          if(k<'0' ||k>'9')break;
                                          if(k=='.')return 2;
                                                }
                                return 0;
                             }
         }
return 0; }

void do_keyword(char *str){
 char not_end=0,a,b,tpe,making,ismin;
 int start_pos,end_pos;
 char w[10],k,tfile=0;
 long num;
 label *lp;
 int myps;
 def_w *the_wds;
 int tmpplace_it;
 int tmpplace[20];
 char teststr[100];

 had_error=0;
 if(last_keyword!=33 && last_keyword!=34)strcat(new_line," ");
 switch(last_keyword){
        case 0://"Print"
                for(;;){
                        skipspaces(str);
                        if(str[lptr]=='#'){ tfile=1; lptr++;
                                strcat(new_line,"cur_file=");
                                if(get_int(str,0,1,1,0,0,0))break;
                                strcat(new_line,";");
                                                }
                        if(str[lptr]==0 || str[lptr]==':')break;
                        a=scan_next(str);
                        if(tfile)strcat(new_line,"f");
                        else strcat(new_line,"s");
                        if(a==2){ strcat(new_line,"_print_f(");
                                   b=get_int(str,1,1,1,0,0,0);
                                        }
                        else if(a==1){strcat(new_line,"_print_s(");
                                   b=get_str(str,1,1,0,0);
                                        }
                        else{ strcat(new_line,"_print_i(");
                                   b=get_int(str,0,1,1,0,0,0);
                                        }
                        if(b)break;
                        strcat(new_line,");");
                        if(str[lptr-1]==','){
                                if(tfile)strcat(new_line,"f");
                                else strcat(new_line,"s");
                                strcat(new_line,"_print_tab();");
                                        }
                        }
               if(str[lptr-1]!=';'){
                        if(tfile)strcat(new_line,"f");
                        else strcat(new_line,"s");
                        strcat(new_line,"_print_newline();");
                        }
               break;
        case 1://"If"
                strcat(new_line,"if(");
                for(;;){
                        a=scan_next(str);
                        if(a==2)b=get_int(str,1,0,0,1,0,0);
                        else if(a==1)b=get_str(str,0,0,1,0);
                        else b=get_int(str,0,0,0,1,0,0);
                        if(b)break;
                        if(if_and_or==0)break;
                        }
                if(b)break;
                strcat(new_line,")");
                skipspaces(str);
                strcat(new_line,"{");
                if(had_then==0) need_endif++;
                else { not_end=1; endif_eol++; }
                break;
        case 2://"EndIf"
                if(need_endif==0)error("EndIf without If");
                else need_endif--;
                strcat(new_line," }");
                break;
        case 3://"Rem"
                 if(endif_eol>0)dump_endif();
                 strcat(new_line,"//");
                 strcat(new_line,str+lptr);
                 lptr=strlen(str);
                break;
        case 4://"For"
                skipspaces(str);
                if(str[lptr]!=0 && str[lptr]!=':' && notletter(str[lptr])){
                                              error("Label expected");
                                              break; }
                get_word(str);
                tpe=0;
                if(str[lptr]=='$'){tpe=1; lptr++; }
                else if(str[lptr]=='#'){tpe=2; lptr++; }
                if(tpe==1){ error("For cannot be String");
                                break; }
                fadd_variable(the_word,tpe,0);
                lp=tmp_lp;
                skipspaces(str);
                if(str[lptr]!='='){ error("For Statement Syntax Error");
                                        break; }
                lptr++;
                strcat(new_line,"for(");                
                add_type(tpe);
                if(lp)strcat(new_line,lp->name);
                strcat(new_line,"=");
                if(tpe==2)b=get_int(str,1,0,0,0,1,0);
                else b=get_int(str,0,0,0,0,1,0);
                strcat(new_line,";;){");
                store_line(new_line); new_line[0]=0;

                if(b)break;
                if(had_for_t!=1){ error("For syntax error"); break; }
                strcat(new_line," if(");
                add_type(tpe);
                if(lp)strcat(new_line,lp->name);
                myps=strlen(new_line);
                strcat(new_line,">=");// <=
                if(tpe==2)b=get_int(str,1,0,0,0,2,0);
                else b=get_int(str,0,0,0,0,2,0);
                //strcat(new_line,"; ");
                strcat(new_line,")break; ");
                add_type(tpe);
                if(lp)strcat(new_line,lp->name);
                if(had_for_t==2==0)strcat(new_line,"++");
                else{  skipspaces(str);
                       if(str[lptr]=='-'){ lptr++; strcat(new_line,"-=");
                                            new_line[myps]='<';//>
                                        }
                       else strcat(new_line,"+=");
                       if(tpe==2)b=get_int(str,1,0,0,0,0,0);
                       else b=get_int(str,0,0,0,0,0,0);
                        }
                //strcat(new_line,"){\n check_break();");
                store_for(new_line); new_line[0]=0;

                strcat(new_line," check_break();");
                in_for++;
                break;
        case 5://"Next"
              for(;;){
               if(in_for==0)error("Not in For..Next loop");
               else in_for--;
               skipspaces(str);
               if(str[lptr]!=0 && str[lptr]!=':' && notletter(str[lptr])){
                                              error("Label expected");
                                              break; }
                get_word(str);
                //Todo:Future update? check if it's the right label
                cat_for();
                strcat(new_line,";\n }");
                skipspaces(str);
                if(str[lptr]==',')lptr++;
                else break;
                }
                break;
        case 6://"Goto"
                skipspaces(str);
                if(notletter(str[lptr])){ error("Missing Location");
                                              break; }
                get_word(str);
                if(win_compat){
                        strcat(new_line,"__asm jmp _p_");
                        strcat(new_line,the_word);
                        }
                else{
                        strcat(new_line,"__asm__(\" jmp _p_");
                        strcat(new_line,the_word);
                        strcat(new_line,"\");");
                        }
                //todo: future update? check all goto's have a place to go
                break;
        case 7://"Gosub"
                skipspaces(str);
                if(notletter(str[lptr])){ error("Missing Location");
                                              break; }
                get_word(str);
                if(win_compat){
                        strcat(new_line,"__asm call _p_");
                        strcat(new_line,the_word);
                }
                else{
                        strcat(new_line,"__asm__(\" call _p_");
                        strcat(new_line,the_word);
                        strcat(new_line,"\");");
                        }
                //todo: future update? check all goto's have a place to go
                break;
        case 8://"Return"
                if(win_compat)strcat(new_line,"__asm ret");
                else strcat(new_line,"__asm__(\" ret\" );");
                break;
        case 9://"Pop"
                //asm adjust stack 4bytes, Naw
                unsupported_com(last_keyword);
                break;
        case 10://"Else"
                skipspaces(str);
                if(toupper(str[lptr])=='I' && toupper(str[lptr+1])=='F' &&
                        str[lptr+2]==' '){
                              if(need_endif==0 && endif_eol==0)strcat(new_line,"else");
                              else if(need_endif>0 || endif_eol>0){
                                                   if(endif_eol>0){dump_endif();
                                                                  strcat(new_line," else");
                                                                  }
                                                   else strcat(new_line,"} else");
                                                         }
                              else error("Else without If");
                              need_endif--;
                              not_end=1;
                              break;
                                      }
               if(str[lptr]==0 || str[lptr]==':'){
                        if(need_endif==0 && endif_eol==0) {strcat(new_line,"else{");
                                                           need_endif++;
                                                            }
                        else if(need_endif>0 || endif_eol>0){
                                                if(endif_eol>0){dump_endif();
                                                                strcat(new_line," else{");
                                                                 }
                                                else strcat(new_line,"} else{");
                                                         }
                        else error("Else without If");
                                }
                else {
                     if(endif_eol>0)dump_endif();
                    else if(need_endif>0){
                                 strcat(new_line,"}");
                                 need_endif--;
                                }
                     strcat(new_line,"else{");endif_eol++;
                     not_end=1; }
                break;
        case 11://"Do"
                strcat(new_line,"for(;;){\n check_break();");
                in_do++;
                break;
        case 12://"Loop"
                if(in_do==0)error("Not in Do..Loop");
                else in_do--;
                strcat(new_line," }");
                break;
        case 13://"End"
        case 14://"Stop"
                if(in_proc==0)strcat(new_line,"goto end_of_proc;");
                else strcat(new_line,"prog_end();");//just calls exit 
                break;
        case 15://"OnErrorGoto"
        case 16://"OnErrorGosub"
                unsupported_com(last_keyword);
                break;
        case 17://"OnErrorContinue"
                strcat(new_line,"end_error=0;");
                break;
        case 18://"Input"
                skipspaces(str);
                if(str[lptr]=='#'){ tfile=1; lptr++;
                                strcat(new_line,"cur_file=");
                                if(get_int(str,0,1,1,0,0,0))break;
                                strcat(new_line,";");
                                                }
                for(;;){
                        skipspaces(str);
                        if(str[lptr]=='\"'){
                                a=str[++lptr];
                                if(tfile)strcat(new_line,"f");
                                else strcat(new_line,"s");
                                strcat(new_line,"_print_s(\"");
                                if(a=='\"' && str[lptr+1]!='\"') lptr++;
                                else for(;;){
                                    if(a!='\"'){sprintf(w,"%c",a); strcat(new_line,w); }
                                    a=str[++lptr];
                                  //if(a=='\"' && str[lptr+1]!='\"'){ lptr++;
                                 //                               break;}
                                   if(a==0){  error("Missing \""); break; }
                                   if(a=='\"'){ lptr++;
                                     if(str[lptr]=='\"'){
                                          sprintf(w,"\\\"");
                                          strcat(new_line,w);
                                                }
                                     else break;
                                        }
                                    }
                                strcat(new_line,"\");");
                                        }
                        else if(notletter(str[lptr])){
                                                error("Input Statement Syntax Error");
                                                break;
                                                }
                        else{
                           get_word(str);
                           tpe=0;
                           if(str[lptr]=='$'){tpe=1; lptr++; }
                           else if(str[lptr]=='#'){tpe=2; lptr++; }
                           fadd_variable(the_word,tpe,0);
                           if(tpe==1)strcat(new_line,"set_str((char **)&");
                           add_type(tpe);
                           strcat(new_line,the_word);
                           if(tpe==1)strcat(new_line,",");
                           else strcat(new_line,"=");
                           if(tfile)strcat(new_line,"f");
                           else strcat(new_line,"s");
                           switch(tpe){
                                     case 1:strcat(new_line,"_input_str());");break;
                                     case 2:strcat(new_line,"_input_float();");break;
                                     default:strcat(new_line,"_input_int();");
                                        }
                                }
                        skipspaces(str);
                        if(str[lptr]==0 || str[lptr]==':')break;
                        else if(str[lptr]==';' || str[lptr]==',')lptr++;
                        else { error("Input Statement Syntax Error"); break; }
                       }
                break;
        case 19://"Define"
                skipspaces(str);
                if(str[lptr]==0 || str[lptr]==':'){ error("Define Missing label");
                                                   break; }
                get_word(str);
                if(find_define(0,0,the_word)){ error("Label already defined");
                                           break; }
                skipspaces(str);
                if(str[lptr]!='='){ error("Define missing =");
                                        break; }
                lptr++; skipspaces(str);
                makedefine(0,the_word,str);
                break;
        case 20://"Include"
                skipspaces(str);
                if(str[lptr]!='\"'){ error("Include missing filename");
                                        break; }
                lptr++;
                skipspaces(str);
                myps=0;
                for(;;){
                       a=str[lptr];
                       if(a==32 || a==9 || a=='\"' || a=='\'' || a=='\n' || a==0)break;
                       lptr++; the_word[myps++]=a;
                        }
                the_word[myps]=0;
                skipspaces(str);
                if(str[lptr]!='\"'){ error("Include filename missing end \"");
                                        break; }
                lptr++;
                //strcat(new_line,"#include \"");
                //myps=strlen(the_word);
                //for(;;){ if(the_word[myps]=='.'){ the_word[myps]=0; break; }
                //         if(myps<1)break;
                //          myps--;
                //                }
                //strcat(the_word,".C");
                //strcat(new_line,the_word);
                //strcat(new_line,"\"");
                do_include(the_word);
                break;
        case 21://"Restore"
                skipspaces(str);
                if(str[lptr]==0 || str[lptr]==':'){ error("Restore Missing label");
                                                   break; }
                get_word(str);
                strcat(new_line,"data_pointer=d_");
                //todo: future update, check all restores have a place to go
                strcat(new_line,the_word);
                strcat(new_line,";");
                break;
        case 22://"Data"
                if(curlabel[0])fadd_data_pointer_name(curlabel,cur_data_offset);
                //todo: maybe a future update to support floating and minus
                //      and >0xff (this'll require the lib updated to)
                for(;;){
                    skipspaces(str);
                    if(str[lptr]=='-' ||(str[lptr]>='0' && str[lptr]<='9')){
                                        ismin=0;
                                        if(str[lptr]=='-'){
                                                       ismin=1;
                                                       lptr++;
                                                        }
                                        num=str[lptr]-'0'; lptr++;
                                        for(;;){
                                           if(str[lptr]<'0' || str[lptr]>'9')break;
                                           num*=10; num+=str[lptr++]-'0';
                                                }
                                        if(num>0xffff)num=0xffff;
                                        //if(ismin)num=-num;
                                        myps=num/0x100;
                                        num-=(myps*0x100);
                                        add_data_byte(ismin);
                                        add_data_byte(num);
                                        add_data_byte(myps);
                                             }
                    else if(str[lptr]=='\"'){ lptr++;
                                        for(;;){
                                            if(str[lptr]=='\"'){ lptr++; break; }
                                            if(str[lptr]==0) break;
                                            add_data_byte(str[lptr++]);
                                                   }
                                                }
                    else {error("Data syntax error"); break; }
                    skipspaces(str);
                    if(str[lptr]==0 || str[lptr]==':')break;
                    else if(str[lptr]==',')lptr++;
                    else {error("Data syntax error"); break; }
                        }
                 //cur_data_offset=strlen(data_place);
                break;
        case 23://"Read"
                skipspaces(str);
                if(str[lptr]==0 || str[lptr]==':'){ error("Read Missing label");
                                                   break; }
                for(;;){
                        skipspaces(str);
                        get_word(str);
                        tpe=0;
                        if(str[lptr]=='$'){tpe=1; lptr++; }
                        else if(str[lptr]=='#'){tpe=2; lptr++; }
                        if(tpe==1) strcat(new_line,"set_str((char **)&");
                        add_type(tpe);
                        strcat(new_line,the_word);
                        if(tpe==1) strcat(new_line,",read_str());");
                        else strcat(new_line,"=read_int();");
                        skipspaces(str);
                        if(str[lptr]==0 || str[lptr]==':')break;
                        else if(str[lptr]==','){ lptr++; strcat(new_line,"\n "); }
                        else {error("Read syntax error"); break; }
                        }
                break;
        case 24://"Clear"
        case 25://"OnBreakGoto"
        case 26://"OnBreakGosub"
                unsupported_com(last_keyword);
                break;
        case 27://"Run"
                strcat(new_line,"proc_main();");
                break;
        case 28://"Dim" (always gobal in xst)
              for(;;){
                store_line(new_line); new_line[0]=0;
                skipspaces(str);
                if(str[lptr]==0 || str[lptr]==':'){ error("Dim Missing label");
                                                   break; }
                get_word(str);
strcpy(teststr,the_word);
                tpe=0;
                if(str[lptr]=='$'){tpe=1; lptr++; }
                else if(str[lptr]=='#'){tpe=2; lptr++; }
                skipspaces(str);
                if(str[lptr]!='('){error("Dim Missing (");break;}
                lptr++;
                if(find_array(the_word,tpe)){ error("Array already declared");
                                             break; }
                add_array(the_word,tpe,array_no);
                myps=0;
                had_a_dim=1;
                for(;;){
                        a=scan_next(str);
                        strcat(new_line,"#define ac_");
                        sprintf(w,"%d_%d ",array_no,myps);
                        strcat(new_line,w);
                        if(a==1){ error("Cannot be string"); break; }
                        if(get_int(str,0,1,0,0,0,1))break;
                        strcat(new_line,"\n");
                        if(str[lptr]==')'){lptr++; break; }
                        else if(str[lptr-1]==',');
                        else { error("Dim Missing )"); break; }
                        myps++;
                        }
                if(cur_top_ele<myps)cur_top_ele=myps;
                if(tpe==2)strcat(new_line,"float ");
                else if(tpe==1)strcat(new_line,"char *");
                else strcat(new_line,"long ");
                 add_type(tpe);
                 strcat(new_line,teststr);//"MOOMOO");
//                 strcat(new_line,the_word);
                 strcat(new_line,"[");
                 a=0;
                 for(;;){
                        strcat(new_line,"ac_");
                        sprintf(w,"%d_%d+1]",array_no,a);
                        strcat(new_line,w);
                        a++; if(a>myps)break;
                        strcat(new_line,"[");
                        }
                  strcat(new_line,";");
                fprintf(dest,"%s\n",new_line);
                new_line[0]=0;
                array_no++;
                if(cur_array)cur_array->elecnt=myps;

                skipspaces(str);
                if(str[lptr]==',')lptr++;
                else break;
                }

                break;
        case 29://"Repeat"
                strcat(new_line,"do{\n check_break();");
                in_repeat++;
                break;
        case 30://"Until"
                if(in_repeat==0)error("Not in Repeat");
                else in_repeat--;
                strcat(new_line,"}while(");
                if(a==1)strcat(new_line,"!");
                skipspaces(str);
                if(a==2)b=get_int(str,1,0,0,2,0,0);
                else if(a==1)b=get_str(str,0,0,2,0);
                else b=get_int(str,0,0,0,2,0,0);
                if(had_then!=0)error("Syntax Error");
                strcat(new_line,");");
                break;
        case 31://"DefFn"
                skipspaces(str);
                if(str[lptr]==0 || str[lptr]==':'){ error("Deffn Missing label");
                                                   break; }
                get_word(str);
                if(find_define(0,0,the_word)){ error("Label already defined");
                                           break; }
                skipspaces(str);
                if(str[lptr]!='('){
                         if(str[lptr]!='='){error("Deffn Syntax error");
                                                break; }
                         lptr++;
                         skipspaces(str);
                         makedefine(0,the_word,str);
                                }
                else{ lptr++;
                      for(myps=0;myps<9;myps++)tmpcharheld[myps]=0;
                      for(myps=0;;){
                             skipspaces(str);
                             k=toupper(str[lptr]);
                             if(k==')'){ error("Deffn missing parameter");
                                                        break; }
                             if(k>='A' && k<='H')tmpcharheld[myps++]=k;
                             else { error("Illegal Deffn parameter");
                                        break; }
                             lptr++; skipspaces(str);
                             if(str[lptr]==',')lptr++;
                             else if(str[lptr]==')'){ lptr++;
                                                skipspaces(str);
                                                if(str[lptr]!='='){error("Deffn Syntax error");
                                                        break; }
                                                lptr++;
                                                break;
                                                }
                             else {error("Deffn Syntax Error");
                                        break; }
                             if(myps>8){ error("Deffn has too many parameters");
                                        break;   }
                               }//for
                        makedefine(1,the_word,str);
                        }//deffn
                break;
        case 32://"Gobal"
                for(;;){
                  skipspaces(str);
                  if(str[lptr]==0 || str[lptr]==':'){ error("Gobal Missing label");
                                                   break; }
                  get_word(str);
                  tpe=0;
                  if(str[lptr]=='$'){tpe=1; lptr++; }
                  else if(str[lptr]=='#'){tpe=2; lptr++; }
                  add_gobal(the_word,tpe);
                  skipspaces(str);
                  if(str[lptr]==',')lptr++;
                  else break;
                  }
                break;
        case 33://"Procedure"
                if(in_proc==1){ error("Cannot have procedure inside a procedure"); break; }
                in_proc=1;  tmpplace_it=0;
                skipspaces(str);
                if(str[lptr]==0 || str[lptr]==':'){ error("Deffn Missing label");
                                                   break; }
                get_word(str);
                tpe=0;
                if(str[lptr]=='$'){tpe=1; lptr++; }
                else if(str[lptr]=='#'){tpe=2; lptr++; }
                making=0;
                if(find_user_proc(the_word,tpe)==0){add_user_proc(the_word,tpe,1); making=1; }
                else if(cur_proc->declr==1){ error("Procedure already declared"); a=1; break; }
                in_proc_type=tpe;
                start_pos=strlen(new_line);
                strcat(new_line,"void ");
                add_type(tpe);
                strcat(new_line,the_word);
                strcat(new_line,"(");
                skipspaces(str); a=0; myps=0;
                push_locals();
                free_got_define_words();
                if(str[lptr]=='['){lptr++;
                          for(;;){
                                skipspaces(str);
                                if(str[lptr]==']'){ lptr++; break; }
                                else if(notletter(str[lptr])){
                                                       error("Procedure Syntax Error");
                                                       a=1;
                                                       break; }
                                get_word(str);
                                b=0;
                                if(str[lptr]=='$'){b=1; lptr++; }
                                else if(str[lptr]=='#'){b=2; lptr++; }
                                fadd_variable(the_word,b,1);
                                if(making){
                                         cur_proc->parms[myps]='0';
                                         if(b==1) cur_proc->parms[myps]='1';
                                                }
                                if(making==0 && cur_proc->parms[myps]==0){error("Procedure has too many parameter(s)");
                                                                        a=1; break; }
                                if(making==0 && ((cur_proc->parms[myps]!='1' && b==1) || 
                                                        (cur_proc->parms[myps]=='1' && b!=1)))
                                                                { error("parameter mismatch"); a=1; break; }
                                if(b==2)strcat(new_line,"float ");
                                else if(b==1)strcat(new_line,"char *");
                                else strcat(new_line,"long ");
                                if(b==1){
                                        tmpplace[tmpplace_it++]=myps;
                                        sprintf(w,"pm%d",myps);
                                        strcat(new_line,w);
                                        store_define_word(the_word);
                                                }
                                else{  
                                        add_type(b);
                                        strcat(new_line,the_word);
                                        }
                                skipspaces(str);
                                if(str[lptr]==']'){ lptr++; break; }
                                else if(str[lptr]==','){ lptr++;
                                                        myps++;
                                                        strcat(new_line,","); }
                                else{ error("Procedure Syntax Error");
                                      a=1; break; }
                                        }
                          if(a)break;
                          if(making==0 && cur_proc->parms[myps+1]!=0)error("Procedure missing parameter(s)");
                                }
                else if(making==0 && cur_proc->parms[0]!=0)error("Procedure missing parameter(s)");
                strcat(new_line,"){");
                end_pos=strlen(new_line)-1;
                dump_proto(start_pos,end_pos,new_line);
                store_line(new_line); new_line[0]=0;
                proc_entry_line=lst_line;
                if(top_defw){
                        the_wds=top_defw;
                        strcat(new_line,"\n ");
                        tmpplace_it=0;
                        while(the_wds){
                                    strcat(new_line," set_str((char **)&");
                                    add_type(1);
                                    strcat(new_line,the_wds->name);
                                    strcat(new_line,",");
                                    //sprintf(w,"pm%d);",myps--);
                                    sprintf(w,"pm%d);",tmpplace[tmpplace_it++]);
                                    strcat(new_line,w);
                                    the_wds=the_wds->prev;
                                        }
                         strcat(new_line,"\n");
                                }
                free_got_define_words();
                break;
        case 34://"EndProc"
        case 35://"PopProc"
                a=last_keyword;
                if(in_proc==0){ error("Not in procedure"); break; }
                skipspaces(str);
                if(str[lptr]!=0 && str[lptr]!=':'){
                            if(in_proc_type==2){strcat(new_line,"f_PARAM=");
                                                get_int(str,1,0,0,0,0,0);
                                                }
                            else if(in_proc_type==0){strcat(new_line,"i_PARAM=");
                                                get_int(str,0,0,0,0,0,0);
                                                }
                            if(in_proc_type==1){get_str(str,0,0,0,0);
                                                strcat(new_line,";");
                                                strcat(new_line,"set_str((char **)&s_PARAM);");
                                                }
                            else strcat(new_line,";");
                                }
                if(a==34){      strcat(new_line,"\nend_of_proc:\n");
                                str_free_locals(top_label);
                                strcat(new_line,"return; }");
                                store_line(new_line); new_line[0]=0;
                                in_proc=0;
                                dump_label_local(top_label);
                                pop_locals();
                                }
                else strcat(new_line," goto end_of_proc;");
                break;
        case 36://"PopFor"
                if(in_for==0)error("Not in For..Next loop");
                strcat(new_line," break;");
                break;
        case 37://"PopLoop"
                if(in_do==0)error("Not in Do..Loop");
                strcat(new_line," break;");
                break;
        case 38://"PopRepeat",
                if(in_repeat==0)error("Not in Repeat");
                strcat(new_line," break;");
                break;
        case 39://"Switch"
                strcat(new_line,"switch(");
                skipspaces(str);
                if(str[lptr]==0 || str[lptr]==':'){ error("Missing Switch value");
                                                        break; }

                a=scan_next(str);
                if(a==1){ error("Cannot be string"); break; }
                if(a==2)get_int(str,1,0,0,0,0,0);
                else get_int(str,0,0,0,0,0,0);
                strcat(new_line,"){");
                in_switch++;
                break;
        case 40://"EndSwitch"
                if(in_switch==0)error("Not in Switch");
                else in_switch--;
                strcat(new_line," }");
                incase=0;
                break;
        case 41://"Case"
                if(in_switch==0)error("Not in Switch");
                strcat(new_line,"case ");
                skipspaces(str);
                if(str[lptr]==0 || str[lptr]==':'){ error("Missing case value");
                                                        break; }
                a=scan_next(str);
                if(a==1){ error("Cannot be string"); break; }
                if(a==2)get_int(str,1,0,0,0,0,1);
                else get_int(str,0,0,0,0,0,1);
                strcat(new_line,":");
                incase=1;
                break;
        case 42://"EndCase"
        case 43://"PopCase"
                if(in_switch==0)error("Not in Switch");
                if(incase==0)error("Not in Case");
                strcat(new_line,"break;");
                break;
        case 44://"DefaultCase"
                if(in_switch==0)error("Not in Switch");
                strcat(new_line,"default:");
                incase=1;
                break;
          case 45://polygon MUST have at least 3 sets of parameters
          case 47://polyline
                b=last_keyword;
                skipspaces(str); k=0;
                if(str[lptr]=='('){ lptr++; k=1; }
                num=0;
                for(;;){ 
                    skipspaces(str);
                    if(str[lptr]==':' || str[lptr]==0)break;
                    canto=0;
                    strcat(new_line,"push_poly_parm(");
                    if(get_int(str,0,1,0,0,0,0))break;
                    strcat(new_line,");\n ");
                    if(str[lptr-1]!=',') {error("Missing parameter"); break; }

                    num++;
                    canto=1;
                    strcat(new_line,"push_poly_parm(");
                    if(get_int(str, 0, 1, 0,0, 0, 0))break;
                    strcat(new_line,");\n ");
                    num++;
                    if(sowasto);
                    else if(str[lptr-1]==',');
                    else if(str[lptr]==')'){lptr++;
                                           if(k==0)error("Syntax Error");
                                           break; }
                    else{  if(k) error("Missing Bracket");
                            break; 
                             }
                        }
                if(num<6) error("Polygon must have at least 3 parameters");
                if(b==45){
                        strcat(new_line,"s_Polygon();");
                                }
                else strcat(new_line,"s_Polyline();");
        break;
        case 46://"lPrint"
                for(;;){
                        skipspaces(str);
                        if(str[lptr]=='#'){
                                 error("Cannot Lprint to File");
                                 break;
                                          }
                        if(str[lptr]==0 || str[lptr]==':')break;
                        a=scan_next(str);
                        strcat(new_line,"s");
                        if(a==2){ strcat(new_line,"_lprint_f(");
                                   b=get_int(str,1,1,1,0,0,0);
                                        }
                        else if(a==1){strcat(new_line,"_lprint_s(");
                                   b=get_str(str,1,1,0,0);
                                        }
                        else{ strcat(new_line,"_lprint_i(");
                                   b=get_int(str,0,1,1,0,0,0);
                                        }
                        if(b)break;
                        strcat(new_line,");");
                        if(str[lptr-1]==','){
                                if(tfile)strcat(new_line,"f");
                                else strcat(new_line,"s");
                                strcat(new_line,"_lprint_tab();");
                                        }
                        }
               if(str[lptr-1]!=';'){
                        if(tfile)strcat(new_line,"f");
                        else strcat(new_line,"s");
                        strcat(new_line,"_lprint_newline();");
                        }
               break;
              //case 47://polyline, done with polygon
              case 48://inc
                strcat(new_line,"++");
              case 49://dec
                if(last_keyword==49)strcat(new_line,"--");
                skipspaces(str);
                if(str[lptr]!=0 && str[lptr]!=':' && notletter(str[lptr])){
                                              error("Label expected");
                                              break; }
                get_int(str,1,0,0,0,0,0);                
                strcat(new_line,";");
              break;
              case 50:case 51://Struct,GlobalStruct (should be removed by preprocess)
                 if(endif_eol>0)dump_endif();
                 lptr=strlen(str);
              break;
              case 52://"CADD"
                 if(endif_eol>0)dump_endif();
                 strcat(new_line,str+lptr);
                 lptr=strlen(str);
                break;

               }
 skipspaces(str);
 if(had_error)skiptoeol(str);
 else if(not_end==0 && str[lptr]!=0 && str[lptr]!=':')error("8Syntax Error");
return; }
