/*
 display X3d zon
 By Rd
*/

#include <stdio.h>

#define MAXS 1000



char id[5];
char title[25];
int numpaths, numpoints,numregions, numwalls, numobjects, numviews;
int startpoints,vers;
//int st_p[10];

//points
long p_x[MAXS],p_y[MAXS];
//short p_link[MAXS];
//regions
long region_type[MAXS];
short region_floorh[MAXS];
short region_ceilh[MAXS];
short region_below[MAXS];
short region_above[MAXS];
char region_floor_tex[MAXS][11];
char region_ceil_tex[MAXS][11];
char emptystr[10];
//walls
long wall_type[MAXS];
short wall_p1[MAXS];
short wall_p2[MAXS];
short wall_r_front[MAXS];
short wall_r_back[MAXS];
char wall_top_tex[MAXS][11];
char wall_mid_tex[MAXS][11];
char wall_bot_tex[MAXS][11];
short wall_texx[MAXS];
short wall_texy[MAXS];

void read_zone(FILE *hnd);
void display_zone(){
 int a;
 printf("%s (%d) %s\n",id,vers,title);
 printf("numpoints %d\nnumregions %d\n", numpoints,numregions);
 printf("numwalls %d\n",numwalls);
 printf("startpoint %d\n",startpoints);
 printf("Points\n");
 for(a=0;a<numpoints;a++){
        printf("Point %d: x %ld : y %ld \n",a,p_x[a],p_y[a]);
                }
 printf("Regions\n");
 for(a=0;a<numregions;a++){
    printf("Region %d: Type %ld : ",a,region_type[a]);
    printf("FloorH %d : CeilH %d : ", region_floorh[a], region_ceilh[a]);
    printf("RegionB %d : RegionA %d : ", region_below[a], region_above[a]);
    printf("FloorT %s : CeilT %s\n", region_floor_tex[a], region_ceil_tex[a]);
  }
 printf("Walls\n");
 for(a=0;a<numwalls;a++){
    printf("Wall %d: Type %ld : ",a,wall_type[a]);
    printf("p1 %d : p2 %d : ",wall_p1[a],wall_p2[a]);
    printf("regionF %d : regionB %d : ",wall_r_front[a],wall_r_back[a]);
    printf("topTex %s : MidTex %s : BotTex %s : ",wall_top_tex[a],wall_mid_tex[a],wall_bot_tex[a]);
    printf("texX %d : TexY %d\n",wall_texx[a],wall_texy[a]);
  }

return; }

void main(int argc,char **argv){
 FILE *hnd;

 if(argc<2){printf("Usage: X3ddis File.zon\n"); exit(-1); }
 hnd=fopen(argv[1],"rb");
 if(hnd==NULL){printf("Cannot open %s\n",argv[1]); exit(-1); }

 read_zone(hnd);
 display_zone();

 fclose(hnd);
return; }


#define PATH_LEN        32              // Number of path steps for a point


void read_str(FILE *hnd,char *str){
 int b;
    for(b=0;b<9;b++)str[b]=fgetc(hnd);
    str[10]=0;
return; }
long  dword_read(FILE *hnd){
 long num=0;
 num=fgetc(hnd)+(0x100*fgetc(hnd))+(0x10000*fgetc(hnd))+(0x1000000*fgetc(hnd));
return num; }
short intword_read(FILE *hnd){
 short num=0;
 num=fgetc(hnd)+(0x100*fgetc(hnd));
return num; }




void read_zone(FILE *hnd){
int a;
 for(a=0;a<4;a++) id[a]=fgetc(hnd); id[4]=0;
 vers=getc(hnd)-'0';
 for(a=0;a<20;a++)title[a]=fgetc(hnd);
 title[20]=0;

 numpoints=intword_read(hnd);
 numregions=intword_read(hnd);
 numwalls=intword_read(hnd);
 startpoints=intword_read(hnd);

 //points...
 for(a=0;a<numpoints;a++){
        p_x[a]=dword_read(hnd);
        p_y[a]=dword_read(hnd);
        //p_link[a]=intword_read(hnd);
          }
 //regions...
 for(a=0;a<numregions;a++){
        region_type[a]=intword_read(hnd);
        region_ceilh[a]=intword_read(hnd);
        region_floorh[a]=intword_read(hnd);
        read_str(hnd,region_ceil_tex[a]);
        read_str(hnd,region_floor_tex[a]);
        region_above[a]=intword_read(hnd);
        region_below[a]=intword_read(hnd);
        }
  //walls...
 for(a=0;a<numwalls;a++){
        wall_type[a]=intword_read(hnd);
        wall_p1[a]=intword_read(hnd);
        wall_p2[a]=intword_read(hnd);
        read_str(hnd,wall_top_tex[a]);
//printf(">F %s<",wall_top_tex[a]);
        read_str(hnd,wall_mid_tex[a]);
        read_str(hnd,wall_bot_tex[a]);
        wall_r_front[a]=intword_read(hnd);
        wall_r_back[a]=intword_read(hnd);
        wall_texx[a]=intword_read(hnd);
        wall_texy[a]=intword_read(hnd);
         }

  //startpoints...

/* for(a=0;a<startpoints;a++){
        st_p[a]=intword_read(hnd);
         }*/
return; }










