
#ifndef BOXES_H
#define BOXES_H

#define TRUE			1
#define FALSE			0


#define BOX_NORMAL		0x0000
#define BOX_PRESS		0x0001
#define BOX_NOBORDER		0x0002
#define BOX_BUTTON		0x0004
#define BOX_FILL		0x0010
#define BOX_TEXT3D		0x0100
#define BOX_TEXTCENTER		0x0200
#define BOX_TIGHT		0x0400

#define LEFT_BUTTON		0x0001
#define RIGHT_BUTTON		0x0002

#define EDIT_ENTER		13		// Enter
#define EDIT_ESC		27		// Esc
#define EDIT_UP			72		// Up arrow
#define EDIT_DOWN		80		// Down arror
#define EDIT_NEXT		9		// Tab
#define EDIT_PREV		15		// Shift+Tab

#define KBD_RSHIFT		0x01
#define KBD_LSHIFT		0x02
#define KBD_SHIFT		0x03
#define KBD_CTRL		0x04
#define KBD_ALT			0x08


typedef unsigned char       BYTE;
typedef unsigned short int  WORD;
typedef unsigned long int   DWORD;
typedef signed short int    SHORT;
typedef signed long int     LONG;
typedef signed long int     FIXED;


struct Box {
	int x1,y1,x2,y2,t;
};
struct Area {
	int Key;
	struct Box *b;
	void (*cb)(void);
	int *var;
	int c;
};


int IsInside(struct Box *, int, int);

void DrawBorder(struct Box *, int);
void DrawText3D(char *);
void DrawMTextBox(struct Box *, char *, int);
void DrawTextBox(struct Box *, char *, int);
int  DrawEditBox(struct Box *, char *, int);
void DrawCheckBox(struct Box *, char, int);

void ProcessMouse(void);
void ProcessKeyboard(void);

int  GetShift(int);
int  MouInit(void);
void MouSetRange(int, int, int, int);
int  MouGetCoord(int *,int *);
int  MouSetCoord(int,int);
void HidePointer(void);
void ShowPointer(void);


extern struct Area Areas[];
extern int NumAreas;

// 3D drawing configuration
extern int Fill3D;			// Filling color
extern int Light3D;			// Highlight color
extern int Dark3D;			// Shadowed color
extern int LimitOn;			// Limits input

extern int MouseX, MouseY, MouseBut;

#endif
