#ifndef _WTD_H_
#define _WTD_H_

#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include <string.h>
#include "hard.h"
#include "level.h"
#include "tex.h"
#include "pal.h"

#define GetMemInfo	__dpmi_get_free_memory_information
#define __PACKED__	__attribute__ ((packed))

//=================
// General defines
//=================
#define WTD_VERSION     "0.9"                  // Current version
#define NULL_RES        "NULL"               // Null resource
//#define ZONE_EXT        ".ZON"                  // Def zone extension
#define TEX_EXT         ".XT"                  // Def tex extension
//#define PIC_EXT         ".PIC"                  // Def picture extension
//#define PAL_EXT         ".PAL"                  // Def pal extension


//==================
// Misc WTD defines
//==================
#define RES_NUM		2048			// Maximum number of res.
#define RES_INC		32			// Num. of res. for mem alloc
#define PATH_CURRENT	0			// Struc. moves from cur. pos.
#define PATH_START	1			// Struc. moves from start
#define PATH_END	2			// Struc. moves from end


//===========================
// Events for object control
//===========================
#define EV_ACT1		0x00000001		// Action #1
#define EV_ACT2		0x00000002		// Action #2
#define EV_ACT3		0x00000004		// Action #3
#define EV_ACT4		0x00000008		// Action #4
#define EV_FORWARD	0x00000010		// Move forward
#define EV_BACKWARD	0x00000020		// Move backward
#define EV_LEFT		0x00000040		// Strafe left
#define EV_RIGHT	0x00000080		// Strafe right
#define EV_UP		0x00000100		// Jump (or move up)
#define EV_DOWN		0x00000200		// Move down
#define EV_TURNLEFT	0x00000400		// Turn left
#define EV_TURNRIGHT	0x00000800		// Turn right
#define EV_DESTROY	0x10000000		// Object is to be deleted


//======================
// Effect types & flags
//======================
#define EFF_INIT	0x00000001		// Init. effect (param)
#define EFF_CLEAR	0x00000002		// Effect is cleared
#define EFF_FRAME	0x00000010		// Eff is updated each frame
#define EFF_POST	0x00000020		// Eff is called after frame
#define EFF_TAG		0x00000040		// Eff is called after TAG
#define EFF_WALLHIT	0x00000100		// Eff is called after wall col
#define EFF_OBJHIT	0x00000200		// Eff is called after obj col
#define EFF_FLOORHIT	0x00000400		// Eff is called after flr hit
#define EFF_CEILHIT	0x00000800		// Eff is called after ceil hit
#define EFF_ENTER	0x00001000		// Obj has entered a region
#define EFF_LEAVE	0x00002000		// Obj has left a region

//===============================
// Types common to all resources
//===============================
#define T_TAGGED	0x01000000		// Tag has been activated
#define T_SEEN		0x02000000		// Has been seen
#define T_ABSLIGHT	0x04000000		// Fade shows abs. light (type)

//============
// Pick types
//============
#define PICK_NULL	0			// Nothing
#define PICK_TOPWALL	1			// Top part of wall
#define PICK_MIDWALL	2			// Mid part of wall
#define PICK_BOTWALL	3			// Bot part of wall
#define PICK_OBJECT	4			// Object

//========
// Errors
//========
#define ER_GENERAL	-1			// Just an error
#define ER_MEMORY	-2			// Not enough memory
#define ER_CACHE0	-3			// Zero cache alloc
#define ER_FOPEN	-4			// Can't open file
#define ER_FORMAT	-5			// Bad format
#define ER_FIND		-6			// Couldn't find something
#define ER_RES		-7			// Out of resources
#define ER_WRONGANIM    -8          //wrong anim type

//=======================
// Some handy WTD macros
//=======================
//#define IsTexStopped(p)         (((p)->pTex)&&((p)->pCell==(p)->pCell->Next))
//#define IsTexAdvance(p)         (((p)->pTex)&&((p)->Delay<=0)&&\
//                                 ((p)->pCell!=(p)->pCell->Next))


//======================
// Engine configuration
//======================
struct EngineCFG {		// Engine configuration
	WORD  ScrWidth;			// _Screen_ width
	WORD  ScrHeight;		// _Screen_ height
	FIXED ScrConst;			// Constant (depends on aspect ratio)
//        FIXED TimeRate;                 // Timer rate (ticks per second)
//        LONG  Ticks;                    // Ticks during last frame
//        FIXED FPS;                      // Drawing speed in frames per sec
//        FIXED IFPS;                     // 1/fps
        FIXED TimeUnit;                 // How long in (1/100 sec) frame takes
	FIXED MaxStairs;		// Max height of a step in stairs
	SHORT PickX,PickY;		// Scr coords to check for pick
	WORD  PickType;			// Type of picked thing
	void *PickPtr;			// Ptr of the picked thing
	FIXED PickDist;			// Distance to picked thing
	struct Object *TraceObject;	// Object to trace
	SHORT TraceX1, TraceY1;		// Top-left coords of TraceObject 
	SHORT TraceX2, TraceY2;		// Bot-right coords of TraceObject
};

//================
// WTD structures
//================
struct Table {				// Table structure
	int   Number __PACKED__;		// Number of entries
	int   Allocated __PACKED__;		// Allocated entries
	int   Size __PACKED__;			// Size of an element
	void *ptr[RES_NUM] __PACKED__;		// Pointers to data entries
};

//=================
// Zone structures
//=================
struct Vars {				// Local variables for walls/objects/etc
	LONG A,B,C,D,P __PACKED__;		// Now includes entry for EffParam
};
struct Move {					// Physics structure
	FIXED X, Y, Z, T __PACKED__;
};
struct Point {					// Point structure
	DWORD Type __PACKED__;			// Type
	FIXED x,y __PACKED__;			// Current coords
	FIXED nx,ny __PACKED__;			// Transformed coords
	FIXED ld,rd,a __PACKED__;		// Renderer data
	SHORT Coord __PACKED__;			// Current coord (in PATH)
	FIXED Count __PACKED__;			// Counter (for PATH coord change)
	struct Point *link __PACKED__;		// Ptr to the next link
	struct Path  *path __PACKED__;		// Ptr to path
	LONG  Stamp __PACKED__;			// Time-stamp of last transform
};
struct Path {				// Point path structure
	SHORT NumCoords __PACKED__;		// Number of coords
	FIXED Delay __PACKED__;			// Delay between coord change
	SHORT ax[PATH_LEN],ay[PATH_LEN] __PACKED__;// Relative coordinates
};
struct Area {                         // Region structure
	DWORD Type __PACKED__;			// Type
	FIXED FloorH, CeilH __PACKED__;		// Height of floor and ceiling
	struct TexCon   FloorTC, CeilTC __PACKED__;// Textures
        struct Area  *Below, *Above __PACKED__;// Region(s) above/below
        struct Vars     Var __PACKED__;         // Local variables
	SHORT Fade __PACKED__;			// Light control
        //SHORT Tag __PACKED__;                   // Tag control
        //struct Move     Resist __PACKED__;      // Local physics
        struct Effect  *Eff __PACKED__;         // Effect ptr
	struct Object  *First __PACKED__;	// First object in the Region list
	struct Wall    **WallPtrs __PACKED__;	// Ptr to Wall pointers array
	LONG  NumWallPtrs __PACKED__;		// Number of wall pointers
        LONG  Stamp __PACKED__;                 // Time-stamp of last render
	SHORT Idx __PACKED__;			// Region's index (for REJECT)
        BYTE hadFloorT,hadCeilT __PACKED__;//had we defining textures for testing level

        //WORD AreaNum    __PACKED__;     // Region number
};
struct Wall {				// Wall structure
	DWORD  Type __PACKED__;			// Type
	struct Point   *p1, *p2 __PACKED__;	// Points
	struct TexCon   TopTC __PACKED__;	// Top texture
	struct TexCon   MidTC __PACKED__;	// Mid texture
	struct TexCon   BotTC __PACKED__;	// Bottom texture
        struct Area  *Front, *Back __PACKED__;// Front and Back regions
        FIXED  Length, Mass __PACKED__;         // Length and (optional) mass
	FIXED  TexX, TexY __PACKED__;		// Texture adjust
	SHORT  Fade __PACKED__;			// Light control
        //SHORT  Tag __PACKED__;                  // Tag control
        struct Vars     Var __PACKED__;         // Local variables
        struct Effect  *Eff __PACKED__;         // Effect ptr
	LONG Stamp __PACKED__;			// Time-stamp of last render
        SHORT wallnum __PACKED__; //let us know which wall we are
};

struct Object {				// Object structure
	DWORD  Type __PACKED__;			// Object's type
	struct Point   *pp __PACKED__;		// Coords
	DWORD  Event __PACKED__;		// Event to/from engine
	SHORT  Angle __PACKED__;		// Direction
	FIXED  H,RH __PACKED__;			// World Z coord, Render Z Coord
	FIXED  Height, Radius __PACKED__;	// Obj dimensions
	FIXED  Mass __PACKED__;			// Obj mass
	SHORT  Fade __PACKED__;			// Light control
        //SHORT  Tag __PACKED__;                  // Tag control
	struct TexCon     TC __PACKED__;	// Texture
        //struct Move       MSpeed __PACKED__;    // Max speed
	struct Move       Acc __PACKED__;	// Obj acceleration
	struct Move       Speed __PACKED__;	// Current speed
        struct Area    *pArea __PACKED__;   // Region where obj is
	struct Vars       Var __PACKED__;	// Local variables
	struct Effect    *Eff __PACKED__;	// Effect+Behaviour ptr
	struct Object    *Next __PACKED__;	// Next object in the Region's list
	DWORD  ID __PACKED__;			// Obj ID number for net play
	SHORT  HAngle __PACKED__;		// Direction of view relative to obj dir for net play
	SHORT  VAngle __PACKED__;		// Ver. angle (-127 to 128) of view for net play

        WORD LeftX,RightX __PACKED__; //for getting screen pos
        FIXED relative_angle;//for 3dobjects angle
        int our_relative_angle;//int version of above

        float x,y,z;

        float _fak_x,_fak_y,_fak_z;
        unsigned char *passed_our_raw;
};

// This may be changed to meet your needs
/*struct NetObject {                      // Network Object structure
	DWORD  Type __PACKED__;			// Object's type
	FIXED  x,y __PACKED__;			// Current coords
	DWORD  Event __PACKED__;		// Event to/from engine
	SHORT  Angle __PACKED__;		// Direction
	FIXED  H __PACKED__;			// World Z coord
	FIXED  Height, Radius __PACKED__;	// Obj dimensions
	FIXED  Mass __PACKED__;			// Obj mass
	FIXED  MX, MY, MZ __PACKED__;		// Max speed
	FIXED  X, Y, Z, T __PACKED__;		// Current speed
	LONG   Shoot __PACKED__;		// Player is shooting
	LONG   A, B, C, D __PACKED__;		// Local variables
	DWORD  ID __PACKED__;			// Obj ID number
	SHORT  HAngle __PACKED__;		// Direction of view relative to obj dir
	SHORT  VAngle __PACKED__;		// Ver. angle (-127 to 128) of view
};*/

struct View {				// View structure
	SHORT  ScrX, ScrY __PACKED__;		// Top-left corner of window
	SHORT  Width, Height __PACKED__;	// Width and height of the window
	BYTE  *Buffer __PACKED__;		// Buffer to draw to
	BYTE **BufScan __PACKED__;		// Table of ptrs to scanlines
	DWORD  BufWidth __PACKED__;		// Width of the output buffer
	DWORD  Size __PACKED__;			// Size of buffer (to check realloc)
	struct Object *pObject __PACKED__;	// Object which carries the camera
	FIXED  ObjHeight __PACKED__;		// Height above object
	FIXED  H __PACKED__;			// Z coord of camera
	FIXED  Vis __PACKED__;			// Visibility
	SHORT  Table __PACKED__;		// Fading table index
	SHORT  HAngle __PACKED__;		// Direction relative to obj dir
	SHORT  VAngle __PACKED__;		// Ver. angle (-127 to 128)
	SHORT  Horizon __PACKED__;		// For tilting view
	struct Vars    Var __PACKED__;		// Local variables
	struct Effect *Eff __PACKED__;		// Effect func (overlays etc)
	struct VLine  *StartClip __PACKED__;	// Start clip array ptr
	FIXED  dBackX,dBackY __PACKED__;	// Background texel size
	FIXED  BackH __PACKED__;		// View height for the texel size
	FIXED  dPicX,dPicY __PACKED__;		// Overlay texel size
	FIXED  ConstHDist, ConstVDist __PACKED__;// Constants
	FIXED  ConstHSlope __PACKED__;		// One more constant
	FIXED  tc1,ts1,tc2,ts2 __PACKED__;	// Variables for floor stuff
	struct BITMAP *bitmap __PACKED__;	// Pointer to Allegro bitmap structure
};
struct General {			// General info
	char Title[24] __PACKED__;		// Zone title
	struct Move GlobalForce __PACKED__;	// Global force
        //struct TexCon ScrTC __PACKED__;         // Screen texture
	struct TexCon BackTC __PACKED__;	// Back texture
	SHORT  BackAngle __PACKED__;		// Angle, back covers
	FIXED  BackConst __PACKED__;		// Background constant
	struct Effect *BackEff __PACKED__;	// Background effect
};
struct Effect {				// Effect structure
	DWORD  Type __PACKED__;			// Effect type
	char   Name[10] __PACKED__;		// Effect name
	void (*func)(void *,DWORD,DWORD) __PACKED__;// Effect function
};


extern struct EngineCFG Engine;
extern struct Palette   Pal;
extern struct General   Gen;

extern struct Table     Texs;
extern struct Table     Pics;
extern struct Table     Points;
extern struct Table     Paths;
extern struct Table     Areas;
extern struct Table     Walls;
extern struct Table     Objects;
extern struct Table     Views;
extern struct Table     Effects;
extern struct View     *ActView;
extern int NumWallPtrs, NumRTE, NumVDraws, NumMLines, NumLevels;

extern LONG TotalFrames;

//=============================
// Virtual Presence Engine API
//=============================
void  WTD_Init(void);                   // Init WTD
void  WTD_Config(int,int);              // Configure WTD (scr size)
void  WTD_Start(void);                  // Start rendering process
void  WTD_Stop(void);                   // Stop rendering process
void  WTD_Shut(void);                   // Shut down the engine
//void  WTD_SetRate(FIXED);               // Set Engine speed rate
void  WTD_Update(void);                 // Prepare zone for next frame
void  WTD_Render(void);                 // Render screen

//================
// Zone functions
//================
void  LoadLevel(char *);                 // Load a zone

//===================
// Texture functions
//===================
void  TexAlloc(struct TexCon *,char *,char,char *,int); // Allocate/load a texture
void  TexUpdate(struct TexCon *);	// Update texture (for mult.frames)
void  TexAction(struct TexCon *, int);  // Go to an act. sequence in a tex.
void  TexFree(struct TexCon *);		// Unload texture

//=====================
// Structure functions
//=====================
void  StructStart(struct Point *, int);	// Start struct. movement
void  StructStop(struct Point *);	// Stop struct. movement
int   StructUpdate(struct Point *);	// Update struct. for the next frame

//=========================
// WTD resource management
//=========================
void            UpdateObject(struct Object *);	// Update obj physics
struct Object  *AddObject(void);		// Add a new object
struct Object  *DelObject(struct Object *);	// Delete an object
struct Point   *AddPoint(void);			// Add a new point
struct Point   *DelPoint(struct Point *);	// Delete a point
struct Area  *FindArea(FIXED,FIXED,FIXED,int);// Find region from coords
void            SetObjArea(struct Object *,struct Area *);// Set r. for o.
void            ClearObjArea(struct Object *);// Clear reg. from an obj.
void SetViewSize(struct View *,int,int,BYTE *,int);// Set view size
void SetViewDir(struct View *,int,int);		// Set view direction

//===================
// Effect management
//===================
void RegisterEffect(char *, void (*func)(void *,DWORD,DWORD), DWORD);
struct Effect *GetEffect(char *, void *);
void ProcessEffect(struct Effect *, void *, DWORD, DWORD);

//==================
// Effect functions
//==================
//void            ActivateTag(int);
struct Wall    *ReAdjWall(struct Area *,int *);


//================
// Math functions
//================
FIXED FixSin(SHORT);			// SIN of an angle given in units
FIXED FixCos(SHORT);			// COS
FIXED FixITan(FIXED,FIXED);		// Angle in units 
FIXED FixDist(FIXED,FIXED,FIXED,FIXED);	// Fast approx for distance
LONG  LongSqrt(LONG);			// Pretty fast sqrt

//=================
// Misc. functions
//=================
void *CacheAlloc(LONG,char *);                 // Alloc. mem. freeing some cache 
void *AddEntry(struct Table *);		// Add entry to a table
void *DelEntry(struct Table *, int);	// Del entry from a table by idx
void *DelEntry2(struct Table *, void *);// Del entry by ptr
//BYTE  IsVisible(struct Area *, struct Area *); // Check visibility
//FIXED GetSPF(FIXED);                    // Get speed per frame
//void  DrawOverlay(struct TexCon *,int,int,int);// Draw overlay on screen
//void  SetPickWatch(int,int);            // Set pick watch for scr coords
//WORD  GetPickWatch(void *,FIXED *);     // Get result of pick watching
//void  SetTrace(struct Object *);        // Set object to trace
//BYTE  GetTrace(int *,int *,int *,int *);// Get results of object tracing

#endif
