/*
   Makes the Palette form a 768 (Artie SavePal) palette
*/

#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include <string.h>
#include "hard.h"
#include "pal.h"

#define MAX_SHADES		32

// ADD_STEP==0  -  Means go to the color color exactly
// ADD_STEP==NumShades - Go half way to the end color
#define ADD_STEP		16

int NumTables, NumShades;
int StartColor, EndColor;
double  DestRed[MAX_TABLES], DestGreen[MAX_TABLES], DestBlue[MAX_TABLES];
char *Filename;

struct Palette  Pal;
double Pals[MAX_SHADES][256][3];
FILE *pal_file;

void LoadPalette(void);
void SaveHeader(FILE *);
void SaveTable(FILE *);
void CreatePals(int);
void CreateTable(void);
unsigned char FindIndex(double, double, double);

void main(int argc,char **argv){
       int i;

       if(argc<2){printf("Needs filename\n");exit(1); }

       for(i=0;i<32;i++) Pal.BackFade[i]=0;

       Filename=argv[1];
//Test with 4 tables (each with 16 shades)
       NumTables=4; NumShades=16;
       StartColor=0; EndColor=255;

//Table 1 Normal
       DestRed[0]=0;  DestGreen[0]=0;  DestBlue[0]=0;  Pal.BackFade[0]=0;
//Table 2 fade all?
       DestRed[1]=32; DestGreen[1]=32; DestBlue[1]=32; Pal.BackFade[1]=15;
//Table 3 fade greens?
       DestRed[2]=0;  DestGreen[2]=32; DestBlue[2]=0;  Pal.BackFade[2]=15;
//Table 4 fade blues?
       DestRed[3]=0;  DestGreen[3]=0;  DestBlue[3]=32; Pal.BackFade[3]=15;
`
       LoadPalette();
       Pal.MemTables=(BYTE *)malloc(NumShades*256);
       if (Pal.MemTables==NULL) {
               printf("Can't get memory!\n");
               exit(1);
	}
	pal_file=fopen("PALETTE.PAL","wb");
	SaveHeader(pal_file);
	for(i=0;i<NumTables;i++) {
		printf("\nBuilding table #%d\n",i);
		CreatePals(i);
                CreateTable();
                SaveTable(pal_file);
	}

	fclose(pal_file);
return; }

void CreateTable(void){
	int i, n;
        for(n=0;n<NumShades;n++) {
		for(i=0;i<256;i++) {
			Pal.MemTables[n*256+i]=FindIndex(Pals[n][i][0],
				Pals[n][i][1],Pals[n][i][2]);
                                }
                }
return; }

void CreatePals(int t){
	double R, G, B, dr, dg, db;
	int i, n;
	for(i=0;i<256;i++) {
                R=Pals[0][i][0]; G=Pals[0][i][1]; B=Pals[0][i][2];
		dr=(DestRed[t]-R)/(double)(NumShades+ADD_STEP);
		dg=(DestGreen[t]-G)/(double)(NumShades+ADD_STEP);
		db=(DestBlue[t]-B)/(double)(NumShades+ADD_STEP);
		R+=dr;G+=dg;B+=db;
		for(n=1;n<NumShades;n++) {
                        Pals[n][i][0]=R; Pals[n][i][1]=G; Pals[n][i][2]=B;
			R+=dr;G+=dg;B+=db;
		}
	}
return; }

unsigned char FindIndex(double r, double g, double b){
	double R, G, B, dist, t;
	int i, index=0;

	dist=256.0*256.0*256.0;
	for(i=StartColor;i<=EndColor;i++) {
                R=Pals[0][i][0]-r; G=Pals[0][i][1]-g;  B=Pals[0][i][2]-b;
		t=R*R+G*G+B*B;
                if (t<dist) { index=i;dist=t; }
	}
return((unsigned char)index); }


void SaveHeader(FILE *fp){
	strcpy(Pal.PH.IDStr,PAL_ID);
	Pal.PH.NumShades=NumShades;
	Pal.PH.NumTables=NumTables;
	fwrite(&Pal.PH,sizeof(struct PalHeader),1,fp);
	fwrite(Pal.VGAPal,1,768,fp);
	fwrite(Pal.BackFade,1,32,fp);
return; }

void SaveTable(FILE *fp){ fwrite(Pal.MemTables,1,NumShades*256,fp); }

void LoadPalette(void){
        //BYTE pal[768];
        int i;
	FILE *fp;

        fp=fopen(Filename,"rb");
        if (fp==NULL) {
			printf("\nCan't open palette file!\n");
			exit(1);
         }
                        // fread(&Pal.PH,sizeof(struct PalHeader),1,fp);
                        //        if (strcmp(Pal.PH.IDStr,PAL_ID)!=0) fseek(fp,0,SEEK_SET);
        fread(Pal.VGAPal,1,768,fp);
                //        if (strcmp(Pal.PH.IDStr,PAL_ID)!=0) {
                //                for(i=0;i<768;i++) Pal.VGAPal[i]>>=2;
                //        }
        fclose(fp);

	for(i=0;i<256;i++) {
		Pals[0][i][0]=(double)Pal.VGAPal[i*3+0];
		Pals[0][i][1]=(double)Pal.VGAPal[i*3+1];
		Pals[0][i][2]=(double)Pal.VGAPal[i*3+2];
	}
}
