/*
	SinTable and CosTable covers 2048 (360 degrees)
	ITanTable 0 (-1) 1023 (1). Values from -256 (-45 deg)
		to 256 (45 degrees)

*/
#include <stdio.h>
#include <math.h>

#define M_PI		3.141592654
#define SIZE		2048		// equals to 360 degrees
#define NUM_ITAN	1024		// -1 to 1

#define DOUBLE_FIX(a)	((FIXED)(a*65536.0))
typedef long int FIXED;

FIXED SinTable[SIZE];
FIXED CosTable[SIZE];
FIXED ITanTable[NUM_ITAN];

void main(voi){
	int i;
	double a;

	for(i=0;i<SIZE;i++) {
		a=(double)i*2.0*M_PI/(double)SIZE;
		SinTable[i]=DOUBLE_FIX(sin(a));
                }
	for(i=0;i<SIZE;i++) {
		a=(double)i*2.0*M_PI/(double)SIZE;
		CosTable[i]=DOUBLE_FIX(cos(a));
                }
	for(i=0;i<NUM_ITAN;i++) {
		a=(double)(i-512)/(double)(NUM_ITAN>>1);
		a=atan(a);
		a=a/M_PI*(double)(SIZE>>1);
		ITanTable[i]=DOUBLE_FIX(a);
                }
return; }
