/*****************************************************************************
 *                                                                           *
 *                             ZONE FILE STUFF                               *
 *                                                                           *
 *****************************************************************************/
#ifdef __DJGPP__
#define __PACKED__	__attribute__ ((packed))
#else
#define __PACKED__
#endif


#define FILE_ID         "X3D"           // Zone file ID

#define PATH_LEN	32		// Number of path steps for a point

#define P_XMOVE		0x00000001	// Free move along X coord
#define P_YMOVE		0x00000002	// Free move along Y coord
#define P_PMOVE		0x00000004	// Point's path on

#define R_MASK		0x00000001	// Masked region (ceil and/or floor)
#define R_RELTEX	0x00000002	// Texturing starts relative to wall
#define R_TRANS		0x00000008	// Trans. region (ceil and/or floor)
#define R_FLOORHOLE	0x00000010	// Fall thru floor
#define R_CEILHOLE	0x00000020	// Fly thru ceiling
#define R_LOCAL		0x00000100	// Use local physics for objects

#define W_MASK		0x00000001	// Masked wall (drawn from back)
#define W_SOLID		0x00000002	// Col. det. works
#define W_MOVABLE	0x00000004	// Wall is movable
#define W_TRANS		0x00000008	// Translucent wall (drawn from back)

#define O_THING		0x00000001	// No speed calcs
#define O_FLYER		0x00000002	// Gravity does not apply to the object
#define O_NOFRIC	0x00000004	// No friction. Move until collision
#define O_NOSLIDE	0x00000008	// Object does not slide along a wall
#define O_WALLCOL	0x00000010	// Check wall collisions
#define O_OBJCOL	0x00000020	// Check obj collisions
#define O_STRUCT	0x00000040	// Special 'structure' collisions
#define O_PLAYER	0x00000080	// Player object
#define O_TRANS		0x00000100	// Translucent object
#define O_PROJECTILE	0x00001000	// Projectile object
#define O_INSTANT	0x00002000	// Object has infinite speed (bullet)
#define O_INFRONT	0x00010000	// Overlay object, slightly closer
#define O_BEHIND	0x00020000	// Overlay object, slightly farther
#define O_SHADOW	0x00040000	// Player shadow for network syncronisation


struct ZF_Header {		// Zone file header
        char  IDStr[4]  __PACKED__;     // Zone file ID string
        char vers;
        char title[20];
        //        SHORT NumPaths  __PACKED__;     // Number of paths
	SHORT NumPoints __PACKED__;	// Number of points
        SHORT NumAreas __PACKED__;    // Number of floors
	SHORT NumWalls	__PACKED__;	// Number of walls
        SHORT StartPos  __PACKED__;     // Number of walls

        SHORT StartPosHeight  __PACKED__;     // Start height(for area above area)
        SHORT CharHeight  __PACKED__;     // character height

        char back[9] __PACKED__;              // background
        //        SHORT NumObjects __PACKED__;    // Number of objects
        //        SHORT NumViews  __PACKED__;     // Number of views
};

struct ZF_Move {		// Used for movement data
	SHORT x,y,z,t	__PACKED__;	// x,y,z and torque
};

struct ZF_General {		// General information
              //  char  Title[24] __PACKED__;     // Zone name
              //  char  Palette[9] __PACKED__;    // Palette filename
              //  char  ScrTex[9] __PACKED__;     // Name of screen texture
	char  BackTex[9] __PACKED__;	// Background texture name
        char  BackEff[9] __PACKED__;    // Background Eff program
	SHORT BackAngle	__PACKED__;	// Angle of view covered by BackTex
	SHORT ActView	__PACKED__;	// Index of view which gets kbd input
              //  struct ZF_Move Force __PACKED__;// Global force
};


struct ZF_Path {                // Point path structure
	SHORT NumCoords	__PACKED__;	// Number of coords
	SHORT Delay	__PACKED__;	// Delay between coord change
	SHORT ax[PATH_LEN], ay[PATH_LEN] __PACKED__; // Relative coordinates
};

struct ZF_Point {		// Point struture
                //DWORD Type      __PACKED__;     // Type
	LONG  x,y	__PACKED__;	// Point coordinates
                //SHORT path      __PACKED__;     // Path index
                //SHORT link      __PACKED__;     // Index of the next point in the link
};

struct ZF_Area {              // Region structure
                //DWORD Type      __PACKED__;     // Type
        WORD Type      __PACKED__;     // Type
        SHORT CeilH     __PACKED__;     // Ceiling height
	SHORT FloorH	__PACKED__;	// Floor height
        char  CeilTex[9] __PACKED__;    // Ceiling texture name
	char  FloorTex[9] __PACKED__;	// Floor texture name
        SHORT Above     __PACKED__;     // Region above
	SHORT Below	__PACKED__;	// Region below
              //  char  Eff[9]    __PACKED__;     // Eff program
              //  SHORT EffParam  __PACKED__;     // Effect's param
              //  SHORT Tag       __PACKED__;     // Tag ID
};

struct ZF_Wall {		// Wall structure
                //DWORD Type      __PACKED__;     // Wall type
        WORD Type      __PACKED__;     // Wall type
	SHORT p1, p2	__PACKED__;	// Point indeces
	char  TopTex[9]	__PACKED__;	// Top texture name
	char  MidTex[9]	__PACKED__;	// Middle texture name
	char  BotTex[9]	__PACKED__;	// Bottom texture name
	SHORT Front	__PACKED__;	// Front Region 
	SHORT Back	__PACKED__;	// Back Region
                //char  Eff[9]    __PACKED__;     // Eff program
                //SHORT EffParam  __PACKED__;     // Effect's param
	SHORT TexX, TexY __PACKED__;	// Texture adjusting
                //SHORT Mass      __PACKED__;     // Mass for movable walls
                //SHORT Tag       __PACKED__;     // Tag ID
};

struct ZF_Object {		// Object structure
	DWORD Type	__PACKED__;	// Object type
	SHORT p		__PACKED__;	// Point index
	SHORT Angle	__PACKED__;	// Direction
	SHORT H		__PACKED__;	// Vertical coordinate
	SHORT Radius, Height __PACKED__;// Object dimensions (for col. det.)
	SHORT Mass	__PACKED__;	// Object mass
	char  Tex[9]	__PACKED__;	// Texture index
	char  Eff[9]	__PACKED__;	// Eff program
	SHORT EffParam	__PACKED__;	// Effect's param
	struct ZF_Move MSpeed __PACKED__;// Max speed of the object
	struct ZF_Move Acc __PACKED__;	// Acceleration
	SHORT Tag	__PACKED__;	// Tag ID
};

struct ZF_View {		// View description
	SHORT Obj	__PACKED__;	// Object for the view;
	SHORT Vis	__PACKED__;	// Visibility
	SHORT ScrX,ScrY __PACKED__;	// Coords of top-left corner
	SHORT Width,Height __PACKED__;	// View dimensions
	SHORT HAngle	__PACKED__;	// Hor. angle relative to object
	SHORT VAngle	__PACKED__;	// Ver. angle
	char  Eff[9]	__PACKED__;	// View's effect (overlay)
	SHORT EffParam	__PACKED__;	// Effect's param
};


