#include "internal.h"

char has_loaded_map=0;

void ClearLevel(void){
        //struct Texture *tex;
	struct View    *v;
        //struct PicInfo *pic;
	int i;

        has_loaded_map=0;

        // Clear effects
        //        SetupEffects(EFF_CLEAR);

        // Free Views' buffers
	for(i=0;i<Views.Number;i++) {
		v=(struct View *)Views.ptr[i];
                if (v->Size) MemFree(v->Buffer,"ClearLevel:view Buffer");
                MemFree(v->BufScan,"ClearLevel:view BufScan");
		v->Buffer=NULL;
		v->BufScan=NULL;
		v->Size=0;
	}
        // Remove all the textures from memory
     /*   for(i=0;i<Texs.Number;i++) {
		tex=(struct Texture *)Texs.ptr[i];
                MemFree(tex->CInfo,"ClearLevel:Tex");
                tex->CInfo=NULL;
	}
        // Mark all loaded PICs as unused (Used==0). Remove empty ones
	for(i=0;i<Pics.Number;i++) {
		pic=(struct PicInfo *)Pics.ptr[i];
                if (pic->Raw)  pic->Used=0;
                else {  DelEntry(&Pics,i);
			i--;
                        }
        }*/

        // Free REJECT
        //if (Reject) { MemFree(Reject); Reject=NULL; }

        // Free Pal's fading and trans tables
        //if (Pal.MemTables) { MemFree(Pal.MemTables,"ClearLevel:PalMemTables");
        //                        Pal.MemTables=NULL; }

        // Free Wall ptrs
        if (WallPtrs) { MemFree(WallPtrs,"ClearLevel:Wallptrs"); WallPtrs=NULL; }

        //Texs.Number=0;


	Points.Number=0;
        //Paths.Number=0;
        Areas.Number=0;
	Walls.Number=0;
	Objects.Number=0;
	Views.Number=0;
	NumRTE=0;	
	NumWallPtrs=0;
return; }

struct Point *AddPoint(void){
	struct Point *pp;
	pp=(struct Point *)AddEntry(&Points);
return(pp); }

struct Point *DelPoint(struct Point *pp){
	int i;

        // Find index of the point to delete
	for(i=Points.Number-1;i>=0;i--) {
		if (Points.ptr[i]==pp) break;
                        }
	if (i<0) return(pp);
        // Delete 
return(DelEntry(&Points,i)); }

struct Object *AddObject(void){
	struct Object *po;
	po=(struct Object *)AddEntry(&Objects);
return(po); }

struct Object *DelObject(struct Object *po){
	int i;
        // Find index of the object to delete
	for(i=Objects.Number-1;i>=0;i--) {
		if (Objects.ptr[i]==po) break;
                        }
	if (i<0) return(po);
        // Remove Object from RTE if needed
	DelRTEffect(po);
        // Remove object from Area's list
        ClearObjArea(po);
        // Update, delete etc
return(DelEntry(&Objects,i)); }

void SetObjArea(struct Object *pObject, struct Area *pArea){
        // Set object's pArea
        pObject->pArea=pArea;
        // Add object to the beginning of the list
        pObject->Next=pArea->First;
        pArea->First=pObject;
        // Send EFF_ENTER events
        ProcessEffect(pArea->Eff,pArea,EFF_ENTER,(DWORD)pObject);
        ProcessEffect(pObject->Eff,pObject,EFF_ENTER,(DWORD)pArea);
return; }

void ClearObjArea(struct Object *pObject){
	struct Object *po, **p;
        struct Area *pArea;

        // Do not process objects without pArea set
        pArea=pObject->pArea;
        if (pArea==NULL) return;
        // Send EFF_LEAVE events
        ProcessEffect(pArea->Eff,pArea,EFF_LEAVE,(DWORD)pObject);
        ProcessEffect(pObject->Eff,pObject,EFF_LEAVE,(DWORD)pArea);
        // Address of the pointer of the prev object to the next object
        p=&pArea->First;
        po=pArea->First;
	while(po) {
		if (po==pObject) {
			*p=pObject->Next;
			pObject->Next=NULL;
                        pObject->pArea=NULL;
			return;
		}
		p=&po->Next;
		po=po->Next;
	}
return; }

struct Area *FindArea(FIXED x, FIXED y, FIXED h, int StrucFlag){
	struct Wall   *pWall;
        struct Area *p;
	FIXED x1, x2, y1, y2, h1, h2, dist, t;
	int i;

        // Go thru all walls to find Area
	dist=INT_FIX(30000);			// dist
        p=NULL;                                 // Area
	for(i=0;i<Walls.Number;i++) {
		pWall=(struct Wall *)Walls.ptr[i];
		if ((pWall->Type&W_MOVABLE)&&StrucFlag) continue;
		x1=pWall->p1->x-x;
		x2=pWall->p2->x-x;
		if (x1<0&&x2<0) continue;
		y1=pWall->p1->y-y;
		y2=pWall->p2->y-y;
		if (y1>=0&&y2<0) {			// Front
			x2-=x1;
			y2-=y1;
			h1=pWall->Front->FloorH;
			h2=pWall->Front->CeilH;
			if (h1<=h&&h2>h) {
				t=FixMul(x2,FixDiv(-y1,y2))+x1;
				if (t>0&&t<dist) {
					p=pWall->Front;
					dist=t;
				}
			}
		}
		else if (y1<0&&y2>=0) {			// Back
			x2-=x1;
			y2-=y1;
			if (pWall->Back) {
				h1=pWall->Back->FloorH;
				h2=pWall->Back->CeilH;
                                }
			else {
				h1=pWall->Front->FloorH;
				h2=pWall->Front->CeilH;
                                }
			if (h1<=h&&h2>h) {
				t=FixMul(x2,FixDiv(-y1,y2))+x1;
				if (t>0&&t<dist) {
					p=pWall->Back;
					dist=t;
				}
			}
		}
	}
return(p); }

struct Wall *ReAdjWall(struct Area *r, int *n){
        if (*n<0||*n>=r->NumWallPtrs) return(NULL);
	(*n)++;
return(r->WallPtrs[(*n)-1]); }

/*BYTE IsVisible(struct Area *r1, struct Area *r2){
	LONG offset;
	BYTE a;

        offset=r2->Idx*Areas.Number+r1->Idx;
	a=Reject[offset>>3]&(1<<(offset&0x07));
return(a==0); }*/
