#define PIC_ID		"PC2"		// Picture file ID
#define TEX_ID          "XTx1"           // Texture file ID



struct PicInfo {		// Information about a picture
	BYTE	 Name[10];		// Picture name
	SHORT	 Width, Height;		// Dimensions of a pic
	SHORT	 InsX, InsY;		// Insertion point
	SHORT	 Used;			// Used counter
	SHORT	 Width2;		// log2 Width
	BYTE	*Raw;			// Pointer to data
};

struct CellInfo {		// Information about a cell in the anim
	WORD     Start;			// Id of the first Pic ptr in frame
	FIXED	 Delay;			// Delay of this frame
	struct CellInfo *Next;		// Pointer to the next CI in a seq
};

struct Texture {		// Main Texture structure
	char	 Name[10];		// Texture name
	SHORT    NumFrames;		// Number of frames
	SHORT    NumSides;		// Number of sides
	SHORT    NumSides2;		// Number of sides log2
	SHORT    SideSize;		// Size of one side (in units)
	SHORT    SideSize2;		// Size of one side log2
	LONG     Stamp;			// Frame it's been used on
	struct CellInfo   *AEntry[16];	// Array of ptrs to action entry points
	struct CellInfo   *CInfo;	// Array of CellInfos
	struct PicInfo   **PicPtrs;	// Array of PicPtrs(NumSides*NumFrames)
        BYTE *Mirrors;                  // Array of mirrors(NumSides*NumFrames)
};

struct TexCon {			// Texture control
	struct Texture   *pTex;		// Pointer to texture
	struct CellInfo  *pCell;	// Pointer to current cell
	struct PicInfo   *pPic;		// Pointer to current picture
	FIXED	 Delay;			// Delay of the cur frame
        BYTE     IsMirror;              // Mirror flag
	BYTE     reserved[3];		// To keep the alignment
};


struct PF_Header {		// Pic file header
	BYTE	 IDStr[4];		// Pic file ID 
	WORD	 Width, Height;		// Dimensions of a pic
	SHORT	 InsX, InsY;		// Insertion point
	WORD	 Width2;		// log2 Width
};

struct TF_Header {		// Tex file header
	BYTE	 IDStr[4];		// Tex file ID
	WORD     NumSides;		// Number of sides
        WORD     NumSides2;             // Number of sides log2
        WORD     NumFrames;             // Number of frames
        WORD     NumCells;              // Number of cells
};

struct TF_Cell {		// Cell field in Tex file
	WORD	 Frame;			// Frame index
	WORD	 Delay;			// Delay
	WORD	 Next;			// Index of the next cell in the seq
};

/*
===============================================================================
	PIC file format
	---------------
	Header			struct PF_Header
	Raw data		BYTE array
===============================================================================
	TEX file format
	---------------
	Header			struct TF_Header
	Cells data		struct TF_Cell * NumCells
	Actions' entries	WORD * 16
	Pic Names		10 chars * NumSides * NumFrames
	Mirror data		BYTE * NumSides * NumFrames
===============================================================================
*/
