[BITS 32]

[GLOBAL _DrawWSpan]
[GLOBAL _DrawMaskWSpan]
[GLOBAL _DrawTransWSpan]

;[SECTION .text ALIGN=4]
[SECTION .text]
%include "wtd.inc"
WLOOP_LEN    equ 32
WLOOP_SIZE   equ 15
WMLOOP_LEN    equ 32
WMLOOP_SIZE   equ 19
WTLOOP_LEN    equ 32
WTLOOP_SIZE   equ 20

;****************************************************************************
; Draws a vertical wall span
;					EAX
;	void DrawWSpan(struct WLine *pWLine)
;****************************************************************************
align
_DrawWSpan:
        push ebp			; preserve caller's stack frame
        mov ebp,esp			; point to our stack frame
	pushad				; save all registers
	mov ebx, [ebp+8]

	movzx eax, word [ebx+Count]
	mov [LoopCount], eax
	and eax, WLOOP_LEN-1
	mov esi, WLoopOffset
	mov eax, [esi+eax*4]
	add eax, .WLoopStart
	push eax

	mov esi, [ebx+RawPtr]
	mov ecx, [ebx+Delta-2]
	xor cx, cx
	mov eax, [ebx+Coord-2]
	mov al, [ebx+Delta+2]
	mov ah, [ebx+WMask]
	xor edx, edx
	mov dl, [ebx+Coord+2]
	movzx ebp, word [ebx+ViewWidth]
	mov edi, [ebx+PixPtr]
	mov ebx, [ebx+PalPtr]

	ret

align
.WLoopStart:				; unrolled loop is in the macro

	and dl, ah
	mov bl, [esi+edx]
	mov bl, [ebx]
	mov [edi], bl
	add edi, ebp
	add eax, ecx
	adc dl, al
       
	and dl, ah
	mov bl, [esi+edx]
	mov bl, [ebx]
	mov [edi], bl
	add edi, ebp
	add eax, ecx
	adc dl, al
       
	and dl, ah
	mov bl, [esi+edx]
	mov bl, [ebx]
	mov [edi], bl
	add edi, ebp
	add eax, ecx
	adc dl, al
       
	and dl, ah
	mov bl, [esi+edx]
	mov bl, [ebx]
	mov [edi], bl
	add edi, ebp
	add eax, ecx
	adc dl, al
       
	and dl, ah
	mov bl, [esi+edx]
	mov bl, [ebx]
	mov [edi], bl
	add edi, ebp
	add eax, ecx
	adc dl, al
       
	and dl, ah
	mov bl, [esi+edx]
	mov bl, [ebx]
	mov [edi], bl
	add edi, ebp
	add eax, ecx
	adc dl, al
       
	and dl, ah
	mov bl, [esi+edx]
	mov bl, [ebx]
	mov [edi], bl
	add edi, ebp
	add eax, ecx
	adc dl, al
       
	and dl, ah
	mov bl, [esi+edx]
	mov bl, [ebx]
	mov [edi], bl
	add edi, ebp
	add eax, ecx
	adc dl, al
       
	and dl, ah
	mov bl, [esi+edx]
	mov bl, [ebx]
	mov [edi], bl
	add edi, ebp
	add eax, ecx
	adc dl, al
       
	and dl, ah
	mov bl, [esi+edx]
	mov bl, [ebx]
	mov [edi], bl
	add edi, ebp
	add eax, ecx
	adc dl, al
       
	and dl, ah
	mov bl, [esi+edx]
	mov bl, [ebx]
	mov [edi], bl
	add edi, ebp
	add eax, ecx
	adc dl, al
       
	and dl, ah
	mov bl, [esi+edx]
	mov bl, [ebx]
	mov [edi], bl
	add edi, ebp
	add eax, ecx
	adc dl, al
       
	and dl, ah
	mov bl, [esi+edx]
	mov bl, [ebx]
	mov [edi], bl
	add edi, ebp
	add eax, ecx
	adc dl, al
       
	and dl, ah
	mov bl, [esi+edx]
	mov bl, [ebx]
	mov [edi], bl
	add edi, ebp
	add eax, ecx
	adc dl, al
       
	and dl, ah
	mov bl, [esi+edx]
	mov bl, [ebx]
	mov [edi], bl
	add edi, ebp
	add eax, ecx
	adc dl, al
       
	and dl, ah
	mov bl, [esi+edx]
	mov bl, [ebx]
	mov [edi], bl
	add edi, ebp
	add eax, ecx
	adc dl, al
       
	and dl, ah
	mov bl, [esi+edx]
	mov bl, [ebx]
	mov [edi], bl
	add edi, ebp
	add eax, ecx
	adc dl, al
       
	and dl, ah
	mov bl, [esi+edx]
	mov bl, [ebx]
	mov [edi], bl
	add edi, ebp
	add eax, ecx
	adc dl, al
       
	and dl, ah
	mov bl, [esi+edx]
	mov bl, [ebx]
	mov [edi], bl
	add edi, ebp
	add eax, ecx
	adc dl, al
       
	and dl, ah
	mov bl, [esi+edx]
	mov bl, [ebx]
	mov [edi], bl
	add edi, ebp
	add eax, ecx
	adc dl, al
       
	and dl, ah
	mov bl, [esi+edx]
	mov bl, [ebx]
	mov [edi], bl
	add edi, ebp
	add eax, ecx
	adc dl, al
       
	and dl, ah
	mov bl, [esi+edx]
	mov bl, [ebx]
	mov [edi], bl
	add edi, ebp
	add eax, ecx
	adc dl, al
       
	and dl, ah
	mov bl, [esi+edx]
	mov bl, [ebx]
	mov [edi], bl
	add edi, ebp
	add eax, ecx
	adc dl, al
       
	and dl, ah
	mov bl, [esi+edx]
	mov bl, [ebx]
	mov [edi], bl
	add edi, ebp
	add eax, ecx
	adc dl, al
       
	and dl, ah
	mov bl, [esi+edx]
	mov bl, [ebx]
	mov [edi], bl
	add edi, ebp
	add eax, ecx
	adc dl, al
       
	and dl, ah
	mov bl, [esi+edx]
	mov bl, [ebx]
	mov [edi], bl
	add edi, ebp
	add eax, ecx
	adc dl, al
       
	and dl, ah
	mov bl, [esi+edx]
	mov bl, [ebx]
	mov [edi], bl
	add edi, ebp
	add eax, ecx
	adc dl, al
       
	and dl, ah
	mov bl, [esi+edx]
	mov bl, [ebx]
	mov [edi], bl
	add edi, ebp
	add eax, ecx
	adc dl, al
       
	and dl, ah
	mov bl, [esi+edx]
	mov bl, [ebx]
	mov [edi], bl
	add edi, ebp
	add eax, ecx
	adc dl, al
       
	and dl, ah
	mov bl, [esi+edx]
	mov bl, [ebx]
	mov [edi], bl
	add edi, ebp
	add eax, ecx
	adc dl, al
       
	and dl, ah
	mov bl, [esi+edx]
	mov bl, [ebx]
	mov [edi], bl
	add edi, ebp
	add eax, ecx
	adc dl, al
       
	and dl, ah
	mov bl, [esi+edx]
	mov bl, [ebx]
	mov [edi], bl
	add edi, ebp
	add eax, ecx
	adc dl, al

	sub dword [LoopCount], WLOOP_LEN
	jae NEAR .WLoopStart

	popad				; restore all registers
	mov esp, ebp
        pop ebp				; restore caller's stack frame
        ret				; return

;****************************************************************************
; Draws a vertical masked wall span (any Tex width)
;					EAX
;	void DrawMaskWSpan(struct WLine *pWLine)
;****************************************************************************
align
_DrawMaskWSpan:
        push ebp			; preserve caller's stack frame
        mov ebp,esp			; point to our stack frame
	pushad				; save all registers
	mov ebx, [ebp+8]

	movzx eax, word [ebx+Count]
	mov [LoopCount], eax
	and eax, WMLOOP_LEN-1
	mov esi, WMLoopOffset
	mov eax, [esi+eax*4]
	add eax, .WMLoopStart
	push eax

	mov esi, [ebx+RawPtr]
	mov ecx, [ebx+Delta-2]
	xor cx, cx
	mov eax, [ebx+Coord-2]
	mov al, [ebx+Delta+2]
	mov ah, [ebx+WMask]
	xor edx, edx
	mov dl, [ebx+Coord+2]
	movzx ebp, word [ebx+ViewWidth]
	mov edi, [ebx+PixPtr]
	mov ebx, [ebx+PalPtr]

	ret

align
.WMLoopStart:				; unrolled loop

	and dl, ah
	mov bl, [esi+edx]
	or bl, bl
	je $+6
	mov bl, [ebx]
	mov [edi], bl
	add edi, ebp
	add eax, ecx
	adc dl, al
         
	and dl, ah
	mov bl, [esi+edx]
	or bl, bl
	je $+6
	mov bl, [ebx]
	mov [edi], bl
	add edi, ebp
	add eax, ecx
	adc dl, al
         
	and dl, ah
	mov bl, [esi+edx]
	or bl, bl
	je $+6
	mov bl, [ebx]
	mov [edi], bl
	add edi, ebp
	add eax, ecx
	adc dl, al
         
	and dl, ah
	mov bl, [esi+edx]
	or bl, bl
	je $+6
	mov bl, [ebx]
	mov [edi], bl
	add edi, ebp
	add eax, ecx
	adc dl, al
         
	and dl, ah
	mov bl, [esi+edx]
	or bl, bl
	je $+6
	mov bl, [ebx]
	mov [edi], bl
	add edi, ebp
	add eax, ecx
	adc dl, al
         
	and dl, ah
	mov bl, [esi+edx]
	or bl, bl
	je $+6
	mov bl, [ebx]
	mov [edi], bl
	add edi, ebp
	add eax, ecx
	adc dl, al
         
	and dl, ah
	mov bl, [esi+edx]
	or bl, bl
	je $+6
	mov bl, [ebx]
	mov [edi], bl
	add edi, ebp
	add eax, ecx
	adc dl, al
         
	and dl, ah
	mov bl, [esi+edx]
	or bl, bl
	je $+6
	mov bl, [ebx]
	mov [edi], bl
	add edi, ebp
	add eax, ecx
	adc dl, al
         
	and dl, ah
	mov bl, [esi+edx]
	or bl, bl
	je $+6
	mov bl, [ebx]
	mov [edi], bl
	add edi, ebp
	add eax, ecx
	adc dl, al
         
	and dl, ah
	mov bl, [esi+edx]
	or bl, bl
	je $+6
	mov bl, [ebx]
	mov [edi], bl
	add edi, ebp
	add eax, ecx
	adc dl, al
         
	and dl, ah
	mov bl, [esi+edx]
	or bl, bl
	je $+6
	mov bl, [ebx]
	mov [edi], bl
	add edi, ebp
	add eax, ecx
	adc dl, al
         
	and dl, ah
	mov bl, [esi+edx]
	or bl, bl
	je $+6
	mov bl, [ebx]
	mov [edi], bl
	add edi, ebp
	add eax, ecx
	adc dl, al
         
	and dl, ah
	mov bl, [esi+edx]
	or bl, bl
	je $+6
	mov bl, [ebx]
	mov [edi], bl
	add edi, ebp
	add eax, ecx
	adc dl, al
         
	and dl, ah
	mov bl, [esi+edx]
	or bl, bl
	je $+6
	mov bl, [ebx]
	mov [edi], bl
	add edi, ebp
	add eax, ecx
	adc dl, al
         
	and dl, ah
	mov bl, [esi+edx]
	or bl, bl
	je $+6
	mov bl, [ebx]
	mov [edi], bl
	add edi, ebp
	add eax, ecx
	adc dl, al
         
	and dl, ah
	mov bl, [esi+edx]
	or bl, bl
	je $+6
	mov bl, [ebx]
	mov [edi], bl
	add edi, ebp
	add eax, ecx
	adc dl, al
         
	and dl, ah
	mov bl, [esi+edx]
	or bl, bl
	je $+6
	mov bl, [ebx]
	mov [edi], bl
	add edi, ebp
	add eax, ecx
	adc dl, al
         
	and dl, ah
	mov bl, [esi+edx]
	or bl, bl
	je $+6
	mov bl, [ebx]
	mov [edi], bl
	add edi, ebp
	add eax, ecx
	adc dl, al
         
	and dl, ah
	mov bl, [esi+edx]
	or bl, bl
	je $+6
	mov bl, [ebx]
	mov [edi], bl
	add edi, ebp
	add eax, ecx
	adc dl, al
         
	and dl, ah
	mov bl, [esi+edx]
	or bl, bl
	je $+6
	mov bl, [ebx]
	mov [edi], bl
	add edi, ebp
	add eax, ecx
	adc dl, al
         
	and dl, ah
	mov bl, [esi+edx]
	or bl, bl
	je $+6
	mov bl, [ebx]
	mov [edi], bl
	add edi, ebp
	add eax, ecx
	adc dl, al
         
	and dl, ah
	mov bl, [esi+edx]
	or bl, bl
	je $+6
	mov bl, [ebx]
	mov [edi], bl
	add edi, ebp
	add eax, ecx
	adc dl, al
         
	and dl, ah
	mov bl, [esi+edx]
	or bl, bl
	je $+6
	mov bl, [ebx]
	mov [edi], bl
	add edi, ebp
	add eax, ecx
	adc dl, al
         
	and dl, ah
	mov bl, [esi+edx]
	or bl, bl
	je $+6
	mov bl, [ebx]
	mov [edi], bl
	add edi, ebp
	add eax, ecx
	adc dl, al
         
	and dl, ah
	mov bl, [esi+edx]
	or bl, bl
	je $+6
	mov bl, [ebx]
	mov [edi], bl
	add edi, ebp
	add eax, ecx
	adc dl, al
         
	and dl, ah
	mov bl, [esi+edx]
	or bl, bl
	je $+6
	mov bl, [ebx]
	mov [edi], bl
	add edi, ebp
	add eax, ecx
	adc dl, al
         
	and dl, ah
	mov bl, [esi+edx]
	or bl, bl
	je $+6
	mov bl, [ebx]
	mov [edi], bl
	add edi, ebp
	add eax, ecx
	adc dl, al
         
	and dl, ah
	mov bl, [esi+edx]
	or bl, bl
	je $+6
	mov bl, [ebx]
	mov [edi], bl
	add edi, ebp
	add eax, ecx
	adc dl, al
         
	and dl, ah
	mov bl, [esi+edx]
	or bl, bl
	je $+6
	mov bl, [ebx]
	mov [edi], bl
	add edi, ebp
	add eax, ecx
	adc dl, al
         
	and dl, ah
	mov bl, [esi+edx]
	or bl, bl
	je $+6
	mov bl, [ebx]
	mov [edi], bl
	add edi, ebp
	add eax, ecx
	adc dl, al
         
	and dl, ah
	mov bl, [esi+edx]
	or bl, bl
	je $+6
	mov bl, [ebx]
	mov [edi], bl
	add edi, ebp
	add eax, ecx
	adc dl, al
         
	and dl, ah
	mov bl, [esi+edx]
	or bl, bl
	je $+6
	mov bl, [ebx]
	mov [edi], bl
	add edi, ebp
	add eax, ecx
	adc dl, al

	sub dword [LoopCount], WMLOOP_LEN
	jae NEAR .WMLoopStart

	popad				; restore all registers
	mov esp, ebp
        pop ebp				; restore caller's stack frame
        ret				; return

;****************************************************************************
; Draws a vertical translucent wall span (any Tex width)
;					EAX
;	void DrawTransWSpan(struct WLine *pWLine)
;****************************************************************************
align
_DrawTransWSpan:
        push ebp			; preserve caller's stack frame
        mov ebp,esp			; point to our stack frame
	pushad				; save all registers
	mov ebx, [ebp+8]

	movzx eax, word [ebx+Count]
	mov [LoopCount], eax
	and eax, WTLOOP_LEN-1
	mov esi, WTLoopOffset
	mov eax, [esi+eax*4]
	add eax, .WTLoopStart
	push eax

	mov esi, [ebx+RawPtr]
	mov ecx, [ebx+Delta-2]
	xor cx, cx
	mov eax, [ebx+Coord-2]
	mov al, [ebx+Delta+2]
	mov ah, [ebx+WMask]
	xor edx, edx
	mov dl, [ebx+Coord+2]
	movzx ebp, word [ebx+ViewWidth]
	mov edi, [ebx+PixPtr]
	mov ebx, [ebx+PalPtr]
	sub ebx, ecx			; different from others!

	ret

align
.WTLoopStart:				; unrolled loop

	and dl, ah
	mov bl, [edi]
	mov ch, [esi+edx]
	mov bl, [ebx+ecx]
	mov [edi], bl
	add edi, ebp
	xor ch, ch
	add eax, ecx
	adc dl, al
         
	and dl, ah
	mov bl, [edi]
	mov ch, [esi+edx]
	mov bl, [ebx+ecx]
	mov [edi], bl
	add edi, ebp
	xor ch, ch
	add eax, ecx
	adc dl, al
         
	and dl, ah
	mov bl, [edi]
	mov ch, [esi+edx]
	mov bl, [ebx+ecx]
	mov [edi], bl
	add edi, ebp
	xor ch, ch
	add eax, ecx
	adc dl, al
         
	and dl, ah
	mov bl, [edi]
	mov ch, [esi+edx]
	mov bl, [ebx+ecx]
	mov [edi], bl
	add edi, ebp
	xor ch, ch
	add eax, ecx
	adc dl, al
         
	and dl, ah
	mov bl, [edi]
	mov ch, [esi+edx]
	mov bl, [ebx+ecx]
	mov [edi], bl
	add edi, ebp
	xor ch, ch
	add eax, ecx
	adc dl, al
         
	and dl, ah
	mov bl, [edi]
	mov ch, [esi+edx]
	mov bl, [ebx+ecx]
	mov [edi], bl
	add edi, ebp
	xor ch, ch
	add eax, ecx
	adc dl, al
         
	and dl, ah
	mov bl, [edi]
	mov ch, [esi+edx]
	mov bl, [ebx+ecx]
	mov [edi], bl
	add edi, ebp
	xor ch, ch
	add eax, ecx
	adc dl, al
         
	and dl, ah
	mov bl, [edi]
	mov ch, [esi+edx]
	mov bl, [ebx+ecx]
	mov [edi], bl
	add edi, ebp
	xor ch, ch
	add eax, ecx
	adc dl, al
         
	and dl, ah
	mov bl, [edi]
	mov ch, [esi+edx]
	mov bl, [ebx+ecx]
	mov [edi], bl
	add edi, ebp
	xor ch, ch
	add eax, ecx
	adc dl, al
         
	and dl, ah
	mov bl, [edi]
	mov ch, [esi+edx]
	mov bl, [ebx+ecx]
	mov [edi], bl
	add edi, ebp
	xor ch, ch
	add eax, ecx
	adc dl, al
         
	and dl, ah
	mov bl, [edi]
	mov ch, [esi+edx]
	mov bl, [ebx+ecx]
	mov [edi], bl
	add edi, ebp
	xor ch, ch
	add eax, ecx
	adc dl, al
         
	and dl, ah
	mov bl, [edi]
	mov ch, [esi+edx]
	mov bl, [ebx+ecx]
	mov [edi], bl
	add edi, ebp
	xor ch, ch
	add eax, ecx
	adc dl, al
         
	and dl, ah
	mov bl, [edi]
	mov ch, [esi+edx]
	mov bl, [ebx+ecx]
	mov [edi], bl
	add edi, ebp
	xor ch, ch
	add eax, ecx
	adc dl, al
         
	and dl, ah
	mov bl, [edi]
	mov ch, [esi+edx]
	mov bl, [ebx+ecx]
	mov [edi], bl
	add edi, ebp
	xor ch, ch
	add eax, ecx
	adc dl, al
         
	and dl, ah
	mov bl, [edi]
	mov ch, [esi+edx]
	mov bl, [ebx+ecx]
	mov [edi], bl
	add edi, ebp
	xor ch, ch
	add eax, ecx
	adc dl, al
         
	and dl, ah
	mov bl, [edi]
	mov ch, [esi+edx]
	mov bl, [ebx+ecx]
	mov [edi], bl
	add edi, ebp
	xor ch, ch
	add eax, ecx
	adc dl, al
         
	and dl, ah
	mov bl, [edi]
	mov ch, [esi+edx]
	mov bl, [ebx+ecx]
	mov [edi], bl
	add edi, ebp
	xor ch, ch
	add eax, ecx
	adc dl, al
         
	and dl, ah
	mov bl, [edi]
	mov ch, [esi+edx]
	mov bl, [ebx+ecx]
	mov [edi], bl
	add edi, ebp
	xor ch, ch
	add eax, ecx
	adc dl, al
         
	and dl, ah
	mov bl, [edi]
	mov ch, [esi+edx]
	mov bl, [ebx+ecx]
	mov [edi], bl
	add edi, ebp
	xor ch, ch
	add eax, ecx
	adc dl, al
         
	and dl, ah
	mov bl, [edi]
	mov ch, [esi+edx]
	mov bl, [ebx+ecx]
	mov [edi], bl
	add edi, ebp
	xor ch, ch
	add eax, ecx
	adc dl, al
         
	and dl, ah
	mov bl, [edi]
	mov ch, [esi+edx]
	mov bl, [ebx+ecx]
	mov [edi], bl
	add edi, ebp
	xor ch, ch
	add eax, ecx
	adc dl, al
         
	and dl, ah
	mov bl, [edi]
	mov ch, [esi+edx]
	mov bl, [ebx+ecx]
	mov [edi], bl
	add edi, ebp
	xor ch, ch
	add eax, ecx
	adc dl, al
         
	and dl, ah
	mov bl, [edi]
	mov ch, [esi+edx]
	mov bl, [ebx+ecx]
	mov [edi], bl
	add edi, ebp
	xor ch, ch
	add eax, ecx
	adc dl, al
         
	and dl, ah
	mov bl, [edi]
	mov ch, [esi+edx]
	mov bl, [ebx+ecx]
	mov [edi], bl
	add edi, ebp
	xor ch, ch
	add eax, ecx
	adc dl, al
         
	and dl, ah
	mov bl, [edi]
	mov ch, [esi+edx]
	mov bl, [ebx+ecx]
	mov [edi], bl
	add edi, ebp
	xor ch, ch
	add eax, ecx
	adc dl, al
         
	and dl, ah
	mov bl, [edi]
	mov ch, [esi+edx]
	mov bl, [ebx+ecx]
	mov [edi], bl
	add edi, ebp
	xor ch, ch
	add eax, ecx
	adc dl, al
         
	and dl, ah
	mov bl, [edi]
	mov ch, [esi+edx]
	mov bl, [ebx+ecx]
	mov [edi], bl
	add edi, ebp
	xor ch, ch
	add eax, ecx
	adc dl, al
         
	and dl, ah
	mov bl, [edi]
	mov ch, [esi+edx]
	mov bl, [ebx+ecx]
	mov [edi], bl
	add edi, ebp
	xor ch, ch
	add eax, ecx
	adc dl, al
         
	and dl, ah
	mov bl, [edi]
	mov ch, [esi+edx]
	mov bl, [ebx+ecx]
	mov [edi], bl
	add edi, ebp
	xor ch, ch
	add eax, ecx
	adc dl, al
         
	and dl, ah
	mov bl, [edi]
	mov ch, [esi+edx]
	mov bl, [ebx+ecx]
	mov [edi], bl
	add edi, ebp
	xor ch, ch
	add eax, ecx
	adc dl, al
         
	and dl, ah
	mov bl, [edi]
	mov ch, [esi+edx]
	mov bl, [ebx+ecx]
	mov [edi], bl
	add edi, ebp
	xor ch, ch
	add eax, ecx
	adc dl, al
         
	and dl, ah
	mov bl, [edi]
	mov ch, [esi+edx]
	mov bl, [ebx+ecx]
	mov [edi], bl
	add edi, ebp
	xor ch, ch
	add eax, ecx
	adc dl, al

	sub dword [LoopCount], WTLOOP_LEN
	jae NEAR .WTLoopStart

	popad				; restore all registers
	mov esp, ebp
        pop ebp				; restore caller's stack frame
        ret				; return

;[SECTION .data ALIGN=4]
[SECTION .data]

LoopCount:	dd 0

WLoopOffset:
    dd 01E0h,01D1h,01C2h,01B3h,01A4h,0195h,0186h,0177h
    dd 0168h,0159h,014Ah,013Bh,012Ch,011Dh,010Eh,00FFh
    dd 00F0h,00E1h,00D2h,00C3h,00B4h,00A5h,0096h,0087h
    dd 0078h,0069h,005Ah,004Bh,003Ch,002Dh,001Eh,000Fh

WMLoopOffset:
    dd 0260h,024Dh,023Ah,0227h,0214h,0201h,01EEh,01DBh
    dd 01C8h,01B5h,01A2h,018Fh,017Ch,0169h,0156h,0143h
    dd 0130h,011Dh,010Ah,00F7h,00E4h,00D1h,00BEh,00ABh
    dd 0098h,0085h,0072h,005Fh,004Ch,0039h,0026h,0013h

WTLoopOffset:
    dd 0280h,026Ch,0258h,0244h,0230h,021Ch,0208h,01F4h
    dd 01E0h,01CCh,01B8h,01A4h,0190h,017Ch,0168h,0154h
    dd 0140h,012Ch,0118h,0104h,00F0h,00DCh,00C8h,00B4h
    dd 00A0h,008Ch,0078h,0064h,0050h,003Ch,0028h,0014h
