#include "internal.h"

#define MAX_COLREGS     4               // Max number of Areas to process
#define F_CDIST		INT_FIX(16)	// Checking distance
#define F_WDIST		INT_FIX(8)	// Min walk distance
#define F_SDIST		INT_FIX(8)	// Step distance
#define SDIST2		3		// Step distance (log2)


extern void handlecollision_object(struct Object *po,struct Object *po2,int type);
extern void handlecollision_wall(struct Object *po,struct Wall *pWall,int type);

void AddColReg(struct Area *);

static struct Area *ColReg[MAX_COLREGS];
static int CurColReg, NumColRegs;

extern int wtd_gravity;

void DoObjectUpdate(struct Object *po){
	struct Point   *pp;
	struct Object  *pObject;
	struct Wall    *pWall;
        struct Area  *pArea, *reg;
        struct Move    *pSpeed=NULL, *pAcc;//*pMSpeed,
	FIXED MoveX,MoveY,MoveZ,AddX,AddY,AddZ,X,Y,AddRH,RegDist;
        FIXED c,s,t,t1,t2,tx,ty,x1,y1,x2,y2,x,y,dist,check,v;
	BYTE  Flag,ColFlag,RotateFlag,MoveFlag;
	int i, Steps;

	if ((po->Event&EV_DESTROY)!=0) {
                DelPoint(po->pp); DelObject(po);
                return;
                }
	pp=po->pp;				// Object point
        pArea=po->pArea;                    // Object Area

        //TexUpdate(&po->TC);

        if (po->Type&O_THING) { // If a THING go to collision-detection
		Steps=1; MoveX=MoveY=MoveZ=AddX=AddY=AddZ=0;
		goto COLDET;
                }

	pSpeed=&po->Speed;			// Speed
        //pMSpeed=&po->MSpeed;                    // Speed limit
	pAcc=&po->Acc;				// Obj acceleration

	// Process movement events
        if (po->Event&EV_LEFT) pSpeed->Y=pAcc->Y;       //sidesteps
        if (po->Event&EV_FORWARD) pSpeed->X=pAcc->X;    //moves
        if (po->Event&EV_TURNLEFT){                     //turns
                po->Angle+=FIX_INT(pAcc->T);
                if(po->Angle>DEG360)po->Angle-=DEG360;
                if(po->Angle<0)po->Angle+=DEG360;
                                }
	if (po->Event&EV_UP) {			// Move upward (jump)
                if (po->Type&O_FLYER) pSpeed->Z=pAcc->Z;
                            }
        // If object is not a flyer and is not moving along Z allow it to
        // fall if above max stairs or simply land
        if ((po->Type&O_FLYER)==0){//&&pSpeed->Z==0) {
                if ( po->H-pArea->FloorH>Engine.MaxStairs ||
                    (pArea->Type&R_FLOORHOLE)!=0 ) pSpeed->Z=INT_FIX(-wtd_gravity);
                else po->H=pArea->FloorH;
                }

        MoveZ=pSpeed->Z;
	t1=FixSin(-po->Angle);
	t2=FixCos(-po->Angle);

        v=pSpeed->Y;  MoveX=FixMul(t1,v);  MoveY=FixMul(t2,v);
        v=pSpeed->X;  MoveX+=FixMul(t2,v); MoveY+=FixMul(-t1,v);
        pSpeed->Z=pSpeed->X=pSpeed->Y=0;

        //reset these
        po->Acc.X=INT_FIX(0); po->Acc.Y=INT_FIX(0);
        po->Acc.T=INT_FIX(0); po->Acc.Z=INT_FIX(0);


        //if(po->Event&EFF_WALLHIT)po->Event&=~EFF_WALLHIT;
        //if(po->Event&EFF_OBJHIT)po->Event&=~EFF_OBJHIT;


/********************  COLLISION DETECTION   *********************/
COLDET:


// No col-det (update and return)
        if ((po->Type)&((O_WALLCOL|O_OBJCOL)==0)) {
		MovePoint(pp,MoveX,MoveY);
		return;
                }
// By default no vertical (stairs) movement
	AddRH=0;
// Fiddle with final position for O_INSTANT
	if (po->Type&O_INSTANT) {
		t=FixDist(0,0,MoveX,MoveY);
                // This should not happen.
                if (t==0){FatalError(ER_GENERAL,"TdError");//,"O_INSTANT has ZERO speed");
                          return;
                                }
		t=FixDiv(pSpeed->X,t);
		MoveX=FixMul(MoveX,t);
		MoveY=FixMul(MoveY,t);
		MoveZ=FixMul(MoveZ,t);
                }
// Prepare steps
	ColFlag=TRUE;
	tx=FixMod(MoveX);
	ty=FixMod(MoveY);
	if (tx>=ty) {
		if (tx>F_SDIST) {	// Multiple steps
			Steps=(FIX_INT(tx)>>SDIST2)+1;
			t=FixDiv(INT_FIX(1),INT_FIX(Steps));
			AddX=FixMul(MoveX,t);
			AddY=FixMul(MoveY,t);
			AddZ=FixMul(MoveZ,t);
                        }
		else {			// Single step
			Steps=1;
			AddX=MoveX; AddY=MoveY; AddZ=MoveZ;
                        }
             }
	else { // MoveY>MoveX
		if (ty>F_SDIST) {	// Multiple steps
			Steps=(FIX_INT(ty)>>SDIST2)+1;
			t=FixDiv(INT_FIX(1),INT_FIX(Steps));
			AddX=FixMul(MoveX,t);
			AddY=FixMul(MoveY,t);
			AddZ=FixMul(MoveZ,t);
		}
		else {			// Single step
			Steps=1;
			AddX=MoveX; AddY=MoveY; AddZ=MoveZ;
                        }
           }


	X=pp->x; Y=pp->y;		// Current coords

// Do col-det for all steps
	for(;Steps>0;Steps--) {
                pArea=po->pArea;
		RegDist=INT_FIX(1000);
		Flag=0;
                // Advance to the next step
                X+=AddX; Y+=AddY; po->H+=AddZ;

        /********** Area COLLISION **********/
                t1=pArea->FloorH;
                t2=pArea->CeilH;
                // Check for collision with floor
		if (po->H<t1) {
                        // Fall thru FloorHole?
                        if (pArea->Type&R_FLOORHOLE) {
                                ClearObjArea(po);
                                SetObjArea(po,pArea->Below);
                                pArea=pArea->Below;
                                }
			else {
				po->H=t1;
				if ((po->Type&O_FLYER)!=0) {// Fl. bounces
					if (pSpeed->Z<0) pSpeed->Z=-pSpeed->Z;
                                        }
                                else pSpeed->Z=0;
                                ProcessEffect(po->Eff,po,EFF_FLOORHIT,(DWORD)pArea);
                                ProcessEffect(pArea->Eff,pArea,EFF_OBJHIT,(DWORD)po);
				ColFlag=FALSE;
                                // If object does not like sliding - bail out
				if ((po->Type&O_NOSLIDE)!=0) break;
			}
		}
                // Check for ceiling collision
		if (po->H+po->Height>=t2) {
		// Fly thru CeilHole?
                        if (pArea->Type&R_CEILHOLE) {
				if (po->H>t2) {
                                        ClearObjArea(po);
                                        SetObjArea(po,pArea->Above);
                                        pArea=pArea->Above;
				}
			}
			else {
                                po->H=t2-po->Height;
				if (pSpeed->Z>0) pSpeed->Z=-pSpeed->Z;
                                ProcessEffect(po->Eff,po,EFF_CEILHIT,(DWORD)pArea);
                                ProcessEffect(pArea->Eff,pArea,EFF_OBJHIT,(DWORD)po);
				ColFlag=FALSE;
                                // If object does not like sliding - bail out
				if ((po->Type&O_NOSLIDE)!=0) break;
			}
		}

/****************************************************************************
        DO COLLISIONS WITH OBJECTS AND WALLS FOR ALL AreaS IN THE ARRAY
*****************************************************************************/
// Start with object's Area
        ColReg[0]=pArea;
	NumColRegs=1;
	for(CurColReg=0;CurColReg<NumColRegs;CurColReg++) {
                pArea=ColReg[CurColReg];

        /**************  OBJECT COLLISION  **************/

                // Skip object collision
		if ((po->Type&O_OBJCOL)==0) goto WALL_COL;
		pObject=po->Next;
		for(;pObject!=NULL;pObject=pObject->Next) {
                        // Check failing conditions
                        //      if (((pObject->Type&O_PLAYER)!=0)
                        //              &((po->Type&O_SHADOW)!=0)) continue;    // ignore collision between player and his shadow
                        //      if (((pObject->Type&O_PROJECTILE)!=0)
                        //              &((po->Type&O_SHADOW)!=0)) continue;    // ignore collision between projectiles and the shadow

			if ((pObject->Type&O_OBJCOL)==0) continue;
			if (pObject->H>po->H+po->Height)	// po is below
				continue;
			if (po->H>pObject->H+pObject->Height)	// po is above
				continue;
                        // Check if pObject is close to this step
			dist=po->Radius+pObject->Radius;
			if (FixMod(X-pObject->pp->x)>=dist) continue;
			if (FixMod(Y-pObject->pp->y)>=dist) continue;
                        // Check structure flags
			if ((po->Type&O_STRUCT)!=(pObject->Type&O_STRUCT))
                                        continue;
                        // We have to compute exact distance
			tx=pObject->pp->x-X; t1=FIX_INT(tx);
			ty=pObject->pp->y-Y; t2=FIX_INT(ty);
			t=INT_FIX(LongSqrt(t1*t1+t2*t2));
                        // Are we too close?
			if (t>INT_FIX(1)&&t<dist) {
				if ((po->Type&O_THING)==0&&(pObject->Type&O_THING)==0) {
					t1=dist-t;
                                        // Total displacement
					tx=FixMul(t1,FixDiv(tx,t));
					ty=FixMul(t1,FixDiv(ty,t));
                                        // pObject has infinite mass?
					if (pObject->Mass==0) {
                                                // Yep. Move only po.
						X-=tx; Y-=ty;
                                                }
                                        // po has infinite mass?
					else if (po->Mass==0) {
                                                // Yep. Move only pObject.
						MovePoint(pObject->pp,tx,ty);
                                                }
                                        // Bounce both objects
					else {
					// Total mass
						t=po->Mass+pObject->Mass;
						tx=FixDiv(tx,t);
						ty=FixDiv(ty,t);
					// Our object
						t1=FixMul(pObject->Mass,tx);
						t2=FixMul(pObject->Mass,ty);
						X-=t1; Y-=t2;
					// The other object
						t1=FixMul(po->Mass,tx);
						t2=FixMul(po->Mass,ty);
						MovePoint(pObject->pp,t1,t2);
					}
				}
			// Send events
				ProcessEffect(po->Eff,po,EFF_OBJHIT,(DWORD)pObject);
				ProcessEffect(pObject->Eff,pObject,EFF_OBJHIT,(DWORD)po);
//po->Event|=EFF_OBJHIT;
                        handlecollision_object(po,pObject,EFF_OBJHIT);
                        

				ColFlag=FALSE;
                                // Is object NOT a slider?
				if ((po->Type&O_NOSLIDE)!=0) {
                                                // Set the loop's terminator
                                                Steps=0;
                                                // Get out of here
                                                break;
                                                }
                                }
		}

/********** WALL COLLISION ************/
                // Skip wallcol?
		if ((po->Type&O_WALLCOL)==0) continue;
WALL_COL:
                // Checking distance
		check=F_CDIST+po->Radius;
                // Min walking distance
		dist=F_WDIST+po->Radius;
                // For all walls in current Area
                for(i=0;i<pArea->NumWallPtrs;i++) {
                        pWall=pArea->WallPtrs[i];
                        // Get wall coords
			x1=pWall->p1->x; y1=pWall->p1->y;
			x2=pWall->p2->x; y2=pWall->p2->y;
                        // Check if obj is near wall
			if (x1>=x2) {
				if (X<=x2-check) continue;
				if (X>x1+check) continue;
                                }
			else { // x2>x1
				if (X<x1-check) continue;
				if (X>=x2+check) continue;
                                }
			if (y1>=y2) {
				if (Y<=y2-check) continue;
				if (Y>y1+check) continue;
                                }
			else { // y2>y1
				if (Y<y1-check) continue;
				if (Y>=y2+check) continue;
                                }
		// Is it a special structure case?
			if ((po->Type&O_STRUCT)!=0 &&
			     (pWall->Type&W_MOVABLE)!=0) continue;

		// Find wall sin and cos. ArcTan way is more accurate than 
		// dividing by WallLength
			x2-=x1; y2-=y1;
			t=FIX_INT(FixITan(x2,y2));
			c=FixCos(t);
			s=FixSin(t);
		// Rotate X,Y into wall space
			x=FixMul(c,X-x1)-FixMul(-s,Y-y1);
			y=FixMul(-s,X-x1)+FixMul(c,Y-y1);
		// Now x coord is along the wall and y coord
		// is perpendicular ( <0 - front) to the wall
		// Too far away
			if (FixMod(y)>=dist) continue;

                        // Coords in wall space will be rotated back by default
			RotateFlag=TRUE;
                        // Clear movable wall's vars
			MoveFlag=(pWall->Type&W_MOVABLE)!=0&&pWall->Mass;
		// Let's do collision handling
			if ((pWall->Type&W_SOLID)==0&&(po->Type&O_STRUCT)==0) {
				t1=pWall->Front->FloorH;
				t2=pWall->Front->CeilH;
				if (pWall->Back) {
					t1=FixMax(t1,pWall->Back->FloorH);
					t2=FixMin(t2,pWall->Back->CeilH);
				}
			// Stairs for sliders
				if ((po->Type&O_NOSLIDE)==0)
					t1-=Engine.MaxStairs+AddRH;
			// Do we pass the wall?
				if ((po->H>=t1)&&((po->H+po->Height)<=t2)) {
                                // Find current Area
					if (y>0) reg=pWall->Back;
					else reg=pWall->Front;
				// Are we close to p1 or p2?
					if (x<0||x>pWall->Length) {
						t1=FIX_INT(x);
						if (x>0) t1-=FIX_INT(pWall->Length);
						t2=FIX_INT(y);
						t=INT_FIX(LongSqrt(t1*t1+t2*t2));
					// Too far from p1
						if (t>po->Radius) continue;
                                        // Very close, change Area
						if (t<F_SDIST) {
/*
							if (y>0)
                                                                reg=FindArea(X,Y,pWall->Back->FloorH,0);
							else
                                                                reg=FindArea(X,Y,pWall->Front->FloorH,0);
*/
reg=FindArea(X,Y,FixMax(pWall->Front->FloorH,pWall->Back->FloorH),0);
						// Should not happen
							if (reg==NULL) continue;
                                                // Change the Area?
                                                        if (pArea!=reg) {
								RegDist=t;
                                                                ClearObjArea(po);
                                                                SetObjArea(po,reg);
								if (po->H<reg->FloorH) {
									po->H=reg->FloorH;
								}
								AddRH=po->RH-po->H;
								break;
							}
						}
					// Otherwise, do stairs
                                                if (po->H>pArea->FloorH)
							continue;
						if (y>0) reg=pWall->Front;
						else reg=pWall->Back;
						AddColReg(reg);
                                                if (reg->FloorH<=pArea->FloorH)
							continue;
						y=t;
					}
				// Inside the wall
					else if (y>0) {
						if (y<RegDist) {
							RegDist=y;
						// Change from Front to Back?
                                                        if (pArea!=reg) {
                                                                ClearObjArea(po);
                                                                SetObjArea(po,reg);
								if (po->H<reg->FloorH) {
									po->H=reg->FloorH;
								}
								AddRH=po->RH-po->H;
								break;
							}
						}
                                        // Close to changing Area to Front
					// Close enough?
						if (y>po->Radius) continue;
					// Down-stairs or flying?
						reg=pWall->Front;
						AddColReg(reg);
                                                if (reg->FloorH<=pArea->FloorH||
                                                    po->H>pArea->FloorH) 
							continue;
					}
					else if (y<0) {
						if (-y<RegDist) {
							RegDist=-y;
						// Change from Back to Front?
                                                        if (pArea!=reg) {
                                                                ClearObjArea(po);
                                                                SetObjArea(po,reg);
							// New floor higher?
								if (po->H<reg->FloorH) {
									po->H=reg->FloorH;
								}
								AddRH=po->RH-po->H;
								break;
							}
						}
                                        // Close to changing Area to Back
					// Close enough?
						if (y<-po->Radius) continue;
					// Down-stairs or flying?
						reg=pWall->Back;
						AddColReg(reg);
                                                if (reg->FloorH<=pArea->FloorH||
                                                    po->H>pArea->FloorH) 
							continue;
						y=-y;
					}
					AddRH=FixMax(AddRH,FixDiv(FixMul(reg->FloorH,po->Radius-y)+
                                                        FixMul(pArea->FloorH,y),po->Radius)-po->H);
				// Go on with the wall loop
					continue;
				}
			}

		// Find the distance to move. Object coords in wall space
		// will be updated and then rotated back into world space
		// only if an object is 'inside' the wall.

			if (x<0) {
		// Object is to the left of the wall. We have to compute 
		// distance to p1. Again Sqrt is too inaccurate for this.
				RotateFlag=FALSE;
				t=FIX_INT(FixITan(X-x1,Y-y1));
				tx=FixCos(t);
				ty=FixSin(t);
				if (FixMod(tx)>FixMod(ty))
					t=FixDiv(X-x1,tx);
				else
					t=FixDiv(Y-y1,ty);
				if (t>=dist||t==0) continue;
			// Calculate displacement for movable wall
				if (MoveFlag) {
				// Total mass
					t1=pWall->Mass+po->Mass;
				// Total displacement
					t2=dist-t;
					t1=FixDiv(t2,t1);
				// Wall displacement
					t1=FixMul(t1,po->Mass);
				// Move the wall
                                        MoveWall(pWall,t1,-tx,-ty,x);
				// Object displacement
					t1=dist-t1;
				}
			// Wall is not moved
				else t1=dist;
			// Move object
				X=x1+FixMul(t1,tx);
				Y=y1+FixMul(t1,ty);
			}
			else if (x>pWall->Length) {
		// Object is to the right of the wall. We have to compute
		// distance to p2.
				RotateFlag=FALSE;
				t=FIX_INT(FixITan(X-x2,Y-y2));
				tx=FixCos(t);
				ty=FixSin(t);
				if (FixMod(tx)>FixMod(ty))
					t=FixDiv(X-x2,tx);
				else
					t=FixDiv(Y-y2,ty);
				if (t>=dist||t==0) continue;
			// Calculate displacement for movable wall
				if (MoveFlag) {
				// Total mass
					t1=pWall->Mass+po->Mass;
				// Total displacement
					t2=dist-t;
					t1=FixDiv(t2,t1);
				// Wall displacement
					t1=FixMul(t1,po->Mass);
				// Move the wall
                                        MoveWall(pWall,t1,-tx,-ty,x);
				// Object displacement
					t1=dist-t1;
				}
			// Wall is not moved
				else t1=dist;
			// Move object
				X=x2+FixMul(t1,tx);
				Y=y2+FixMul(t1,ty);
			}
			else {
		// Object is 'inside' the wall. Just update y coord in
		// wall space as the object gets pushed perpendicular
		// to the wall line.
			// Store distance to wall
				t=y;
			// Object is in front of the wall.
                                if (pArea==pWall->Front) {
//					if (y>0&&pWall->Back) continue;
					y=-dist-1024;
				}
			// Object is behind the wall.
				else {
//					if (y<0) continue;
					y=dist+1024;
				}
			// Calculate displacement for movable wall
				if (MoveFlag) {
                                        // Total mass
                                       t1=pWall->Mass+po->Mass;
                                        // Total displacement
					t2=y-t;
					t1=FixDiv(t2,t1);
                                        // Wall displacement
					t1=FixMul(t1,po->Mass);
                                        // Move the wall
                                        if (t1>=0) MoveWall(pWall,t1,s,-c,x);
                                        else MoveWall(pWall,-t1,-s,c,x);
                                        // Object displacement
					y-=t1;
                                        }
			}

                        // Call the effects
			ProcessEffect(po->Eff,po,EFF_WALLHIT,(DWORD)pWall);
			ProcessEffect(pWall->Eff,pWall,EFF_OBJHIT,(DWORD)po);
                        //po->Event|=EFF_WALLHIT;
                        handlecollision_wall(po,pWall,EFF_WALLHIT);
			ColFlag=FALSE;
                        // Is object NOT a slider?
			if ((po->Type&O_NOSLIDE)!=0) {
				X-=AddX;
				Y-=AddY;
				po->H-=AddZ;
                                // Set the loop's terminator
				Steps=0;
                                // Get out of here
				break;
			}
			else {
			// Normal coords update.
				if (RotateFlag) {
				// Rotate x,y into world space
					X=FixMul(c,x)-FixMul(s,y)+x1;
					Y=FixMul(s,x)+FixMul(c,y)+y1;
				}
			}
		}

	}
/*************************************************************************
END OF COL_DET FOR AreaS IN THE ARRAY
**************************************************************************/
	}



//if(!ColFlag)po->Event|=EFF_WALLHIT;

        // If O_INSTANT survived without collisions, mark for delete.
	if (po->Type&O_INSTANT) {
                if (ColFlag) po->Event|=EV_DESTROY;
                }
        // Make RH
        if (po->Type&O_NOSLIDE)po->RH=po->H;
        else po->RH=po->H+AddRH;
        // Move the object! Finally!

	MovePoint(pp,X-pp->x,Y-pp->y);
return; }

void AddColReg(struct Area *reg){
	int i;
        for(i=0;i<NumColRegs;i++)if (ColReg[i]==reg) return;
	if (i<MAX_COLREGS) {
		ColReg[i]=reg;
		NumColRegs++;
                }
return; }
