#include <dpmi.h>

/*******************************
  SOME MACHINE DEPENDENT STUFF 
********************************/

#define FALSE           0
#define TRUE            1

#define DPMI_INT	0x31

#define close		_close
#define read		_read
#define outp		outportb

//==========================
// General type definitions
//==========================
typedef unsigned char   BYTE;
typedef unsigned short  WORD;
typedef unsigned long   DWORD;
typedef long int        LONG;
typedef short int       SHORT;
typedef long int        FIXED;


//==================
// Math definitions
//==================
#define DEG360		2048		// equals to 360 degrees
#define DEG360_2	11		// DEG360 log2
#define DEG180		1024		// 180 degrees
#define DEG90		512		// 90 degrees
#define ITAN_LEN	1024		// -1 to 1 (1024 steps)
#define F_DEG360	(2048<<16)	// 360 deg FIXED
#define F_DEG180	(1024<<16)	// 180 deg FIXED
#define F_DEG90		(512<<16)	// 90  deg FIXED
#define F_HITAN		(512<<16)	// Half of the ITAN_LEN (FIXED)
#define ITAN_MUL	9		// log2(ITAN_LEN>>1)


//===============
// Useful macros
//===============
#define FIX_INT(x)	(SHORT)((x)>>16)
#define INT_FIX(x)	((FIXED)(x)<<16)
#define DOUBLE_FIX(x)   ((FIXED)((double)(x)*65536.0))
#define FIX_DOUBLE(x)   ((double)(x)/65536.0)
#define GET_LOW(px)	(WORD)(*px)
#define GET_HI(px)	(*((SHORT *)(px)+1))
#define SET_HI(px,a)    (*((SHORT *)(px)+1)=a
#define SET_LOW(px,a)	(*((WORD *)(px))=a)
#define FixMin(a,b)	((a)<(b)?(a):(b))
#define FixMax(a,b)	((a)>(b)?(a):(b))
#define FixMod(a)	((a)>=0?(a):(-(a)))
#define mod(a)		((a)>0?(a):(-(a)))
#define min(a,b)	((a)<(b)?(a):(b))
#define max(a,b)	((a)>(b)?(a):(b))


void  FatalError(int,char *);          // Fatal error

void *MemAlloc(long int,char *);               // Allocate some memory
void *MemZAlloc(long int,char *);              // Allocate memory zeroing it
void  MemFree(void *,char *);                  // Free memory

inline long static FixMul(FIXED a, FIXED b){
	FIXED result;
	asm ( "imull %%ebx\n\t"
	"shrdl $16,%%edx,%%eax\n\t"
	: "=a" (result)
	: "a" (a), "b" (b)
	: "edx");
return (result); }

inline long static FixDiv(FIXED d, FIXED b){
	FIXED result;
	asm ( "xorl %%eax, %%eax\n\t"
	"shrdl $16,%%edx,%%eax\n\t"
	"sarl $16, %%edx\n\t"
	"idivl %%ebx"
	: "=a" (result)
	: "d" (d), "b" (b)
	: "edx");
return (result); }
