/* 
   'Splay' trees.  Should check to see if the original was smaller-2b sure.
*/        
//#include <stdio.h>
//#include <stdlib.h>
//#include <string.h>
//#include <ctype.h>

//typedef unsigned int unsigned int;
//typedef unsigned char unsigned char;
//typedef unsigned char bool;

unsigned char *pack_mem1,*pack_mem2;
long pack_mem1_len,pack_mem1_ptr,pack_mem2_len,pack_outofmem;

#define pack_bufsize     16384       // size of input and output buffers
#define pack_maxchar     256         // ordinal of highest character
#define pack_eofchar     256         // used to mark end of compressed file
#define pack_predmax     255         // pack_maxchar - 1
#define pack_twicemax    512         // 2 * pack_maxchar
#define pack_root        0           // index of root node

unsigned char pack_bitmask[8]={1, 2, 4, 8, 16, 32, 64, 128};// Used to unpack bits and bytes

typedef unsigned char pack_bufferarray[pack_bufsize + 1];
typedef unsigned int pack_codetype;                          // 0..pack_maxchar
typedef unsigned char pack_upindex;                           // 0..pack_predmax
typedef unsigned int pack_downindex;                         // 0..pack_twicemax
typedef pack_downindex pack_treedownarray[pack_predmax + 1];  // pack_upindex
typedef pack_upindex pack_treeuparray[pack_twicemax + 1];     // pack_downindex

pack_bufferarray pack_inbuffer;           // input file buffer
pack_bufferarray pack_outbuffer;          // output file buffer
pack_treedownarray pack_left, pack_right; // child branches of code tree
pack_treeuparray pack_up;                 // Parent branches of code tree
unsigned char pack_bitpos;                        // current bit in unsigned char
pack_codetype pack_inbyte;               // current input unsigned char
pack_codetype pack_outbyte;              // current output unsigned char
unsigned int pack_insize;                        // current chars in input buffer
unsigned int pack_outsize;                       // Current chars in output buffer
unsigned int pack_index;                         // general purpose index

int pack_getmem(pack_bufferarray des, int bufsize){
  int p;
  if(des==NULL)return 0;
  if(pack_mem1==NULL)return 0;
  for(p=0;p<bufsize;p++){
        if(p+pack_mem1_ptr>=pack_mem1_len)break;
        des[p]=pack_mem1[p+pack_mem1_ptr];
        }
 pack_mem1_ptr+=p;
return p; }

void pack_store_2mem(int sz,unsigned char *ptr){
 unsigned long s=pack_mem2_len;
 if(pack_mem2==NULL){pack_mem2=(unsigned char *)malloc(sz+1);pack_mem2_len=sz; }
 else if(pack_mem2!=NULL){ pack_mem2_len+=sz;
                      pack_mem2=(unsigned char *)realloc(pack_mem2,pack_mem2_len+1);
                        }
 if(pack_mem2==NULL){ pack_outofmem=1; return; }
 memcpy(pack_mem2+s, ptr, sz);
return; }

// function prototypes
void pack_initializesplay(void);
void pack_splay(pack_codetype Plain);
void pack_flushoutbuffer(void);
void pack_writebyte(void);
void pack_compress(pack_codetype Plain);
unsigned char pack_getbyte(void);
pack_codetype pack_expand(void);
void pack_expandfile(void);

// initialize the splay tree - as a balanced tree
void pack_initializesplay(void){
    pack_downindex I;
    int /*pack_upindex*/ J;
    pack_downindex K;
    for (I = 1; I <= pack_twicemax; I++) pack_up[I] = (I - 1) >> 1;
    for (J = 0; J <= pack_predmax; J++){
        K = ((unsigned char)J + 1) << 1; pack_left[J] = K - 1; pack_right[J] = K;
        }
return; }

// rearrange the splay tree for each succeeding character
void pack_splay(pack_codetype Plain){
    pack_downindex A, B;
    pack_upindex C, D;
    A = Plain + pack_maxchar;
    do{  // walk up the tree semi-rotating pairs
        C = pack_up[A];
        if (C != pack_root){            
            D = pack_up[C]; // a pair remains
            B = pack_left[D]; // exchange children of pair
            if (C == B){
                B = pack_right[D]; pack_right[D] = A;
                }
            else pack_left[D] = A;
            if (A == pack_left[C]) pack_left[C] = B;
            else pack_right[C] = B;
            pack_up[A] = D; pack_up[B] = C; A = D;
        }
        else A = C;
    } while (A != pack_root);
return; }

// flush output buffer and reset
void pack_flushoutbuffer(void){
    if (pack_outsize > 0){
        //fwrite(pack_outbuffer+1, sizeof(unsigned char), pack_outsize, OutF);
        pack_store_2mem(pack_outsize,pack_outbuffer+1);
        pack_outsize = 0;
        }
return; }

// output unsigned char in pack_outbyte
void pack_writebyte(void){
    if (pack_outsize == pack_bufsize) pack_flushoutbuffer();
    pack_outsize++;
    pack_outbuffer[pack_outsize] = pack_outbyte;
return; }

// compress a single char
void pack_compress(pack_codetype Plain){
    pack_downindex A;
    pack_upindex U;
    unsigned int Sp;
    //bool Stack[pack_predmax+1];
    unsigned char Stack[pack_predmax+1];
    
    A = Plain + pack_maxchar; Sp = 0;
    
    do{ // walk up the tree pushing bits onto stack
        U = pack_up[A]; Stack[Sp] = (pack_right[U] == A); Sp++; A = U;
      } while (A != pack_root);

    do{// unstack to transmit bits in correct order
        Sp--;
        if (Stack[Sp]) pack_outbyte |= pack_bitmask[pack_bitpos];
        if (pack_bitpos == 7){
            pack_writebyte();  // unsigned char filled with bits, write it out
            pack_bitpos = 0; pack_outbyte = 0;
            }
        else pack_bitpos++;
    } while (Sp != 0);
    pack_splay(Plain);    // update the tree
return; }

// compress input file, writing to outfile
void CompressFile(void){

   if(pack_mem2==NULL){pack_mem2=(unsigned char *)malloc(5);
                       pack_mem2_len=4;
                       if(pack_mem2){
                                pack_mem2[0]='X'; pack_mem2[1]='p';
                                pack_mem2[2]='a'; pack_mem2[3]='k';
                                }
      }
    // compress file
    pack_outsize = 0; pack_bitpos = 0; pack_outbyte = 0;
    do{
       // pack_insize = fread(pack_inbuffer+1, sizeof(unsigned char), pack_bufsize, InF);
       pack_insize = pack_getmem(pack_inbuffer+1, pack_bufsize);

        for (pack_index = 1; pack_index <= pack_insize; pack_index++)pack_compress(pack_inbuffer[pack_index]);
    } while (pack_insize >= pack_bufsize);
    pack_compress(pack_eofchar); // Mark end of file
    
    // Flush buffers
    if (pack_bitpos != 0)pack_writebyte();
    pack_flushoutbuffer();
return; }

// return next unsigned char from compressed input
unsigned char pack_getbyte(void){
    pack_index++;
    if (pack_index > pack_insize){  // reload file buffer
        //pack_insize = fread(pack_inbuffer+1, sizeof(unsigned char), pack_bufsize, InF);
       pack_insize = pack_getmem(pack_inbuffer+1, pack_bufsize);

        pack_index = 1; // end of file handled by special marker in compressed file
    } // get next unsigned char from buffer
return pack_inbuffer[pack_index]; }

// return next char from compressed input
pack_codetype pack_expand(void){
    pack_downindex A;
    // scan the tree to a leaf, which determines the character
    A = pack_root;
    do{
        if (pack_bitpos == 7){
            pack_inbyte = pack_getbyte();  // used up bits in current unsigned char, get another
            pack_bitpos = 0;  }
        else pack_bitpos++;
        if ((pack_inbyte & pack_bitmask[pack_bitpos]) == 0) A = pack_left[A];
        else A = pack_right[A];
    } while (A <= pack_predmax);
    A -= pack_maxchar; pack_splay(A);  // Update the code tree
return A; }

// uncompress the file and write output
void pack_expandfile(void){
    pack_index = 0; pack_insize = 0;  // force buffer load first time
    pack_outsize = 0;            // nothing in output buffer
    pack_bitpos = 7;             // force bit buffer load first time
    // read and expand the compressed input
    pack_outbyte = pack_expand();
    while (pack_outbyte != pack_eofchar){ pack_writebyte(); pack_outbyte = pack_expand(); }
    pack_flushoutbuffer();       // flush the output buffer
return; }

int pack_check_id(){
 if(pack_mem1==NULL)return 0;
 if(pack_mem1_len<4)return 0;
 if(pack_mem1[0]!='X')return 0; if(pack_mem1[1]!='p')return 0;
 if(pack_mem1[2]!='a')return 0; if(pack_mem1[3]!='k')return 0;
 pack_mem1_ptr=4;
return 1; }

/*int main(int argc, char *argv[]){
 long m;
 FILE *hnd;

 pack_mem1=NULL; pack_mem2=NULL;
 pack_mem1_len=0; pack_mem2_len=0; pack_outofmem=0;
 pack_mem1_ptr=0;

 hnd=fopen("test.bmp","rb");
 if(hnd==NULL){printf("File not found\n"); return -1; }

 fseek(hnd,0,SEEK_END);
 pack_mem1_len=ftell(hnd);
 fseek(hnd,0,SEEK_SET);

 pack_mem1=(unsigned char *)malloc(pack_mem1_len+1);
 if(pack_mem1==NULL){ fclose(hnd);printf("Out of Memory\n"); return -1; }

 for(m=0;m<pack_mem1_len;m++) pack_mem1[m]=fgetc(hnd);
 fclose(hnd);

 pack_initializesplay();

 CompressFile();

 hnd=fopen("test.ooh","wb");
 if(hnd){
     fputc('X',hnd); fputc('p',hnd);
     fputc('a',hnd); fputc('k',hnd);
     for(m=0;m<pack_mem2_len;m++) fputc(pack_mem2[m],hnd);
     fclose(hnd);
        }


 if(pack_outofmem==1)printf("Out of mem\n");

 if(pack_mem1)free(pack_mem1);
 if(pack_mem2)free(pack_mem2);

//decompress

 pack_mem1=NULL; pack_mem2=NULL;
 pack_mem1_len=0; pack_mem2_len=0; pack_outofmem=0;
 pack_mem1_ptr=0;

 hnd=fopen("test.ooh","rb");
 if(hnd==NULL){printf("File not found\n"); return -1; }

 fseek(hnd,0,SEEK_END);
 pack_mem1_len=ftell(hnd);
 fseek(hnd,0,SEEK_SET);

 pack_mem1=(unsigned char *)malloc(pack_mem1_len+1);
 if(pack_mem1==NULL){ fclose(hnd);printf("Out of Memory\n"); return -1; }
 for(m=0;m<pack_mem1_len;m++) pack_mem1[m]=fgetc(hnd);
 fclose(hnd);

 if(pack_check_id()==0){ printf("Not Xpac file\n"); return -1; }
 

 pack_initializesplay();

 pack_expandfile();
 hnd=fopen("test.don","wb");
 if(hnd){
     for(m=0;m<pack_mem2_len;m++) fputc(pack_mem2[m],hnd);
     fclose(hnd);
        }


 if(pack_outofmem==1)printf("Out of mem\n");

 if(pack_mem1)free(pack_mem1);
 if(pack_mem2)free(pack_mem2);

return 0; }
*/
