// Basic Serial Coms
// PC uses COM2
// LapTop uses COM1

//#include <stdio.h>
//#include <dos.h>
//#include <ctype.h>
//#include <process.h>
//#include <stdio.h>
//#include <conio.h>

     /* Certain ASCII codes */
#define ASCII_SOH        0x01                 /* Start of header      */
#define ASCII_STX        0x02                 /* Start of text / data */
#define ASCII_EOT        0x03                 /* End of transmission  */
#define ASCII_ENQ        0x05                              /* Inquiry */
#define ASCII_ACK        0x06                 /* Positive acknowledge */
#define ASCII_NAK        0x15                 /* Negative acknowledge */
#define ASCII_SYN        0x16                 /* Synchronous idle     */


#define sLOBYTE( w ) ( ( unsigned char ) ( ( w ) & 0xFF ) )
#define sHIBYTE( w ) ( ( unsigned char ) ( ( ( w ) >> 8 ) & 0xFF ) )

#define SER_COM1 0x3F8                           /* Base address COM1 */
#define SER_COM2 0x2F8                           /* Base address COM2 */
#define SER_IRQ_COM1 4                         /* IRQ 4 = vector 0x0C */
#define SER_IRQ_COM2 3                         /* IRQ 3 = vector 0x0B */

#define SER_MAXBAUD 115200L                      /* Maximum baud rate */

#define NOSER    0
#define INS8250  1                   /* National Semiconductor UART's */
#define NS16450  2
#define NS16550A 3
#define NS16C552 4

#define SER_IRQ_ENABLE     0x01          /* Interrupt enable register */
#define SER_IRQ_ID         0x02              /* Interrupt ID register */

#define SER_SCRATCH        0x07                   /* Scratch register */
#define SER_LINE_CONTROL   0x03                  /* Line control */
#define SER_LCR_SETDIVISOR 0x80  /* For access to baud rate divisor */
#define SER_DIVISOR_LSB    0x00              /* Baud rate divisor LSB */
#define SER_DIVISOR_MSB    0x01              /* Baud rate divisor MSB */
#define SER_LINE_CONTROL   0x03                  /* Line control */
#define SER_TXBUFFER       0x00                  /* Transmit register */
#define SER_RXBUFFER       0x00                   /* Receive register */
#define SER_2FUNCTION      0x02        /* Alternate function register */
#define SER_FIFO_TRIGGER14  0xC0                          /* 14 bytes */

#define SER_LCR_NOPARITY   0x00         /* Disable parity check */
#define SER_LCR_1STOPBIT   0x00                          /* 1 stop bit */
#define SER_LCR_8BITS      0x03

#define SER_FIFO           0x02                      /* FIFO register */
#define SER_FIFO_ENABLE        0x01
#define SER_FIFO_RESETRECEIVE  0x02
#define SER_FIFO_RESETTRANSMIT 0x04

#define SER_MCR_DTR        0x01                  /* Set DTR signal */
#define SER_MCR_RTS        0x02                  /* Set RTS signal */
#define SER_MCR_UNUSED     0x04
#define SER_MCR_IRQENABLED 0x08     /* Inform IRQ controller of IRQs */
#define SER_MCR_LOOP       0x10                         /* Self-test */

#define SER_MODEM_CONTROL  0x04                     /* Modem control */
#define SER_MODEM_STATUS   0x06                        /* Modem status */
#define SER_LINE_STATUS    0x05                     /* Line status */

#define SER_LSR_TSREMPTY     0x40

#define SER_ERRTIMEOUT 0x0400
#define SER_ERRSIGNALS 0x0300
#define SER_LSR_DATARECEIVED 0x01 /* Data word (5 - 8 bits) received */
#define SER_LSR_OVERRUNERROR 0x02    /* Previous data word lost */
#define SER_LSR_PARITYERROR  0x04                   /* Parity error */
#define SER_LSR_FRAMINGERROR 0x08            /* Start/stop bit error */
#define SER_LSR_BREAKDETECT  0x10                   /* Break detected */

#define SER_LSR_ERRORMSK (SER_LSR_OVERRUNERROR|SER_LSR_PARITYERROR|\
                          SER_LSR_FRAMINGERROR|SER_LSR_BREAKDETECT)


int iSerPort;
int iSerIRQ;

int iUART;
long lBaud;

#define inp inportb
#define outp outportb

int ser_UARTType( int iSerPort ){
  //- Check base capabilities ------------------------------------
  outp( iSerPort + SER_LINE_CONTROL, 0xAA ); /* Divisor latch set */
  if( inp( iSerPort + SER_LINE_CONTROL ) != 0xAA ) return NOSER;

  outp( iSerPort + SER_DIVISOR_MSB, 0x55 );    /* Specify divisor */
  if( inp( iSerPort + SER_DIVISOR_MSB ) != 0x55 ) return NOSER;

  outp( iSerPort + SER_LINE_CONTROL, 0x55 ); /* Clear divisor latch */
  if( inp( iSerPort + SER_LINE_CONTROL ) != 0x55 ) return NOSER;

  outp( iSerPort + SER_IRQ_ENABLE, 0x55 );
  if( inp( iSerPort + SER_IRQ_ENABLE ) != 0x05 ) return NOSER;

  outp( iSerPort + SER_FIFO, 0 );             /* Clear FIFO and IRQ */
  outp( iSerPort + SER_IRQ_ENABLE, 0 );
  if( inp( iSerPort + SER_IRQ_ID ) != 1 ) return NOSER;

  outp( iSerPort + SER_MODEM_CONTROL, 0xF5 );
  if( inp( iSerPort + SER_MODEM_CONTROL ) != 0x15 ) return NOSER;

  outp( iSerPort + SER_MODEM_CONTROL, SER_MCR_LOOP );      /* Looping */
  inp( iSerPort + SER_MODEM_STATUS );
  if( ( inp( iSerPort + SER_MODEM_STATUS ) & 0xF0 ) != 0 ) return NOSER;

  outp( iSerPort + SER_MODEM_CONTROL, 0x1F );
  if( ( inp( iSerPort + SER_MODEM_STATUS ) & 0xF0 ) != 0xF0 ) return NOSER;

  outp( iSerPort + SER_MODEM_CONTROL, SER_MCR_DTR | SER_MCR_RTS );

  outp( iSerPort + SER_SCRATCH, 0x55 ); /* Scratch register detected? */
  if( inp( iSerPort + SER_SCRATCH ) != 0x55 ) return INS8250;
  outp( iSerPort + SER_SCRATCH, 0 );

  outp( iSerPort + SER_FIFO, 0xCF );              /* FIFO detected ? */
  if( ( inp( iSerPort + SER_IRQ_ID ) & 0xC0 ) != 0xC0 ) return NS16450;
  outp( iSerPort + SER_FIFO, 0 );
                            /* Alternate function register detected? */
  outp( iSerPort + SER_LINE_CONTROL, SER_LCR_SETDIVISOR );
  outp( iSerPort + SER_2FUNCTION, 0x07 );
  if( inp( iSerPort + SER_2FUNCTION ) != 0x07 ){
    outp( iSerPort + SER_LINE_CONTROL, 0 );
    return NS16550A;
    }
  outp( iSerPort + SER_LINE_CONTROL, 0 );               // Reset
  outp( iSerPort + SER_2FUNCTION, 0 );
return NS16C552; }

int ser_init( int  iSerPort, long lBaudRate, unsigned char bParams ){
 unsigned short uDivisor;
          if( ser_UARTType( iSerPort ) != NOSER ){
            uDivisor = ( unsigned short )( SER_MAXBAUD / lBaudRate );
            outp( iSerPort + SER_LINE_CONTROL,inp( SER_LINE_CONTROL ) | SER_LCR_SETDIVISOR );
            outp( iSerPort + SER_DIVISOR_LSB, sLOBYTE( uDivisor ) );
            outp( iSerPort + SER_DIVISOR_MSB, sHIBYTE( uDivisor ) );
            outp( iSerPort + SER_LINE_CONTROL,
                        inp( SER_LINE_CONTROL ) & ~SER_LCR_SETDIVISOR );
            outp( iSerPort + SER_LINE_CONTROL, bParams );
            inp( iSerPort + SER_TXBUFFER );
            return 1;
            }
return -1; }

void ser_FIFOLevel( int iSerPort, unsigned char bLevel ){
         if( bLevel ) outp( iSerPort + SER_FIFO, bLevel | SER_FIFO_ENABLE );
         else outp( iSerPort + SER_FIFO, SER_FIFO_RESETRECEIVE | SER_FIFO_RESETTRANSMIT );
return; }

int ser_IsDataAvailable( int iSerPort ){
         return inp( iSerPort + SER_LINE_STATUS ) & SER_LSR_DATARECEIVED;
}

int ser_IsWritingPossible( int iSerPort ){
         return ( inp( iSerPort + SER_LINE_STATUS ) & SER_LSR_TSREMPTY );
}

int ser_WriteByte( int iSerPort, unsigned char bData, int uTimeOut,
                           unsigned char bSigMask, unsigned char bSigVals ){
        // if( uTimeOut ){// Timeout loop
        //    while( !ser_IsWritingPossible( iSerPort ) && uTimeOut ) uTimeOut--;
        //    if( !uTimeOut ) return SER_ERRTIMEOUT;
        //    }
        // else while( !ser_IsWritingPossible( iSerPort ) );        // Wait!

         // Test signal lines
         if(((unsigned char) inp( iSerPort + SER_MODEM_STATUS ) &bSigMask)==bSigVals){
            outp( iSerPort + SER_TXBUFFER, bData );
            return inp( iSerPort + SER_LINE_STATUS ) & SER_LSR_ERRORMSK;
            }
         else return SER_ERRSIGNALS;
}

int ser_ReadByte( int iSerPort, unsigned char *pData, int uTimeOut,
                          unsigned char bSigMask, unsigned char bSigVals ){
        // if( uTimeOut ){ // Timeout loop
        //    while( !ser_IsDataAvailable( iSerPort ) && uTimeOut ) uTimeOut--;
        //    if( !uTimeOut ) return SER_ERRTIMEOUT;
        //    }
        //  else while( !ser_IsDataAvailable( iSerPort ) );             // Wait!

        // Test signal lines
        if(((unsigned char) inp( iSerPort + SER_MODEM_STATUS ) &bSigMask)==bSigVals){
            *pData = ( unsigned char )inp( iSerPort + SER_RXBUFFER );
            return inp( iSerPort + SER_LINE_STATUS ) & SER_LSR_ERRORMSK;
            }
         else return SER_ERRSIGNALS;
}


/*

  SerialOpen COM,BAUD
//check com and baud numbers
    iUART = ser_init( iSerPort, lBaud,
                 SER_LCR_8BITS | SER_LCR_1STOPBIT | SER_LCR_NOPARITY );
    if( iUART == NOSER ){  printf("No port!\n"); exit( 0 );  }
    if( iUART > INS8250 ) ser_FIFOLevel( iSerPort, SER_FIFO_TRIGGER14 );

  SerialClose
//     if( iUART > INS8250 ) ser_FIFOLevel( iSerPort, 0 );
  SerialSend 'x'
//   c=ser_WriteByte( iSerPort, 'X', 0,0,0);
//   if(c!=0)error
  A=SerialRecieve
//   c=ser_ReadByte( iSerPort, &b, 0x0,0,0);
//   if(c!=0)error
//   else return b


void main(){
  unsigned char b;
  int c;
   // Only COM1 and COM2 are "standardized"
      //iSerPort = SER_COM1;    iSerIRQ  = SER_IRQ_COM1;
       iSerPort = SER_COM2; iSerIRQ  = SER_IRQ_COM2;

      lBaud = 9600;              // Maximum baud rate for UART 8450A

      iUART = ser_init( iSerPort, lBaud,
                  SER_LCR_8BITS | SER_LCR_1STOPBIT | SER_LCR_NOPARITY );
      if( iUART == NOSER ){  printf("No port!\n"); exit( 0 );  }
      if( iUART > INS8250 ) ser_FIFOLevel( iSerPort, SER_FIFO_TRIGGER14 );

      printf( "COM port: 0x%04X, IRQ: 0x%02X, Baud: %ld\n",iSerPort, iSerIRQ, lBaud );




//   if(ser_WriteByte( iSerPort, 'X', 0x8000,0,0)==0)printf("Send OK\n");

   c=ser_WriteByte( iSerPort, 'X', 0,0,0);
   if(c==0)printf("Send OK\n");
   else printf("Send Error (0x%x)",c);

   c=ser_ReadByte( iSerPort, &b, 0x8000,0,0);
   if(c==0)printf("Read OK %c\n",b);
   else printf("Read Error (0x%x) %c (%d)",c,b,b);

//           c=ser_ReadByte( iSerPort, &b, 0x0,0,0);
//           if(c==0)printf("Read OK %c (%d)\n",b,b);
//           else printf("Read Error (0x%x) %c (%d)",c,b,b);
//          getch();


     if( iUART > INS8250 ) ser_FIFOLevel( iSerPort, 0 );
return;}
*/
