/*#include <stdlib.h>
#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include <math.h>

#include "d:\ssprogs\artie\defines.h"
#include "d:\ssprogs\artie\xlib.h"*/

#define CENT_X 160
#define CENT_Y 100
#define LENS 256

//update to use tables instead of sin/cos


typedef struct _3dobject{
                int p_num;
                int t_num;

                int *draw_order_num;
                int *draw_order_dist;

                int *points_x;
                int *points_y;
                int *points_z;

                int *rotated_x;
                int *rotated_y;
                int *rotated_z;

                int *triangles_p1;
                int *triangles_p2;
                int *triangles_p3;
                unsigned char *tex_n;
                unsigned char *tex_x1;
                unsigned char *tex_x2;
                unsigned char *tex_x3;
                unsigned char *tex_x4;
                unsigned char *tex_x5;
                unsigned char *tex_x6;
                unsigned char *tex_mask;
                char name[8];
                struct _3dobject *prev;

                //unsigned char *drawbuffer;
                int xmax,ymax,size;
                }_3dobject;

_3dobject *top_object=NULL;

void our_free(void *p){
 malfreecntr--;
 free(p);
return; }


void free_3dobject(_3dobject *t_object){
        //if(t_object->drawbuffer)our_free(t_object->drawbuffer);
        if(t_object->draw_order_num)our_free(t_object->draw_order_num);
        if(t_object->draw_order_dist)our_free(t_object->draw_order_dist);

        if(t_object->points_x)our_free(t_object->points_x);
        if(t_object->points_y)our_free(t_object->points_y);
        if(t_object->points_z)our_free(t_object->points_z);
        if(t_object->rotated_x)our_free(t_object->rotated_x);
        if(t_object->rotated_y)our_free(t_object->rotated_y);
        if(t_object->rotated_z)our_free(t_object->rotated_z);
        if(t_object->triangles_p1)our_free(t_object->triangles_p1);
        if(t_object->triangles_p2)our_free(t_object->triangles_p2);
        if(t_object->triangles_p3)our_free(t_object->triangles_p3);
        if(t_object->tex_n)our_free(t_object->tex_n);
        if(t_object->tex_x1)our_free(t_object->tex_x1);
        if(t_object->tex_x2)our_free(t_object->tex_x2);
        if(t_object->tex_x3)our_free(t_object->tex_x3);
        if(t_object->tex_x4)our_free(t_object->tex_x4);
        if(t_object->tex_x5)our_free(t_object->tex_x5);
        if(t_object->tex_x6)our_free(t_object->tex_x6);
        if(t_object->tex_mask)our_free(t_object->tex_mask);
return; }

void free_3dobjects(){
_3dobject *t;
 while(top_object){
        t=top_object->prev;
        free_3dobject(top_object);
        our_free(top_object);
        top_object=t;
                }
return; }

int our_lptr;
void our_skipspaces(char *lin){
  for(;;){
       if(lin[our_lptr]!=32 && lin[our_lptr]!=9)break;
       our_lptr++;
        }
return; }

int our_getnum(char *lin){
 int num=0,n;
 char ismin=0;
 our_skipspaces(lin);
 if(lin[our_lptr]=='-'){ismin=1; our_lptr++; } 
 for(;;){
  n=lin[our_lptr];
  if(n<'0' || n>'9')break;
  num=num*10;
  num=num+n-'0';
  our_lptr++;
  }
 our_skipspaces(lin);
 if(ismin==1) num=-num;
return num; }

int make_p_mem(int num,_3dobject *t_object){
  if(t_object->points_x)our_free(t_object->points_x);
  if(t_object->points_y)our_free(t_object->points_y);
  if(t_object->points_z)our_free(t_object->points_z);
  if(t_object->rotated_x)our_free(t_object->rotated_x);
  if(t_object->rotated_y)our_free(t_object->rotated_y);
  if(t_object->rotated_z)our_free(t_object->rotated_z);
  t_object->points_x=NULL;  t_object->points_y=NULL;  t_object->points_z=NULL;
  t_object->rotated_x=NULL;  t_object->rotated_y=NULL;  t_object->rotated_z=NULL;

  t_object->points_x=(int *)malloc((num*sizeof(int))+4);
  if(t_object->points_x==NULL)return -2; malfreecntr++;
  t_object->points_y=(int *)malloc((num*sizeof(int))+4);
  if(t_object->points_y==NULL)return -2; malfreecntr++;
  t_object->points_z=(int *)malloc((num*sizeof(int))+4);
  if(t_object->points_z==NULL)return -2; malfreecntr++;
 
  t_object->rotated_x=(int *)malloc((num*sizeof(int))+4);
  if(t_object->rotated_x==NULL)return -2; malfreecntr++;
  t_object->rotated_y=(int *)malloc((num*sizeof(int))+4);
  if(t_object->rotated_y==NULL)return -2; malfreecntr++;
  t_object->rotated_z=(int *)malloc((num*sizeof(int))+4);
  if(t_object->rotated_z==NULL)return -2; malfreecntr++;
return 0; }

int make_t_mem(int num,_3dobject *t_object){

   if(t_object->draw_order_num)our_free(t_object->draw_order_num);
   if(t_object->draw_order_dist)our_free(t_object->draw_order_dist);

   if(t_object->triangles_p1)our_free(t_object->triangles_p1);
   if(t_object->triangles_p2)our_free(t_object->triangles_p2);
   if(t_object->triangles_p3)our_free(t_object->triangles_p3);
   if(t_object->tex_n)our_free(t_object->tex_n);
   if(t_object->tex_x1)our_free(t_object->tex_x1);
   if(t_object->tex_x2)our_free(t_object->tex_x2);
   if(t_object->tex_x3)our_free(t_object->tex_x3);
   if(t_object->tex_x4)our_free(t_object->tex_x4);
   if(t_object->tex_x5)our_free(t_object->tex_x5);
   if(t_object->tex_x6)our_free(t_object->tex_x6);
   if(t_object->tex_mask)our_free(t_object->tex_mask);

   t_object->draw_order_num=NULL; t_object->draw_order_dist=NULL;
   t_object->triangles_p1=NULL;t_object->triangles_p2=NULL;
   t_object->triangles_p3=NULL;
   t_object->tex_n=NULL; t_object->tex_x1=NULL; t_object->tex_x2=NULL;
   t_object->tex_x3=NULL; t_object->tex_x4=NULL; t_object->tex_x5=NULL;
   t_object->tex_x6=NULL; t_object->tex_mask=NULL;

   t_object->draw_order_num=(int *)malloc((num*sizeof(int))+4);
   if(t_object->draw_order_num==NULL)return -2; malfreecntr++;
   t_object->draw_order_dist=(int *)malloc((num*sizeof(int))+4);
   if(t_object->draw_order_dist==NULL)return -2; malfreecntr++;

   t_object->triangles_p1=(int *)malloc((num*sizeof(int))+4);
   if(t_object->triangles_p1==NULL)return -2; malfreecntr++;
   t_object->triangles_p2=(int *)malloc((num*sizeof(int))+4);
   if(t_object->triangles_p2==NULL)return -2; malfreecntr++;
   t_object->triangles_p3=(int *)malloc((num*sizeof(int))+4);
   if(t_object->triangles_p3==NULL)return -2; malfreecntr++;

   t_object->tex_n=(unsigned char *)malloc((num*sizeof(unsigned char))+4);
   if(t_object->tex_n==NULL)return -2; malfreecntr++;
   t_object->tex_x1=(unsigned char *)malloc((num*sizeof(unsigned char))+4);
   if(t_object->tex_x1==NULL)return -2; malfreecntr++;
   t_object->tex_x2=(unsigned char *)malloc((num*sizeof(unsigned char))+4);
   if(t_object->tex_x2==NULL)return -2; malfreecntr++;
   t_object->tex_x3=(unsigned char *)malloc((num*sizeof(unsigned char))+4);
   if(t_object->tex_x3==NULL)return -2; malfreecntr++;
   t_object->tex_x4=(unsigned char *)malloc((num*sizeof(unsigned char))+4);
   if(t_object->tex_x4==NULL)return -2; malfreecntr++;
   t_object->tex_x5=(unsigned char *)malloc((num*sizeof(unsigned char))+4);
   if(t_object->tex_x5==NULL)return -2; malfreecntr++;
   t_object->tex_x6=(unsigned char *)malloc((num*sizeof(unsigned char))+4);
   if(t_object->tex_x6==NULL)return -2; malfreecntr++;
   t_object->tex_mask=(unsigned char *)malloc((num*sizeof(unsigned char))+4);
   if(t_object->tex_mask==NULL)return -2; malfreecntr++;
return 0; }


int load_3dobject(char *filename,char *idname){
 int p_num=0,t_num=0;
 FILE *hnd;
 char lin[100],com[50];
 char k=1,y,inwot=0;
 int p2;
 int n1,n2,n3,n4,n5,n6,n,n7;
 int p_cntr=0,t_cntr=0,x_cntr=0;
 _3dobject *the_o;

 hnd=fopen(filename,"r");
 if(hnd==NULL)return -1;

 the_o=(_3dobject *)malloc(sizeof(_3dobject));
 if(the_o==NULL){ fclose(hnd); return -2; } malfreecntr++;
 the_o->prev=top_object;
 top_object=the_o;
 the_o->p_num=0;  the_o->t_num=0;
 the_o->xmax=0; the_o->ymax=0; the_o->size=0;
 //the_o->drawbuffer=NULL;
 the_o->draw_order_num=NULL; the_o->draw_order_dist=NULL;
 the_o->points_x=NULL; the_o->points_y=NULL; the_o->points_z=NULL;
 the_o->rotated_x=NULL; the_o->rotated_y=NULL; the_o->rotated_z=NULL;
 the_o->triangles_p1=NULL; the_o->triangles_p2=NULL;the_o->triangles_p3=NULL;
 the_o->tex_x1=NULL; the_o->tex_x2=NULL; the_o->tex_x3=NULL;
 the_o->tex_x4=NULL; the_o->tex_x5=NULL; the_o->tex_x6=NULL;
 the_o->tex_n=NULL; the_o->tex_mask=NULL;
 strcpy(the_o->name,idname);

 for(;;){
  skipline:
  our_lptr=0;
  if(k<1)break;
  for(;;){ k=fgetc(hnd); if(k=='\n' || k<1)break;
           lin[our_lptr++]=k;
              }
  lin[our_lptr]=0; our_lptr=0;
 
  our_skipspaces(lin);
  y=lin[our_lptr];
  if(y==0 || y=='\'' || y==10 || y==13)goto skipline;

  p2=0;for(;;){
        y=toupper(lin[our_lptr]);
        if(y==0 ||y==10 || y==32 || y==13 || y=='\"' || y=='=')break;
        com[p2++]=y;
        our_lptr++;
        } com[p2]=0;
  our_skipspaces(lin);
  y=lin[our_lptr];

  if(!stricmp(com,"MaxX")){
            if(y=='='){our_lptr++;
                       the_o->xmax=our_getnum(lin);
                        }
          }
  else if(!stricmp(com,"MaxY")){
            if(y=='='){our_lptr++;
                       the_o->ymax=our_getnum(lin);
                        }
          }
  else if(!stricmp(com,"Zoom")){
            if(y=='='){our_lptr++;
                       the_o->size=our_getnum(lin);
                        }
          }
  else if(!stricmp(com,"PointNumber")){
            if(y=='='){our_lptr++;
                       p_num=our_getnum(lin);
                       make_p_mem(p_num,the_o);
                       the_o->p_num=p_num;
                        }
          }
  else if(!stricmp(com,"TriangleNumber")){
            if(y=='='){our_lptr++;
                       t_num=our_getnum(lin);
                       make_t_mem(t_num,the_o);
                       the_o->t_num=t_num;
                        }
        }
  else if(!stricmp(com,"Points:"))inwot=1;
  else if(!stricmp(com,"Triangles:"))inwot=2;
  else if(!stricmp(com,"Textures:"))inwot=3;
  else if(inwot==1 && p_cntr<p_num){
       our_lptr=0; n1=our_getnum(lin);
       our_skipspaces(lin); our_lptr++;
       n2=our_getnum(lin);
       our_skipspaces(lin); our_lptr++;
       n3=our_getnum(lin);
          the_o->points_x[p_cntr]=n1;
          the_o->points_y[p_cntr]=n2;
          the_o->points_z[p_cntr]=n3;
          the_o->rotated_x[p_cntr]=0;
          the_o->rotated_y[p_cntr]=0;
          the_o->rotated_z[p_cntr]=0;
       p_cntr++;
//printf("(%d %d %d)",n1,n2,n3);
        }
  else if(inwot==2 && t_cntr<t_num){
       our_lptr=0; n1=our_getnum(lin);
       our_skipspaces(lin); our_lptr++;
       n2=our_getnum(lin);
       our_skipspaces(lin); our_lptr++;
       n3=our_getnum(lin);
                the_o->triangles_p1[t_cntr]=n1;
                the_o->triangles_p2[t_cntr]=n2;
                the_o->triangles_p3[t_cntr]=n3;
       t_cntr++;
        }
  else if(inwot==3 && x_cntr<t_num){
       our_lptr=0; n=our_getnum(lin);
        our_skipspaces(lin); our_lptr++;
        n1=our_getnum(lin);
        our_skipspaces(lin); our_lptr++;
        n2=our_getnum(lin);
        our_skipspaces(lin); our_lptr++;
        n3=our_getnum(lin);
        our_skipspaces(lin); our_lptr++;
        n4=our_getnum(lin);
        our_skipspaces(lin); our_lptr++;
        n5=our_getnum(lin);
        our_skipspaces(lin); our_lptr++;
        n6=our_getnum(lin);
        our_skipspaces(lin); our_lptr++;
        n7=our_getnum(lin);
          the_o->tex_n[x_cntr]=n;
          the_o->tex_x1[x_cntr]=n1;
          the_o->tex_x2[x_cntr]=n2;
          the_o->tex_x3[x_cntr]=n3;
          the_o->tex_x4[x_cntr]=n4;
          the_o->tex_x5[x_cntr]=n5;
          the_o->tex_x6[x_cntr]=n6;
          the_o->tex_mask[x_cntr]=0;
          if(n7==1)the_o->tex_mask[x_cntr]=1;
       x_cntr++;
      }

  if(k<1)break;
        }
 fclose(hnd);

// the_o->drawbuffer=(unsigned char*)malloc((the_o->xmax*the_o->ymax)+8);
// if(the_o->drawbuffer==NULL) return -2; malfreecntr++;
// memset(the_o->drawbuffer,0,the_o->xmax*the_o->ymax);
return 0;}

void erase_3dobject(char *idname){
 _3dobject *t,*l=NULL;
 t=top_object;
 while(t){
        if(!stricmp(idname,t->name)){
                        if(l)l->prev=t->prev;
                        if(t==top_object)top_object=t->prev;
                        free_3dobject(t);
                        our_free(t);
                        break;
                          }
        l=t;
        t=t->prev;
          }
return; }

//unsigned char *passed_our_raw;
int passed_xsiz,passed_ysiz;

int find_3dobject(char *idname){//, unsigned char *passed_our_raw){
 _3dobject *t,*l=NULL;
 t=top_object;
 while(t){
        if(!stricmp(idname,t->name)){
                                //passed_our_raw=t->drawbuffer;
                                passed_xsiz=t->xmax;
                                passed_ysiz=t->ymax;
                                return 1;
                                 }
        l=t;
        t=t->prev;
          }
return 0; }



/*void list_3dobject(){
_3dobject *t;
 t=top_object;
printf("LIST:\n");
 while(t){
  printf(">%s (%d %d %d)<\n",t->name,t->points_x[2],t->points_y[2],t->points_z[2]);
  t=t->prev; }
return; }*/

float new_x,new_y,new_z,zom;

void rotatex(int d,float cos_a,float sin_a,_3dobject *t){
 int old_x,old_y,old_z;
 old_x=new_x; old_y=new_y; old_z=new_z;
 //Rotate X AXIS
 new_y = (old_y * cos_a) - (old_z * sin_a);
 new_z = (old_z * cos_a) + (old_y * sin_a);
 t->rotated_x[d] = new_x;
 t->rotated_y[d] = new_y;
 t->rotated_z[d] = new_z;
return; }

void rotatey(int d,float cos_x,float sin_a,_3dobject *t){
 int old_x,old_y,old_z;
 old_x=new_x; old_y=new_y; old_z=new_z;
 //Rotate Y AXIS
 new_z = (old_z * cos_x) - (old_x * sin_a);
 new_x = (old_x * cos_x) + (old_z * sin_a);
 t->rotated_x[d] = new_x;
 t->rotated_y[d] = new_y;
 t->rotated_z[d] = new_z;
return; }

void rotatez(int d,float cos_a,float sin_a,_3dobject *t){
 int old_x,old_y,old_z;
 old_x=new_x; old_y=new_y; old_z=new_z;
 //Rotate Z AXIS
 new_x = (old_x * cos_a) - (old_y * sin_a);
 new_y = (old_y * cos_a) + (old_x * sin_a);
 t->rotated_x[d] = new_x;
 t->rotated_y[d] = new_y;
 t->rotated_z[d] = new_z;
return; }
//rotate and translate all the points
void rot_trans(float x,float y,float z,_3dobject *t){
 int d;
 float cos_x,sin_x,cos_y,sin_y,cos_z,sin_z,dist;
    cos_x = cos(x); sin_x = sin(x);  cos_y = cos(y);
    sin_y = sin(y); cos_z = cos(z);  sin_z = sin(z);
    for(d=0;d<t->p_num;d++){
      new_x = t->points_x[d];
      new_y = t->points_y[d];
      new_z = t->points_z[d];
      rotatex(d,cos_x,sin_x,t);
      rotatey(d,cos_y,sin_y,t);
      rotatez(d,cos_z,sin_z,t);
      t->rotated_z[d]=t->rotated_z[d]+zom;
      dist = 256 - t->rotated_z[d];
//      t->rotated_x[d] = CENT_X + (LENS * t->rotated_x[d] / dist);
//      t->rotated_y[d] = CENT_Y + (LENS * t->rotated_y[d] / dist);
      t->rotated_x[d] = (LENS * t->rotated_x[d] / dist);
      t->rotated_y[d] = (LENS * t->rotated_y[d] / dist);
    }
return; }

void _bubblesort(_3dobject *t){
 int c,temp;
 char flag=0;
 for(;;){
      flag=-1;
      for(c=0;c<t->t_num-1;c++){
          if(t->draw_order_dist[c]>t->draw_order_dist[c+1]){
                flag=0;
                temp=t->draw_order_dist[c];
                t->draw_order_dist[c]=t->draw_order_dist[c+1];
                t->draw_order_dist[c+1]=temp;
                temp=t->draw_order_num[c];
                t->draw_order_num[c]=t->draw_order_num[c+1];
                t->draw_order_num[c+1]=temp;
                    }
              }
    if(flag==-1)break;
    }
return; }

//zsort (put far away first)
void zsort(_3dobject *t){
 int a,p,d,d1,d2,d3;
 //store there positions
 for(a=0; a<t->t_num; a++){
       p=t->triangles_p1[a];  d1=t->rotated_z[p];
       p=t->triangles_p2[a];  d2=t->rotated_z[p];
       p=t->triangles_p3[a];  d3=t->rotated_z[p];
       d=d1+d2+d3/3;
       t->draw_order_num[a]=a;
       t->draw_order_dist[a]=d;
     }
 _bubblesort(t);
return; }

int set_object_point(char *id,int p,int x,int y,int z){
 _3dobject *t;
 char fnd=0;
 t=top_object;
 while(t){
        if(!stricmp(id,t->name)){
                        fnd=1;
                        break;
                          }
        t=t->prev;
        }
 if(fnd==0)return -1;
 if(p<0 || 0>t->p_num)return 0;
  t->points_x[p]=x;
  t->points_y[p]=y;
  t->points_z[p]=z;
return 0; }

unsigned char *passed_our_raw;
extern void Draw_Textured_Triangle(int msk_col,void *vface, int mem_pitch,unsigned char *scr);
int display_object(int xp,int yp,int sc,float x,float y,float z,char *id,char scrtype){
 FACE3D face; // the triangle object
 _3dobject *t;
 int fnd=0,aaa,wh,p;
 int x1,y1,x2,y2,x3,y3;

// int x4,y4;

 int tx1,tx2,tx3,tx4,tx5,tx6,txn;
 unsigned char *scr;
 int pitch;
 t=top_object;

// passed_our_raw=NULL;
 while(t){
        if(!stricmp(id,t->name)){ fnd=1;  break;  }
        t=t->prev;
        }
 if(fnd==0)return -1;
//  exit(1);
  if(scrtype==-1){
//  exit(1);
       //scr=passed_our_raw;
       //if(scr){free(scr); td_memcntr--; }
       scr=(unsigned char *)malloc((t->xmax*t->ymax)+8);
       passed_our_raw=scr;
       if(scr==NULL) return -5; td_memcntr++;
        //scr=t->drawbuffer;
        poly_clip_min_x=0;  poly_clip_min_y=0;
        poly_clip_max_x=t->xmax-1; poly_clip_max_y=t->ymax-1;
        xp=t->xmax/2; yp=t->ymax/2;
        //memset(scr,maskcol,t->xmax*t->ymax);
        memset(scr,0,t->xmax*t->ymax);
        sc=t->size;
        pitch=t->xmax;
        passed_xsiz=t->xmax;
        passed_ysiz=t->ymax;
                        }
  else{
    if(cur_screen==0) scr=vdu_scr+4;
    else{ scr=mem_bank[cur_screen-1]+5;
              if(scr==NULL)return 0;
              else if(scr[0]!=SCREEN_IDNUM)return 0;//incase user has change the bank
                      }      

        poly_clip_min_x=g_winx;  poly_clip_min_y=g_winy;
        poly_clip_max_x=g_winx2-1; poly_clip_max_y=g_winy2-1;
        if(poly_clip_max_x>g_winresx-1)poly_clip_max_x=g_winresx-1;
        if(poly_clip_max_y>g_winresy-1)poly_clip_max_y=g_winresy-1;

        pitch=g_winresx;
      }
 zom=sc;
 //passed_our_raw=scr;

 //convert and draw it
 rot_trans(x,y,z,t);
 zsort(t);
 for(aaa=0;aaa<t->t_num; aaa++){
      wh=t->draw_order_num[aaa];
       p=t->triangles_p1[wh]; x1=t->rotated_x[p];  y1=t->rotated_y[p];
       p=t->triangles_p2[wh]; x2=t->rotated_x[p];  y2=t->rotated_y[p];
       p=t->triangles_p3[wh]; x3=t->rotated_x[p];  y3=t->rotated_y[p];
       txn=t->tex_n[wh];
       tx1=t->tex_x1[wh]; tx2=t->tex_x2[wh]; tx3=t->tex_x3[wh];
       tx4=t->tex_x4[wh]; tx5=t->tex_x5[wh]; tx6=t->tex_x6[wh];


//if triangle
       face.tlist[0].x = x1+xp;
       face.tlist[0].y = y1+yp;
       face.tlist[1].x = x2+xp;
       face.tlist[1].y = y2+yp;
       face.tlist[2].x = x3+xp;
       face.tlist[2].y = y3+yp;
       face.tlist[0].u = tx1;
       face.tlist[0].v = tx2;
       face.tlist[1].u = tx3;
       face.tlist[1].v = tx4;
       face.tlist[2].u = tx5;
       face.tlist[2].v = tx6;

      if(top_sprite_no==0 || top_sprite==NULL || sprite_table==NULL)return -2;
      if(txn<1 || txn>top_sprite_no)return -3;
      if(sprite_table[txn-1]->maxx!=64 || sprite_table[txn-1]->maxy!=64)return -4;

       face.texture = sprite_table[txn-1]->image;

       if(t->tex_mask[wh]==1)Draw_Textured_Triangle(maskcol,(void *)&face, pitch,scr);
       else Draw_Textured_Triangle(-1,(void *)&face, pitch,scr);
//else{ //rectangle

//       face.tlist[0].x = x1+xp;  face.tlist[0].y = y1+yp;
//       face.tlist[1].x = x2+xp;  face.tlist[1].y = y2+yp;
//       face.tlist[2].x = x3+xp;  face.tlist[2].y = y3+yp;
//       face.tlist[0].u = 0;  face.tlist[0].v = 0;
//       face.tlist[1].u = 0;  face.tlist[1].v = 63;
//       face.tlist[2].u = 63; face.tlist[2].v = 0;
//      if(top_sprite_no==0 || top_sprite==NULL || sprite_table==NULL)return -2;
//      if(txn<1 || txn>top_sprite_no)return -3;
//      if(sprite_table[txn-1]->maxx!=64 || sprite_table[txn-1]->maxy!=64)return -4;
//       face.texture = sprite_table[txn-1]->image;
//       if(t->tex_mask[wh]==1)Draw_Textured_Triangle(maskcol,(void *)&face, pitch,scr);
//       else Draw_Textured_Triangle(-1,(void *)&face, pitch,scr);

//       face.tlist[0].x = x2+xp;  face.tlist[0].y = y2+yp;
//       face.tlist[1].x = x3+xp;  face.tlist[1].y = y3+yp;
//       face.tlist[2].x = x4+xp;  face.tlist[2].y = y4+yp;
//       face.tlist[0].u = 63;  face.tlist[0].v = 0;
//       face.tlist[1].u = 0;  face.tlist[1].v = 63;
//       face.tlist[2].u = 63; face.tlist[2].v = 63;
//      if(top_sprite_no==0 || top_sprite==NULL || sprite_table==NULL)return -2;
//      if(txn<1 || txn>top_sprite_no)return -3;
//      if(sprite_table[txn-1]->maxx!=64 || sprite_table[txn-1]->maxy!=64)return -4;
//       face.texture = sprite_table[txn-1]->image;
//       if(t->tex_mask[wh]==1)Draw_Textured_Triangle(maskcol,(void *)&face, pitch,scr);
//       else Draw_Textured_Triangle(-1,(void *)&face, pitch,scr);


/*
//test (of course)
//for(y1=0;y1<t->ymax;y1++)
//  for(x1=0;x1<t->xmax;x1++)
//    xstg_put_pixel( 10+x1,10+y1,scr[x1+(y1*t->xmax)]);

  //if(scrtype==-1) and use scr not t->drawbuffer
  memset(t->drawbuffer,55,t->xmax*t->ymax);

y1=0;
 for(x1=0;x1<t->xmax;x1+=2) { t->drawbuffer[x1+(y1*t->xmax)]=19; y1++; }
//loose below
if(scrtype!=-1){
 for(x1=0;x1<t->xmax;x1++)
 for(y1=0;y1<t->ymax;y1++)
        xstg_put_pixel(x1,y1,t->drawbuffer[x1+(y1*t->xmax)]);
        }                */


      }
return 0; }


//void erase_3dobject(char *idname)
/*void main(){
 int a;
 load_3dobject("..\\editor\\star.3do","star1");
 load_3dobject("..\\editor\\star.3do","star2");
 load_3dobject("..\\editor\\star.3do","star3");

  if(x_set_mode(X_320X200)==FALSE){
                  printf("Could not initilise graphics mode.\n"); exit(-1);
                          }


 a=display_object(10,10,50,"star2");
 getch();
   x_set_text_mode();
 free_3dobjects();
 printf("(%d)mal %d\n",a,malfreecntr);
return; }*/
