
#define KEYBOARD_INT    9

int three_finger_flag = -1;
//static int keyboard_installed = 0;
int keyboard_installed = 0; 
volatile char key[128];                   /* key pressed flags */

char key_ascii_table[128] =
{
/* 0    1    2    3    4    5    6    7    8    9    A    B    C    D    E    F             */
   0,   27,  '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '-', '=', 8,   9,       /* 0 */
   'q', 'w', 'e', 'r', 't', 'y', 'u', 'i', 'o', 'p', '[', ']', 13,  0,   'a', 's',     /* 1 */
   'd', 'f', 'g', 'h', 'j', 'k', 'l', ';', 39,  '`', 0,   92,  'z', 'x', 'c', 'v',     /* 2 */
   'b', 'n', 'm', ',', '.', '/', 0,   '*', 0,   ' ', 0,   0,   0,   0,   0,   0,       /* 3 */
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   '-', 0,   0,   0,   '+', 0,       /* 4 */
   0,   0,   0,   127, 0,   0,   92,  0,   0,   0,   0,   0,   0,   0,   0,   0,       /* 5 */
   13,  0,   '/', 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   127,     /* 6 */
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0        /* 7 */
};
char key_shift_table[128] =
{
/* 0    1    2    3    4    5    6    7    8    9    A    B    C    D    E    F             */
   0,   27,  '!', '@', '#', '$', '%', '^', '&', '*', '(', ')', '_', '+', 8,   9,       /* 0 */
   'Q', 'W', 'E', 'R', 'T', 'Y', 'U', 'I', 'O', 'P', '{', '}', 13,  0,   'A', 'S',     /* 1 */
   'D', 'F', 'G', 'H', 'J', 'K', 'L', ':', 34,  '~', 0,   '|', 'Z', 'X', 'C', 'V',     /* 2 */
   'B', 'N', 'M', '<', '>', '?', 0,   '*', 0,   ' ', 0,   0,   0,   0,   0,   0,       /* 3 */
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   '-', 0,   0,   0,   '+', 0,       /* 4 */
   0,   0,   0,   127, 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,       /* 5 */
   13,  0,   '/', 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   127,     /* 6 */
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0        /* 7 */
};
char key_control_table[128] =
{
/* 0    1    2    3    4    5    6    7    8    9    A    B    C    D    E    F             */
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,       /* 0 */
   17,  23,  5,   18,  20,  25,  21,  9,   15,  16,  0,   0,   0,   0,   1,   19,      /* 1 */
   4,   6,   7,   8,   10,  11,  12,  0,   0,   0,   0,   0,   26,  24,  3,   22,      /* 2 */
   2,   14,  13,  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,       /* 3 */
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,       /* 4 */
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,       /* 5 */
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,       /* 6 */
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0        /* 7 */
};

#define KEY_BUFFER_SIZE    256

static volatile int key_buffer[KEY_BUFFER_SIZE]; 
static volatile int key_buffer_start = 0;
static volatile int key_buffer_end = 0;


static inline void add_key(int c){//add keypress to buffer
   key_buffer[key_buffer_end] = c;

   key_buffer_end++;
   if (key_buffer_end >= KEY_BUFFER_SIZE) key_buffer_end=0;
   if (key_buffer_end == key_buffer_start) {    /* buffer full */
              key_buffer_start++;
              if (key_buffer_start >= KEY_BUFFER_SIZE) key_buffer_start = 0;
                   }
}
void simulate_keypress(int key){//push a key to buffer (as if it was pressed)
   DISABLE();
   add_key(key);
   ENABLE();
return; }

void clear_keybuf(){//Clears the keyboard buffer
   int c;
   DISABLE();
   key_buffer_start = 0;
   key_buffer_end = 0;
   for (c=0; c<128; c++) key[c] = 0;
   ENABLE();
return; }

int keypressed(){//returns -1 if there is a key waiting
   if (key_buffer_start == key_buffer_end) return 0;
return -1; }

int readkey(){//Wait for and read key from keyboard:lowbyte=ASCII:highbyte=SCANCODE
   int r;

   if (!keyboard_installed)return 0;
   do {  } while (key_buffer_start == key_buffer_end);  /* wait for a press */
   DISABLE();
   r = key_buffer[key_buffer_start];
   key_buffer_start++;
   if (key_buffer_start >= KEY_BUFFER_SIZE) key_buffer_start = 0;
   ENABLE();
return r;  }


static int my_keyint(){//the keyboard interrupt handler
   int t, temp;
   temp = inportb(0x60);                 // read keyboard byte 
   if (temp & 0x80) key[temp&0x7f] = 0;  // key was released
   else {                                // key was pressed
      temp &= 0x7f;
      key[temp] = -1;

      if(key[KEY_CONTROL] && temp==70) ctrl_break=1;//CtrlBreak

      if ((temp != KEY_LSHIFT) && (temp != KEY_RSHIFT) &&
	  (temp != KEY_CONTROL) && (temp != KEY_ALT) &&
	  (temp != KEY_CAPSLOCK) && (temp != KEY_NUMLOCK) &&
	  (temp != KEY_SCRLOCK)) {
                     if (key[KEY_ALT]) t = SCANCODE_TO_ALT(temp);
                     else if (key[KEY_CONTROL]) t = SCANCODE_TO_CONTROL(temp);
                     else if ((key[KEY_LSHIFT]) || (key[KEY_RSHIFT]))
                                                            t = SCANCODE_TO_SHIFT(temp);
                     else t = SCANCODE_TO_KEY(temp);
                     add_key(t);



                    if ((three_finger_flag) && (key[KEY_CONTROL]) && (key[KEY_ALT]) &&
                     ((temp == KEY_DEL) || (temp == KEY_END))) {
                            asm (
                               "  movb $0x79, %%al ; "
                               "  call ___djgpp_hw_exception "
                            : : : "%eax", "%ebx", "%ecx", "%edx", "%esi", "%edi", "memory"
                                 );
                           }
                }
    }
   outportb(0x20,0x20);       /* ack. the interrupt */
return 0; }

static END_OF_FUNCTION(my_keyint);



//NOTE: this will also catch ctrl-break!!!
int install_keyboard(){//installs the keyboard, returns -1 on failure
   if (keyboard_installed) return -1;

   LOCK_VARIABLE(key);
   LOCK_VARIABLE(key_ascii_table);
   LOCK_VARIABLE(key_shift_table);
   LOCK_VARIABLE(key_control_table);
   LOCK_VARIABLE(key_buffer);
   LOCK_VARIABLE(key_buffer_start);
   LOCK_VARIABLE(key_buffer_end);
   LOCK_VARIABLE(three_finger_flag);
   LOCK_FUNCTION(my_keyint);

   clear_keybuf();

   /* transfer keys waiting in BIOS keyboard buffer */
        //   while ((kbhit()) && (key_buffer_end < KEY_BUFFER_SIZE-1))
        //      key_buffer[key_buffer_end++] = getch();

   _install_irq(KEYBOARD_INT, my_keyint);

   //_add_exit_func(remove_keyboard);
   keyboard_installed = -1;
return 0; }

void remove_keyboard(){//remove the keyboard
   if (!keyboard_installed) return;

   _remove_irq(KEYBOARD_INT);
   clear_keybuf();
   //_remove_exit_func(remove_keyboard);
   keyboard_installed = 0;
return; }


