/*
 *  libfb - FreeBASIC's runtime library
 *	Copyright (C) 2004-2007 The FreeBASIC development team.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *  As a special exception, the copyright holders of this library give
 *  you permission to link this library with independent modules to
 *  produce an executable, regardless of the license terms of these
 *  independent modules, and to copy and distribute the resulting
 *  executable under terms of your choice, provided that you also meet,
 *  for each linked independent module, the terms and conditions of the
 *  license of that module. An independent module is a module which is
 *  not derived from or based on this library. If you modify this library,
 *  you may extend this exception to your version of the library, but
 *  you are not obligated to do so. If you do not wish to do so, delete
 *  this exception statement from your version.
 */

#ifndef __FB_THREAD_H__
#define __FB_THREAD_H__

typedef void (FBCALL *FB_THREADPROC)( void *param );

typedef struct _FBTHREAD
{
	FB_THREADID   id;
	FB_THREADPROC proc;
	void         *param;
	void         *opaque;
} FBTHREAD;

struct _FBMUTEX;
struct _FBCOND;

FBCALL FBTHREAD         *fb_ThreadCreate( FB_THREADPROC proc, void *param, int stack_size );
FBCALL void              fb_ThreadWait  ( FBTHREAD *thread );

FBCALL struct _FBMUTEX  *fb_MutexCreate ( void );
FBCALL void              fb_MutexDestroy( struct _FBMUTEX *mutex );
FBCALL void              fb_MutexLock   ( struct _FBMUTEX *mutex );
FBCALL void              fb_MutexUnlock ( struct _FBMUTEX *mutex );

FBCALL struct _FBCOND   *fb_CondCreate  ( void );
FBCALL void              fb_CondDestroy ( struct _FBCOND *cond );
FBCALL void              fb_CondSignal  ( struct _FBCOND *cond );
FBCALL void              fb_CondBroadcast( struct _FBCOND *cond );
FBCALL void              fb_CondWait    ( struct _FBCOND *cond, struct _FBMUTEX *mutex );

/**************************************************************************************************
 * per-thread local storage context
 **************************************************************************************************/

enum {
	FB_TLSKEY_ERROR,
	FB_TLSKEY_DIR,
	FB_TLSKEY_INPUT,
	FB_TLSKEY_PRINTUSG,

	FB_TLSKEY_GFX,
	
	FB_TLSKEYS
};

enum {
	FB_TLSLEN_ERROR 	= sizeof( FB_ERRORCTX ),
	FB_TLSLEN_DIR		= sizeof( FB_DIRCTX ),
	FB_TLSLEN_INPUT		= sizeof( FB_INPUTCTX ),
	FB_TLSLEN_PRINTUSG  = sizeof( FB_PRINTUSGCTX ),
};

FBCALL void		   *fb_TlsGetCtx		( int index, int len );
FBCALL void			fb_TlsDelCtx		( int index );
FBCALL void 		fb_TlsFreeCtxTb		( void );

#define FB_TLSGETCTX(id) (FB_##id##CTX *)fb_TlsGetCtx( FB_TLSKEY_##id, FB_TLSLEN_##id );

#endif /* __FB_THREAD_H__ */
