;Wolfware Assembler
;Copyright (c) 1985-1991 Eric Tauck. All rights reserved.

;===============================================;
;                    Mne_Put                    ;
; Get mnemonic field, look up, and put results  ;
; into the operation table. Carry is set if a   ;
; valid mnemonic is found. OP_LOC returns the   ;
; data location, OP_NUMBER returns the          ;
; operation number, and OPRND_NUM returns the   ;
; number of operands to look up.                ;
;===============================================;

Mne_Put Proc Near
 Call Mne_Look          ;get and look up next field
 Jnc Mperr              ;jump if no match

;----- mnemonic matched, put in table

 Cmp Cod_Num,Max_Instr  ;table filled
 Je Mnecan              ;jump if so

 Push Es
 Mov Di,Cod_Point       ;code pointer
 Mov Es,Cod_Seg         ;segment
 Stosw                  ;store location
 Pop Es
 Mov Cod_Point,Di       ;save pointer
 Inc Cod_Num            ;add instruction

;----- set return data

 Mov Op_Loc,Ax          ;save location
 Mov Bx,Ax
 Mov Ax,[Bx+Mentry_Flg] ;special instruction flags
 Mov Optype1,Ax         ;save
 And Ah,Onum_Mask       ;mask out bits of high byte
 Mov Op_Number,Ah       ;set special instruction number
 Mov Al,[Bx+Mstr_Len]   ;get number of operands
 Mov Oprnd_Num,Al       ;save
 Stc
 Ret

;----- mnemonic not recognized or nul

Mperr Push Es
 Mov Di,Cod_Point       ;code pointer
 Mov Es,Cod_Seg         ;segment
 Stosw                  ;store type
 Pop Es
 Mov Cod_Point,Di       ;save pointer
 Clc                    ;clear carry
 Ret

;----- too many instructions, terminate

Mnecan
 Mov Bx,Max_Instr       ;maximum instructions
 Mov Ax,828eh           ;error 142
 Call Error             ;error routine, critical error
 Endp                   ;Mne_Put

;===============================================;
;                    Mne_Get                    ;
; Get operation data from operation table.      ;
; Check for start of macros. If presently in    ;
; macro expansion, do a literal mneumonic look  ;
; up of the operation. OP_LOC returns the data  ;
; location, OP_NUMBER returns the operation     ;
; number, and OPRND_NUM returns the number of   ;
; operands to look up.                          ;
;===============================================;

Mne_Get Proc Near
 Test Mac_Stat,Mac_Flag ;check if macro
 Jnz Macmne             ;jump if so

 Push Ds
 Mov Si,Cod_Point       ;code pointer
 Mov Ds,Cod_Seg         ;segment
 Lodsw                  ;load data location
 Pop Ds
 Mov Cod_Point,Si       ;save pointer

 Cmp Ax,Undef_Cod       ;check if undefined
 Je Mgmac               ;jump if so, may be start of macro
 Cmp Ax,Nul_Cod         ;check if nul (didn't exist)
 Je Mgnul               ;jump if so

 Push Ax
 Call Skip_Field        ;skip mnemonic in line
 Pop Ax

;----- recognized mnemonic, get info

Mgfound Mov Op_Loc,Ax   ;save location
 Mov Bx,Ax
 Mov Ax,[Bx+Mentry_Flg] ;special instruction flags
 Mov Optype1,Ax         ;save
 And Ah,Onum_Mask       ;mask out number bits
 Mov Op_Number,Ah       ;set special instruction number
 Mov Al,[Bx+Mstr_Len]   ;get number of operands
 Mov Oprnd_Num,Al       ;save
 Stc
 Ret

;----- instruction within macro expansion, execute string look up

Macmne Call Mne_Look    ;look up
 Jc Mgfound             ;jump if found, set return data
 Cmp Ax,Undef_Cod       ;check if undefined
 Je Mgmac2              ;jump if so, check if macro

;----- no mnemonic returned

Mgnul Mov Op_Number,Def_Inum ;standard (non-special) operation
 Clc  
 Ret

;----- was not recognized in pass 0, get field and check if macro

Mgmac Call Get_Field    ;get field
Mgmac2 Mov Si,Tempbuff  ;mnemonic location
 Call Get_Sym           ;look for symbol
 Jnc Mgerr              ;jump if not found

 Test Ax,Macrot         ;test if macro
 Jz Mgerr               ;jump if not
 Test Ax,Undef          ;test if undefined (by false conditional)
 Jnz Mgerr              ;jump if not

;----- recognized macro

 Test Mac_Stat,Mac_Def  ;check if in definition
 Jnz Mgnul              ;jump if so, no expansion

;----- check for conditional macro

 Test Ax,Cond_Mac       ;check if conditional macro
 Jz Mgnoconm            ;jump if not
 Mov Optype1,Start_Cmac ;set flag
 Jmps Mgmacstar         ;start expansion

;----- not conditional macro, see if should be expanded

Mgnoconm Cmp If_Stat,If_Skip ;check if in skipped (false) code
 Je Mgnul
 Cmp If_Stat,If_False   ;check if in false code
 Je Mgnul
 Mov Optype1,0          ;clear flags

;----- start macro execution

Mgmacstar Mov Macro_Sta,Bx ;save start of data
 Mov Macro_Num,Cx       ;save definition number

 Mov Op_Loc,Offset Mac_Instr ;dummy instruction
 Or Optype1,Spec_Assm   ;process in false code
 Mov Op_Number,0        ;standard number
 Mov Oprnd_Num,0        ;no operands
 Stc
 Ret

;----- mnemonic not recognized, unsuccessful

Mgerr Test Mac_Stat,Mac_Flag ;check if in macro expansion
 Jnz Mgnul              ;jump if so, error flagged in definition

 Mov Ax,0413h           ;error 19
 Call Error             ;error routine
 Mov Op_Number,Def_Inum ;standard (non-special) operation
 Clc                    ;clear carry
 Ret

;----- dummy macro instruction data, calls a pseudo-pseudo-op for the init code

Mac_Instr Label Byte
 Db 0,0,0,0,0,0,0,0,0,0, 0, 1
 Dw Offset Op9999, 10h

Op9999 Dw 0001h,0001h,0000h,0080h,0015h ;none,none (pseudo-op 15H)
 Endp                   ;Mne_Get

;===============================================;
;                   Mne_Look                    ;
; Get and look up the next mnemonic. Carry is   ;
; set if field found and recognized. AX         ;
; returns data location, error, or nul type.    ;
;===============================================;

Mne_Look Proc Near
 Call Get_Field         ;get next field
 Jz Mlnone              ;jump if none

;----- look for op code string in table

 Mov Cx,Op_Num          ;number of mnemonics
 Mov Di,Op_Table2       ;OP_TABLE2 (search table)
 Mov Si,Tempbuff        ;source mnemonic
 Mov Ax,[Si+1]          ;skip length, get first two characters

;----- scan for first two characters and then jump if not found

 Repne
 Scasw                  ;scan until match or not found
 Jne Mlerr              ;not found

;----- first two characters found, try to match whole string

 Mov Di,Op_Num          ;number of mnemonics
 Inc Cx                 ;number left after scan
 Sub Di,Cx              ;calculate which mnemonic
 Shl Di
 Shl Di
 Shl Di
 Shl Di                 ;offset into OP_TABLE1 (mnemonics)
 Add Di,Op_Table1       ;table location

;----- loop through table until entire string is matched

Mlloop 
 Push Cx
 Push Di
 Push Si
 Comp_Str               ;compare strings
 Pop Si
 Pop Di
 Pop Cx
 Je Mlstok              ;jump if equal
 Add Di,16              ;length of entry in operation table one
 Loop Mlloop            ;loop for next mnemonic

;----- mnemonic not recognized

Mlerr Mov Ax,Undef_Cod  ;undefined code
 Clc                    ;clear carry
 Ret

;----- no field returned

Mlnone Mov Ax,Nul_Cod   ;no operation
 Clc                    ;clear carry
 Ret

;----- mnemonic matched

Mlstok Mov Ax,Di
 Stc
 Ret
 Endp                   ;Mne_Look

;===============================================;
;                   Code_Look                   ;
; Instruction lookup. Tries to find a version   ;
; of the operation that has operands matching   ;
; those in the source line. Carry is set if     ;
; found and the type, value, and size are       ;
; returned in OPTYPE2, OPVAL, and OPSIZE.       ;
;===============================================;

Code_Look Proc Near
 Mov Opflag,0           ;initialize operation flags

;----- check if RET

 Cmp Op_Number,Return   ;check if RET
 Jne Chktypes           ;jump if not

;----- RET instruction, reference PROC stack

 Mov Bl,Stack_Top       ;stack top
 Or Bl,Bl
 Jz Stkerr

 Sub Bh,Bh              ;clear high part
 Dec Bx
 Shl Bx                 ;disp. from stack base
 Add Bx,Stack_Base      ;stack base
 Mov Ax,[Bx]            ;get type
 Mov Stype,Ax           ;put in STYPE
 Jmps Chktypes

;----- stack error, no PROC to set RET type, unsuccessful

Stkerr Mov Ax,0023h     ;error 35
 Call Error             ;error routine
 Clc                    ;clear carry
 Ret

;----- check operand types

Chktypes Mov Ax,Dtype   ;destination type
 Mov Dx,Stype           ;source type
 Sub Bx,Bx              ;BX holds opcode flags
 Mov Di,Op_Loc          ;mnemonic entry location
 Mov Si,[Di+Mstr_Len+2] ;start of legal operand types

 Cmp Oprnd_Num,0        ;ckeck if no operands
 Je Codfound            ;jump if so

 Mov Cl,[Di+Mstr_Len+1] ;number of legal operand variations
 Sub Ch,Ch

;----- check DTYPE

Codloop Test Ax,[Si+Dt_Off] ;test destination to destination
 Jz Checkdir            ;jump if no match

 Cmp Oprnd_Num,1        ;ckeck if only one operand
 Je Codfound            ;jump if so

;----- check STYPE

 Test Dx,[Si+St_Off]    ;test source to source
 Jnz Codfound           ;jump if match

;----- types did not match, check for direction

Checkdir Test Word [Si+Ot_Off],Direction ;test for direction
 Jz Nomatch             ;jump not
 Or Bx,Direction        ;set direction

;----- check DTYPE

 Test Ax,[Si+St_Off]    ;test destination to source
 Jz Nodmatch            ;jump if match

;----- check STYPE

 Test Dx,[Si+Dt_Off]    ;test source to destination
 Jnz Codfound           ;jump if match

;----- clear direction on no match

Nodmatch And Bx,Not Direction ;no direction

;----- no match, if another entry then loop for it

Nomatch Add Si,Entry_Len ;location of next entry
 Loop Codloop           ;loop back to test types
 Jmp Codstr             ;operands not matched

;----- operation types match, check size

Codfound Or Opflag,Bx   ;op code flags (possible direction)
 Test Word [Si+Ot_Off],Chksize ;test check size flag
 Jnz Codspeschk

;----- operation found, no size check

 Mov Ax,[Si+Ot_Off]
 Mov Optype2,Ax         ;type
 Mov Ax,[Si+Vl_Off]
 Mov Opval,Ax           ;value
 Mov Ax,[Si+Os_Off]
 Mov Opsize,Ax          ;size
 Stc                    ;set carry
 Ret

;----- sizes must be matched, check for special size definition

Codspeschk Test Word [Si+Os_Off],Des_Sdef ;test for des size definition
 Jnz Sdbdes             ;jump if set
 Test Word [Si+Os_Off],Sou_Sdef ;test for sou size definition
 Jnz Sdbsou             ;jump if set
 Jmps Codregschk

;----- size defined by destination, default or special bit set

Sdbdes Mov Ax,Dsize     ;set size
 Or Al,Al               ;test for ambigious size
 Jz Spesiam             ;jump if so

 Test Stype,None        ;is there a source?
 Jnz Spesiok            ;jump if not
 Test Word [Si+Os_Off],Smatch ;is the auto match bit set?
 Jnz Spesiok            ;jump if is

;----- compare sizes

 And Ax,Ssize           ;set to common size
 Jz Spesiba             ;jump if incompatable sizes
 Jmps Spesiok           ;compatible sizes

;----- size defined by source, special bit set

Sdbsou Mov Ax,Ssize     ;set size
 Or Al,Al               ;check if ambigious
 Jz Spesiam             ;jump if is

 Test Dtype,None        ;is there a destination?
 Jnz Spesiok            ;jump if not
 Test Word [Si+Os_Off],Dmatch ;is the auto match bit set?
 Jnz Spesiok            ;jump if so

;----- compare sizes

 And Ax,Dsize           ;set to common size
 Jnz Spesiok            ;compatible sizes
 Jmps Spesiba           ;jump if incompatable sizes

;----- size ok

Spesiok Jmp Nossour

;----- ambiguous size

Spesiam Test Dtype,Undef ;check if destination undefined
 Jnz Opsierrsk          ;jump if so
 Test Stype,Undef       ;check if source undefined
 Jnz Opsierrsk          ;jump if so
 Mov Ax,007ah           ;error 122
 Call Error             ;error routine

;----- try to use most appropriate size, common size of source and instruction

Opsierrsk Mov Ax,Ssize  ;source size
 And Ax,[Si+Os_Off]     ;use common size
 Jnz Spesiok            ;jump if there is common size
 Mov Ax,[Si+Os_Off]     ;if not simply use instruction size
 Jmps Spesiok

;----- incompatible size

Spesiba Call Err_Sset   ;store destination and source sizes
 Mov Si,Tempbuff
 Mov Ax,0465h           ;error 101
 Call Error             ;error routine
 Clc                    ;clear carry
 Ret

;----- no special size definition, look for register

Codregschk Mov Bx,Reg Or Seg ;register types
 Test Ax,Bx             ;check if destination is reg
 Jnz Desreg             ;jump if so
 Test Dx,Bx             ;check if source is reg.
 Jnz Soureg             ;jump if so
 Jmps Sdbdes            ;jump if not, goto default check

;----- size defined by destination, destination is type of register

Desreg Mov Ax,Dsize     ;set size
 Test Stype,None        ;is there a source?
 Jnz Regsiok            ;no source
 Test Stype,Mem         ;is the operand a mem. ref.?
 Jnz Sdbdessoc          ;jump if so, check if valid
Sdbdesc Test Word [Si+Os_Off],Smatch ;is the auto match bit set?
 Jnz Regsiok

;----- compare sizes

 Test Ax,Ssize          ;compare sizes
 Jnz Regsiok            ;jump if OK
 Jmps Regsiba           ;not compatible

;----- check if destination register can define source mem. ref. size

Sdbdessoc Test Ssize,0ffh ;see if any m.r. size bits set
 Jz Regsiok
 Jmps Sdbdesc

;----- size defined by source, source is type of register

Soureg Mov Ax,Ssize     ;set size
 Test Dtype,Mem         ;is destination a mem. ref.?
 Jnz Sdbsousoc          ;jump if so
Sdbsouc Test Word [Si+Os_Off],Dmatch ;is the auto match bit set?
 Jnz Regsiok            ;jump if so

;----- compare sizes

 Mov Dx,Dtype           ;save destination type in case of error
 Test Ax,Dsize          ;compare sizes
 Jnz Regsiok            ;sizes OK
 Jmps Regsiba           ;jump if not compatible

;----- check if source register can define destination mem. ref. size

Sdbsousoc Test Dsize,0ffh ;see if any size bits set
 Jz Regsiok
 Jmps Sdbsouc

;----- size ok

Regsiok Jmps Nossour

;----- incompatible size

Regsiba Test Stype,Undef ;check if source undefined
 Jnz Regsiok            ;jump if so
 Test Dtype,Undef       ;check if destination undefined
 Jnz Regsiok            ;jump if so

 Or Bx,Immed            ;add immed to types
 Test Dx,Bx             ;see if other operand is reg or immed
 Jz Regoverr            ;jump not, size override
 Jmp Spesiba            ;utterly incompatible sizes

;----- overriding preset size

Regoverr Push Ax
 Push Si
 Call Err_Sset          ;store destination and source sizes
 Mov Si,Tempbuff
 Mov Ax,446ah           ;error 106
 Call Error             ;error routine
 Pop Si
 Pop Ax

;----- an operand size has been agreed upon

Nossour Test Word [Si+Ot_Off],Typedata ;test for special size checking
 Jnz Tdstes             ;jump if so

;----- compare operand size to operation size

 And Ax,[Si+Os_Off]     ;compare sizes
 Jz Nosize              ;not compatible, try next entry

;----- operation found, with size check

Opfonns Mov Opsize,Ax   ;size
 Mov Ax,[Si+Ot_Off]
 Mov Optype2,Ax         ;type
 Mov Ax,[Si+Vl_Off]
 Mov Opval,Ax           ;value
 Stc                    ;set carry
 Ret

;----- special byte type size checking (mainly for port data)

Tdstes Test Dtype,Immed ;see if is destination
 Jz Tessd               ;jump if not
 Test Dsize,S8bit       ;must be byte data
 Jnz Testops            ;jump if is
 Jmps Byteer            ;data to big

Tessd Test Stype,Immed  ;see if source
 Jz Testops             ;jump if not, false alarm
 Test Ssize,S8bit       ;must be byte data
 Jz Byteer              ;jump if not

;----- compare operand size to operation size

Testops And Ax,[Si+Os_Off] ;set to common size
 Jnz Opfonns            ;jump if compatible
 Jmps Nosize            ;not compatible, try next entry

;----- special byte operand (port type) too big

Byteer Push Ax
 Mov Ax,0017h           ;error 23
 Call Error             ;error routine
 Pop Ax
 Jmps Testops           ;go back to check normal size

;----- sizes didn't match

Nosize Or Line_Stat,Bad_Opsize ;set size mismatch flag
 Mov Ax,Dtype           ;reset destination type
 Mov Dx,Stype           ;reset source type
 Jmp Nomatch

;---- operand could not be matched by either size or type, unsuccessful

Codstr Test Ax,Undef    ;check if undefined
 Jnz Nocodser           ;jump if so
 Test Dx,Undef          ;check if undefined
 Jnz Nocodser           ;jump if so

 Call Err_Tset          ;store destination and source types
 Mov Si,Tempbuff
 Mov Ax,0416h           ;error 22
 Call Error             ;error routine

 Test Line_Stat,Bad_Opsize ;see if size was the problem
 Jnz Memsiz             ;jump if so
Nocodser Clc            ;clear carry
 Ret

;----- operand size doesn't match operation size diagnostic

Memsiz Call Err_Sset    ;store destination and source sizes
 Mov Si,Tempbuff
 Mov Ax,4428h           ;error 40
 Call Error             ;error routine
 Clc                    ;clear carry, not found
 Ret
 Endp                   ;Code_Look

