;Wolfware Assembler
;Copyright (c) 1985-1991 Eric Tauck. All rights reserved.

;===============================================;
;                    Get_Sym                    ;
; Get symbol data. Looks for symbol at SI in    ;
; symbol table. If found carry is set, else     ;
; carry is cleared. BX returns value, CX        ;
; returns size, and AX returns type. Does not   ;
; clear any type bits.                          ;
;===============================================;

Get_Sym Proc Near
 Push Es
 Call Seek_Sym          ;find symbol
 Jc Gfoundsym           ;jump if found
 Pop Es
 Ret

;----- symbol found

Gfoundsym
 Seg Es                 ;in symbol seg
 Mov Bx,[Di]            ;value
 Seg Es                 ;in symbol seg
 Mov Cx,[Di+2]          ;size
 Seg Es                 ;in symbol seg
 Mov Ax,[Di+4]          ;type
 Pop Es                 ;restore ES
 Stc                    ;set carry, found
 Ret
 Endp                   ;Get_Sym

;===============================================;
;                   Put_Proc                    ;
; Reset symbol type for PROC.                   ;
;===============================================;

Put_Proc Proc Near
 Call Eval_Oprnd        ;get operand
 And Ax,Neart + Fart    ;allow only valid bits
 Sub Cx,Cx              ;no size (not used)
 Call Put_Sym1          ;reset symbol data
 Ret
 Endp                   ;Put_Proc

;===============================================;
;                    Put_Db                     ;
; Reset symbol type for DB.                     ;
;===============================================;

Put_Db Proc Near
 Mov Ax,Addr            ;type
 Mov Cx,S8bit           ;size
 Call Put_Sym1          ;reset symbol data
 Ret
 Endp                   ;Put_Db

;===============================================;
;                    Put_Dw                     ;
; Reset symbol type for DW.                     ;
;===============================================;

Put_Dw Proc Near
 Mov Ax,Addr            ;type
 Mov Cx,S16bit          ;size
 Call Put_Sym1          ;reset symbol data
 Ret
 Endp                   ;Put_Dw

;===============================================;
;                    Put_Ds                     ;
; Reset symbol type for DS.                     ;
;===============================================;

Put_Ds Proc Near
 Mov Ax,Addr            ;type
 Sub Cx,Cx              ;size
 Call Put_Sym1          ;reset symbol data
 Ret
 Endp                   ;Put_Ds

;===============================================;
;                    Put_Equ                    ;
; Reset symbol type for EQU.                    ;
;===============================================;

Put_Equ Proc Near
 Call Eval_Oprnd        ;get operand
 Test Ax,Immed          ;test if proper type
 Jz Pundsy              ;jump if not

 And Ax,Immed Or Signed Or True_Const ;only allow legal bits
 Or Ax,Spec_Sym         ;special symbol bit
 Call Put_Sym2          ;reset symbol data
 Ret

;----- undefined value

Pundsy
 Mov Ax,Immed Or String Or Spec_Sym ;type
 Sub Bx,Bx              ;value
 Mov Cx, S16bit Or S8bit ;size
 Call Put_Sym2          ;reset symbol data
 Ret
 Endp                   ;Put_Equ

;===============================================;
;                   Put_Label                   ;
; Reset symbol type for LABEL.                  ;
;===============================================;

Put_Label Proc Near
 Call Eval_Oprnd        ;get operand
 And Ax,None + Neart + Fart ;allow legal types
 Test Ax,None           ;check if size
 Jz Lablab              ;jump if so
 Mov Ax,Addr            ;new type

Lablab
 Call Put_Sym1          ;reset symbol data
 Ret
 Endp                   ;Put_Label

;===============================================;
;                   Put_Macro                   ;
; Reset symbol type for MACRO.                  ;
;===============================================;

Put_Macro Proc Near
 Mov Ax,Macrot + Spec_Sym ;macro symbol type
 Mov Bx,Mac_Point       ;present pointer value
 Mov Cx,Mac_Number1     ;definition number
 Call Put_Sym2          ;reset symbol data
 Ret
 Endp                   ;Put_Macro

;===============================================;
;                   Put_Macroc                  ;
; Reset symbol type for MACROC.                 ;
;===============================================;

Put_Macroc Proc Near
 Mov Ax,Macrot + Spec_Sym + Cond_Mac ;macro symbol types
 Mov Bx,Mac_Point       ;present pointer value
 Mov Cx,Mac_Number1     ;definition number
 Call Put_Sym2          ;reset symbol data
 Ret
 Endp                   ;Put_Macroc

;===============================================;
;                    Put_Sym1                   ;
; Reset symbol data. Sets the the information   ;
; of the last accessed symbol to the type in AX ;
; and size in CX. Exactly like PUT_SYM2  except ;
; that the value is NOT changed.                ;
;===============================================;

Put_Sym1 Proc Near
 Mov Di,Last_Dat        ;pointer to last data
 Push Ds
 Mov Ds,Sym_Seg         ;symbol table segment

 Mov [Di+2],Cx          ;size

 Mov Dx,[Di+4]          ;load type
 And Dx,Non_Sym         ;get error bits
 Or Ax,Dx               ;error bits in new type
 Mov [Di+4],Ax          ;type

 Pop Ds
 Ret
 Endp                   ;Put_Sym1

;===============================================;
;                    Put_Sym2                   ;
; Reset symbol data. Sets the the information   ;
; of the last accessed symbol to the type in    ;
; AX, value in BX, and size in CX. Exactly like ;
; PUT_SYM1 except that the value is changed.    ;
;===============================================;

Put_Sym2 Proc Near
 Mov Di,Last_Dat        ;pointer to last data
 Push Ds
 Mov Ds,Sym_Seg         ;symbol table segment

 Mov [Di],Bx            ;value
 Mov [Di+2],Cx          ;size

 Mov Dx,[Di+4]          ;load type
 And Dx,Non_Sym         ;get error bits
 Or Ax,Dx               ;error bits in new type
 Mov [Di+4],Ax          ;type

 Pop Ds
 Ret
 Endp                   ;Put_Sym2

;===============================================;
;                    Add_Sym                    ;
; Add symbol at SI to symbol table. Checks for  ;
; illegal symbol, duplicate definition, and too ;
; many symbols.                                 ;
;===============================================;

Add_Sym Proc Near
 Sub Dx,Dx              ;holds error bits
 Mov Al,[Si+1]          ;first byte
 Cmp Al,'0'             ;check if below 0
 Jb Nesymok1            ;jump if so, OK
 Cmp Al,'9'             ;check if below or equal to 9
 Jbe Symerror           ;jump if so, error, is 0 to 9

Nesymok1
 Cmp Al,Const_Mark      ;check if constant mark
 Je Symerror            ;jump if so

;----- symbol OK

Nesymok2
 Push Es
 Call Seek_Sym          ;check if in table (note: must save DX)
 Jc Symerror2           ;jump if so, duplicate definition

Nesymok3
 Pop Es
 Mov Di,Sym_Point       ;symbol pointer
 Cmp Di,Sym_Size        ;check if too big
 Ja Symerror13          ;jump if above, too big

;----- make the entry

 Inc Sym_Num            ;increment number of symbols
 Mov Last_Sym,Di        ;save start of last symbol
 Push Es                ;save ES
 Mov Es,Sym_Seg         ;symbol table segment

;----- label

 Mov Cl,[Si]            ;length of symbol
 Sub Ch,Ch              ;clear high part
 Inc Cx                 ;length including length byte
 Rep
 Movsb                  ;put into table, including length

;----- offset and size

 Mov Last_Dat,Di        ;save start of last symbol data
 Sub Ax,Ax              ;clear AX
 Stosw                  ;no value at first
 Stosw                  ;no size at first

;----- type, initialized to near label

 Mov Ax,Dx              ;any error bits
 Or Ax,Neart            ;set to near

 Test Mac_Stat,Mac_Def  ;check if in macro definition
 Jz Newennom            ;jump if not
 Or Ax,Mlabel           ;make macro label also

Newennom Stosw

;----- save table pointer

 Pop Es                 ;restore ES
 Mov Sym_Point,Di       ;new symbol table pointer
 Ret

;----- invalid symbol

Symerror
 Or Dx,Badsym           ;set bad symbol bit
 Jmps Nesymok2          ;continue with symbol entry

;----- duplicate definition error

Symerror2
 Seg Es
 Or Word [Di+4],Dupdef  ;set duplicate definition bit in prev
 Or Dx,Dupdef           ;error bit in symbol to put in table
 Jmps Nesymok3

;----- symbol table is full error, out of memory

Symerror13
 Mov Bx,Sym_Size        ;bytes available
 Mov Ax,863dh           ;error 61
 Call Error             ;error routine, critical error (no return)
 Endp                   ;Add_Sym

;===============================================;
;                    Seek_Sym                   ;
; Looks through the symbol table for the symbol ;
; at SI. Carry is set if found and   ES:DI      ;
; return location of data, carry cleared        ;
; otherwise. NOTE: ES is destroyed, must be     ;
; preserved by caller.                          ;
;===============================================;

Seek_Sym Proc Near
 Cmp Sym_Num,0          ;check if no symbols
 Jz Emtab               ;jump if nothing in table

 Push Si
 Mov Bx,Sym_Point       ;symbol table end
 Mov Es,Sym_Seg         ;symbol table segment
 Lodsb                  ;length
 Sub Ch,Ch              ;clear high part
 Mov Bp,Sp              ;save location in stack
 Sub Di,Di              ;start at beginning

;----- loop until found or end of table

Chksym
 Seg Es                 ;in ES
 Mov Cl,[Di]            ;length
 Inc Di                 ;skip over length
 Cmp Cl,Al              ;compare lengths
 Jne Nextsym            ;jump if unequal

 Repz
 Cmpsb                  ;compare strings
 Je Foundseek           ;jump if found
 Mov Si,[Bp]            ;get source back
 Inc Si                 ;beginning of string

;----- symbol not found, continue checking

Nextsym
 Add Di,Cx              ;move table pointer over string
 Add Di,6               ;move over data
 Cmp Di,Bx              ;compare to end of table
 Jne Chksym             ;loop back if not end

;----- end of table, symbol not found

 Pop Si

Emtab
 Clc                    ;clear carry, not found
 Ret

;----- symbol found

Foundseek
 Pop Si
 Stc                    ;set carry, found
 Ret
 Endp                   ;Seek_Sym

;===============================================;
;                   Mac_Label                   ;
; Convert the label at SI into a unique macro   ;
; label by adding a byte 00, the macro          ;
; expansion, and macro definition number to     ;
; the end.                                      ;
;===============================================;

Mac_Label Proc Near
 Mov Bl,[Si]            ;get length
 Sub Bh,Bh
 Mov Byte [Bx+Si+1],0   ;make non-standard symbol
 Mov Ax,Mac_Number1     ;definition number
 Mov [Bx+Si+2],Ax       ;save
 Mov Ax,Mac_Number2     ;expansion number
 Mov [Bx+Si+4],Ax       ;save
 Add Bl,5               ;five bytes longer
 Mov [Si],Bl            ;save new length
 Ret
 Endp                   ;Mac_Label

;===============================================;
;                  Mac_Dlabel                   ;
; Convert the label at SI into the definition   ;
; macro label by adding a byte 00, the macro    ;
; definition number, and a zero expansion       ;
; number to the end.                            ;
;===============================================;

Mac_Dlabel Proc Near
 Mov Bl,[Si]            ;get length
 Sub Bh,Bh
 Mov Byte [Bx+Si+1],0   ;make non-standard symbol
 Mov Ax,Mac_Number1     ;definition number
 Mov [Bx+Si+2],Ax       ;save
 Mov Word [Bx+Si+4],0   ;expansion number
 Add Bl,5               ;five bytes longer
 Mov [Si],Bl            ;save new length
 Ret
 Endp                   ;Mac_Dlabel

;===============================================;
;                   Mac_Unlabel                 ;
; Remove the last five bytes from the string    ;
; at SI (i.e. undo the effects of MAC_LABEL     ;
; and MAC_UNLABEL).                             ;
;===============================================;

Mac_Unlabel Proc Near
 Mov Al,[Si]            ;get length
 Sub Al,5               ;four bytes shorter
 Mov [Si],Al            ;save new length
 Ret
 Endp                   ;Mac_Unlabel

;===============================================;
;                  Mac_Plabel                   ;
; Convert the label at SI into the parameter    ;
; macro label by adding a byte 00, and the      ;
; macro definition number to the end.           ;
;===============================================;

Mac_Plabel Proc Near
 Mov Bl,[Si]            ;get length
 Sub Bh,Bh
 Mov Byte [Bx+Si+1],0   ;make non-standard symbol
 Mov Ax,Mac_Number1     ;definition number
 Mov [Bx+Si+2],Ax       ;save
 Add Bl,3               ;three bytes longer
 Mov [Si],Bl            ;save new length
 Ret
 Endp                   ;Mac_Plabel

;===============================================;
;                   Mac_Uplabel                 ;
; Remove the last three bytes from the string   ;
; at SI (i.e. undo the effects of MAC_PLABEL).  ;
;===============================================;

Mac_Uplabel Proc Near
 Mov Al,[Si]            ;get length
 Sub Al,3               ;four bytes shorter
 Mov [Si],Al            ;save new length
 Ret
 Endp                   ;Mac_Uplabel

