;****************************************
; WASM Object Module Macros
; By Eric Tauck
;
; Defines:
;
;   INIT    initialize OBJ file
;   PUBLIC  define public symbols
;   BEGIN   begin code and data
;   END     end of code and data

;--- segment align values

ALIGN_BYTE      EQU     00100000B       ;byte aligned
ALIGN_WORD      EQU     01000000B       ;word aligned
ALIGN_PARA      EQU     01100000B       ;paragraph aligned
ALIGN_PAGE      EQU     10000000B       ;page aligned

;--- segment combine values

COMBINE_PRIVATE EQU     00000000B       ;private segment (not combined)
COMBINE_PUBLIC  EQU     00001000B       ;public segment (combined)
COMBINE_STACK   EQU     00010100B       ;stack segment (combined)
COMBINE_COMMON  EQU     00011000B       ;common segment (overlapped)

_ENDSIZ         EQU     5       ;size of MODEND record generated by END macro

;================================================
; This local macro declares an OBJ string.  The
; first byte is the length and the remaining
; bytes are the string.

_str    MACRO   str
        DB      OFFSET _str2 - OFFSET _str1     ;declare length
_str1   DB      str                             ;declare string
_str2
        ENDM

;================================================
; Initialize object module.
;
; Arguments:
;
;   name     name of module (usually source file)
;   segment  name of segment
;   class    name of class
;   segtype  align and combine values
;
; Example:
;
;   INIT 'MYFILE.ASM', '_TEXT', 'CODE', ALIGN_BYTE+COMBINE_PRIVATE

INIT    MACRO   name, segment, class, segtype

;--- THEADR

        DB      080H
        DW      OFFSET _init2 - OFFSET _init1
_init1  RESETC
        _str    name                    ;name of module
        DB      $SUM
_init2 

;--- COMMENT

        DB      088H
        DW      OFFSET _init4 - OFFSET _init3
_init3  RESETC
        DB      000000B                 ;comment type
        DB      00H                     ;comment class
        DB      'WASM Object Module'    ;comment
        DB      $SUM
_init4

;--- LNAMES

        DB      096H
        DW      OFFSET _init6 - OFFSET _init5
_init5  RESETC
        _str    segment                 ;segment name
        IFN     TYPE(class)=TYPE()
        _str    class                   ;class name
        ENDIF
        DB      $SUM
_init6

;--- SEGDEF

        DB      098H
        DW      OFFSET _init8 - OFFSET _init7
_init7  RESETC
        DB      segtype                 ;segment type
        DW      $END - _ENDSIZ          ;segment length
        DB      1                       ;segment name
        IFN     TYPE(class)=TYPE()
        DB      2                       ;class name
        ELSE
        DB      0                       ;no class
        ENDIF
        DB      0                       ;no overlay name
        DB      $SUM
_init8
        ENDM

;================================================
; Define a public symbol.
;
; Arguments: 
;
;   symbol  assembler symbol to be referenced
;   name    name to use in referencing symbol
;
; Example:
;
;   PUBLIC  MyProc, 'MYPROC'

PUBLIC  MACRO   symbol, name
        DB      090H
        DW      OFFSET _publc2 - OFFSET _publc1
_publc1 RESETC
        DB      0                       ;group name
        DB      1                       ;segment name
        _str    name                    ;name
        DW      OFFSET symbol           ;symbol
        DB      0                       ;type
        DB      $SUM
_publc2 
        ENDM

;================================================
; Begin assembler code/data.

BEGIN   MACRO

;--- LEDATA

        DB      0A0H
        DW      $END - _ENDSIZ + 3
        RESETC
        DB      1                       ;segment
        DW      0                       ;offset
        ORG     0
        ENDM

;================================================
; End of assembler code/data (end of object
; module).

END     MACRO
        DB      $SUM

;--- MODEND

        DB      08AH
        DW      OFFSET _end2 - OFFSET _end1
_end1   RESETC
        DB      00000000B               ;attribute
        DB      $SUM
_end2
        ENDM
