;******************************************;
; WASM Checksum Calculation, Standard Byte ;
; By Eric Tauck                            ;
;                                          ;
; Defines:                                 ;
;                                          ;
;   SumRes  reset checksum                 ;
;   SumCur  return current checksum        ;
;   SumUpd  update checksum                ;
;******************************************;

        jmps    _check2_end

;--- data

_chk_cur        DW      0       ;current checksum value

;========================================
; Reset checksum.

SumRes  PROC    NEAR
        mov     _chk_cur, 0     ;zero checksum
        ret
        ENDP

;========================================
; Return the current checksum.

SumCur  PROC    NEAR
        mov     ax, _chk_cur    ;return checksum
        ret
        ENDP

;========================================
; Update the current checksum by a byte.

SumUpd  PROC    NEAR
        sub     ah, ah          ;zero high byte
        add     _chk_cur, ax    ;update checksum
        ret
        ENDP

_check2_end
