;****************************************;
; WASM Buffered File I/O, Initialization ;
; By Eric Tauck                          ;
;                                        ;
; Defines:                               ;
;                                        ;
;   BufAll  allocate buffer              ;
;   BufRel  release buffer               ;
;   BufOpn  open buffer file             ;
;   BufClo  close buffer file            ;
;                                        ;
; Requires:                              ;
;                                        ;
;   FILE.ASM                             ;
;   MEMORY.ASM                           ;
;****************************************;

; Note: All buffer routines (in BUFFER?.ASM) use BX for the
; buffer record.  BX is guaranteed preserved through these
; routines (though not through the WASM library routines.).

        jmps    _buffer1_end

;--- global data

BUFFER_RECORD   EQU     12      ;bytes in buffer record

BUFFER_READ     EQU     0       ;reading
BUFFER_WRITE    EQU     1       ;writing
BUFFER_CREATE   EQU     2       ;create (implies writing)

;--- layout of buffer record

_BUFFER_CURRENT EQU     0       ;current read/write location (4 bytes)
_BUFFER_BASE    EQU     4       ;base offset (2 bytes)
_BUFFER_SIZE    EQU     6       ;size of buffer (2 bytes)
_BUFFER_BYTES   EQU     8       ;bytes in buffer (2 bytes)
_BUFFER_HANDLE  EQU     10      ;file handle (2 bytes)

;========================================
; Allocate a buffer.
;
; In: BX= buffer record address; AX= size
;     of buffer.
;
; Out: CY= set if error; AL= error code
;      if error; DX= memory available (if
;      out of memory).

BufAll  PROC    NEAR
        push    bx
        call    MemAll                          ;allocate memory
        pop     bx
        jc      _bfall1
        mov     [bx + _BUFFER_CURRENT + 2], ax  ;buffer segment
        mov     WORD [bx + _BUFFER_BASE], 0     ;buffer base
        mov     [bx + _BUFFER_SIZE], dx         ;buffer size
_bfall1 ret
        ENDP

;========================================
; Release buffer.
;
; In: BX= buffer record address.

BufRel  PROC    NEAR
        push    bx
        mov     ax, [bx + _BUFFER_CURRENT + 2]  ;buffer segment
        call    MemRel                          ;release memory
        pop     bx
        ret
        ENDP

;========================================
; Open a buffer.
;
; In: BX= buffer record address; AX=
;     address of file name; CL= open
;     type.
;
; Out: AL= DOS error code; CY= set if
;      error.

BufOpn  PROC    NEAR
        push    WORD [bx + _BUFFER_BASE]        ;base offset
        pop     WORD [bx + _BUFFER_CURRENT]     ;load to current offset
        mov     WORD [bx + _BUFFER_BYTES], 0    ;zero byte count

        push    bx
        mov     dx, OFFSET FilOpn       ;open file routine
        cmp     cl, BUFFER_CREATE       ;check if create new file
        jne     _bfopn1                 ;jump if not
        mov     cl, ATTR_NORMAL         ;create attribute
        mov     dx, OFFSET FilCre       ;create file routine
_bfopn1 call    dx                      ;execute open
        pop     bx
        mov     [bx+_BUFFER_HANDLE], ax ;save handle
        ret
        ENDP

;========================================
; Close a buffer.
;
; Out: AL= DOS error code; CY= set if
;      error.

BufClo  PROC    NEAR
        push    bx
        mov     bx, [bx+_BUFFER_HANDLE] ;load file handle
        call    FilClo                  ;close file
        pop     bx
        ret
        ENDP

_buffer1_end
