LANG OCTASM,0.1

#qsort_32 { ;(ptr array,size/4)
	   ;ordena un array con punteros de 32 bits
	   ;de menor a mayor
	   ;puede ocurrir un stack overflow
	   ;el array debe estar alineado a 4
	pusha
	esi=[esp+arg1] edi=[esp+arg1+4] edi=esi+edi*4-4
	l0() popa retp 8
      # jne >1
	eax=[esi] edx=[edi] cmp edx,eax jnc >1
	[esi]=edx [edi]=eax
      # ret
   #l3  pop eax
	sub edi,4 [esi]=edx add esi,4
	push edi edi=eax
	l0()
	pop edi,esi
    #l0 ecx=esi+4 cmp ecx,edi jnc <2
	push edi,esi
	eax=[edi]      ;por si el array esta ordenado
	add ecx,edi    ;se compara con el del medio
	rcr ecx,1 and ecx,-4
	edx=[ecx] [ecx]=eax
	jmp l1c
   #l1  [esi]=eax
   #l1b add esi,4 cmp esi,edi je l3
   #l1c eax=[esi] cmp eax,edx jc l1b
   #l2  [edi]=eax
   #l2b sub edi,4 cmp esi,edi je l3
	eax=[edi] cmp edx,eax jc l2b jmp l1
	}

#_pow   fyl2x
#f2ex   fld st0 frndint fxch st1,st0 fsub st1
	f2xm1 fld1 faddp st1,st0 fscale fstp st1 ret

DAT
    #digits db '0123456789abcdef'
CODE

#ltoa   ;(n,cad,base) eax,edi,cl ncr 0=base10 con signo
	;incrementa edi
	;ch longitud de la cadena si 0 se escribe solo lo necesario
	;ch>0 alineamiento a la derecha rellenando con espacios
	;ch<0 alineamiento a la izquierda rellenando con espacios
	{
	pushad test ch,ch jg derecha
      # ebp=esp test cl jg >2 js >1
	cl=-10
      # neg cl test eax jns >1
	neg eax b[edi]='-' inc edi
      # cmp cl,16 ja >6 jc >1
	b[edi]='0' inc edi
      # cmp cl,2 jc >5
	ecx=cl
      # xor edx,edx div ecx push edx test eax jnz <1
      # pop edx al=[edx+digits]  stosb cmp esp,ebp jc <1
	cmp cl,10 je >2
	al='h' cmp cl,16 je >1
	al='b' cmp cl,2 jne >3
      # stosb
      # [esp]=edi
      # popad ret
      #derecha
	ebx=ch add edi,ebx [esp]=edi dec edi
	bh=' ' test cl jg >2 js >1
	cl=-10
      # neg cl test eax jns >1
	neg eax bh='-'
      # b[edi]='h' cmp cl,16 je >1 cmc jc final
	b[edi]='b' cmp cl,2 jc final jne >2
      # dec edi dec bl js error
      # ecx=cl
      # dec bl js error xor edx,edx div ecx
	dl=[edx+digits] [edi]=dl dec edi
	test eax jnz <1
	cmp dl,'a' jc >1
	dec bl jc final
	b[edi]='0' dec edi
      # cmp bh,'-' jne >1
	dec bl js error
	b[edi]=bh dec edi
      # dec bl js >2
      # b[edi]=' ' dec edi dec bl jns <1
      # clc
 #final popad ret
 #error stc popad ret
	}

#atob{   ;esi=txt+1
	;eax=b[txt]+latin1 dl=[eax]
	;retorna esi-> final del numero
	;cf=0 zf=1 entero en ebx:eax
	;cf=0 zf=0 float en st0
	;cf=1 zf=1 numero muy grande
	;cf=1 zf=0 syntax error
	push ebp ebp=esp
	xor ecx,ecx xor ebx,ebx
      # and dl,15 jnz l1
      # lodsb cmp al,'_' je <1     ;eax=latin1 al=char
	dl=[eax] test dl js <2     ;dl=n
	cmp al,'.' je f1   ;cl=ncifras
	or al,32 cmp al,'x' jne l3
	cmp b[esi-2],'0' jne l3
	test ch jnz l3
	ch=16 jmp <1
      #l2 and dl,15
	test cl,7 jnz l1
	push ebx xor ebx,ebx
      #l1
	inc cl js big_number
	shl ebx,4 or bl,dl
      # lodsb cmp al,'_' je <1 dl=[eax] test dl js l2
	cmp al,'.' je f2
      #l3
	or al,32 cmp al,'h' je hexadecimal
	--esi cmp ch,16 je hexadecimal
	al=bl and al,15 cmp al,0bh je base2
      ;dec
	check_digits()
	eax=ebx cmp cl,1 jna n32
	cmp cl,8 ja d9
	and eax,0f0f0f0fh sub ebx,eax
	shr ebx,4 ebx=ebx*5 eax=ebx*2+eax
	ebx=0ff00ff00h and ebx,eax jz >1
	sub eax,ebx shr ebx,8 imul ebx,100 add eax,ebx
      # ebx=eax shr ebx,16 jz n32
	cwde imul ebx,10000 add eax,ebx
      #n32 xor ebx,ebx leave ret
      #d9 fninit
	ch=cl and cl,7 shl cl,2 ror eax,cl
	neg cl add cl,32
	pop ebx check_digits()
	cmp ch,16 ja d17
	shrd eax,ebx,cl shr ebx,cl
	push eax,ebx,0
	fbld [esp] fistp q[esp+4]
	pop eax,eax,ebx
      # xor edx,edx leave ret
   #d17 edi=ebx pop ebx check_digits()
	sub cl,8 cmp ch,20 ja big_number
	shrd eax,edi,cl shrd edi,ebx,cl shr ebx,cl
	push 100,eax,edi,ebx edi=esp fbld [edi+6]
	edx=ah shr edx,4 and ah,15
	edx=edx*5 add dl,dl fimul w[edi]
	add dl,ah [edi]=edx fiadd w[edi] fstp t[edi]
	pop eax,ebx,ecx,edi sub cx,401fh
	cmp cx,1fh ja big_number
	xor cl,1fh jnz h64s
      # leave ret
      #base2 xor eax,eax dec cl jz n32
	dl=7 ch=cl and dl,cl jz b1
	eax=ebx-0bh
	xor dl,7 shl dl,2 xchg cl,dl
	shl eax,cl cl=dl jmp >1
  #b1   pop eax sub cl,8
      # ebx=eax test eax,0eeeeeeeeh jnz bad_number
	and eax,0f0f0f0f0h sub ebx,eax
	shr eax,3 or ebx,eax eax=ebx shr eax,6
	or ebx,eax eax=ebx shr eax,12 or ebx,eax
	shrd edx,ebx,8 test cl,24 jnz b1
	xchg edi,edx cmp cl,8 jnc b1
	cl=ch neg cl and cl,31
	eax=edi cmp ch,32 ja b64
	shr eax,cl jmp n32
   #b64 ebx=edi eax=edx
	cmp ch,64 ja bad_number jne h64s
     # leave ret
#hexadecimal eax=ebx
       cmp cl,16 ja bad_number
       cmp cl,8  jna n32
  #h64 pop ebx neg cl
       add cl,16 jz <1
       shl cl,2 shl eax,cl
 #h64s shrd eax,ebx,cl shr ebx,cl cmp eax,eax leave ret
#bad_number or eax,1 stc leave ret

#check_digits
	edx=0eeeeeeeeh and edx,ebx add edx,66666666h
	adc edx,0 and edx,11111111h jnz bad_number
	ret

#big_number cmp eax,eax stc leave ret


      # and dl,15 jnz f21
	inc ch js big_number   ;ch=ncifras despues del punto
      #f1 ;0.
      # lodsb cmp al,'_' je <1     ;eax=latin1 al=char
	dl=[eax] test dl js <2     ;dl=n
	xor eax,eax leave ret
      #f2 test cl jz f22
	push ebx ch=cl edi=esp
      # ebx=[edi] add edi,4 check_digits()
	sub cl,8 ja <1
	pop ebx shr ecx,8 jmp f22
      #f20 and dl,15 cmp dl,9 ja f4
	test cl,7 jnz f21
	push ebx xor ebx,ebx
      #f21 ;n.
	add cx,101h test cx,8080h jnz big_number
	shl ebx,4 or bl,dl
      #f22 lodsb cmp al,'_' je f22
	dl=[eax] test dl js f20
	push ebx jmp f5
      #f4 cmp dl,0eh jne bad_number
	push ebx xor edx,edx
      # lodsb cmp al,'_' je <1
	cmp al,'+' je >1
	cmp al,'-' jne >2
	bts ecx,31
      # lodsb cmp al,'_' je <1
      # bl=[eax] test bl jns f41
	edx=edx*5 and ebx,15 cmp ebx,9 ja bad_number
	edx=edx*2+ebx test dh,11100000b jz <2 jmp big_number
      #f41 btr ecx,31 jc >1
	neg edx
      # bl=ch add edx,ebx jns >1
	neg edx bts ecx,31
      # ch=0 shl edx,8 or ecx,edx
      #f5 dec esi xor eax,eax xor edi,edi
	pop ebx cmp cl,8 jna >1
	pop eax cmp cl,16 jna >1
	pop edi cmp cl,20 ja big_number
      # fninit
	dl=cl and cl,7 shl cl,2
	neg cl add cl,32 shl ebx,cl
	shrd ebx,eax,cl shrd eax,edi,cl shr edi,cl
	push ebx,eax,edi edi=esp cl=dl cmp cl,18 ja >1
	fbld [edi] jmp >2
      # fbld [edi+1] eax=bl shr eax,4 and ebx,15
	eax=eax*5 eax=eax*2+ebx+100*10000h
	push eax fimul w[edi-2] fiadd w[edi-4]
	pop eax
      # shr ecx,8 jz f62
	eax=cx edx=tabla
	ebx=eax and ebx,15 fld q[edx+ebx*8]
	add edx,128-10 shr eax,4 jz f61
      # ebx=eax and ebx,7 jz >1
	ebx=ebx*5 fld t[edx+ebx*2] fmulp st1
      # add edx,70 shr eax,3 jnz <2
   #f61 bt ecx,23 jc >1
	fdivp st1 jmp f62
      # fmulp st1
  #f62 fxam fstsw ax and ah,1+4+64 cmp ah,4 jne >1
       test ah ;zf=0
       leave ret
     # fninit
       cmp ah,64 jne big_number
       xor eax,eax jmp n32

   #ini fninit
	edi=tabla
	push 10 fild w[esp] fld1 al=16
      # fst q[edi] add edi,8 fmul st1 dec al jnz <1
	pop eax al=7 call >1 al=7 call >1 al=4
      # fld st0
      # fld st0 fstp t[edi] add edi,10 fmul st1 dec al jnz <1
	ret

VDAT4 #tabla rb 128+70+70+40
	}

;----------MEM-------------
#memmove     ;ds:si ds:di cx   cr si,di,cx
       push eax
       cmp esi,edi jnc >2
       eax=ecx add eax,esi cmp edi,eax jnc >2
       dec eax,edi xchg eax,esi add edi,ecx
     # al=[esi] dec esi [edi]=al dec edi loop <1
       pop eax ret
#movedata push eax
      # xor eax,eax sub eax,edi and eax,3 xchg ecx,eax sub eax,ecx jle >1
	rep movsb ecx=eax shr ecx,2 rep movsd and eax,3
      # add ecx,eax rep movsb pop eax ret

#memset
#setdata ah=al
#setdataw push ax,ax pop eax
	cmp ecx,4 jc >4
	test edi,1 jz >1
	stosb ror eax,8 dec ecx
      # test edi,2 jz >1
	stosw ror eax,16 dec ecx,ecx
      # push ecx shr ecx,2 jz >1
	rep stosd
      # pop ecx
      # test ecx,2 jz >1
	stosw ror eax,16
      # test ecx,1 jz >1
	stosb
      # xor ecx,ecx ret

     # push  d[edi] free() pop edi
#freelist test edi jnz <1 ret

     # push  d[edi] free2() pop edi
#freelist2 test edi jnz <1 ret

#mallocset malloc()
	push ecx,edi rep stosb
	pop ecx,edi ret

#mallocz malloc() jmp >1
#mallocz2 malloc2() # pusha add ecx,3 xor eax,eax shr ecx,2 rep stosd popa
       # ret
#mresize ; puntero en edi ncr retorna nuevo puntero en edi
       test edi jz malloc cmp ecx,[edi-4] je <1 free() jmp malloc

;;
Hay tres grupos pequeo<=mb1,mediano>mb1 y grande>mb2
la posicion de los bloques esta alineada a RN
forman listas ([ptr1]=ptr2 [ptr+4]=tamao total)
en las que cada bloque apunta al siquiente
la posicion de los bloques esta alineada a RN
los grandes estan en mb2_list ordenados por posicin
malloc retorna un puntero a bloque+4
d[bloque]=tamao requerido
el tamao total es superior al tamao requerido+3
;;

	MBS=4   ;bits significativos
	RNS=4 RN=2 pow RNS    ;REDONDEO MIN 16
	RNMS=8 RNM=2 pow RNMS  ;REDONDEO MAX
	MB1=2 pow (MBS+RNS)
	MB2=2 pow (RNMS+MBS)    ;falla si es muy grande y hay poca memoria
	TSIZE=(RNMS-RNS+2)*(2 pow MBS)*2

       #malloc edi=ecx jecxz >1
	       add ecx,4 malloc2() sub ecx,4 [edi]=ecx add edi,4
	     # ret

       #malloc2
       {
      # push ecx dec ecx cmp ecx,MB1 jnc mb2
	shr ecx,RNS ecx=ecx*4+memtable
	edi=[ecx] test edi jz recarga
    #l1 d[ecx]=[edi] ecx=[edi+4]
    #l2 dec d[Nb] sub [mem_total],ecx
	pop ecx ret
      #mb2
	cmp ecx,MB2 jnc mb3
	edi=ecx bsr ecx,edi sub ecx,MBS-1
	shr edi,cl sub ecx,RNS
	shl ecx,MBS-1 add ecx,edi
	ecx=ecx*4+memtable
	edi=[ecx] test edi jnz l1 jmp recarga2
      #mb3
	push eax edi=mb2_list add ecx,RNM and ecx,-RNM
      # eax=edi edi=[edi] test edi jz no_mem
	cmp ecx,[edi+4] ja <1
	d[eax]=[edi] ;extraer de la lista
	pop eax je l2
	pusha
	;fragmentar
	eax=[edi+4] sub eax,ecx
	sub [mem_total],eax sub eax,4
	add edi,ecx stosd d[edi+4]=0 free()
	popa jmp l2

     #recarga     ;un bloque mas grande se divide en bloques pequeos
	edi=ecx pop ecx
	pusha
	add ecx,RN-1 and ecx,-RN eax=ecx
      # ecx=eax*2 malloc2()
	pop esi push edi add edi,eax
	inc d[Nb] add [mem_total],eax
	d[edi]=[esi] [edi+4]=eax
	[esi]=edi
	popa ret
     #recarga2
	edi=ecx pop ecx
	pusha
	eax=ecx-1 bsr ecx,eax sub ecx,MBS-1
	shr eax,cl inc eax shl eax,cl jmp <1
	}

#free   test edi jz >1
	push ecx sub edi,4 ecx=[edi] add ecx,4 free2()
	pop ecx
      # ret
#free2 test edi jz <1
       {
	pusha
	test edi,RN-1 jnz error
	dec ecx cmp ecx,MB1 jnc fb2
	eax=ecx+RN and eax,-RN
	shr ecx,RNS ecx=ecx*4+memtable
      # add [mem_total],eax
	d[edi]=[ecx] [ecx]=edi [edi+4]=eax
	inc d[Nb] popa xor edi,edi
	ret
   #fb2 cmp ecx,MB2 jnc fb3
	ebx=ecx
	bsr ecx,ebx sub ecx,MBS-1
	shr ebx,cl eax=ebx+1
	shl eax,cl sub ecx,RNS shl ecx,MBS+1
	ecx=ecx+ebx*4+memtable jmp <1
  #fb3  add ecx,RNM and ecx,-RNM
	add [mem_total],ecx
	esi=mb2_list ebp=ecx+edi
      # ebx=esi esi=[esi] cmp esi,ebp je >2 ja >1
	test esi jnz <1
      # [edi]=esi inc d[Nb] jmp >2
      # add ecx,[esi+4] d[edi]=[esi] ;merge with next block
	d[esi+8]=0
      # edx=[ebx+4] eax=ebx+edx
	esi=edi cmp eax,esi jne >1
	d[edi+8]=0
	esi=[esi] edi=ebx dec d[Nb] add ecx,edx  ;merge with prev block
      # d[ebx]=esi [edi+4]=ecx
	popa xor edi,edi ret
       }

  #no_mem
  #error
   prn("%nb %10 mem error") jmp exit

#mem{
#check{  ;busqueda de errores en la memoria
	 ;retorna edx nbloques o 0 si error,ecx memoria libre
pusha
ecx=[Nb] cmp ecx,1 jna l5
ecx=ecx*4+16
esi=mb2_list xor edx,edx xor ebx,ebx
# esi=[esi]
test esi jz error
cmp ecx,[esi+4] ja <1
edi=esi+16 add ecx,esi
esi=memtable ebp=edi
#l0 lodsd test eax jz l1
# cmp edi,ecx jnc error
  test eax,RN-1 jnz error
  add edx,[eax+4] jc error
  test edx,RN-1 jnz error
  stosd eax=[eax] test eax jnz <1
#l1 cmp esi,mb2_list+4 jc l0
  cmp edi,ecx jne error
  cmp edx,[mem_total] jne error
#l4
;defrag
push ecx sub ecx,ebp esi=ebp shr ecx,2
push ecx
 qsort_32(esi,ecx)
 edi=Nb xor eax,eax ecx=mb2_list+8 sub ecx,edi rep stosb

pop edx dec edx
pop esi sub esi,4
edi=[esi] ecx=edi add ecx,[edi+4]
# sub esi,4 eax=[esi]
test eax,0fh jnz error
ebx=eax add ebx,[eax+4] [eax+8]=d 0
cmp ebx,edi je >1 ja error
f1() ecx=ebx
# edi=eax dec edx jnz <2
f1() edi=[esp+14h] eax=[esp+18h]
sub eax,edi add_mem2()
#l5
popa
edx=[Nb]
ecx=[mem_total]
ret
#error popa xor edx,edx ret

#f1
pusha
cmp ecx,esi jna >1
cmp edi,esi ja >1
[esp+24h+14h]=edi [esp+24h+18h]=ecx
popa ret
# sub ecx,edi eax=ecx add_mem2()
popa ret

}

#add_mem2 ;edi=offset aligned to RN
	  ;eax=size round to RN
	  ;fragments blocks of any size into blocks with valid sizes
	ebx=eax
      # bsf ecx,eax cmp ecx,RNMS jnc >1
	shr eax,cl and eax,2 pow MBS -1
	shl eax,cl sub ebx,eax jz >1
	esi=edi+eax call >1
	edi=esi eax=ebx jmp <1
      # ecx=eax jmp free2

}


VDAT4
#Nb dd 0        ;numero de bloques libres
#mem_total dd 0 ;memoria libre
#memtable
rb TSIZE    ;listas de bloques pequeos y medianos
#mb2_list dd 0  ;lista de bloques grandes ordenados por posicion
dd 0            ;para simplificar en fb3  'edx=[ebx+4] '
CODE


