COMMENT |
============================================================================

  NOISE.SYS v0.4.9-Beta, A random-noise device driver (2 March 96)
  by Robert Rothenburg Walking-Owl.  Portions by Colin Plumb.
  Copyright (C)	1995-1996.  All	Rights Reserved.

  This is code for a character device which samples various sources of
  entropy (most	based on fast timings between events like keystrokes
  and disk access) and accumulates them	in a pool which	is mixed using
  a Secure Hash	Algorithm transformation.

== License and (Non)Warranty Information ===================================

  This program is free software; you can redistribute it and/or	modify
  it under the terms of	the GNU	General	Public License as published by
  the Free Software Foundation;	either version 2 of the	License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along	with this program; if not, write to the	Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111 USA.

===========================================================================|

__cpu	     equ 3  ; 3	for 386, 4 for 486

__sample09   equ 1  ; 1	to sample Int 0x09 (Keyboard ISR)
__sample13   equ 1  ; 1	to sample Int 0x13 (Low-level disk calls)

__sample28   equ 1  ; 1	to sample during idle

__samplkeys  equ 0  ; add keyboard scan	codes to pool? (unimplemented)
__sampldrift equ 1  ; sample cpu clock drift (low entropy, but still usable)
__samplaudio equ 0  ; sample from audio card (incomplete implementation)
__samplwinbc equ 1  ; sample Windows broadcasts (when Windows is active)

; -----	Note: loading the driver with mouse-sampling enabled before the
;	mouse-driver is	enabled	will probably cause your system	to crash!

__sample08   equ 0  ; 1	to hook	to timer and periodically sample non-timer
		    ; sources, enabled by /P option on loading
__samplmouse equ 1  ; sample mouse position changes (req. __sample08)

__keepfull   equ 1  ; 1	to fill	pool w/minimum entropy after each hash

initseedcnt  equ 160 ; if non-zero, sample keystrokes when /I option given

; --------------------------------------------------------------------------
; -----	Note: these defines for	testing	only, in order to verify how much
;	entropy	is generated by	a particular sampling method.
NOHASH       equ 0  ; 1 disables mixing with hash function
NOMIX        equ 0  ; 1 disables accumulate function
; Caveat about disabling accumulation: it's easy to forget this	and panic
;  over	low-entropy (repatative) data added to the pool, as with clock drift
;  sampling.  When NOMIX==1, older samples are overwritten, and	previous
;  entropy is lost.
; --------------------------------------------------------------------------

unknowncmd equ 8003h
BUSY	   equ 0200h
DONE	   equ 0100h

drvname    equ 'NOISE.SYS'
drvver     equ '0.4.9', 225
attribute  equ 1000000000000000b        ; driver attribute word
IOCTLSpt   equ 0100000000000000b        ; IOCTL Supported Flag

		include	noise.mac

if __cpu lt 3
   .err		; 386 is min supported CPU for this version
elseif __cpu eq	3
   .386
elseif __cpu eq	4
   .486
endif

; --------------------------------------------------------------------------
_TEXT	segment	word public use16 'CODE'
	assume	cs:_TEXT, ds:_TEXT
	org	0
rheader	label	dword			; /dev/random device header
	dw	uheader, -1		; device header	offset
        dw      attribute+IOCTLSpt      ; character device
	dw	rstrategy
	dw	rinterrupt
        db      'RANDOM  '              ; device name

rrh	label	dword			; request header pointer
	dd	?
; --------------------------------------------------------------------------
uheader	label	dword			; /dev/urandom device header
        dd      -1                      ; device header offset
	dw	attribute		; character device
	dw	ustrategy
	dw	uinterrupt
	db	'URANDOM '		; device name

urh	label	dword			; request header pointer
	dd	?
; --------------------------------------------------------------------------
; Data used by the driver

; Data used for entropy estimation
LastTick LABEL WORD
        DW  0
Counter LABEL WORD
        DW  0
CurrentHash LABEL WORD
        DW  (-1) and (TABLESIZE-1)
lastNtable LABEL WORD
        DW N dup (0)
indexNtable LABEL WORD
        DW 0
deltatable LABEL WORD
        DW TABLESIZE dup (0)
partial LABEL WORD
        DW 8000h

ReadIOCTL LABEL BYTE                    ; IOCTL Information Record
        DW  IOCTLRecSZ                  ; Record size
        DB  'NOIZ'                      ; Tag
        DW  0049h                       ; NOISE.SYS IOCTL version
Flags   LABEL WORD                      ; Flags
        DW  NoDriftFlag+NoAudioFlag+NoMouseFlag+NoKeepFull+NoHashFlag
        DW  0 ; (reserved)
        DW FRACBITS+(N shl 3)           ; FracBits, Order-N, other info
        DW EntropyThreshold             ; Min bits required for output
        DW QualityThreshold             ; __KeepFull attempted threshold
FreshCount LABEL WORD                   ; total fresh bits in pool
        DW 0
        DW 512 shl FRACBITS             ; Maximum size of pool
  if __samplaudio
sbPort		LABEL	WORD
        DW      220h            ; Default base address
  else
        DW 0
  endif
IOCTLRecSZ = $ - ReadIOCTL

Index   LABEL   WORD
        DW      0                       ; where new data is put
BytesAvail LABEL WORD                   ; output queue pointer
  ife NOHASH
        DW      0
StateSize EQU (hashbits/8)              ; 160 bits
initstate label	dword			; initial SHA chaining variables
	dd 67452301h, 0EFCDAB89h, 98BADCFEh, 10325476h,	0C3D2E1F0h
state	label	dword			; initial SHA chaining variables
	dd 67452301h, 0EFCDAB89h, 98BADCFEh, 10325476h,	0C3D2E1F0h
Pool    DD      80 dup (?)              ; sampling pool SHA expansion array
  else
statesize equ rawsize
        DW      rawsize-1
Pool    DD      16 dup (?)
  endif
; --------------------------------------------------------------------------
rdevicetable label word			; /dev/random device table
        dw      rdevok                  ; Initialize driver (unused here)
	dw	rdevok			; Media	Check
	dw	rcunknown
        dw      IOCTL_Read              ; IOCTL Read
	dw	rdevread		; Read
	dw	rcunknown		; Nondestructive Read (Removed 0.3.5)
	dw	devstatus		; Input	Status
	dw	rflushdevice		; Flush	Input Buffers
        dw      rcunknown
        dw      rcunknown
        dw      rcunknown
        dw      rcunknown
        dw      IOCTL_Write             ; IOCTL Write
rMAXCMD	equ	($ - rdevicetable) / 2	; Maximum allowable command
; --------------------------------------------------------------------------
udevicetable label word			; /dev/urandom device table
        dw      InitDevice              ; Initialize driver
	dw	devok			; Media	Check
	dw	cunknown
	dw	cunknown
	dw	devread			; Read
	dw	cunknown		; Nondestructive Read
	dw	devok			; Input	Status
	dw	flushdevice		; Flush	Input Buffers
uMAXCMD	equ	($ - udevicetable) / 2	; Maximum allowable command
; --------------------------------------------------------------------------
rstrategy	proc	far
		mov	WORD PTR cs:rrh, bx
		mov	WORD PTR cs:rrh+2, es
		ret
rstrategy	endp

ustrategy	proc	far
		mov	WORD PTR cs:urh, bx
		mov	WORD PTR cs:urh+2, es
		ret
ustrategy	endp

; We could probably get away with one strategy routine in DOS, but
; it gives me a bad vibe, and probably isn't good for multitasking
; --------------------------------------------------------------------------
rinterrupt	proc	far
		cld
		SaveRegs
; -----	We could add a routine to sample the soundcard here... worthwhile?
		les	di, DWORD PTR rrh
		mov	bl, es:[di].ReqHdr.CmdCode
		xor	bh, bh
		cmp	bx, rMAXCMD
		ja	SHORT rcunknown
		add	bx, bx
		jmp	WORD PTR rdevicetable[bx]
  rcunknown:			       ; ----- Unknown command
		mov	ax, unknowncmd
		jmp	SHORT rfinished
  rdevok:				; Everything went Ok
		xor	ax, ax
  rfinished:				; Leave	the driver
		les	bx, DWORD PTR rrh ; es:[bx] -> response	header
		or	ax, DONE    ; set to done code
		mov	es:[bx].ReqHdr.StatusCode, ax
		RestoreRegs
		ret
rinterrupt	endp
; --------------------------------------------------------------------------
uinterrupt	proc	far
		cld
		SaveRegs
; -----	We could add a routine to sample the soundcard here... worthwhile?
		les	di, DWORD PTR urh
		mov	bl, es:[di].ReqHdr.CmdCode
		xor	bh, bh
		cmp	bx, uMAXCMD
		ja	SHORT cunknown
		add	bx, bx
		jmp	WORD PTR udevicetable[bx]
  cunknown:			       ; ----- Unknown command
		mov	ax, unknowncmd
		jmp	SHORT finished
; --------------------------------------------------------------------------
; initdevice routine moved to disposed portion of driver (v0.3.5)

  devok:				; Everything went Ok
		xor	ax, ax
  finished:				; Leave	the driver
		les	bx, DWORD PTR urh ; es:[bx] -> response	header
		or	ax, DONE    ; set to done code
		mov	es:[bx].ReqHdr.StatusCode, ax
		RestoreRegs
		ret
uinterrupt	endp
; --------------------------------------------------------------------------
doneread	proc	near		; Read operation completed
		mov	bytesavail, 0	; throw	away remaining bytes
		jmp	SHORT devok
doneread	endp
  ife NOHASH
; --------------------------------------------------------------------------
flush		proc	near
		mov	bx, bytesavail	;
		mov	bytesavail,ax
  flushloop:	dec	bx
		jns	SHORT doneflush
		mov	al, BYTE PTR initstate[bx]
		mov	BYTE PTR state[bx], al
		jmp	SHORT flushloop
  doneflush:	ret
flush		endp
  endif
; --------------------------------------------------------------------------
flushdevice	proc	far		; wipe the buffer
  ife NOHASH
		call	flush
  endif					; does nothing
		jmp	SHORT devok
flushdevice	endp
; --------------------------------------------------------------------------
devstatus	proc	near
; This is needed if we intend to limit the amount of bytes returned
		cmp	freshcount, entropythreshold
		ja	SHORT somentpres ; is enough entropy present?
		mov	ax, BUSY
		jmp	SHORT rfinished
  somentpres:
		jmp	SHORT rdevok
devstatus	endp
; --------------------------------------------------------------------------
rflushdevice	proc	far		; wipe the buffer
  ife NOHASH
		call	flush
  endif
		mov	WORD PTR freshcount, 0 ; v0.4.2
		jmp	rdevok
rflushdevice	endp
; --------------------------------------------------------------------------
; This expects to be called with ds == cs and es:[si] -> response header
rdevread	proc	near		; Read /dev/random
  if __keepfull
                call    FillWithNoise   ; get some fresh randomness before
                                        ; reading from the pool.
  endif
		mov	cx, freshcount	       ; check if pool has entropy
		cmp	cx, entropythreshold
		ja	SHORT abovethresh
		mov	es:[di].ReqHdr.Siz, 0  ; if not, return	nothing
		jmp	SHORT devstatus
  abovethresh:
		shr	cx, 3+FRACBITS	       ; bytes requested > entropy?
		cmp	cx, es:[di].ReqHdr.Siz
		jnb	SHORT enoughentrop
		mov	es:[di].ReqHdr.Siz, cx ; if so,	limit output
  enoughentrop:
		mov	cx, es:[di].ReqHdr.Siz	; Bytes	to read
		mov	bx, bytesavail
		les	di, es:[di].ReqHdr.Addr	 ; Address to read to
		call	read
		mov	bytesavail, 0	; throw	away remaining bytes
		jmp	rdevok
rdevread	endp
; --------------------------------------------------------------------------
devread		proc	near		; Read /dev/urandom
		mov	cx, es:[di].ReqHdr.Siz	; Bytes	to read
		mov	bx, bytesavail
		les	di, es:[di].ReqHdr.Addr	 ; Address to read to
  DO_READ:
; -----	CAVEAT:	rather than calling read and jumping to	doneread, we push
;	the address for	doneread onto the stack	and go to read.
		push	OFFSET doneread
devread		endp
; --------------------------------------------------------------------------
;   cx == bytes	to read, bx == available bytes
read		proc	near		; Read data
; The Read routine was rewritten by Colin Plumb	(v0.3)
  readloop:
		dec	bx
		jns	SHORT copybyte
		mov	ax, WORD PTR freshcount
		sub	ax, (statesize*8) shl FRACBITS
		jns	SHORT freshleft
		xor	ax, ax
  freshleft:	xchg	ax, WORD PTR freshcount

  ife NOHASH
		push	cx		; Oops,	we need	to hash	more data
		call	SHATransform
; -----	Now add	the hash output	back to	the pool.
;	This cheaply stirs up the pool even more.
		mov	cx, statesize/2
		mov	si, OFFSET state
  recycle:
		lodsw
		call	accumulate
		loop	recycle
    if __keepfull
		call	FillWithNoise	; Sample some more noise for driver
    endif
		pop	cx		; And restore the pointers
  endif
		mov	bx, statesize-1

  copybyte:	; -----	Copy bytes to user buffer
  ife NOHASH
		mov	al, BYTE PTR initstate[bx] ; (changed v0.3.5)
		xchg	al, BYTE PTR state[bx]
		; -----	Don't keep a copy of random data!
  else
		mov	al, BYTE PTR pool[bx]
  endif
		stosb
		loop	readloop
		ret
read		endp

  ife NOHASH
		include	sha.inc		; -----	Secure Hash Transform -----
  endif

  if __sample08	; added	v0.3.5
; --------------------------------------------------------------------------
; We don't sample the timer here, rather we use	the timer to trigger
; periodic samplings of	other things...

; Note that under Windows 3.1 this handler will	not be called!!

SamplePeriod	equ	8 ; must be a power of two, unless you change the and
CycleCounter	LABEL	WORD
		DW	SamplePeriod-1

		DD	(?)
_timerlatch	proc	far
		pushf
		call	DWORD PTR cs:[_timerlatch-4] ; handle original IRQ0
		dec	WORD PTR cs:[CycleCounter]   ; adjust counter
		js	SHORT ItsTime		     ; if < 0, deal with it
		iret
  ItsTime:	pushad
		push	ds	; save registers
		mov	ax, cs
		mov	ds, ax
		and	WORD PTR CycleCounter, SamplePeriod-1
		SampleMousePos
		pop	ds
		popad
		iret
_timerlatch	endp
  endif

  if __sample28
; --------------------------------------------------------------------------
@OldInt28Vect	LABEL	DWORD
		DD	(?)
_idlewait	proc	near
		pushf			; changed to prior call	for v0.3.7
		call	DWORD PTR cs:[@OldInt28Vect]
		pushad
		push	ds
		mov	ax, cs
		mov	ds, ax
  ife __sample08
  ; if we're sampling the mouse	position during	timer, we don't	need
  ;  to	sample it also while idling

		SampleMousePos
  endif
		test	cs:Flags, WindowsFlag ;	running	in Windows conflicts
		jnz	SHORT @NoIdle1	      ;	with WinSock (comm overruns)
		SampleDrift ; Changed to inline	macro v0.3.6
;; ----- Got rid of SampleAudio	for now... (v0.4.2)
;;		  SampleAudio
  @NoIdle1:
		pop	ds
		popad
		iret
_idlewait	endp
  endif

; -----	The interrupt hooks are	here:
  if __sample09
	GenericSampler _keysample
  endif
  if __sample13
; We can't use the generic sampler here	because	Int 13 needs to	return
;   the	CF.  A rather careless bug, fixed in v0.4.3 by using the older
;   method (v0.2).  The	extra time to sample before performing disk ops
;   shouldn't have a significant effect	on the system.
@DskOldVector	LABEL	DWORD
		DD (?)		    ; Old vector
_DskSample	PROC	FAR
		pushad		    ; save registers, set ds ==	cs
		push	ds
		call	Sample
		pop	ds	    ; restore registers
		popad
		jmp	DWORD PTR cs:[@DskOldVector] ; call original handler
_DskSample	ENDP
  endif
  if __samplkeys
@OldKeyboard LABEL DWORD
  DD ?
_KeyboardHook PROC FAR
	jmp   DWORD PTR	cs:[@OldKeyboard]
	.err
; <----	write a	routine	that Accumulates the return scan codes and flags
;	from keyboard interrupt	(not timings or	deltas)?
_KeyboardHook ENDP
  endif

	include	multiplex.inc

; --------------------------------------------------------------------------
; Trashes ax, bx and cx, sets ds = cs. Leaves everything else alone.
Sample  LABEL   NEAR
        mov     ax, cs      ; set ds = cs
        mov     ds, ax
        SampleTimerWord     ; Get 16-bit sample from timer0

TrackDeltas LABEL NEAR
; We changed the method for calculating entropy in v0.4.3.
        mov     cx, ax
        sub     cx, LastTick ; cs =delta
        mov     LastTick, ax ; save last tick
        mov     bx, cx     ; Mix the bits around a bit cx = delta^(delta<<<8)
        rol     cx, 8
        xor     cx, bx
        mov     bx, indexNtable
        inc     BYTE PTR indexNtable
        and     BYTE PTR indexNtable, N-1
        mov     dx, lastNtable[bx]
        mov     lastNtable[bx], cx
        rol     dx, N*5
        xor     cx, dx
        xor     cx, CurrentHash
        rol     cx, 5
        mov     CurrentHash, cx ; CurrentHash = (CurrentHash^cx) <<< 5;
        mov     bx, cx
        and     bx, (TABLESIZE-1)*2 ; Mask off index bits
        mov     cx, Counter
        inc     Counter
        xchg    cx, deltatable[bx]
CalcEntropy:
        test    cx, (not 1)
        jz      SHORT @ceNoEntropy
        mov     bx, 15+1
@ceDeltaLoop:
        test    cx, cx
        js      SHORT @ce00
        shl     cx, 1
        dec     bx
        jmp     SHORT @ceDeltaLoop
@ce00:
        mov     bp, ax          ; Save ax
        mov     ax, cx
        xor     dx, dx
        mul     WORD PTR partial
        mov     cx, dx          ;
        test    cx, cx
        js      SHORT @ce01
        add     cx, cx
        dec     bx        
@ce01:
        mov     partial, cx
  if FRACBITS
        shl     bx, FRACBITS
CalcFracEntropy:
        mov     ax, cx
        mov     cx, (1 shl FRACBITS)-1
@ceFracLoop:
        xor     dx, dx
        mul     ax
        mov     ax, dx
        test    ax, ax
        js      SHORT @ce02
        add     bx, cx
        jmp     SHORT @ce03
@ce02:
        add     ax, ax
@ce03:
        shr     cx, 1
        jnz     SHORT @ceFracLoop
  endif
        add     bx, freshcount
        cmp     bx, (512 shl FRACBITS)
        jc      SHORT @ceStoreFresh
        mov     bx, (512 shl FRACBITS) ; Carry clear: cx >= dx.
@ceStoreFresh:
        mov     freshcount, bx
@ceNoEntropy:
        mov     ax, bp          ; Restore ax

Accumulate      LABEL   NEAR
  ife NOMIX		     ; ----- pool mixing function by Colin Plumb
		include	polynom.inc
  else			; -----	NOMIX accumulation in buffer
; Unmixed accumulation simply adds the new samples to the queue. It is
; used for testing and experimenting with sample methods only!
		mov	bx, index
		add	bx, 2
		and	bx, 62
		mov	index, bx
  endif
		mov	WORD PTR pool[bx], ax
;; if NOMIX, experiment	with xor instead of mov	to keep	some previous samples
		ret

; --------------------------------------------------------------------------
  if __keepfull
FillWithNoise	PROC	NEAR	; added	v0.4.2
; -----	Called after each hash to ensure pool has a min. amount	of entropy
;	Normally sampling the sound card interferes with things, but here
;	it's relatively	safe to	sample that and	other continuous sources.

; <----- Needs:	Save SoundCardState

		test	Flags, WORD PTR	NoKeepFull
		jnz	BailOut
		SampleDrift ; slows everything down if inside the loop
		mov	FillCounter, (qualitythreshold*2)
		; we want to account for samples with no entropy
  FillUpLoop:
		SampleMousePos
		SampleAudio
		dec	WORD PTR FillCounter ; if Counter==0 w/out entropy?
		jz	SHORT BailOut	     ; bail out	to prevent jamming!
		cmp	WORD PTR FreshCount, QualityThreshold
; <----	Make QualityThreshold user-definable?
		jb	SHORT FillUpLoop
  BailOut:
; <----	Needs: Restore SoundCardState
		ret
FillWithNoise	ENDP
FillCounter LABEL WORD
    DW	0
  endif

; --------------------------------------------------------------------------
IOCTL_Read      PROC    NEAR
                mov     si, OFFSET ReadIOCTL
		mov	cx, es:[di].ReqHdr.Siz	; Bytes	to read
                cmp     cx, [si]
                jna     SHORT @@irSizeOk
                mov     cx, [si]
@@irSizeOk:
                mov     es:[di].ReqHdr.Siz, cx
		les	di, es:[di].ReqHdr.Addr	 ; Address to read to
                rep     movsb
                jmp     rdevok
IOCTL_Read      ENDP

; --------------------------------------------------------------------------
IOCTL_Write     PROC    NEAR
                push    ds
                mov     cx, es:[di].ReqHdr.Siz  ; Bytes to write
                cmp     cx, 4
                jnb     SHORT @@iwSizeOk
                mov     es:[di].ReqHdr.Siz, 0
@@iwError:                
                pop     ds
                jmp     rCUnknown
@@iwSizeOk:     
                les     di, es:[di].ReqHdr.Addr ; Address to read to
                cmp     cx, es:[di]             ; is size passed Ok?
                ja      SHORT @@iwError
                mov     bx, es:[di+2]           ; Get IOCTL Function
                cmp     bx, iwMAXCMD
                ja      SHORT @@iwError
                add     bx, bx
                jmp     WORD PTR @@iwFuncTbl[bx]
@@iwSetFlags:                                   ; Set driver flags
                cmp     cx, 6
                jb      SHORT @@iwError
                mov     ax, es:[di+4]           ; Get flags
                and     ax, NoMouseFlag+NoAudioFlag+NoDriftFlag+NoKeepFull
                mov     bx, Flags
                and     bx, not (NoMouseFlag+NoAudioFlag+NoDriftFlag+NoKeepFull)
                or      bx, ax
                mov     Flags, bx
@@iwSetFlagsDone:
                pop     ds
                jmp     rdevok
@@iwSample:
                cmp     cx, 4
                jb      SHORT @@iwError
                sub     cx, 4
                shr     cx, 1
                jz      SHORT @@iwSampleDone
                mov     si, cx
                add     di, 4
@@iwSampleLoop:
                mov     ax, es:[di]
                call    TrackDeltas
                add     di, 2
                dec     si
                jnz     SHORT @@iwSampleLoop
@@iwSampleDone:
                pop     ds
                jmp     rdevok

@@iwFuncTbl     LABEL   WORD
                DW      @@iwSetFlags            ; 0 = set flags
                DW      @@iwSample              ; 1 = sample data
iwMAXCMD        equ     ($ - @@iwFuncTbl)/2
IOCTL_Write     ENDP




; --------------------------------------------------------------------------
; all code after this point is only needed for installation of the driver
; --------------------------------------------------------------------------
EndOfDevice	equ	$

	include	initnoise.inc

_TEXT	ends
	end


