/*
 * Decompiled with CFR 0.152.
 */
package org.jline.terminal.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Objects;
import org.jline.terminal.impl.AbstractPosixTerminal;
import org.jline.terminal.impl.Pty;
import org.jline.utils.InputStreamReader;
import org.jline.utils.NonBlockingReader;

public class PosixPtyTerminal
extends AbstractPosixTerminal {
    protected final InputStream input;
    protected final OutputStream output;
    private final NonBlockingReader reader;
    private final PrintWriter writer;
    private final Thread inputPumpThread;
    private final Thread outputPumpThread;

    public PosixPtyTerminal(String name, String type, Pty pty, InputStream in, OutputStream out, String encoding) throws IOException {
        super(name, type, pty);
        Objects.requireNonNull(in);
        Objects.requireNonNull(out);
        this.input = pty.getSlaveInput();
        this.output = pty.getSlaveOutput();
        this.reader = new NonBlockingReader(name, new InputStreamReader(this.input, encoding));
        this.writer = new PrintWriter(new OutputStreamWriter(this.output, encoding));
        this.inputPumpThread = new PumpThread(in, this.getPty().getMasterOutput());
        this.outputPumpThread = new PumpThread(this.getPty().getMasterInput(), out);
        this.parseInfoCmp();
        this.inputPumpThread.start();
        this.outputPumpThread.start();
    }

    @Override
    public InputStream input() {
        return this.input;
    }

    @Override
    public NonBlockingReader reader() {
        return this.reader;
    }

    @Override
    public OutputStream output() {
        return this.output;
    }

    @Override
    public PrintWriter writer() {
        return this.writer;
    }

    private class PumpThread
    extends Thread {
        private final InputStream in;
        private final OutputStream out;

        public PumpThread(InputStream in, OutputStream out) {
            this.in = in;
            this.out = out;
        }

        @Override
        public void run() {
            try {
                int b;
                while ((b = this.in.read()) >= 0) {
                    this.out.write(b);
                    this.out.flush();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

