/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.lispexpr;

import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Method;
import gnu.bytecode.PrimType;
import gnu.bytecode.Type;
import gnu.bytecode.Variable;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.Expression;
import gnu.expr.Language;
import gnu.expr.Target;
import gnu.expr.TypeValue;
import gnu.kawa.lispexpr.LangObjType;
import gnu.kawa.reflect.InstanceOf;
import gnu.kawa.reflect.LazyType;
import gnu.lists.Sequence;
import gnu.mapping.Procedure;
import gnu.mapping.Values;
import gnu.text.Char;

public class LangPrimType
extends PrimType
implements TypeValue {
    Language language;
    PrimType implementationType;
    public static final PrimType byteType = Type.byteType;
    public static final PrimType shortType = Type.shortType;
    public static final PrimType intType = Type.intType;
    public static final PrimType longType = Type.longType;
    public static final PrimType floatType = Type.floatType;
    public static final PrimType doubleType = Type.doubleType;
    public static final LangPrimType charType = new LangPrimType(Type.charType);
    public static final PrimType voidType = Type.voidType;
    static final ClassType scmCharType = ClassType.make("gnu.text.Char");
    public static final LangPrimType characterType = new LangPrimType(Type.intType);
    public static final LangPrimType characterOrEofType;
    public static final LangPrimType stringCursorType;

    public LangPrimType(PrimType type) {
        super(type);
        this.implementationType = type;
    }

    public LangPrimType(PrimType type, Language language) {
        super(type);
        this.language = language;
        this.implementationType = type;
    }

    public LangPrimType(String nam, String sig, int siz, Class reflectClass) {
        super(nam, sig, siz, reflectClass);
    }

    public LangPrimType(String nam, String sig, int siz, Class reflectClass, Language language) {
        this(nam, sig, siz, reflectClass);
        this.implementationType = Type.signatureToPrimitive(sig.charAt(0));
        this.language = language;
    }

    @Override
    public Type getImplementationType() {
        return this.implementationType;
    }

    @Override
    public ClassType boxedType() {
        if (this == characterType) {
            return scmCharType;
        }
        if (this == characterOrEofType) {
            return Type.objectType;
        }
        return super.boxedType();
    }

    @Override
    public Object coerceFromObject(Object obj) {
        if (obj.getClass() == this.reflectClass) {
            return obj;
        }
        char sig1 = this.getSignature().charAt(0);
        switch (sig1) {
            case 'I': {
                if (this != characterType && this != characterOrEofType) break;
                if (obj instanceof Integer) {
                    return obj;
                }
                int ival = obj instanceof Char ? ((Char)obj).intValue() : (obj == Sequence.eofValue && this == characterOrEofType ? -1 : (int)((Character)obj).charValue());
                return ival;
            }
            case 'Z': {
                return this.language.isTrue(obj) ? Boolean.TRUE : Boolean.FALSE;
            }
            case 'C': {
                return new Character(((Char)obj).charValue());
            }
            case 'V': {
                return Values.empty;
            }
        }
        return super.coerceFromObject(obj);
    }

    @Override
    public char charValue(Object value) {
        if (value instanceof Character) {
            return ((Character)value).charValue();
        }
        return ((Char)value).charValue();
    }

    @Override
    public void emitIsInstance(CodeAttr code) {
        char sig1 = this.getSignature().charAt(0);
        switch (sig1) {
            case 'I': {
                String mname;
                String string2 = this == characterType ? "isChar" : (mname = this == characterOrEofType ? "isCharOrEof" : null);
                if (mname == null) break;
                code.emitInvokeStatic(scmCharType.getDeclaredMethod(mname, 1));
                return;
            }
            case 'Z': {
                code.emitPop(1);
                code.emitPushInt(1);
                return;
            }
            case 'C': {
                ClassType scmCharType = ClassType.make("gnu.text.Char");
                code.emitInvokeStatic(scmCharType.getDeclaredMethod("isChar", 1));
                return;
            }
        }
        super.emitIsInstance(code);
    }

    @Override
    public void emitCoerceFromObject(CodeAttr code) {
        char sig1 = this.getSignature().charAt(0);
        switch (sig1) {
            case 'I': {
                String mname;
                if (this == characterType || this == characterOrEofType) {
                    Type top = code.topType();
                    if (top == javalangCharacterType) {
                        code.emitInvokeVirtual(javalangCharacterType.getDeclaredMethod("charValue", 0));
                        return;
                    }
                    if (top == scmCharType) {
                        code.emitInvokeVirtual(scmCharType.getDeclaredMethod("intValue", 0));
                        return;
                    }
                }
                String string2 = this == characterType ? "castToCharacter" : (mname = this == characterOrEofType ? "castToCharacterOrEof" : null);
                if (mname == null) break;
                code.emitInvokeStatic(scmCharType.getDeclaredMethod(mname, 1));
                return;
            }
            case 'Z': {
                Compilation.getCurrent().emitCoerceToBoolean();
                return;
            }
            case 'C': {
                if (code.topType() == javalangCharacterType) {
                    code.emitInvokeVirtual(javalangCharacterType.getDeclaredMethod("charValue", 0));
                    return;
                }
                Method charValueMethod = scmCharType.getDeclaredMethod("castToChar", 1);
                code.emitInvokeStatic(charValueMethod);
                return;
            }
        }
        super.emitCoerceFromObject(code);
    }

    @Override
    public Object coerceToObject(Object obj) {
        char sig1 = this.getSignature().charAt(0);
        switch (sig1) {
            case 'I': {
                if (this != characterType && this != characterOrEofType) break;
                if (obj instanceof Integer) {
                    int ival = (Integer)obj;
                    if (ival >= 0) {
                        return Char.make(ival);
                    }
                    if (ival == -1 && this == characterOrEofType) {
                        return Sequence.eofValue;
                    }
                }
                if (!(obj instanceof Char) || obj != Sequence.eofValue || this != characterOrEofType) break;
                return obj;
            }
            case 'Z': {
                return this.language.booleanObject((Boolean)obj);
            }
            case 'C': {
                if (obj instanceof Char) {
                    return obj;
                }
                return Char.make(((Character)obj).charValue());
            }
            case 'V': {
                return Values.empty;
            }
        }
        return super.coerceToObject(obj);
    }

    @Override
    public Object convertToRaw(Object obj) {
        if (this == characterType || this == characterOrEofType) {
            if (obj instanceof Char) {
                return ((Char)obj).intValue();
            }
            if (obj == Sequence.eofValue && this == characterOrEofType) {
                return -1;
            }
        }
        return obj;
    }

    @Override
    public void emitCoerceToObject(CodeAttr code) {
        char sig1 = this.getSignature().charAt(0);
        Object argType = null;
        String cname = null;
        switch (sig1) {
            case 'I': {
                String mname;
                String string2 = this == characterType ? "make" : (mname = this == characterOrEofType ? "makeOrEof" : null);
                if (mname != null) {
                    Method makeCharMethod = scmCharType.getDeclaredMethod(mname, 1);
                    code.emitInvokeStatic(makeCharMethod);
                    break;
                }
                super.emitCoerceToObject(code);
                break;
            }
            case 'Z': {
                Compilation comp = Compilation.getCurrent();
                code.emitIfIntNotZero();
                comp.emitPushBoolean(true);
                code.emitElse();
                comp.emitPushBoolean(false);
                code.emitFi();
                break;
            }
            case 'C': {
                ClassType scmCharType = ClassType.make("gnu.text.Char");
                Method makeCharMethod = scmCharType.getDeclaredMethod("make", 1);
                code.emitInvokeStatic(makeCharMethod);
                break;
            }
            default: {
                super.emitCoerceToObject(code);
            }
        }
        if (cname != null) {
            ClassType clas = ClassType.make(cname);
            Type[] args = new Type[]{argType};
            code.emitInvokeStatic(clas.getDeclaredMethod("make", args));
        }
    }

    @Override
    public int compare(Type other) {
        if (other instanceof LazyType) {
            other = ((LazyType)other).getValueType();
        }
        char sig1 = this.getSignature().charAt(0);
        char sig2 = other.getSignature().charAt(0);
        if (sig1 == 'Z') {
            return this.implementationType.compare(other);
        }
        if (this == other) {
            return 0;
        }
        if (this == stringCursorType) {
            return other == Type.objectType ? -1 : -3;
        }
        if (this == charType) {
            if (other == characterType || other == characterOrEofType || other == scmCharType) {
                return -1;
            }
            return this.getImplementationType().compare(other);
        }
        if (this == characterType) {
            if (other == characterOrEofType) {
                return -1;
            }
            if (other == charType || sig2 == 'C') {
                return 1;
            }
            return scmCharType.compare(other);
        }
        if (this == characterOrEofType) {
            if (other == characterType || other == ClassType.make("gnu.lists.EofClass") || other == charType || other == scmCharType || sig2 == 'C') {
                return 1;
            }
            return other == Type.objectType ? -1 : -3;
        }
        if (other instanceof PrimType) {
            if (sig1 == sig2) {
                return 0;
            }
            if (sig1 == 'V') {
                return 1;
            }
            if (sig2 == 'V') {
                return -1;
            }
        }
        if (sig1 == 'V') {
            return 1;
        }
        if (other instanceof LangObjType) {
            return LangPrimType.swappedCompareResult(other.compare(this));
        }
        return super.compare(other);
    }

    @Override
    public int isCompatibleWithValue(Type valueType) {
        if (this.getSignature().charAt(0) == 'Z') {
            return 1;
        }
        if (this == charType && valueType == Type.charType) {
            return 2;
        }
        return super.isCompatibleWithValue(valueType);
    }

    @Override
    public void emitTestIf(Variable incoming, Declaration decl, Compilation comp) {
        CodeAttr code = comp.getCode();
        if (incoming != null) {
            code.emitLoad(incoming);
        }
        if (decl != null) {
            code.emitDup();
            decl.compileStore(comp);
        }
        this.emitIsInstance(code);
        code.emitIfIntNotZero();
    }

    @Override
    public Expression convertValue(Expression value) {
        return null;
    }

    @Override
    public void emitIsInstance(Variable incoming, Compilation comp, Target target) {
        InstanceOf.emitIsInstance(this, incoming, comp, target);
    }

    @Override
    public Procedure getConstructor() {
        return null;
    }

    @Override
    public String encodeType(Language language) {
        if (this == characterType) {
            return "character";
        }
        if (this == characterOrEofType) {
            return "character-or-eof";
        }
        if (this == stringCursorType) {
            return "string-cursor";
        }
        return null;
    }

    static {
        characterType.setName("character");
        characterOrEofType = new LangPrimType(Type.intType);
        characterOrEofType.setName("character-or-eof");
        stringCursorType = new LangPrimType(Type.intType);
        stringCursorType.setName("string-cursor");
    }
}

