/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.functions;

import gnu.math.DFloNum;
import gnu.math.IntNum;
import gnu.math.Numeric;
import gnu.math.RatNum;
import java.math.BigDecimal;
import java.math.BigInteger;

public class Arithmetic {
    public static final int INT_CODE = 1;
    public static final int LONG_CODE = 2;
    public static final int BIGINTEGER_CODE = 3;
    public static final int INTNUM_CODE = 4;
    public static final int BIGDECIMAL_CODE = 5;
    public static final int RATNUM_CODE = 6;
    public static final int FLOAT_CODE = 7;
    public static final int DOUBLE_CODE = 8;
    public static final int FLONUM_CODE = 9;
    public static final int NUMERIC_CODE = 10;
    public static final IntNum ten_exp_9 = IntNum.make(1000000000);

    public static int classifyValue(Object object2) {
        if (object2 instanceof Numeric) {
            if (object2 instanceof IntNum) {
                return 4;
            }
            if (object2 instanceof RatNum) {
                return 6;
            }
            if (object2 instanceof DFloNum) {
                return 9;
            }
            return 10;
        }
        if (object2 instanceof Number) {
            if (object2 instanceof Integer || object2 instanceof Short || object2 instanceof Byte) {
                return 1;
            }
            if (object2 instanceof Long) {
                return 2;
            }
            if (object2 instanceof Float) {
                return 7;
            }
            if (object2 instanceof Double) {
                return 8;
            }
            if (object2 instanceof BigInteger) {
                return 3;
            }
            if (object2 instanceof BigDecimal) {
                return 5;
            }
            return -1;
        }
        return -1;
    }

    public static int asInt(Object object2) {
        return ((Number)object2).intValue();
    }

    public static long asLong(Object object2) {
        return ((Number)object2).longValue();
    }

    public static float asFloat(Object object2) {
        return ((Number)object2).floatValue();
    }

    public static double asDouble(Object object2) {
        return ((Number)object2).doubleValue();
    }

    public static BigInteger asBigInteger(Object object2) {
        if (object2 instanceof BigInteger) {
            return (BigInteger)object2;
        }
        if (object2 instanceof IntNum) {
            return new BigInteger(object2.toString());
        }
        return BigInteger.valueOf(((Number)object2).longValue());
    }

    public static IntNum asIntNum(Object object2) {
        if (object2 instanceof IntNum) {
            return (IntNum)object2;
        }
        if (object2 instanceof BigInteger) {
            return IntNum.valueOf(object2.toString(), 10);
        }
        return IntNum.make(((Number)object2).longValue());
    }

    public static BigDecimal asBigDecimal(Object object2) {
        if (object2 instanceof BigDecimal) {
            return (BigDecimal)object2;
        }
        if (object2 instanceof BigInteger) {
            return new BigDecimal((BigInteger)object2);
        }
        if (object2 instanceof Long || object2 instanceof Integer || object2 instanceof Short || object2 instanceof Byte) {
            return BigDecimal.valueOf(((Number)object2).longValue());
        }
        return new BigDecimal(object2.toString());
    }

    public static RatNum asRatNum(Object object2) {
        if (object2 instanceof RatNum) {
            return (RatNum)object2;
        }
        if (object2 instanceof BigInteger) {
            return IntNum.valueOf(object2.toString(), 10);
        }
        if (object2 instanceof BigDecimal) {
            IntNum intNum;
            int n;
            BigDecimal bigDecimal = (BigDecimal)object2;
            RatNum ratNum = IntNum.valueOf(bigDecimal.unscaledValue().toString(), 10);
            for (n = bigDecimal.scale(); n >= 9; n -= 9) {
                ratNum = RatNum.divide(ratNum, ten_exp_9);
            }
            while (n <= -9) {
                ratNum = RatNum.times(ratNum, ten_exp_9);
                n += 9;
            }
            switch (n > 0 ? n : -n) {
                case 1: {
                    intNum = IntNum.make(10);
                    break;
                }
                case 2: {
                    intNum = IntNum.make(100);
                    break;
                }
                case 3: {
                    intNum = IntNum.make(1000);
                    break;
                }
                case 4: {
                    intNum = IntNum.make(10000);
                    break;
                }
                case 5: {
                    intNum = IntNum.make(100000);
                    break;
                }
                case 6: {
                    intNum = IntNum.make(1000000);
                    break;
                }
                case 7: {
                    intNum = IntNum.make(10000000);
                    break;
                }
                case 8: {
                    intNum = IntNum.make(100000000);
                    break;
                }
                default: {
                    return ratNum;
                }
            }
            if (n > 0) {
                return RatNum.divide(ratNum, intNum);
            }
            return RatNum.times(ratNum, intNum);
        }
        return IntNum.make(((Number)object2).longValue());
    }

    public static Numeric asNumeric(Object object2) {
        if (!(object2 instanceof Numeric)) {
            if (object2 instanceof BigInteger || object2 instanceof Long || object2 instanceof Short || object2 instanceof Byte || object2 instanceof Integer) {
                return Arithmetic.asIntNum(object2);
            }
            if (object2 instanceof BigDecimal) {
                return Arithmetic.asRatNum(object2);
            }
            if (object2 instanceof Float || object2 instanceof Double) {
                return new DFloNum(Arithmetic.asDouble(object2));
            }
        }
        return (Numeric)object2;
    }
}

