/*
 * Decompiled with CFR 0.152.
 */
package kawa.lang;

import gnu.expr.Declaration;
import gnu.expr.ReferenceExp;
import gnu.lists.LList;
import gnu.lists.Pair;
import gnu.mapping.Printable;
import gnu.mapping.Procedure1;
import gnu.mapping.Symbol;
import gnu.mapping.WrongType;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.PrintWriter;
import java.util.Vector;
import kawa.lang.AnyPat;
import kawa.lang.EqualPat;
import kawa.lang.ListRepeatPat;
import kawa.lang.Macro;
import kawa.lang.PairPat;
import kawa.lang.Pattern;
import kawa.lang.SyntaxForm;
import kawa.lang.SyntaxRule;
import kawa.lang.Translator;

public class SyntaxRules
extends Procedure1
implements Printable,
Externalizable {
    Object[] literal_identifiers;
    SyntaxRule[] rules;
    int maxVars = 0;

    private void calculate_maxVars(int n) {
        int n2 = this.rules.length;
        while (--n2 >= 0) {
            int n3 = this.rules[n2].num_variables + n;
            if (n3 <= this.maxVars) continue;
            this.maxVars = n3;
        }
    }

    public SyntaxRules() {
    }

    public SyntaxRules(Object[] objectArray, SyntaxRule[] syntaxRuleArray, int n) {
        this.literal_identifiers = objectArray;
        this.rules = syntaxRuleArray;
        this.calculate_maxVars(n);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SyntaxRules(Object[] objectArray, Object object2, Translator translator) {
        Object object3;
        Object object4;
        this.literal_identifiers = objectArray;
        int n = LList.listLength(object2, false);
        if (n <= 0) {
            n = 0;
            translator.syntaxError("missing or invalid syntax-rules");
        }
        this.rules = new SyntaxRule[n];
        Macro macro = translator.currentMacroDefinition;
        Vector vector = macro.capturedIdentifiers;
        int n2 = 0;
        while (true) {
            Object var21_22;
            int n3;
            int n4;
            Pair pair;
            block13: {
                block12: {
                    block11: {
                        if (n2 >= n) break;
                        pair = (Pair)object2;
                        Object object5 = pair.car;
                        if (!(object5 instanceof Pair)) {
                            translator.syntaxError("missing pattern in " + n2 + "'th syntax rule");
                            return;
                        }
                        Pair pair2 = (Pair)object5;
                        object4 = pair2.car;
                        object3 = translator.getFile();
                        n4 = translator.getLine();
                        n3 = translator.getColumn();
                        try {
                            translator.setLine(pair2);
                            if (!(pair2.cdr instanceof Pair)) {
                                translator.syntaxError("missing template in " + n2 + "'th syntax rule");
                                var21_22 = null;
                                translator.setLine((String)object3, n4, n3);
                                return;
                            }
                            pair2 = (Pair)pair2.cdr;
                            if (pair2.cdr != LList.Empty) {
                                translator.syntaxError("junk after " + n2 + "'th syntax rule");
                                break block11;
                            }
                            Object object6 = pair2.car;
                            StringBuffer stringBuffer = new StringBuffer();
                            Vector vector2 = new Vector();
                            if (!(object4 instanceof Pair) || !(((Pair)object4).car instanceof String)) {
                                translator.syntaxError("pattern does not start with name");
                                break block12;
                            }
                            objectArray[0] = ((Pair)object4).car;
                            object4 = ((Pair)object4).cdr;
                            Pattern pattern = SyntaxRules.translate_pattern(object4, objectArray, vector2, stringBuffer, 0, translator);
                            String string = stringBuffer.toString();
                            this.rules[n2] = new SyntaxRule(pattern, string, vector2, object6, vector, translator);
                            break block13;
                        }
                        catch (Throwable throwable) {
                            var21_22 = null;
                            translator.setLine((String)object3, n4, n3);
                            throw throwable;
                        }
                    }
                    var21_22 = null;
                    translator.setLine((String)object3, n4, n3);
                    return;
                }
                var21_22 = null;
                translator.setLine((String)object3, n4, n3);
                return;
            }
            var21_22 = null;
            translator.setLine((String)object3, n4, n3);
            ++n2;
            object2 = pair.cdr;
        }
        int n5 = vector.size();
        this.calculate_maxVars(n5);
        macro.templateIdentifiers = new String[n5];
        vector.copyInto(macro.templateIdentifiers);
        macro.capturedDeclarations = new Declaration[n5];
        int n6 = n5;
        while (--n6 >= 0) {
            object4 = macro.templateIdentifiers[n6];
            object3 = translator.lexical.lookup(object4, -1);
            if (object3 != null && !((Declaration)object3).getFlag(65536)) {
                ((Declaration)object3).setCanRead(true);
                ((Declaration)object3).setFlag(524288);
            }
            macro.capturedDeclarations[n6] = object3;
        }
        return;
    }

    public static Pattern translate_pattern(Object object2, Object[] objectArray, Vector vector, StringBuffer stringBuffer, int n, Translator translator) {
        if (object2 instanceof Pair) {
            Object object3;
            Pair pair = (Pair)object2;
            if (pair.cdr instanceof Pair) {
                object3 = (Pair)pair.cdr;
                if (((Pair)object3).car == "...") {
                    if (((Pair)object3).cdr != LList.Empty) {
                        translator.syntaxError("junk follows ... in syntax-rule pattern");
                    }
                    Pattern pattern = SyntaxRules.translate_pattern(pair.car, objectArray, vector, stringBuffer, n + 1, translator);
                    return new ListRepeatPat(pattern);
                }
            }
            object3 = SyntaxRules.translate_pattern(pair.car, objectArray, vector, stringBuffer, n, translator);
            return new PairPat((Pattern)object3, SyntaxRules.translate_pattern(pair.cdr, objectArray, vector, stringBuffer, n, translator));
        }
        if (object2 instanceof String || object2 instanceof Symbol) {
            int n2 = objectArray.length;
            while (--n2 >= 0) {
                if (objectArray[n2] != object2) continue;
                return new EqualPat(object2);
            }
            if (vector.contains(object2)) {
                translator.syntaxError("duplicated pattern variable " + object2);
            }
            vector.addElement(object2);
            stringBuffer.append((char)n);
            return new AnyPat();
        }
        return new EqualPat(object2);
    }

    public Object apply1(Object object2) {
        Pair pair;
        SyntaxForm syntaxForm;
        try {
            syntaxForm = (SyntaxForm)object2;
            pair = (Pair)syntaxForm.form;
        }
        catch (ClassCastException classCastException) {
            throw WrongType.make(classCastException, this, 0);
        }
        return this.expand(pair, syntaxForm.tr);
    }

    public Object expand(Pair pair, Translator translator) {
        Object object2 = pair.cdr;
        Object[] objectArray = new Object[this.maxVars];
        Macro macro = (Macro)translator.getCurrentSyntax();
        int n = macro.templateIdentifiers.length;
        int n2 = 0;
        while (n2 < this.rules.length) {
            SyntaxRule syntaxRule = this.rules[n2];
            if (syntaxRule.pattern.match(object2, objectArray, 0)) {
                Object object3;
                int[] nArray = new int[syntaxRule.max_nesting];
                int n3 = 0;
                while (n3 < n) {
                    object3 = macro.templateIdentifiers[n3];
                    Symbol symbol = new Symbol((String)object3);
                    objectArray[syntaxRule.num_variables + n3] = symbol;
                    Declaration declaration = macro.capturedDeclarations == null ? null : macro.capturedDeclarations[n3];
                    Declaration declaration2 = new Declaration(symbol);
                    ReferenceExp referenceExp = declaration != null ? new ReferenceExp(declaration) : new ReferenceExp(object3);
                    declaration2.noteValue(referenceExp);
                    declaration2.setAlias(true);
                    translator.push(declaration2);
                    ++n3;
                }
                object3 = syntaxRule.execute_template(0, objectArray, 0, nArray, translator, pair);
                return object3;
            }
            ++n2;
        }
        return translator.syntaxError("no matching syntax-rule for " + this.literal_identifiers[0]);
    }

    public void print(PrintWriter printWriter) {
        printWriter.print("#<macro " + this.literal_identifiers[0] + ">");
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.literal_identifiers);
        objectOutput.writeObject(this.rules);
        objectOutput.writeInt(this.maxVars);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.literal_identifiers = (Object[])objectInput.readObject();
        this.rules = (SyntaxRule[])objectInput.readObject();
        this.maxVars = objectInput.readInt();
    }
}

