/*
 * Decompiled with CFR 0.152.
 */
package gnu.lists;

import gnu.lists.LList;
import gnu.lists.LListPosition;
import gnu.lists.PositionManager;
import gnu.lists.Sequence;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class Pair
extends LList
implements Externalizable {
    public Object car;
    public Object cdr;

    public Pair(Object object2, Object object3) {
        this.car = object2;
        this.cdr = object3;
    }

    public Pair() {
    }

    public int size() {
        int n = LList.listLength(this, true);
        if (n >= 0) {
            return n;
        }
        if (n == -1) {
            return Integer.MAX_VALUE;
        }
        throw new RuntimeException("not a true list");
    }

    public boolean isEmpty() {
        return false;
    }

    public int length() {
        int n = 0;
        Object object2 = this;
        Object object3 = this;
        while (object3 != LList.Empty) {
            if (!(object3 instanceof Pair)) {
                if (object3 instanceof Sequence) {
                    int n2 = ((Sequence)object3).size();
                    return n2 >= 0 ? n + n2 : n2;
                }
                return -2;
            }
            Pair pair = object3;
            if (pair.cdr == LList.Empty) {
                return n + 1;
            }
            if (object3 == object2 && n > 0) {
                return -1;
            }
            if (!(pair.cdr instanceof Pair)) {
                ++n;
                object3 = pair.cdr;
                continue;
            }
            if (!(object2 instanceof Pair)) {
                return -2;
            }
            object2 = ((Pair)object2).cdr;
            object3 = ((Pair)pair.cdr).cdr;
            n += 2;
        }
        return n;
    }

    public boolean hasNext(int n) {
        if (n <= 0) {
            return n == 0;
        }
        return PositionManager.getPositionObject(n).hasNext();
    }

    public int nextPos(int n) {
        if (n <= 0) {
            if (n < 0) {
                return 0;
            }
            return PositionManager.manager.register(new LListPosition(this, 1, true));
        }
        LListPosition lListPosition = (LListPosition)PositionManager.getPositionObject(n);
        return lListPosition.gotoNext() ? n : 0;
    }

    public Object getPosNext(int n) {
        if (n <= 0) {
            return n == 0 ? this.car : Sequence.eofValue;
        }
        return PositionManager.getPositionObject(n).getNext();
    }

    public Object getPosPrevious(int n) {
        if (n <= 0) {
            return n == 0 ? Sequence.eofValue : this.lastPair().car;
        }
        return PositionManager.getPositionObject(n).getPrevious();
    }

    public final Pair lastPair() {
        Pair pair = this;
        while (true) {
            Object object2 = pair.cdr;
            if (!(this.cdr instanceof Pair)) break;
            pair = (Pair)object2;
        }
        return pair;
    }

    public int hashCode() {
        int n = 1;
        Object object2 = this;
        while (object2 instanceof Pair) {
            Pair pair = object2;
            Object object3 = pair.car;
            n = 31 * n + (object3 == null ? 0 : object3.hashCode());
            object2 = pair.cdr;
        }
        if (object2 != LList.Empty && object2 != null) {
            n ^= object2.hashCode();
        }
        return n;
    }

    public static boolean equals(Pair pair, Pair pair2) {
        if (pair == pair2) {
            return true;
        }
        if (pair == null || pair2 == null) {
            return false;
        }
        Object object2;
        Object object3;
        while ((object3 = pair.car) == (object2 = pair2.car) || object3 != null && object3.equals(object2)) {
            object3 = pair.cdr;
            object2 = pair2.cdr;
            if (object3 == object2) {
                return true;
            }
            if (object3 == null || object2 == null) {
                return false;
            }
            if (!(object3 instanceof Pair) || !(object2 instanceof Pair)) {
                return object3.equals(object2);
            }
            pair = (Pair)object3;
            pair2 = (Pair)object2;
        }
        return false;
    }

    public Object get(int n) {
        int n2;
        Pair pair = this;
        for (n2 = n; n2 > 0; --n2) {
            if (pair.cdr instanceof Pair) {
                pair = (Pair)pair.cdr;
                continue;
            }
            if (!(pair.cdr instanceof Sequence)) break;
            return ((Sequence)pair.cdr).get(n2);
        }
        if (n2 == 0) {
            return pair.car;
        }
        throw new IndexOutOfBoundsException();
    }

    public boolean equals(Object object2) {
        if (object2 != null && object2 instanceof Pair) {
            return Pair.equals(this, (Pair)object2);
        }
        return false;
    }

    public static Pair make(Object object2, Object object3) {
        return new Pair(object2, object3);
    }

    public Object[] toArray() {
        int n = this.size();
        Object[] objectArray = new Object[n];
        int n2 = 0;
        Sequence sequence = this;
        while (n2 < n && sequence instanceof Pair) {
            Pair pair = sequence;
            objectArray[n2] = pair.car;
            sequence = (Sequence)pair.cdr;
            ++n2;
        }
        int n3 = n2;
        while (n2 < n) {
            objectArray[n2] = sequence.get(n2 - n3);
            ++n2;
        }
        return objectArray;
    }

    public Object[] toArray(Object[] objectArray) {
        int n = objectArray.length;
        int n2 = this.length();
        if (n2 > n) {
            objectArray = new Object[n2];
            n = n2;
        }
        int n3 = 0;
        Sequence sequence = this;
        while (n3 < n2 && sequence instanceof Pair) {
            Pair pair = sequence;
            objectArray[n3] = pair.car;
            sequence = (Sequence)pair.cdr;
            ++n3;
        }
        int n4 = n3;
        while (n3 < n2) {
            objectArray[n3] = sequence.get(n3 - n4);
            ++n3;
        }
        if (n2 < n) {
            objectArray[n2] = null;
        }
        return objectArray;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.car);
        objectOutput.writeObject(this.cdr);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.car = objectInput.readObject();
        this.cdr = objectInput.readObject();
    }
}

