/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.sax;

import gnu.lists.Consumable;
import gnu.lists.Consumer;
import gnu.lists.SeqPosition;
import gnu.mapping.Symbol;
import gnu.text.Char;
import gnu.xml.XName;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class ContentConsumer
implements Consumer,
Attributes {
    ContentHandler out;
    int nesting = 0;
    String[] names = new String[15];
    int numAttributes;
    String[] attributes = new String[20];
    char[] chBuffer;
    StringBuffer strBuffer = new StringBuffer(200);
    int inStartTag;

    public ContentConsumer() {
    }

    public ContentConsumer(ContentHandler contentHandler) {
        this.out = contentHandler;
    }

    public void error(String string, SAXException sAXException) {
        throw new RuntimeException("caught " + sAXException + " in " + string);
    }

    public int getLength() {
        return this.numAttributes;
    }

    public String getQName(int n) {
        return n >= this.numAttributes ? null : this.attributes[4 * n];
    }

    public String getURI(int n) {
        return n >= this.numAttributes ? null : this.attributes[4 * n + 1];
    }

    public String getLocalName(int n) {
        return n >= this.numAttributes ? null : this.attributes[4 * n + 2];
    }

    public String getValue(int n) {
        return n >= this.numAttributes ? null : this.attributes[4 * n + 3];
    }

    public String getType(int n) {
        return n >= this.numAttributes ? null : "CDATA";
    }

    public int getIndex(String string, String string2) {
        int n = this.numAttributes;
        while (--n >= 0) {
            if (!string.equals(this.attributes[4 * n + 1]) || !string2.equals(this.attributes[4 * n + 2])) continue;
            return n;
        }
        return -1;
    }

    public int getIndex(String string) {
        int n = this.numAttributes;
        while (--n >= 0) {
            if (!string.equals(this.attributes[4 * n])) continue;
            return n;
        }
        return -1;
    }

    public String getType(String string, String string2) {
        int n = this.getIndex(string, string2);
        return n < 0 ? null : "CDATA";
    }

    public String getType(String string) {
        int n = this.getIndex(string);
        return n < 0 ? null : "CDATA";
    }

    public String getValue(String string, String string2) {
        int n = this.getIndex(string, string2);
        return n < 0 ? null : this.attributes[4 * n + 3];
    }

    public String getValue(String string) {
        int n = this.getIndex(string);
        return n < 0 ? null : this.attributes[4 * n + 3];
    }

    void endStartTag() {
        if (this.inStartTag != 1) {
            return;
        }
        int n = 3 * (this.nesting - 1);
        try {
            this.out.startElement(this.names[n], this.names[n + 1], this.names[n + 2], this);
        }
        catch (SAXException sAXException) {
            this.error("startElement", sAXException);
        }
        n = 4 * this.numAttributes;
        while (--n >= 0) {
            this.attributes[n] = null;
        }
        this.numAttributes = 0;
        this.inStartTag = 0;
    }

    public void beginGroup(String string, Object object2) {
        String string2;
        Object object3;
        if (this.inStartTag == 1) {
            this.endStartTag();
        }
        this.flushStrBuffer();
        int n = 3 * this.nesting;
        if (n >= this.names.length) {
            object3 = new String[2 * n];
            System.arraycopy(this.names, 0, object3, 0, n);
            this.names = object3;
        }
        if (object2 instanceof Symbol) {
            Symbol symbol = (Symbol)object2;
            object3 = symbol.getNamespaceURI();
            string2 = symbol.getLocalName();
        } else if (object2 instanceof XName) {
            XName xName = (XName)object2;
            object3 = xName.getNamespaceURI();
            string2 = xName.getLocalName();
        } else {
            object3 = "";
            string2 = object2.toString();
        }
        this.names[n] = object3;
        this.names[n + 1] = string2;
        this.names[n + 2] = string;
        this.numAttributes = 0;
        this.inStartTag = 1;
        ++this.nesting;
    }

    public void beginAttribute(String string, Object object2) {
        String[] stringArray;
        int n = 4 * this.numAttributes;
        if (n >= this.attributes.length) {
            stringArray = new String[2 * n];
            System.arraycopy(this.attributes, 0, stringArray, 0, n);
            this.attributes = stringArray;
        }
        stringArray = ((Symbol)object2).getNamespaceURI();
        String string2 = ((Symbol)object2).getLocalName();
        this.attributes[n] = string;
        this.attributes[n + 1] = stringArray;
        this.attributes[n + 2] = string2;
        ++this.numAttributes;
        this.inStartTag = 2;
    }

    public void endAttribute() {
        this.attributes[4 * this.numAttributes - 1] = this.strBuffer.toString();
        this.strBuffer.setLength(0);
        this.inStartTag = 1;
    }

    public void beginDocument() {
        try {
            this.out.startDocument();
        }
        catch (SAXException sAXException) {
            this.error("beginDocument", sAXException);
        }
    }

    public void endDocument() {
        try {
            this.out.endDocument();
        }
        catch (SAXException sAXException) {
            this.error("endDocument", sAXException);
        }
    }

    public void endGroup(String string) {
        this.endStartTag();
        this.flushStrBuffer();
        --this.nesting;
        int n = 3 * this.nesting;
        try {
            this.out.endElement(this.names[n], this.names[n + 1], this.names[n + 2]);
        }
        catch (SAXException sAXException) {
            this.error("endElement", sAXException);
        }
        this.names[n] = null;
        this.names[n + 1] = null;
        this.names[n + 2] = null;
    }

    void flushStrBuffer() {
        if (this.strBuffer.length() > 0) {
            if (this.chBuffer == null) {
                this.chBuffer = new char[200];
            }
            try {
                int n;
                int n2 = this.strBuffer.length();
                int n3 = 0;
                while ((n = n2 - n3) > 0) {
                    if (n > this.chBuffer.length) {
                        n = this.chBuffer.length;
                    }
                    this.strBuffer.getChars(n3, n3 + n, this.chBuffer, n3);
                    this.out.characters(this.chBuffer, 0, n);
                    n3 += n;
                }
                this.strBuffer.setLength(0);
            }
            catch (SAXException sAXException) {
                this.error("characters", sAXException);
            }
        }
    }

    public void write(char[] cArray, int n, int n2) {
        if (this.inStartTag == 1) {
            this.endStartTag();
        }
        if (this.inStartTag == 2) {
            this.strBuffer.append(cArray, n, n2);
        } else {
            this.flushStrBuffer();
            try {
                this.out.characters(cArray, n, n2);
            }
            catch (SAXException sAXException) {
                this.error("characters", sAXException);
            }
        }
    }

    public void writeChar(int n) {
        if (this.inStartTag == 1) {
            this.endStartTag();
        }
        this.strBuffer.append((char)n);
    }

    public void writeChars(String string) {
        if (this.inStartTag == 1) {
            this.endStartTag();
        }
        this.strBuffer.append(string);
    }

    public void writeObject(Object object2) {
        if (object2 instanceof Consumable) {
            ((Consumable)object2).consume(this);
        } else if (object2 instanceof SeqPosition) {
            SeqPosition seqPosition = (SeqPosition)object2;
            seqPosition.sequence.consumeNext(seqPosition.ipos, this);
        } else if (object2 instanceof Char) {
            this.writeChar(((Char)object2).intValue());
        } else {
            this.writeChars(object2 == null ? "(null)" : object2.toString());
        }
    }

    public void writeBoolean(boolean bl) {
        if (this.inStartTag == 1) {
            this.endStartTag();
        }
        this.strBuffer.append(bl);
    }

    public void writeLong(long l) {
        if (this.inStartTag == 1) {
            this.endStartTag();
        }
        this.strBuffer.append(l);
    }

    public void writeInt(int n) {
        if (this.inStartTag == 1) {
            this.endStartTag();
        }
        this.strBuffer.append(n);
    }

    public void writeFloat(float f) {
        if (this.inStartTag == 1) {
            this.endStartTag();
        }
        this.strBuffer.append(f);
    }

    public void writeDouble(double d) {
        if (this.inStartTag == 1) {
            this.endStartTag();
        }
        this.strBuffer.append(d);
    }

    public void finalize() {
        this.flushStrBuffer();
    }

    public boolean ignoring() {
        return false;
    }

    public void setContentHandler(ContentHandler contentHandler) {
        this.out = contentHandler;
    }

    public ContentHandler getContentHandler() {
        return this.out;
    }
}

