/*
 * Decompiled with CFR 0.152.
 */
package gnu.bytecode;

import gnu.bytecode.CodeAttr;
import gnu.bytecode.Location;
import gnu.bytecode.Type;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class Variable
extends Location
implements Enumeration {
    Variable next;
    private int flags = 1;
    private static final int SIMPLE_FLAG = 1;
    private static final int PARAMETER_FLAG = 2;
    private static final int ARTIFICIAL_FLAG = 4;
    static final int UNASSIGNED = -1;
    int offset = -1;
    int start_pc;
    int end_pc;

    public final Variable nextVar() {
        return this.next;
    }

    public final boolean hasMoreElements() {
        return this.next != null;
    }

    public Object nextElement() {
        if (this.next == null) {
            throw new NoSuchElementException("Variable enumeration");
        }
        return this.next;
    }

    public Variable() {
    }

    public Variable(String string) {
        this.setName(string);
    }

    public Variable(String string, Type type) {
        this.setName(string);
        this.setType(type);
    }

    public final boolean isAssigned() {
        return this.offset != -1;
    }

    final boolean dead() {
        return this.end_pc > 0;
    }

    private void setFlag(boolean bl, int n) {
        this.flags = bl ? (this.flags |= n) : (this.flags &= ~n);
    }

    public final boolean isSimple() {
        return (this.flags & 1) != 0;
    }

    public final void setSimple(boolean bl) {
        this.setFlag(bl, 1);
    }

    public final boolean isParameter() {
        return (this.flags & 2) != 0;
    }

    public final void setParameter(boolean bl) {
        this.setFlag(bl, 2);
    }

    public final boolean isArtificial() {
        return (this.flags & 4) != 0;
    }

    public final void setArtificial(boolean bl) {
        this.setFlag(bl, 4);
    }

    public boolean reserveLocal(int n, CodeAttr codeAttr) {
        int n2;
        int n3;
        int n4 = n3 = this.getType().size > 4 ? 2 : 1;
        if (codeAttr.locals.used == null) {
            codeAttr.locals.used = new Variable[20 + n3];
        } else if (codeAttr.getMaxLocals() + n3 >= codeAttr.locals.used.length) {
            Variable[] variableArray = new Variable[2 * codeAttr.locals.used.length + n3];
            System.arraycopy(codeAttr.locals.used, 0, variableArray, 0, codeAttr.getMaxLocals());
            codeAttr.locals.used = variableArray;
        }
        for (n2 = 0; n2 < n3; ++n2) {
            if (codeAttr.locals.used[n + n2] == null) continue;
            return false;
        }
        for (n2 = 0; n2 < n3; ++n2) {
            codeAttr.locals.used[n + n2] = this;
        }
        if (n + n3 > codeAttr.getMaxLocals()) {
            codeAttr.setMaxLocals(n + n3);
        }
        this.offset = n;
        return true;
    }

    public void allocateLocal(CodeAttr codeAttr) {
        if (this.offset != -1) {
            return;
        }
        int n = 0;
        while (!this.reserveLocal(n, codeAttr)) {
            ++n;
        }
        return;
    }

    public void freeLocal(CodeAttr codeAttr) {
        int n;
        this.end_pc = codeAttr.PC;
        int n2 = n = this.getType().size > 4 ? 2 : 1;
        while (--n >= 0) {
            codeAttr.locals.used[this.offset + n] = null;
        }
    }

    public String toString() {
        return "Variable[" + this.getName() + " offset:" + this.offset + ']';
    }
}

