/*
 * Decompiled with CFR 0.152.
 */
package gnu.prolog.vm.buildins.termcreation;

import gnu.prolog.term.AtomTerm;
import gnu.prolog.term.AtomicTerm;
import gnu.prolog.term.CompoundTerm;
import gnu.prolog.term.CompoundTermTag;
import gnu.prolog.term.IntegerTerm;
import gnu.prolog.term.Term;
import gnu.prolog.term.VariableTerm;
import gnu.prolog.vm.ExecuteOnlyCode;
import gnu.prolog.vm.Interpreter;
import gnu.prolog.vm.PrologException;
import gnu.prolog.vm.TermConstants;

public class Predicate_functor
extends ExecuteOnlyCode {
    public static final IntegerTerm zero = IntegerTerm.get(0);

    @Override
    public int execute(Interpreter interpreter, boolean backtrackMode, Term[] args) throws PrologException {
        int undoPos = interpreter.getUndoPosition();
        Term term = args[0];
        Term name = args[1];
        Term arity = args[2];
        if (term instanceof AtomicTerm) {
            int rc = interpreter.unify(term, name);
            if (rc == -1) {
                interpreter.undo(undoPos);
                return -1;
            }
            rc = interpreter.unify(arity, zero);
            if (rc == -1) {
                interpreter.undo(undoPos);
                return -1;
            }
            return 1;
        }
        if (term instanceof CompoundTerm) {
            CompoundTermTag tag = ((CompoundTerm)term).tag;
            IntegerTerm tarity = IntegerTerm.get(tag.arity);
            int rc = interpreter.unify(tag.functor, name);
            if (rc == -1) {
                interpreter.undo(undoPos);
                return -1;
            }
            rc = interpreter.unify(tarity, arity);
            if (rc == -1) {
                interpreter.undo(undoPos);
                return -1;
            }
            return 1;
        }
        if (term instanceof VariableTerm) {
            int rc;
            if (arity instanceof VariableTerm) {
                PrologException.instantiationError();
            }
            if (name instanceof VariableTerm) {
                PrologException.instantiationError();
            }
            if (!(name instanceof AtomicTerm)) {
                PrologException.typeError(TermConstants.atomicAtom, name);
            }
            if (!(arity instanceof IntegerTerm)) {
                PrologException.typeError(TermConstants.integerAtom, arity);
            }
            IntegerTerm iarity = (IntegerTerm)arity;
            if (iarity.value > 0) {
                if (!(name instanceof AtomTerm)) {
                    PrologException.typeError(TermConstants.atomAtom, name);
                }
                AtomTerm functor = (AtomTerm)name;
                int n = iarity.value;
                IntegerTerm maxArityTerm = (IntegerTerm)interpreter.getEnvironment().getPrologFlag(TermConstants.maxArityAtom);
                if (n > maxArityTerm.value) {
                    PrologException.representationError(TermConstants.maxArityAtom);
                }
                Term[] targs = new Term[n];
                for (int i = 0; i < n; ++i) {
                    targs[i] = new VariableTerm();
                }
                int rc2 = interpreter.unify(term, new CompoundTerm(functor, targs));
                if (rc2 == -1) {
                    interpreter.undo(undoPos);
                    return -1;
                }
                return 1;
            }
            if (iarity.value < 0) {
                PrologException.domainError(TermConstants.notLessThanZeroAtom, arity);
            }
            if ((rc = interpreter.unify(term, name)) == -1) {
                interpreter.undo(undoPos);
                return -1;
            }
            return 1;
        }
        return -1;
    }
}

