#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 3, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2002-2009 Free Software Foundation
#
# FILE:
# transforms/4xslt/Adapter.py
#
# DESCRIPTION:
# Transforms adapter for 4xslt
#
# NOTES:
#

import sys, tempfile

try:
  from Ft.Xml.Xslt.Processor import Processor
except ImportError:
  raise "Unable to load 4xslt"

from Ft.Xml import InputSource
from gnue.reports.base.GROutputAdapter import TransformAdapter as Base


class TransformAdapter(Base):

  def open(self):
    # We need a temp file for sablotron
    # TODO: check to see if PySablot will take
    # TODO: a file handle as a parameter.
    self.input, self.infile = self.createTempFile()
    return self.input

  def close(self):

    # We are finished with the intermediate file, so
    # close in order for sablotron to be able to open it.
    self.input.close()

    # Get a file for output from the destination adapter.
    outfile = self.destination.getOutputFile()

    # Get the name of the transform script
    try:
      xslfile = self.parameters['template']
    except KeyError:
      raise "Filter configuration file is missing the 'template=' parameter"

    processor = Processor()
    f1 = open(xslfile,'r')
    transform = InputSource.DefaultFactory.fromStream(f1)
    processor.appendStylesheet(transform)
    f2 = open(self.infile,'r')
    source = InputSource.DefaultFactory.fromStream(f2)
    f3 = open(outfile,'w')
    result = processor.run(source, outputStream=f3)
    f1.close()
    f2.close()
    f3.close()

    try:
      mimetype = self.parameters['mimetype']
    except:
      mimetype = 'text/plain'


    # Let the destination adapter do its thing
    self.destination.close(mimetype=mimetype)

    # clean up our temp files
    self.deleteTempFile(self.infile)
