[Setup]
AppId=GNUe-Reports
AppName=GNU Enterprise Reports
AppVerName=GNU Enterprise Reports 0.2.0
AppPublisher=GNU Enterprise
AppPublisherURL=http://www.gnuenterprise.org
AppSupportURL=http://www.gnuenterprise.org
AppUpdatesURL=http://www.gnuenterprise.org
DefaultDirName={pf}\GNUe\
DefaultGroupName=GNUe
AllowNoIcons=true
LicenseFile=
ChangesAssociations=true
CreateAppDir=true
ShowLanguageDialog=yes
OutputBaseFilename=gnue-reports-0.2.0.win32-py25
DisableDirPage=true
AppendDefaultDirName=false

[Files]
Source: C:\TMP\GNUe\Bin\gnue-reports.exe; DestDir: {app}\Bin; Components: main; Flags: ignoreversion
Source: C:\TMP\GNUe\Bin\gnue-reports-server.exe; DestDir: {app}\Bin; Components: main; Flags: ignoreversion
Source: C:\TMP\GNUe\Bin\gnue\reports\*.*; DestDir: {app}\Bin\gnue\reports; Flags: recursesubdirs ignoreversion; Components: main
Source: C:\TMP\GNUe\Config\report-filters.conf; DestDir: {app}\Config; Components: main; Flags: onlyifdoesntexist
; FIXME: Remove the following line when gnue-common has been changed to use "Config" instead of "etc" under Windows
Source: C:\TMP\GNUe\Config\report-filters.conf; DestDir: {app}\etc; Components: main; Flags: onlyifdoesntexist
Source: C:\TMP\GNUe\share\locale\gnue-reports.mo; DestDir: {app}\share\locale\; Flags: recursesubdirs createallsubdirs; Components: translations
Source: C:\TMP\GNUe\share\doc\gnue-reports\*.*; DestDir: {app}\share\doc\gnue-reports; Flags: recursesubdirs; Components: doc
Source: C:\TMP\GNUe\share\gnue\*.*; DestDir: {app}\share\gnue\; Components: main; Flags: recursesubdirs createallsubdirs

[UninstallDelete]
Name: {app}\Bin\gnue\reports\*.*; Type: filesandordirs

[Components]
Name: main; Description: Shared Program Files; Types: full compact custom; Flags: fixed
Name: doc; Description: Documentation; Types: full
Name: translations; Description: Translations; Types: full

[Code]
function GetPathInstalled(AppID: String): String;
var
  sPrevPath: String;
begin
  sPrevPath := '';
  if not RegQueryStringValue(HKLM,
    'Software\Microsoft\Windows\CurrentVersion\Uninstall\'+AppID+'_is1',
    'Inno Setup: App Path', sPrevpath) then
    RegQueryStringValue(HKCU, 'Software\Microsoft\Windows\CurrentVersion\Uninstall\'+AppID+'_is1' ,
      'Inno Setup: App Path', sPrevpath);
  Result := sPrevPath;
end;

function InitializeSetup(): Boolean;
var
  sPrevPath: String;
  sPrevID: String;
begin
  sPrevID := 'GNUe-Tools';
  sPrevPath := GetPathInstalled(sprevID);
  if (Length(sPrevPath) > 0) then
    Result := true
  else
    begin
      MsgBox('GNUe-Runtime-Environment is not installed!', mbInformation, MB_OK);
      Result := false;
    end;
  if (Length(GetPathInstalled('GNUe-Common')) > 0) then
    Result := true
  else begin
    MsgBox('GNUe-Common is not installed!  Please install the GNUe-Common package in order to setup GNUe-Reports.', mbInformation, MB_OK);
    Result := false;
  end;
end;
