# GNU Enterprise Forms - wx 2.6 UI Driver - Scrollbar widget
#
# Copyright 2001-2009 Free Software Foundation
#
# This file is part of GNU Enterprise
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 3, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# $Id: scrollbar.py 9956 2009-10-11 18:54:57Z reinhard $

import wx

from gnue.forms.uidrivers.wx26.widgets import _base

# =============================================================================
# This class implements a scrollbar for navigating multiple records
# =============================================================================

class UIScrollBar (_base.UIHelper):

    # -------------------------------------------------------------------------
    # Create the wx widget
    # -------------------------------------------------------------------------

    def _create_widget_ (self, event, spacer):

        parent = event.container

        csize = self.get_default_size()
        self.widget = wx.ScrollBar(parent, -1, size=csize,
                style=wx.SB_VERTICAL)
        self.getParent().add_widgets(self, spacer)

        wx.EVT_COMMAND_SCROLL(self.widget, self.widget.GetId(),
                self.__on_scroll)

        return self.widget


    # -------------------------------------------------------------------------
    # Handle changes of the adjustment's value
    # -------------------------------------------------------------------------

    def __on_scroll(self, event):

        self._gfObject._event_scrollToRecord(event.GetPosition ())
        event.Skip()


    # -------------------------------------------------------------------------
    # Get the default size of a scrollbar
    # -------------------------------------------------------------------------

    def _get_default_size_(self):
        """
        Get the default widget size.

        For positioned layout the default width is the product of the
        character-width and the avarage cellWidth. The default height is set to
        -1, which means it will be set by the sizers.

        @returns: tuple with default size
        """

        if not self.managed:
            return (-1, self._uiDriver.cellHeight * self.chr_h)
        else:
            return (-1, -1)


    # -------------------------------------------------------------------------
    # adjust the scrollbar to a new position
    # -------------------------------------------------------------------------

    def _ui_adjust_scrollbar_(self, position, size, count):

        self.widget.SetScrollbar(position, size, count, size - 1, True)


    # -------------------------------------------------------------------------
    # Indicate whether this widget is vertically growable
    # -------------------------------------------------------------------------

    def is_growable(self):

        return True


# -----------------------------------------------------------------------------
# Configuration data
# -----------------------------------------------------------------------------

configuration = {
  'baseClass'  : UIScrollBar,
  'provides'   : 'GFScrollBar',
  'container'  : 0,
}
