# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 3, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2009 Free Software Foundation
#
# $Id: box.py 9956 2009-10-11 18:54:57Z reinhard $
#
# DESCRIPTION:
# A PyWin32 based user interface driver for GNUe forms.
#
# NOTES:
#
import win32con

from gnue.forms.uidrivers.win32.widgets._base import UIHelper, Win32Window
from gnue.forms.uidrivers.win32.common import *

#
# UIBox
#
# Widget set specific function that creates a single instance of a border box
#
class UIBox(UIHelper):

    def _create_widget(self, event, spacer):

        w = int (event.widgetWidth / 2)
        h = int (event.widgetHeight / 8)

        object = event.object
        itemHeight = object.Char__height * event.widgetHeight - int( event.widgetHeight /2)

        style = win32con.WS_CHILD | win32con.BS_GROUPBOX | win32con.WS_GROUP
        styleEx = 0
        newWidget = Win32Window(self._uiDriver, styleEx, 'BUTTON', textEncode(object.label), style,
                           self.itemX + w,
                           self.itemY + h,
                           self.itemWidth - 2*w,
                           itemHeight ,
                           event.container)
        return newWidget


#
# Configuration data
#
configuration = {
    'baseClass'  : UIBox,
    'provides'   : 'GFBox',
    'container'  : 0,
    }
