# GNU Enterprise Forms - GF Object Hierarchy - Entry Objects
#
# Copyright 2001-2009 Free Software Foundation
#
# This file is part of GNU Enterprise
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 3, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# $Id: GFEntry.py 10015 2009-10-28 11:46:40Z reinhard $

"""
The primary data entry widget in forms
"""

from gnue.forms.GFObjects.GFTabStop import GFFieldBound

# =============================================================================
# Class for data entry widgets
# =============================================================================

class GFEntry(GFFieldBound):

    # -------------------------------------------------------------------------
    # Constructor
    # -------------------------------------------------------------------------

    def __init__(self, parent=None):

        GFFieldBound.__init__(self, parent, 'GFEntry')

        # Default attributes (these may be replaced by parser)
        self.style = "default"
        self.label = None

        # Trigger exposure
        self._validTriggers = {
            'PRE-FOCUSOUT'     : 'Pre-FocusOut',
            'POST-FOCUSOUT'    : 'Post-FocusOut',
            'PRE-FOCUSIN'      : 'Pre-FocusIn',
            'POST-FOCUSIN'     : 'Post-FocusIn',
            'ON-NEXT-ENTRY'    : 'On-Next-Entry',
            'ON-PREVIOUS-ENTRY': 'On-Previous-Entry'}

        self._triggerFunctions = {'set': {'function': self.triggerSetValue},
                                  'get': {'function': self.getValue}}
        self._triggerSet = self.triggerSetValue
        self._triggerGet = self.getValue

        self._triggerProperties = {
              'rows':     {'get': self.triggerGetRows},
              'value':    {'set': self.triggerSetValue,
                           'get': self.getValue},
              'hidden':   {'set': self.triggerSetHidden,
                           'get': self.triggerGetHidden},
              'navigable':{'set': self.triggerSetNavigable,
                           'get': self.triggerGetNavigable},
        }


    # -------------------------------------------------------------------------
    # Phase I init
    # -------------------------------------------------------------------------

    def _phase_1_init_(self):
        """
        On Phase 1 initialization add the entry to the owning blocks' entry
        list as well as to the pages' field list.
        """

        GFFieldBound._phase_1_init_(self)

        if not hasattr(self, 'Char__height'):
            self.Char__height = int(gConfigForms('widgetHeight'))
        if not hasattr(self, 'Char__width'):
            self.Char__width  = int(gConfigForms('widgetWidth'))

        # Select "auto" style
        if self.style == 'auto':
            if hasattr(self._field, 'fk_source'):
                self.style = 'dropdown'
            elif self._field.datatype == 'boolean':
                self.style = 'checkbox'
            else:
                self.style = 'default'

        # Have a look wether the entry will be navigable or not
        if self.style == 'label':
            self.navigable = False

        if not self._form._layout.managed:
            if self.style == 'default' and self.Char__height > 1:
                self.style = 'multiline'


    # -------------------------------------------------------------------------
    # Indicate whether this widget makes use of the separate label column
    # -------------------------------------------------------------------------

    def __get_has_label(self):

        return (self.label is not None and self.style != 'checkbox')

    has_label = property(__get_has_label)


    # =========================================================================
    # Trigger functions
    # =========================================================================

    def getValue(self, *args, **parms):

        return self._field.getValue(*args, **parms)

    # -------------------------------------------------------------------------

    def triggerSetValue(self, *args, **parms):

        return self._field.triggerSetValue(*args, **parms)

    # -------------------------------------------------------------------------

    def triggerGetRows(self):

        return self._rows

    # -------------------------------------------------------------------------

    def triggerSetHidden(self, value):

        self.hidden = bool(value)

    # -------------------------------------------------------------------------

    def triggerGetHidden(self):

        return self.hidden

    # -------------------------------------------------------------------------

    def triggerSetNavigable(self, value):

        self.navigable = bool(value)

    # -------------------------------------------------------------------------

    def triggerGetNavigable(self):

        return self.navigable


    # -------------------------------------------------------------------------
    # Begin/end editing mode for this entry
    # -------------------------------------------------------------------------

    def beginEdit(self):

        self._displayHandler.beginEdit()

    # -------------------------------------------------------------------------

    def endEdit(self):

        self._displayHandler.endEdit()
