#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2002-2007 Free Software Foundation
#
# FILE:
# InputBox.py
#
# DESCRIPTION:
#
# NOTES:
#


from constants import *
from Button import Button
from Dialog import Dialog
from Label import Label
from TextBox import TextBox

class InputBox(Dialog):
  """ A small dialog to get text-input from the user
  """
  def __init__(self, Parent, Prompt, DefaultText="", **properties):
    SIOInstance = Parent.Screen()
    sMCOL = SIOInstance.MAXCOL
    sMROW = SIOInstance.MAXROW
    if len(Prompt) < 40:
      DialogWidth = 40
    else:
      DialogWidth = len(Prompt) + 4
    DialogHeight = 6
    r1 = (sMROW - DialogHeight) / 2
    r2 = r1 + DialogHeight

    c1 = (sMCOL - DialogWidth) / 2
    c2 = c1 + DialogWidth

    Dialog.__init__(self, Parent, r1, c1, r2, c2, **properties)

    tCmdOK = Button(self, "OKBtn", 5, (DialogWidth - 10) / 4, 10, "OK")
    tCmdOK.EXITFORM = 1
    self.AddDialogControl(tCmdOK)

    tCmdCancel = Button(self, "CnclBtn", 5, 2 + (2 * ((DialogWidth - 10)) / 4), 10, "Cancel")
    tCmdCancel.EXITFORM = 1
    self.AddDialogControl(tCmdCancel)

    self.AddDialogControl(Label(self, "lbl", 1, 2, Prompt))

    self.tTextBox = TextBox(self, "txtBox", 2, 2, DialogWidth - 4, DefaultText)
    self.tTextBox.DEPTH = len(DefaultText)
    self.AddDialogControl(self.tTextBox)
    self.STARTPOINT = 3

  def Show(self):
    self.Screen().LoLight()
    t = self.RunDialog()
    if t == 0:              # User hit OK
      t = self.tTextBox.TEXT
    else:
      t = None
    return t


