/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc.result;

import com.sun.electric.tool.ncc.basic.NccUtils;
import com.sun.electric.tool.ncc.result.PartReport;
import java.io.Serializable;

public class SizeMismatch {

    public static class WidthMismatch
    extends Mismatch {
        static final long serialVersionUID = 0L;

        @Override
        public String widLen() {
            return "width";
        }

        @Override
        public String wl() {
            return "W";
        }

        public WidthMismatch(double min2, PartReport.PartReportable minPart, int minNdx, double max2, PartReport.PartReportable maxPart, int maxNdx) {
            super(min2, minPart, minNdx, max2, maxPart, maxNdx);
        }
    }

    public static class LengthMismatch
    extends Mismatch {
        static final long serialVersionUID = 0L;

        @Override
        public String widLen() {
            return "length";
        }

        @Override
        public String wl() {
            return "L";
        }

        public LengthMismatch(double min2, PartReport.PartReportable minPart, int minNdx, double max2, PartReport.PartReportable maxPart, int maxNdx) {
            super(min2, minPart, minNdx, max2, maxPart, maxNdx);
        }
    }

    public static abstract class Mismatch
    implements Serializable {
        private StringBuffer sb = new StringBuffer();
        public final double min;
        public final double max;
        public final PartReport minPart;
        public final PartReport maxPart;
        public final int minNdx;
        public final int maxNdx;

        private void aln(String s) {
            this.sb.append(s);
            this.sb.append("\n");
        }

        Mismatch(double min2, PartReport.PartReportable minPart, int minNdx, double max2, PartReport.PartReportable maxPart, int maxNdx) {
            this.min = min2;
            this.max = max2;
            this.minNdx = minNdx;
            this.maxNdx = maxNdx;
            this.minPart = new PartReport(minPart);
            this.maxPart = new PartReport(maxPart);
        }

        public double relErr() {
            return (this.max - this.min) / this.min;
        }

        public double absErr() {
            return this.max - this.min;
        }

        public abstract String widLen();

        public abstract String wl();

        public String toString() {
            double maxSz;
            double minSz;
            double absErr;
            double relErr;
            if (this.relErr() * 100.0 < 0.1 || this.absErr() < 0.1) {
                relErr = this.relErr() * 100.0;
                absErr = this.absErr();
                minSz = this.min;
                maxSz = this.max;
            } else {
                relErr = NccUtils.round(this.relErr() * 100.0, 1);
                absErr = NccUtils.round(this.absErr(), 2);
                minSz = NccUtils.round(this.min, 2);
                maxSz = NccUtils.round(this.max, 2);
            }
            this.aln("    " + this.minPart.getTypeString() + " " + this.widLen() + "s don't match. " + " relativeError=" + relErr + "%" + " absoluteError=" + absErr);
            this.aln("      " + this.wl() + "=" + minSz + " for " + this.minPart.fullDescription());
            this.aln("      " + this.wl() + "=" + maxSz + " for " + this.maxPart.fullDescription());
            return this.sb.toString();
        }
    }
}

