/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.ui;

import com.sun.electric.database.text.Pref;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.user.menus.WindowMenu;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InvisibleLayerConfiguration {
    private static InvisibleLayerConfiguration onlyOne = new InvisibleLayerConfiguration();
    private Map<String, String> configurations = new HashMap<String, String>();
    private Pref savedConfigurations;
    public static int NumConfigs = 13;

    private InvisibleLayerConfiguration() {
        int closePos;
        int openPos;
        Pref.Group prefs = Pref.groupForPackage(InvisibleLayerConfiguration.class);
        this.savedConfigurations = Pref.makeStringPref("LayerVisibilityConfigurations", prefs, "");
        String sc = this.savedConfigurations.getString();
        boolean[] overridden = new boolean[13];
        while ((openPos = sc.indexOf(91)) >= 0 && (closePos = sc.indexOf(93)) >= 0) {
            String config = sc.substring(openPos + 1, closePos);
            sc = sc.substring(closePos + 1);
            int tabPos = config.indexOf(9);
            if (tabPos < 0) continue;
            String cName = config.substring(0, tabPos);
            String con = config.substring(tabPos + 1);
            if (con.startsWith("(")) {
                int index = TextUtils.atoi(con.substring(1));
                overridden[index] = true;
            }
            this.configurations.put(cName, con);
        }
        for (int i = 0; i < 13; ++i) {
            if (overridden[i]) continue;
            String menuName = this.getDefaultHardwiredName(i);
            String value = "(" + i + ")";
            this.configurations.put(menuName, value);
        }
    }

    private String getDefaultHardwiredName(int index) {
        String menuName = "Set ";
        menuName = index == 0 ? menuName + "All" : menuName + "M" + index;
        menuName = menuName + " Visible";
        return menuName;
    }

    public String getMenuName(int index) {
        String cName = this.findHardWiredConfiguration(index);
        if (cName == null) {
            return this.getDefaultHardwiredName(index);
        }
        return cName;
    }

    private void saveConfigurations() {
        StringBuffer sb = new StringBuffer();
        for (String cName : this.configurations.keySet()) {
            String invisLayers = this.configurations.get(cName);
            sb.append('[');
            sb.append(cName);
            sb.append('\t');
            sb.append(invisLayers);
            sb.append(']');
        }
        this.savedConfigurations.setString(sb.toString());
        WindowMenu.setDynamicVisibleLayerMenus();
    }

    public static InvisibleLayerConfiguration getOnly() {
        return onlyOne;
    }

    public boolean exists(String cName) {
        String invisLayers = this.configurations.get(cName);
        return invisLayers != null;
    }

    public void addConfiguration(String cName, int hardWiredIndex, Technology tech, List<Layer> layers) {
        StringBuffer sb = new StringBuffer();
        if (hardWiredIndex >= 0) {
            sb.append("(" + hardWiredIndex + ")");
        }
        sb.append(tech.getTechName());
        for (Layer layer : layers) {
            sb.append(',');
            sb.append(layer.getName());
        }
        this.configurations.put(cName, sb.toString());
        this.saveConfigurations();
    }

    public void renameConfiguration(String cName, String newName) {
        String configData = this.configurations.get(cName);
        if (configData == null) {
            return;
        }
        this.configurations.remove(cName);
        this.configurations.put(newName, configData);
        this.saveConfigurations();
    }

    public void deleteConfiguration(String cName) {
        String invisLayers = this.configurations.get(cName);
        if (invisLayers == null) {
            return;
        }
        this.configurations.remove(cName);
        if (invisLayers.startsWith("(")) {
            int hardIndex = TextUtils.atoi(invisLayers.substring(1));
            String menuName = this.getDefaultHardwiredName(hardIndex);
            String value = "(" + hardIndex + ")";
            this.configurations.put(menuName, value);
        }
        this.saveConfigurations();
    }

    public List<String> getConfigurationNames() {
        ArrayList<String> configs = new ArrayList<String>();
        for (String key : this.configurations.keySet()) {
            configs.add(key);
        }
        Collections.sort(configs);
        return configs;
    }

    public Technology getConfigurationTechnology(String cName) {
        String[] iLayers;
        Technology tech = null;
        String invisLayers = this.configurations.get(cName);
        if (invisLayers != null && (iLayers = invisLayers.split(",")).length != 0) {
            String techName = iLayers[0];
            if (techName.startsWith("(")) {
                techName = techName.substring(3);
            }
            tech = Technology.findTechnology(techName);
        }
        return tech;
    }

    public String findHardWiredConfiguration(int index) {
        for (String cName : this.configurations.keySet()) {
            String invisLayers = this.configurations.get(cName);
            if (invisLayers == null || !invisLayers.startsWith("(") || index != TextUtils.atoi(invisLayers.substring(1))) continue;
            return cName;
        }
        return null;
    }

    public int getConfigurationHardwiredIndex(String cName) {
        String techName;
        String[] iLayers;
        String invisLayers = this.configurations.get(cName);
        if (invisLayers != null && (iLayers = invisLayers.split(",")).length != 0 && (techName = iLayers[0]).startsWith("(")) {
            return TextUtils.atoi(techName.substring(1));
        }
        return -1;
    }

    public Set<Layer> getConfigurationValue(String cName) {
        String[] iLayers;
        HashSet<Layer> invisibleLayers = new HashSet<Layer>();
        String invisLayers = this.configurations.get(cName);
        if (invisLayers != null && (iLayers = invisLayers.split(",")).length != 0) {
            Technology tech;
            String techName = iLayers[0];
            int hardWiredIndex = -1;
            if (techName.startsWith("(")) {
                hardWiredIndex = TextUtils.atoi(techName.substring(1));
                techName = techName.substring(3);
            }
            if ((tech = Technology.findTechnology(techName)) == null && hardWiredIndex >= 0) {
                tech = Technology.getCurrent();
            }
            for (int i = 0; i < iLayers.length; ++i) {
                String iLayer = iLayers[i];
                Layer lay = tech.findLayer(iLayer);
                if (lay == null) continue;
                invisibleLayers.add(lay);
            }
        }
        return invisibleLayers;
    }
}

