/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.layout.gates;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.tool.generator.layout.FoldedMos;
import com.sun.electric.tool.generator.layout.FoldedNmos;
import com.sun.electric.tool.generator.layout.FoldedPmos;
import com.sun.electric.tool.generator.layout.FoldsAndWidth;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.generator.layout.StdCellParams;
import com.sun.electric.tool.generator.layout.TechType;
import com.sun.electric.tool.generator.layout.TrackRouterH;

class Nand2_star {
    private static final double nmosTop = -9.0;
    private static final double pmosBot = 9.0;
    private static final double wellOverhangDiff = 6.0;
    private static final double inbY = 4.0;
    private static final double inaY = -4.0;
    private static final double outHiY = 11.0;
    private static final double outLoY = -11.0;

    Nand2_star() {
    }

    private static void error(boolean pred, String msg) {
        LayoutLib.error(pred, msg);
    }

    static Cell makePart(double sz, String threshold, StdCellParams stdCell) {
        int i;
        int i2;
        TechType tech = stdCell.getTechType();
        sz = stdCell.roundSize(sz);
        Nand2_star.error(!threshold.equals("") && !threshold.equals("HLT"), "Nand2: threshold not \"\" or \"HLT\": " + threshold);
        String nm = "nand2" + threshold;
        double minSz = 3.0 / (threshold.equals("HLT") ? 4.5 : 6.0);
        sz = stdCell.checkMinStrength(sz, minSz, nm);
        double spaceAvail = stdCell.getCellTop() - 6.0 - 9.0;
        double lamPerSz = threshold.equals("HLT") ? 4.5 : 6.0;
        double totWid = sz * lamPerSz * 2.0;
        FoldsAndWidth fwP = stdCell.calcFoldsAndWidth(spaceAvail, totWid, 2);
        Nand2_star.error(fwP == null, "can't make " + nm + " this small: " + sz);
        int nbStackedN = 2;
        spaceAvail = -9.0 - (stdCell.getCellBot() + 6.0);
        totWid = sz * 3.0 * (double)nbStackedN;
        FoldsAndWidth fwN = stdCell.calcFoldsAndWidth(spaceAvail, totWid, 1);
        Nand2_star.error(fwN == null, "can't make " + nm + " this small: " + sz);
        Cell nand = stdCell.findPart(nm, sz);
        if (nand != null) {
            return nand;
        }
        nand = stdCell.newPart(nm, sz);
        double inaX = 3.5;
        double pmosX = inaX + 2.0 + 3.0 + 2.0;
        double pmosY = 9.0 + fwP.physWid / 2.0;
        FoldedPmos pmos = new FoldedPmos(pmosX, pmosY, fwP.nbFolds, 1, fwP.gateWid, nand, tech);
        double nmosY = -9.0 - fwN.physWid / 2.0;
        FoldedMos[] nmoss = new FoldedMos[(int)Math.ceil((double)fwN.nbFolds / 2.0)];
        for (int nbFoldsN = 0; nbFoldsN < fwN.nbFolds; nbFoldsN += 2) {
            int nbStacked = 2;
            int nbFolds = Math.min(2, fwN.nbFolds);
            double nmosPitch = 32.0;
            double nmosX = LayoutLib.roundCenterX(pmos.getSrcDrn(0)) + 3.0 + (double)(nbFoldsN / 2) * nmosPitch;
            FoldedNmos nmos = new FoldedNmos(nmosX, nmosY, nbFolds, nbStacked, fwN.gateWid, nand, tech);
            nmoss[nbFoldsN / 2] = nmos;
        }
        stdCell.fillDiffAndSelectNotches(nmoss, true);
        stdCell.wireVddGnd(nmoss, StdCellParams.EVEN, nand);
        stdCell.wireVddGnd(pmos, StdCellParams.EVEN, nand);
        LayoutLib.newExport(nand, "ina", PortCharacteristic.IN, tech.m1(), 4.0, inaX, -4.0);
        TrackRouterH inA = new TrackRouterH(tech.m1(), 3.0, -4.0, tech, nand);
        inA.connect(nand.findExport("ina"));
        for (i2 = 0; i2 < nmoss.length; ++i2) {
            for (int j = 0; j < nmoss[i2].nbGates(); j += 2) {
                if (j / 2 % 2 == 0) {
                    inA.connect(nmoss[i2].getGate(j, 'T'), -1.5);
                    continue;
                }
                inA.connect(nmoss[i2].getGate(j + 1, 'T'), 1.5);
            }
        }
        for (i2 = 0; i2 < pmos.nbGates(); i2 += 2) {
            if (i2 / 2 % 2 == 0) {
                inA.connect(pmos.getGate(i2, 'B'), 1.5);
                continue;
            }
            inA.connect(pmos.getGate(i2 + 1, 'B'), -1.5);
        }
        double inbX = StdCellParams.getRightDiffX(pmos, nmoss) + 2.0 + 3.0 + 2.0;
        LayoutLib.newExport(nand, "inb", PortCharacteristic.IN, tech.m1(), 4.0, inbX, 4.0);
        TrackRouterH inb = new TrackRouterH(tech.m1(), 3.0, 4.0, tech, nand);
        inb.connect(nand.findExport("inb"));
        for (i = 0; i < nmoss.length; ++i) {
            for (int j = 0; j < nmoss[i].nbGates(); j += 2) {
                if (j / 2 % 2 == 0) {
                    inb.connect(nmoss[i].getGate(j + 1, 'T'));
                    continue;
                }
                inb.connect(nmoss[i].getGate(j, 'T'));
            }
        }
        for (i = 0; i < pmos.nbGates(); i += 2) {
            if (i / 2 % 2 == 0) {
                inb.connect(pmos.getGate(i + 1, 'B'));
                continue;
            }
            inb.connect(pmos.getGate(i, 'B'));
        }
        double outX = inbX + 2.0 + 3.0 + 2.0;
        LayoutLib.newExport(nand, "out", PortCharacteristic.OUT, tech.m1(), 4.0, outX, 11.0);
        TrackRouterH outHi = new TrackRouterH(tech.m2(), 4.0, 11.0, tech, nand);
        outHi.connect(nand.findExport("out"));
        for (int i3 = 1; i3 < pmos.nbSrcDrns(); i3 += 2) {
            outHi.connect(pmos.getSrcDrn(i3));
        }
        TrackRouterH outLo = new TrackRouterH(tech.m2(), 4.0, -11.0, tech, nand);
        outLo.connect(nand.findExport("out"));
        for (int i4 = 0; i4 < nmoss.length; ++i4) {
            for (int j = 1; j < nmoss[i4].nbSrcDrns(); j += 2) {
                outLo.connect(nmoss[i4].getSrcDrn(j));
            }
        }
        double wellMinX = 0.0;
        double wellMaxX = outX + 2.0 + 1.5;
        stdCell.addNmosWell(wellMinX, wellMaxX, nand);
        stdCell.addPmosWell(wellMinX, wellMaxX, nand);
        stdCell.addEssentialBounds(wellMinX, wellMaxX, nand);
        stdCell.doNCC(nand, nm + "{sch}");
        return nand;
    }
}

