/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.layout;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.HierarchyEnumerator;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.EditWindow_;
import com.sun.electric.database.variable.UserInterface;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.generator.layout.DrcRings;
import com.sun.electric.tool.generator.layout.Gallery;
import com.sun.electric.tool.generator.layout.GenerateLayoutForGatesInSchematic;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.generator.layout.StdCellParams;
import com.sun.electric.tool.generator.layout.Tech;
import com.sun.electric.tool.generator.layout.TechType;
import com.sun.electric.tool.generator.layout.gates.MoCMOSGenerator;
import com.sun.electric.tool.user.User;
import java.lang.reflect.Method;
import java.util.Map;

public class GateLayoutGenerator {
    private static final DrcRings.Filter FILTER = new DrcRings.Filter(){

        @Override
        public boolean skip(NodeInst ni) {
            return ni.getProto().getName().indexOf("mosWellTie_") != -1;
        }
    };

    public static Cell generateCell(Library outputLib, StdCellParams stdCell, String type, double Xstrength) {
        if (outputLib == null) {
            return null;
        }
        stdCell.setOutputLibrary(outputLib);
        if (Tech.getTechnology() != stdCell.getTechnology()) {
            Tech.setTechnology(stdCell.getTechnology());
        }
        if (Xstrength < 0.0) {
            return null;
        }
        int pwr = type.indexOf("_pwr");
        if (pwr != -1) {
            type = type.substring(0, pwr);
        }
        Cell c = null;
        if (Tech.is90nm()) {
            try {
                Class<?> cmos90GeneratorClass = Class.forName("com.sun.electric.plugins.tsmc.gates90nm.CMOS90Generator");
                Class[] parameterTypes = new Class[]{String.class, Double.class, StdCellParams.class};
                Method makeGateMethod = cmos90GeneratorClass.getDeclaredMethod("makeGate", parameterTypes);
                c = (Cell)makeGateMethod.invoke(null, type, new Double(Xstrength), stdCell);
            }
            catch (Exception e) {
                System.out.println("ERROR invoking the CMOS90 gate generator");
            }
        } else {
            c = MoCMOSGenerator.makeGate(type, Xstrength, stdCell);
        }
        return c;
    }

    public static Map<Nodable, Cell> generateLayoutFromSchematics(Library outLib, Cell cell, VarContext context, StdCellParams stdCell, boolean topLevelOnly) {
        stdCell.setOutputLibrary(outLib);
        Tech.setTechnology(stdCell.getTechnology());
        GenerateLayoutForGatesInSchematic visitor = new GenerateLayoutForGatesInSchematic(stdCell, topLevelOnly);
        HierarchyEnumerator.enumerateCell(cell, context, visitor);
        Cell gallery = Gallery.makeGallery(outLib);
        DrcRings.addDrcRings(gallery, FILTER, stdCell);
        return visitor.getGeneratedCells();
    }

    public static void generateFromSchematicsJob(TechType type) {
        GenerateFromSchematicsJob job = new GenerateFromSchematicsJob(type);
        job.startJob();
    }

    public static StdCellParams locoParams() {
        StdCellParams stdCell = new StdCellParams(TechType.MOCMOS);
        stdCell.enableNCC("purpleFour");
        stdCell.setSizeQuantizationError(0.0);
        stdCell.setMaxMosWidth(1000.0);
        stdCell.setVddY(21.0);
        stdCell.setGndY(-21.0);
        stdCell.setNmosWellHeight(42.0);
        stdCell.setPmosWellHeight(42.0);
        stdCell.setSimpleName(true);
        return stdCell;
    }

    public static StdCellParams sportParams() {
        StdCellParams stdCell = new StdCellParams(TechType.CMOS90);
        stdCell.setSizeQuantizationError(0.0);
        stdCell.setMaxMosWidth(1000.0);
        stdCell.setVddY(24.5);
        stdCell.setGndY(-24.5);
        stdCell.setNmosWellHeight(84.0);
        stdCell.setPmosWellHeight(84.0);
        stdCell.setSimpleName(true);
        return stdCell;
    }

    public static StdCellParams dividerParams(TechType technology) {
        StdCellParams stdCell = new StdCellParams(technology);
        stdCell.enableNCC("purpleFour");
        stdCell.setSizeQuantizationError(0.0);
        stdCell.setMaxMosWidth(1000.0);
        stdCell.setVddY(21.0);
        stdCell.setGndY(-21.0);
        stdCell.setNmosWellHeight(84.0);
        stdCell.setPmosWellHeight(84.0);
        stdCell.setSimpleName(true);
        return stdCell;
    }

    public static StdCellParams fastProxParams(TechType technology) {
        StdCellParams stdCell = new StdCellParams(technology);
        stdCell.enableNCC("purpleFour");
        stdCell.setSizeQuantizationError(0.0);
        stdCell.setMaxMosWidth(1000.0);
        stdCell.setVddY(24.0);
        stdCell.setGndY(-24.0);
        stdCell.setVddWidth(9.0);
        stdCell.setGndWidth(9.0);
        stdCell.setNmosWellHeight(60.0);
        stdCell.setPmosWellHeight(60.0);
        stdCell.setSimpleName(true);
        return stdCell;
    }

    public static StdCellParams justinParams(TechType technology) {
        StdCellParams stdCell = new StdCellParams(technology);
        stdCell.enableNCC("purpleFour");
        stdCell.setSizeQuantizationError(0.0);
        stdCell.setMaxMosWidth(1000.0);
        stdCell.setVddY(21.0);
        stdCell.setGndY(-21.0);
        stdCell.setNmosWellHeight(42.0);
        stdCell.setPmosWellHeight(42.0);
        stdCell.setSimpleName(true);
        return stdCell;
    }

    public static class GenerateFromSchematicsJob
    extends Job {
        private TechType technology;
        private Cell cell;
        private VarContext context;

        public GenerateFromSchematicsJob(TechType techNm) {
            super("Generate gate layouts", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.ANALYSIS);
            this.technology = techNm;
            UserInterface ui = Job.getUserInterface();
            EditWindow_ wnd = ui.needCurrentEditWindow_();
            if (wnd == null) {
                return;
            }
            this.cell = wnd.getCell();
            this.context = wnd.getVarContext();
        }

        @Override
        public boolean doIt() throws JobException {
            String outLibNm = "autoGenLib" + this.technology;
            Library outLib = LayoutLib.openLibForWrite(outLibNm);
            Tech.setTechnology(this.technology);
            Technology cmos90 = Technology.getCMOS90Technology();
            StdCellParams stdCell = cmos90 != null && this.technology == TechType.CMOS90 ? GateLayoutGenerator.sportParams() : GateLayoutGenerator.dividerParams(this.technology);
            if (this.cell == null) {
                System.out.println("Please open the schematic for which you want to generate gate layouts.");
                return false;
            }
            if (!this.cell.isSchematic()) {
                System.out.println("The current cell isn't a schematic. This command only works on schematics.");
                return false;
            }
            System.out.println("Generating layouts for gates in the schematic: " + this.cell.getName() + " and its descendents");
            System.out.println("Output goes to library: " + outLibNm);
            GateLayoutGenerator.generateLayoutFromSchematics(outLib, this.cell, this.context, stdCell, false);
            System.out.println("done.");
            return true;
        }
    }
}

